import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "mesh"
    enabled: syncRoot(box.name+".ON")

    VariClockTrigger {
        id: animFrame
        clockSpeed: sync(box.name+".anim.FPS", 0.0)
        reset: syncTrigger(box.name+".anim.reset")
    }
    property real animFramesPerRow: sync(box.name+".anim.numCols", 1.0)
    property real animRows: sync(box.name+".anim.numRows", 1.0)
    property int animFrames: Math.max(1.0, sync(box.name+".anim.frames", 1.0))
    property int animLoopFadeFrames: sync(box.name+".anim.loopFadeFrames", 1.0)
    property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)
//    property real animFrameUVX: (animFrameInt/animFramesPerRow-Math.floor(animFrameInt/animFramesPerRow))*animFramesPerRow*sync(box.name+".anim.width", 1.0/6.0)
//    property real animFrameUVY: Math.floor(animFrameInt/animFramesPerRow)*sync(box.name+".anim.height", 1.0/6.0)

    property real uvScale: sync(box.name+".uvScale", 1.0);

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "velBuf" }

    TextureSel { name: box.name }
    TextureSel { name: box.name; textureUnit: 1 }
    TextureSel { name: box.name; textureUnit: 6 }

    Texture { textureUnit: 7;  textureRT: "mainDepth" }
    Shader { file: {
            var v = sync(box.name+".shaderIndex");

//            if (abs(meshMorph)>0.001) {
//                if (v===0) return "smLogo";
//                if (v===1) return "smMeshMotionMorph";
//            }

            if (meshi.isMorph) {
                if (v===0) return "smLogoMorph";
                if (v===1) return "smMeshMotionMorph";
                return "smLogoMorph";
            } else {
                if (v===0) return "smLogo";
                if (v===1) return "smMeshMotion";
                return "smLogo";
            }
//            if (v===0) return "smLogo";
//            if (v===1) return "smMeshMotion";
//            if (v===2) return "smMeshMotionMorph";
//            if (v===1) return "smMeshMotion";
//            if (v===2) return "smGen";
            return "smLogo";
        }
    }

    property bool origScale: sync(box.name+".origScale", 0.0) < 0.5

    property real meshMorph: sync(box.name+".meshMorph", 0.0)

    DrawMesh {
        id: meshi
        property string name: box.name
        file: meshSel(box.name)
        file2: meshSel2(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)

        autoCenter: origScale
        autoScale: origScale

        smoothNormals: true; normalSmoothAngle: 80;

        Pos { x: syncOsc(box.name+".posX"); y: syncOsc(box.name+".posY"); z: syncOsc(box.name+".posZ")}
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
      //  ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*sync(box.name+".uvScaleX", 1.0))+","+(uvScale*sync(box.name+".uvScaleY", 1.0))}
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }
        ShaderParam { paramName: "g_alphaSub"; paramValue: sync(box.name+".alphaSub", 0.0) }

        ShaderParam { paramName: "g_meshMorph"; paramValue: meshMorph }

        ShaderParam { paramName: "g_mulTexAmp"; paramValue: sync(box.name+".mulTexAmp") }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

        ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(box.name+".uvOfsX", 0.0) }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }


        ShaderParam { paramName: "g_animInfo"; paramValueVec4: animFramesPerRow+","+animFrames+","+animRows+","+animFrameInt }
        ShaderParam { paramName: "g_animLoopFadeFrames"; paramValue: animLoopFadeFrames }
        //ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }

}
