import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property alias simShaderParams: simPar.delegate
    property string drawShader: "partWater"
    property alias drawShaderParams: drawPar.delegate
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true

    property real syncDepthEnabled: sync(partSim.name+".draw.depthEnabled", 1.0)

    property bool drawDepthEnabled: (syncDepthEnabled > 0.5) && (syncDepthEnabled < 1.5)
    property bool drawDepthWrite: (syncDepthEnabled > 1.5)
    property bool drawDepthTest: (syncDepthEnabled < 2.5)

    property real partSize: 0.50
    property int particleCount: advanceSim.particleCount

    onParticleCountChanged: {
        root.setCustomText(name, name+": particle count", "Particle count:"+particleCount);
    }

    signal particleCountTo(int pc)

    Blit { textureRT: "screenBuffer" }

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;"


    property real partSimReset: syncTrigger(spaceVortex.name+".sim.reset")


    VariClockTrigger {
        id: simNoiseMoveX
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.x")
        reset: partSimReset
    }
    VariClockTrigger {
        id: simNoiseMoveY
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.y")
        reset: partSimReset
    }
    VariClockTrigger {
        id: simNoiseMoveZ
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.z")
        reset: partSimReset
    }

    // ----------------------------------------
    // PARTICLES TO MESH stuff, used if enabled
    // ----------------------------------------

    property bool particleToMeshEnabled: sync(partSim.name+".p2m.ON")

    function isMeshTexUpdating() {
        return true;
    }

    property int gWidth: 500

    Group {
        id: transMesh
        enabled: particleToMeshEnabled
        property string shaderVaryings: "
            vec3 posG;
            vec3 normalG;
            vec2 uvG;
            vec3 tangentG;"

        property int triangleTexDim: 512

        Shader {
            file: "smTexSpaceTrans"; tfVaryings: transMesh.shaderVaryings;
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
            //            ShaderParam { paramName: "g_zoomAmount"; paramValue: 1.0+zoomPercent}
        }

        // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
        // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
        DrawVB {
            type: "drawStart"; primType: "triangles"; vboId: partSim.name+".transMesh"; tfVaryings: transMesh.shaderVaryings;
            enabled: true
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
        }
        DrawMesh {
            property string meshFile: meshSel(partSim.name+".p2m")
            file: meshFile
//            onMeshFileChanged: {
//                mesh.triggerMeshTexUpdate();
//            }
            enabled: true; smoothNormals: true; normalSmoothAngle: 80;
            depthTest: true; depthWrite: true;

            property real meshScale: sync(partSim.name+".p2m.meshScale")
          //  onMeshScaleChanged: mesh.triggerMeshTransUpdate();

            property real meshX: sync(partSim.name+".p2m.meshX")
            property real meshY: sync(partSim.name+".p2m.meshY")
            property real meshZ: sync(partSim.name+".p2m.meshZ")

//            onMeshXChanged: mesh.triggerMeshTransUpdate();
//            onMeshYChanged: mesh.triggerMeshTransUpdate();
//            onMeshZChanged: mesh.triggerMeshTransUpdate();

            property real recLimit: sync(partSim.name+".p2m.subdiv")

          //  onRecLimitChanged: mesh.triggerMeshTexUpdate()

            cull: false; cullBack: false
            Pos { x: parent.meshX; y: parent.meshY; z: parent.meshZ}
            Rot { d: sync(partSim.name+".p2m.rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: sync(partSim.name+".p2m.rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: sync(partSim.name+".p2m.rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
            Sca { s: parent.meshScale; x: 1.0; y: 1.0; z: 1.0 }

            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
//            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
//            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
//            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(partSim.name+".p2m.uvOfsY") }
//            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
//            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
//            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
//            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}

            ShaderParam { paramName: "recLimit"; paramValue: parent.recLimit}
        }
        // stop drawing to the vertex buffer (with transform feedback)
        DrawVB {
            enabled: true
            type: "drawStop";  primType: "triangles"; vboId: partSim.name+".transMesh"; tfVaryings: transMesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
        }


        RenderTarget {
            RenderTargetLayer {
                id: triangleInfo
                textureRT: "triangleInfo"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: dim*3
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }
        RenderTarget {
            RenderTargetLayer {
                id: triangleIds
                textureRT: "triangleIds"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 3*dim
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: -1.0; cG: -1.0; cB: -1.0; cA: 1.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeGridHeadPointers
                textureRT: "edgeGridHeadPointers"
                format: "R32F"
                property int baseDim: 12
                property int dim: baseDim*baseDim*baseDim
                width: dim
                height: dim
                Clear {
                    enabled: isMeshTexUpdating()
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
                }
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeDataCenter
                textureRT: "edgeDataCenter"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 2*dim
                height: dim
            }
        }

        RenderTarget {
            RenderTargetLayer {
                id: edgeDataIds
                textureRT: "edgeDataIds"
                format: "RGBA32F"
                property int dim: transMesh.triangleTexDim
                width: 2*dim
                height: dim
            }
        }

        ShaderAtomicCounter { name: partSim.name+".sacP2M"; clear: true }

        Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
        Shader { file: "smGenTriangleTex" }
        DrawVB {
            id: genTriangleTex
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: partSim.name+".transMesh"
            tfVaryings: transMesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_texW"; paramValue: triangleInfo.width }
            ShaderParam { paramName: "g_texH"; paramValue: triangleInfo.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: transMesh.triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
//            onParticleCountChanged: {
//                root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
//            }
        }

//        Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
//        Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
//        Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
//        Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
//        Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
//        Shader { file: "smGenTriangleIds" }
//        DrawVB {
//            id: genTriangleIds
//            enabled: true
//            type: "pointGridDraw"
//            primType: "triangles"
//            vboId: partSim.name+".transMesh"
//            tfVaryings: transMesh.shaderVaryings
//            gridWidth: gWidth; gridHeight: 1000
//            drawNumPoints: gridWidth*gridHeight
//            depthTest: false; depthWrite: false

//            ShaderParam { paramName: "g_texW"; paramValue: triangleInfo.width }
//            ShaderParam { paramName: "g_texH"; paramValue: triangleInfo.height }
//            ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
//            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

//            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
//            Pos { x: 0.0; y: 0.0; z: 0.0}
//            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
//            blendMode: "off"
//            onParticleCountChanged: {
//                root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
//            }
//        }

    }

    ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1"; clear: false }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: partSim.name+"emitVortexPartPos" }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: partSim.name+"emitVortexPartVel" }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: partSim.name+"emitVortexPartCol" }

    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "edgeDataIds"; }

    property alias tex0: t0.delegate
    Repeater { id: t0; model: 1 }
    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/random16.png"
        }
    }
    property alias tex2: t2.delegate
    Repeater { id: t2; model: 1 }

    Texture { textureUnit: 3; textureRT: "depth" } // world space normal in rgb components
    Texture { textureUnit: 4; textureRT: "mainDepth" }
    Texture { textureUnit: 5; textureRT: "prevBlur" }

    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------
    Shader {
        file: simShader
        tfVaryings: shaderVaryings
    }
    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+partSim.name

        property real resetOn: partSimReset

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
                // console.log("particles reset now");
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            particleCountTo(particleCount);
        }

        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping", 1.0) }
        property real noiseScaleAll: sync(partSim.forceName+".simNoiseScale.all", 1.0);
        property real nsx: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.x")
        property real nsy: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.y")
        property real nsz: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.z")

        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: parent.nsx+","+parent.nsy+","+parent.nsz }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+syncFFT(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force", 2.0) }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq", 1.0) }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed", 1.0) }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge", 10.0) }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity", 0.5) }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr", 0.0) }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand", 1.0) }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm", 1.0) }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed", 1.0) }
        ShaderParam { paramName: "g_noiseRec"; paramValue: sync(partSim.name+".sim.noiseRec", 0.0) }

        ShaderParam { paramName: "g_triangleTexDim"; paramValue: transMesh.triangleTexDim }
        ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

        ShaderParam { paramName: "g_partToMeshForce"; paramValue: sync(partSim.name+".p2m.force", 0.0) }
        ShaderParam { paramName: "g_partToMeshVelDamp"; paramValue: sync(partSim.name+".p2m.velDamp", 0.05) }



        // inject custom shader params
        Repeater { id: simPar; model: 1 }
    }

    // ----------------------------------------
    // PARTICLES TO MESH stuff, used if enabled
    // ----------------------------------------
//    property bool particleToMeshEnabled: sync(partSim.name+".p2m.ON")
//    function isParticleToMeshUpdating() {
//        return true;
//    }
//    Group {
//        id: particleToMeshPost
//        enabled: particleToMeshEnabled
//    }

    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: drawDepthTest
        depthWrite: drawDepthWrite

        // blendMode: "normal"
        blendMode: drawBlendMode
        // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        ShaderParam { paramName: "g_partSize"; paramValue: partSize }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }


        ShaderParam { paramName: "g_palaEmitFadeZ"; paramValue: sync(partSim.name+".draw.palaEmitFadeZ", 0.0) }
        ShaderParam { paramName: "g_palaEmitGainZ"; paramValue: sync(partSim.name+".draw.palaEmitGainZ", -9999.0) }
        ShaderParam { paramName: "g_palaEmit"; paramValue: sync(partSim.name+".draw.palaEmit", 0.0) }
        ShaderParam { paramName: "g_palaEmitThr"; paramValue: sync(partSim.name+".draw.palaEmitThr", 0.0) }

        // inject custom shader params
        Repeater { id: drawPar; model: 1 }

        drawBuffers: 3
    }

//    Shader {
//        file: sceneDir+"partDepthOnly"
//    }
    DrawVB { // depth only draw
        enabled: drawDepthEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: true

        // blendMode: "normal"
        blendMode: "add"
        // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }
}
