import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
  id: zoomPlane
  // big mirror plane
  Shader { file: "smInfiFade" }
  name: "zoomPlane"
  enabled: syncRoot(name+".ON")

  VariClockTrigger {
      id: zoomClock;
      clockSpeed: 0.3*sync(zoomPlane.name+".zoomPercent")
      reset: sync(zoomPlane.name+".zoomClock.reset")
  }

  TextureSel { name: parent.name }
  DrawMesh {
    file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "normal"; depthTest: true; depthWrite: true; cull: true; cullBack: true; Pos { x: 0.0; y: -0.950; z: 0.0}
    Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
    Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
    autoCenter: false; autoScale: false
    ShaderParam { paramName: "g_uvScale"; paramValue: sync(zoomPlane.name+".uvScale", 0.5)}
    ShaderParam { paramName: "g_texBrightness"; paramValue: sync(zoomPlane.name+".texBright", 0.5)}
    ShaderParam { paramName: "g_texAmbient"; paramValue:sync(zoomPlane.name+".ambient", 0.0)}
    ShaderParam { paramName: "g_bump"; paramValue: sync(zoomPlane.name+".bump", 0.25)}
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(zoomPlane.name+".prevBlurAmount")}
    ShaderParam { paramName: "g_color"; paramValueVec4: sync(zoomPlane.name+".colorR", 1.0)+","+sync(zoomPlane.name+".colorG", 1.0)+","+sync(zoomPlane.name+".colorB", 1.0)+","+sync(zoomPlane.name+".colorA", 1.0)}
    ShaderParam { paramName: "g_centerAlpha"; paramValue: sync(zoomPlane.name+".alphaCenter")}
    ShaderParam { paramName: "g_alphaFade"; paramValue: sync(zoomPlane.name+".alphaFade")}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    ShaderParam { paramName: "g_zoomTime"; paramValue: zoomClock.time }
  }
}
