import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Defaults {}
    BgBall {}

    Blit { textureRT: "bgBlurGlass" }
    BlurRt { name: "bgBlurGlass"; textureRT: "bgBlurGlass" }

    BgBlur { }

    Overlay { name: "ovlBg1" }

    ShaderAtomicCounter { name: "part"+"sacVortex1"; clear: true }

    BreakIn {
        name: "breakin"
        particlesName: "part" // the name of the particle effect where to emit the particles in case some emitted
        clearParticleEmits: false
        autoCenter: false
        autoScale: false
    }

    Mesh { name: "mesh1" } //
    Mesh { name: "mesh2" } //
    Mesh { name: "mesh3" } //
    Mesh { name: "mesh4" } //


    Gen { name: "gen" } //
    Gen { name: "gen2" } //

    BoxGrower { }

    Blit { textureRT: "depth"; blitRT: 1}

    EmitPart {
        id: emitPart
        name: "part"
        // do not modify this dynamically on fly during the demo
        maxParticles: 1000000
        clearParticleEmits: false
//        voxBD: voxel.baseDim
//        voxAS: voxAreaSize
    //    autoSize: sync(name+".autoSize", 1.0) > 0.5
    }

    EmitPart {
        id: emitPart2
        name: "part2"
        // do not modify this dynamically on fly during the demo
        maxParticles: 1000000
        clearParticleEmits: true
//        voxBD: voxel.baseDim
//        voxAS: voxAreaSize
    //    autoSize: sync(name+".autoSize", 1.0) > 0.5
    }


    Blit { textureRT: "bgBlurMesh" }
    BlurRt { name: "bgBlurMesh"; textureRT: "bgBlurMesh" }
    Aalto { }
  //  Aalto { name: aalto2 }

    Blit { textureRT: "currentAlpha" }
    Blit { textureRT: "depth"; blitRT: 1 }

    Overlay { name: "ovlPre1" }

    Blit { textureRT: "emitBuf"; blitRT: 2 }

    MotionBlur { }

    Reflect { }

    GodRay {
        property int centrumSel: 0 // sync("godray.meshIndex")
        property string centrum: {
            // ball
            if (centrumSel === 0) return "centrum";

            // box
            if (centrumSel === 1) return "centrumBox";

            // default to not follow any mesh
            return "";
        }

        godRayX: centrum !== "" ? getSavePointX2D(centrum) : 0.0
        godRayY: centrum !== "" ? getSavePointY2D(centrum) : 0.0
    }

    Overlay { name: "ovl1" }


    PalaFlow {
    }
    PrevBlur { }

	Glow { }
	
    Vignette { }

    Coords {}
    Tonemap {}

    SMAA {}
	
	Overlay { name: "ovlFin0" }
    Overlay { name: "ovlLoader" }

}
