/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class pink_in_space
extends PApplet {
    PVector camera_target;
    PVector camera_dir;
    float angle_x;
    float angle_y;
    float angle_z;
    ModArea pinkArea;
    SweepArea sweepArea;
    PImage star_field;
    Moonlander moonLander;

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public void setup() {
        this.camera_target = new PVector((float)(this.width / 2), (float)(this.height / 2), 0.0f);
        this.camera_dir = new PVector(0.0f, 0.0f, 0.0f);
        this.angle_x = 0.0f;
        this.angle_y = 0.0f;
        this.angle_z = 0.0f;
        this.star_field = this.loadImage("star_field.png");
        this.pinkArea = new ModArea(new PVector(0.0f, 0.0f, 0.0f), 10.0f, 3.0f);
        this.sweepArea = new SweepArea();
        this.moonLander = Moonlander.initWithSoundtrack((PApplet)this, (String)"space_song.mp3", (int)190, (int)4);
        this.moonLander.start();
    }

    public void draw() {
        this.moonLander.update();
        this.background(0);
        this.ortho();
        this.hint(5);
        this.image(this.star_field, 0.0f, 0.0f);
        this.hint(-5);
        float fovOffset = (float)this.moonLander.getValue("fov_offset");
        float fov = 1.0471976f + pink_in_space.radians((float)fovOffset);
        float aspect = (float)this.width / (float)this.height;
        float near_clip = 0.1f;
        float far_clip = 400.0f;
        this.perspective(fov, aspect, near_clip, far_clip);
        float camera_depth = (float)this.moonLander.getValue("Camera_offset");
        this.camera_target.add(this.camera_dir);
        this.camera(this.width / 2, this.height / 2, 150.0f + camera_depth, this.camera_target.x, this.camera_target.y, this.camera_target.z, 0.0f, 1.0f, 0.0f);
        this.angle_x = (float)this.moonLander.getValue("angle_x") / 100.0f;
        this.angle_y = (float)this.moonLander.getValue("angle_y") / 100.0f;
        this.angle_z = (float)this.moonLander.getValue("angle_z") / 100.0f;
        this.pinkArea.Sync(this.moonLander);
        this.sweepArea.Sync(this.moonLander);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        int minCoord = -100;
        int maxCoord = 100;
        int stepCoord = (int)this.moonLander.getValue("grid_step");
        if (stepCoord < 12) {
            stepCoord = 12;
        }
        float black_size = 1.0f + (float)this.moonLander.getValue("black_size");
        int z = minCoord;
        while (z < maxCoord) {
            int x = minCoord;
            while (x < maxCoord) {
                int y = minCoord;
                while (y < maxCoord) {
                    this.pushMatrix();
                    this.rotateX(this.angle_x);
                    this.rotateY(this.angle_y);
                    this.rotateZ(this.angle_z);
                    this.translate(x, y, z);
                    PVector cube_pos = new PVector((float)x, (float)y, (float)z);
                    if (this.pinkArea.InRange(cube_pos)) {
                        this.fill(this.pinkArea.GetCubeColor());
                        this.stroke(this.pinkArea.GetBorderColor());
                        this.box(this.pinkArea.GetSize());
                    } else {
                        float sweepIntensity = this.sweepArea.InRange(cube_pos);
                        this.noStroke();
                        this.fill(sweepIntensity * (float)this.sweepArea.sweep_color);
                        this.box(black_size);
                    }
                    this.popMatrix();
                    y += stepCoord;
                }
                x += stepCoord;
            }
            z += stepCoord;
        }
        this.popMatrix();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"pink_in_space"};
        if (passedArgs != null) {
            PApplet.main((String[])pink_in_space.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class ModArea {
        PVector center;
        float area_size;
        float cube_size;
        int pink_color_r;
        int pink_color_g;
        int pink_color_b;
        float border_multiplier;

        ModArea(PVector pos, float sz, float cubeSizeP) {
            this.center = pos;
            this.area_size = sz;
            this.cube_size = cubeSizeP;
        }

        public int GetCubeColor() {
            return pink_in_space.this.color(this.pink_color_r, this.pink_color_g, this.pink_color_b);
        }

        public int GetBorderColor() {
            return pink_in_space.this.color((float)this.pink_color_r * this.border_multiplier, (float)this.pink_color_g * this.border_multiplier, (float)this.pink_color_b * this.border_multiplier);
        }

        public float GetSize() {
            return this.cube_size;
        }

        public boolean InRange(PVector cubePosition) {
            return this.center.dist(cubePosition) < this.area_size;
        }

        public void Sync(Moonlander syncer) {
            this.area_size = (float)syncer.getValue("pink_area_size");
            this.cube_size = (float)syncer.getValue("pink_cube_size");
            this.pink_color_r = (int)syncer.getValue("pink_red");
            this.pink_color_g = (int)syncer.getValue("pink_green");
            this.pink_color_b = (int)syncer.getValue("pink_blue");
            this.border_multiplier = (float)syncer.getValue("pink_border_mult");
        }
    }

    class SweepArea {
        float row;
        float size;
        float tail;
        int sweep_color;

        SweepArea() {
        }

        public float InRange(PVector cubePosition) {
            float x = cubePosition.x;
            if (cubePosition.x > this.row - this.size && cubePosition.x < this.row + this.size) {
                return 1.0f;
            }
            if (cubePosition.x > this.row - this.size - this.tail) {
                return pink_in_space.abs((float)(x - (this.row - this.size))) / this.tail;
            }
            if (cubePosition.x < this.row + this.size + this.tail) {
                return (this.row + this.size - x) / this.tail;
            }
            return 0.0f;
        }

        public void Sync(Moonlander syncer) {
            this.row = (float)syncer.getValue("sweep_x");
            this.size = (float)syncer.getValue("sweep_size");
            this.tail = (float)syncer.getValue("sweep_tail");
            this.sweep_color = (int)syncer.getValue("sweep_color");
        }
    }
}

