import processing.sound.*;

Blob[] blobs = new Blob[21];
PGraphics pg;
SoundFile file;
int beatId = 0;
import java.util.*;

long audioStartTime = 0;
boolean beat = false;
ArrayDeque<Long> beats;
ArrayDeque<Long> colorbeats;
ArrayDeque<Long> updatetags;
ArrayDeque<float[]> test;

PImage dimang;

long last = 0;
long curBeat = 0;
boolean ending = false;
float fadeOff = 0;
boolean hsb = false;
boolean update = false;


void setup() {
  beats = new ArrayDeque();
  colorbeats = new ArrayDeque();
  updatetags = new ArrayDeque();
  test = new ArrayDeque();
  dimang = loadImage("dimang.png");
  noSmooth();
  /*test.add(new float[]{1,0.1f,0.1f});
  test.add(new float[]{1,1,1});
  test.add(new float[]{1,1f,0.1f});
  test.add(new float[]{1,1,1});
*/  
  test.add(new float[]{1,1,1});
  test.add(new float[]{0.2f,1,1f});
  /*
  test.add(new float[]{0.1f,0.1f,1f});
  test.add(new float[]{1,1,1});
  test.add(new float[]{1f,0.1f,1f});
  test.add(new float[]{1,1,1});*/

  addTimeStamps();
  noCursor();
  randomSeed(64987);

  pg = createGraphics(384, 216);
  fullScreen();
  //size(1280,780);
  colorMode(RGB, 255);
  for (int i = 0; i < blobs.length; i++) {
    blobs[i] = new Blob(random(pg.width), random(pg.height));
  }
  file = new SoundFile(this, "Final-Hour-isaiah658-cc0.mp3");
  file.play();
  audioStartTime = millis();
}

void keyPressed(){
  println("updatetags.add(" + (millis() - audioStartTime) + "l);");
}

float updateLogic(long audioTime, float e){
      if (beats.peek() != null && audioTime + 50 > beats.peek() && audioTime - 200 < beats.peek()){
          e = abs(audioTime - beats.peek())/100;
          //println(e);
          beat = true;
          last = beats.pop();
       } else if (beat == true || update && audioTime - 200 < beats.peek()) {
          beatId++;
          if (beatId >= 12){
            beatId = 0;
          }
          beat = false;
          //println(beatId);
       } 
       
       return e;
}

void draw() {
  if (millis() >  55000l){
    file.amp((56759l - millis()) / (float) 1759);
  }
  if (millis() > 56759l){
    exit();
  }
  pg.beginDraw();
  pg.background(0);
  
  pg.loadPixels();
  long audioTime = millis() - audioStartTime;
  float e = 1;

  if (colorbeats.peek() != null && audioTime + 50 > colorbeats.peek()){
    if (hsb){
      colorMode(RGB, 255);
      hsb = false;
      test.add(test.pop());
    } else {
      colorMode(HSB, 255);
      hsb = true;
    }
    colorbeats.pop();
      
  }  
  
  if (updatetags.peek() != null && audioTime + 50 > updatetags.peek()){
    update = !update;
    updatetags.pop();
  }
  
  float[] colorsToUse = test.peek();
  
  for (int x = 0; x < pg.width; x++) {
    for (int y = 0; y < pg.height; y++) {
      int index = x + y * pg.width;
      float sum = 0;
      float rsum = 0;
      float gsum = 0;
      float bsum = 0;

      int i = 0;
      updateLogic(audioTime, e);
              

      for (Blob b : blobs) {
        
        float d = dist(x, y, b.pos.x, b.pos.y);
        float ee = 1;
        
        if (beat){
          b.newVelo();
        }
        if (i%12 == beatId){
          ee = e * 2f;
        }
        if (i%12 == abs(beatId - 6)){
          ee = e * 0.1f;
          b.update();
        }
        
        if (i%12 == abs(beatId - 9)){
          ee = e * 1.2f;
        }

        
        if (i%12 == abs(beatId - 3)){
          ee = e * 0.5f;
        }
        
        
        if (millis() - last < 500){
          ee *= 2 - (millis() - last)/(float)500;
        }
      

        
        if (i%3 == 0){
          rsum += 4 * b.r * ee / d;
          gsum += 2 * b.r * ee / d;
          bsum += 2 * b.r * ee / d;
        } else if (i%3 == 1){
          rsum += 2 * b.r * ee / d;
          gsum += 4 * b.r * ee / d;
          bsum += 2 * b.r * ee / d;
        } else if (i%3 == 2){
          rsum += 2 * b.r * ee / d;
          gsum += 2 * b.r * ee / d;
          bsum += 4 * b.r * ee / d;
        }
        if (beat){
            rsum = 0;
            gsum = 0;
            bsum = 0;
        }
        if (!hsb){
          rsum = rsum * colorsToUse[0];
          gsum = gsum * colorsToUse[1];
          bsum = bsum * colorsToUse[2];
        }

       

        i++;
      }
      sum = sum / 2;
      pg.pixels[index] = color(rsum, gsum, bsum, 255);
    }

  }

  pg.updatePixels();

  for (Blob b : blobs) {
    b.update();
    //b.show();
  }

  pg.endDraw();
  if (millis() >  45000l){
    tint(255, 255, 255, ((56759l - millis()) / (float) 11759) * 255); 
  }

  image(pg,0,0, width, height);
  
  if (millis() >  49000l){
    if (millis() < 53759l){
      tint(255, 255, 255, 255 - ((53759l - millis()) / (float) 4759) * 255); 
    } else {
      float amount = ((54759l - millis()) / (float) 1000) * 255;
      tint(amount, amount, amount, amount); 
    }
    int dimangW = (int) (206 * (2 - ((54759l - millis()) / (float) 4759)));
    int dimangH = (int) (140 * (2 - ((54759l - millis()) / (float) 4759))); 

    image(dimang, width/2 - dimangW / 2, height/2 - dimangH / 2, dimangW, dimangH);
  }

  
}

class Blob {
  PVector pos;
  float r;
  PVector vel;
  float r2;
  float endR;

  Blob(float x, float y) {
    pos = new PVector(x, y);
    vel = PVector.random2D();
    vel.mult(random(1, 2));
    r = random(-10, -10);
    r2 = random(-10, -15);
    endR = 0;
  }

  void newVelo(){
    vel = PVector.random2D();
    vel.mult(random(1, 2));
  }
  void update() {
    if (millis() > 40000l){
      if (endR == 0){
        endR = r;
      }
      r = endR - (millis() - 40000l) / 24;
    } else {
      r = millis() / 75 + r2;
    }
    pos.add(vel); 
    if (pos.x > pg.width || pos.x < 0) {
      vel.x *= -1;
    }
    if (pos.y > pg.height || pos.y < 0) {
      vel.y *= -1;
    }
  }

  void show() {
    noFill();
    stroke(0);
    strokeWeight(4);
    ellipse(pos.x, pos.y, r*2, r*2);
  }
}

void addTimeStamps(){
  beats.add(404l);
beats.add(776l);
beats.add(1308l);
beats.add(1585l);
beats.add(2143l);
beats.add(2689l);
beats.add(3063l);
beats.add(3604l);
beats.add(4064l);
beats.add(4395l);
beats.add(4982l);
beats.add(5442l);
beats.add(5775l);
beats.add(6357l);
beats.add(6857l);
beats.add(7233l);
beats.add(7774l);
beats.add(8235l);
beats.add(8608l);
beats.add(9189l);
beats.add(9649l);
beats.add(10025l);
beats.add(10612l);
beats.add(11074l);
beats.add(11409l);
beats.add(11953l);
beats.add(12452l);
beats.add(12827l);
beats.add(13413l);
beats.add(13872l);
beats.add(14122l);
beats.add(14829l);
beats.add(15331l);
beats.add(15665l);
beats.add(16253l);
beats.add(16711l);
beats.add(17047l);
beats.add(17593l);
beats.add(18096l);
beats.add(18473l);
beats.add(19014l);
beats.add(19474l);
beats.add(19848l);
beats.add(20433l);
beats.add(20893l);
beats.add(21270l);
beats.add(21857l);
beats.add(22356l);
beats.add(22692l);
beats.add(23275l);
beats.add(23733l);
beats.add(24107l);
beats.add(24691l);
beats.add(25191l);
beats.add(25525l);
beats.add(26067l);
beats.add(26565l);
beats.add(26981l);
beats.add(27524l);
beats.add(28027l);
beats.add(28362l);
beats.add(28951l);
beats.add(29412l);
beats.add(29787l);
beats.add(30328l);
beats.add(30786l);
beats.add(31201l);
beats.add(31745l);
beats.add(32204l);
beats.add(32578l);
beats.add(33132l);
beats.add(33636l);
beats.add(34013l);
beats.add(34558l);
beats.add(35016l);
beats.add(35434l);
beats.add(35977l);
beats.add(36482l);
beats.add(36818l);
beats.add(37359l);
beats.add(37827l);
beats.add(38243l);
beats.add(38830l);
beats.add(39287l);
//beats.add(39664l);

colorbeats.add(5775l);
colorbeats.add(8608l);
colorbeats.add(11409l);
colorbeats.add(14122l);
colorbeats.add(17047l);
colorbeats.add(22692l);

colorbeats.add(28362l);
colorbeats.add(29787l);
colorbeats.add(31201l);
colorbeats.add(34013l);
colorbeats.add(35434l);
colorbeats.add(36818l);
//colorbeats.add(39664l);

updatetags.add(5775l);
updatetags.add(5875l);
updatetags.add(8608l);
updatetags.add(8708l);
updatetags.add(11409l);
updatetags.add(11509l);
updatetags.add(14122l);
updatetags.add(14222l);
updatetags.add(17047l);
updatetags.add(17147l);
updatetags.add(22692l);
updatetags.add(22792l);
}
