/*
 * Decompiled with CFR 0.152.
 */
import damkjer.ocd.Camera;
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PVector;

public class assydemo
extends PApplet {
    float TURN = (float)Math.PI * 2;
    float worblePos = 0.0f;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int fps = 60;
    Moonlander moonlander;
    Camera camera;
    PVector camPos = new PVector(20.0f, -10.0f, 10.0f);
    PVector focusPos = new PVector(0.0f, -5.0f, 0.0f);
    ArrayList<Plant> flowers = new ArrayList();
    float treeAge = 1.0f;
    float singleGrassAge = 1.0f;
    float singleFlowerAge = 1.0f;
    float grassPatchAge = 1.0f;
    float flowerPatchAge = 1.0f;
    Plant tree;
    Plant singleGrass;
    Plant singleFlower;
    Plant grassPatch;
    private PVector t1 = new PVector();
    private PVector t2 = new PVector();
    private PVector tNormal = new PVector();

    public float sinNoise(float t, float x) {
        return 0.5f * assydemo.sin((float)(t * x)) + 0.5f * assydemo.cos((float)(t * 0.31232f * x)) + 0.5f * assydemo.sin((float)((t * 0.123f + assydemo.cos((float)(t * 0.001351f))) * 0.871f * x));
    }

    public float shakyNoise(float time, float freq, float bass, float discant, float seed) {
        return (this.noise(time * 0.2f * freq, seed * 123.321f) * 2.0f - 1.0f) * bass + (this.noise(time * 1.0f * freq, seed * 887.213f) * 2.0f - 1.0f) * discant;
    }

    public void settings() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.fullScreen("processing.opengl.PGraphics3D");
        this.randomSeed(8719L);
        this.noiseSeed(2131L);
    }

    public void setup() {
        this.noCursor();
        this.rectMode(3);
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        this.camera = new Camera((PApplet)this, -20.0f, 0.0f, 0.0f);
        this.camera.aim(0.0f, 0.0f, 0.0f);
        this.camera.feed();
        this.frameRate(this.fps);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"babbys_first_pumpkin_patch.mp3", (int)222, (int)8);
        this.moonlander.start();
        this.setupPlants();
    }

    public void draw() {
        this.background(0);
        this.fill(255);
        this.moonlander.update();
        int stopNow = this.moonlander.getIntValue("stopNow");
        if (stopNow >= 1) {
            this.exit();
        }
        float time = (float)this.moonlander.getCurrentTime();
        float deltaTime = 1.0f / (float)this.fps;
        float cameraSpeed = (float)this.moonlander.getValue("camera:speed");
        float cameraDistance = (float)this.moonlander.getValue("camera:distance");
        float cameraFocusHeight = (float)this.moonlander.getValue("camera:focusHeight");
        this.camPos.x = cameraDistance * assydemo.cos((float)(this.TURN * time * cameraSpeed));
        this.camPos.z = cameraDistance * assydemo.sin((float)(this.TURN * time * cameraSpeed));
        this.camPos.y = (float)this.moonlander.getValue("camera:height");
        this.camera.jump(this.camPos.x, this.camPos.y, this.camPos.z);
        this.camera.aim(this.focusPos.x, this.focusPos.y + cameraFocusHeight, this.focusPos.z);
        this.camera.feed();
        this.noStroke();
        float sunWorbleAmount = (float)this.moonlander.getValue("sun:worbleAmount");
        float sunWorbleSpeed = (float)this.moonlander.getValue("sun:worbleSpeed");
        this.worblePos += deltaTime * sunWorbleSpeed;
        this.directionalLight(255.0f, 200.0f, 50.0f, assydemo.sin((float)this.worblePos) * sunWorbleAmount, -1.0f, -assydemo.cos((float)this.worblePos) * sunWorbleAmount);
        this.directionalLight(20.0f, 40.0f, 140.0f, 0.0f, -1.0f, 0.0f);
        this.ambientLight(30.0f, 50.0f, 80.0f);
        this.directionalLight(200.0f, 50.0f, 10.0f, 0.2f, 0.1f, 0.1f);
        this.treeAge = (float)this.moonlander.getValue("plants:tree");
        this.singleGrassAge = (float)this.moonlander.getValue("plants:singleGrass");
        this.singleFlowerAge = (float)this.moonlander.getValue("plants:singleFlower");
        this.grassPatchAge = (float)this.moonlander.getValue("plants:grassPatch");
        this.flowerPatchAge = (float)this.moonlander.getValue("plants:flowerPatch");
        this.fill(255.0f, 255.0f, 255.0f);
        this.drawPlants(time);
        this.noStroke();
    }

    public void setupPlants() {
        new RandomSequence(21348L);
        this.tree = new Plant(new PVector(0.0f, 0.0f, 0.0f), 42L, new Branch(new Leaf(), new Branch(new Leaf(), new Branch(new Leaf(), new Leaf()))));
        this.singleFlower = new Plant(new PVector(0.0f, 0.0f, 0.0f), 42L, new Flower(new Leaf(this.color(100, 100, 200)), new Leaf(), new PVector(0.0f, 0.0f, 0.0f)));
        this.grassPatch = new Plant(new PVector(0.0f, 0.0f, 0.0f), 42L, new Grass(100, 30));
        this.singleGrass = new Plant(new PVector(0.0f, 0.0f, 0.0f), 42L, new Grass(1, 0));
        int i = 0;
        while (i < 75) {
            this.flowers.add(new Plant(new PVector(0.0f, 0.0f, 0.0f), 42L, new Flower(new Leaf(this.color(this.random(50.0f, 255.0f), this.random(50.0f, 255.0f), this.random(50.0f, 255.0f))), new Leaf(), new PVector(this.random(1.0f) * 25.0f - 12.5f, 0.0f, this.random(1.0f) * 25.0f - 12.5f))));
            ++i;
        }
    }

    public void drawPlants(float time) {
        this.tree.context.age = this.treeAge;
        this.singleGrass.context.age = this.singleGrassAge;
        this.singleFlower.context.age = this.singleFlowerAge;
        this.grassPatch.context.age = this.grassPatchAge;
        this.tree.drawPlant();
        this.grassPatch.drawPlant();
        this.singleGrass.drawPlant();
        this.pushMatrix();
        this.translate(3.0f, 0.0f, 0.0f);
        this.singleFlower.drawPlant();
        this.popMatrix();
        for (Plant plant : this.flowers) {
            plant.context.age = this.flowerPatchAge;
            this.pushMatrix();
            plant.drawPlant();
            this.popMatrix();
        }
    }

    public float mix(float t, float a, float b) {
        return (b - a) * t + a;
    }

    public double mix(double t, double a, double b) {
        return (b - a) * t + a;
    }

    public float smoothMix(float t, float a, float b) {
        float relPos = 0.5f * (1.0f + assydemo.cos((float)assydemo.map((float)t, (float)0.0f, (float)1.0f, (float)((float)Math.PI), (float)((float)Math.PI * 2))));
        return this.mix(relPos, a, b);
    }

    public float mapClamp(float value, float sourceStart, float sourceEnd, float destStart, float destEnd) {
        return assydemo.map((float)assydemo.constrain((float)value, (float)sourceStart, (float)sourceEnd), (float)sourceStart, (float)sourceEnd, (float)destStart, (float)destEnd);
    }

    public float smoothMap(float value, float sourceStart, float sourceEnd, float destStart, float destEnd) {
        float relPos = 0.5f * (1.0f + assydemo.cos((float)assydemo.map((float)value, (float)sourceStart, (float)sourceEnd, (float)((float)Math.PI), (float)((float)Math.PI * 2))));
        return this.mix(relPos, destStart, destEnd);
    }

    public float smoothMapClamp(float value, float sourceStart, float sourceEnd, float destStart, float destEnd) {
        float relPos = 0.5f * (1.0f + assydemo.cos((float)this.mapClamp(value, sourceStart, sourceEnd, (float)Math.PI, (float)Math.PI * 2)));
        return this.mix(relPos, destStart, destEnd);
    }

    public void normal(PVector n) {
        this.normal(n.x, n.y, n.z);
    }

    public void vertex(PVector v) {
        this.vertex(v.x, v.y, v.z);
    }

    public void translate(PVector v) {
        this.translate(v.x, v.y, v.z);
    }

    public PVector faceNormal(PVector p1, PVector p2, PVector p3, PVector normal) {
        this.t1.set(p1);
        this.t1.sub(p2);
        this.t2.set(p1);
        this.t2.sub(p3);
        this.t1.cross(this.t2, normal);
        return normal;
    }

    public void addTriangle(PVector p1, PVector p2, PVector p3) {
        this.faceNormal(p1, p2, p3, this.tNormal);
        this.normal(this.tNormal);
        this.vertex(p1);
        this.vertex(p2);
        this.vertex(p3);
    }

    public void addTriangle(PVector p1, PVector p2, PVector p3, int c) {
        this.addTriangle(p1, p2, p3, c, c, c);
    }

    public void addTriangle(PVector p1, PVector p2, PVector p3, int c1, int c2, int c3) {
        this.faceNormal(p1, p2, p3, this.tNormal);
        this.normal(this.tNormal);
        this.fill(c1);
        this.vertex(p1);
        this.fill(c2);
        this.vertex(p2);
        this.fill(c3);
        this.vertex(p3);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"assydemo"};
        if (passedArgs != null) {
            PApplet.main((String[])assydemo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Apple
    extends PlantPart {
        float size;
        int youngColor;
        int oldColor;

        Apple() {
            this.size = 10.0f;
            this.youngColor = -12541920;
            this.oldColor = -6279072;
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            if (context.plantAge <= 0.0f) {
                this.drawFlower();
            } else {
                this.drawFuit(context);
            }
        }

        public void drawFlower() {
        }

        public void drawFuit(PlantContext context) {
            float s = this.size * context.age;
            assydemo.this.translate(0.0f, -s / 2.0f, 0.0f);
            assydemo.this.fill(assydemo.this.lerpColor(this.youngColor, this.oldColor, context.age));
            assydemo.this.sphereDetail(16);
            assydemo.this.sphere(s);
        }
    }

    class Ball
    extends PlantPart {
        float size;
        int youngColor;
        int oldColor;

        Ball() {
            this.size = 10.0f;
            this.youngColor = -12541920;
            this.oldColor = -6279072;
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            float s = this.size * context.age;
            assydemo.this.translate(0.0f, -s / 2.0f, 0.0f);
            assydemo.this.fill(assydemo.this.lerpColor(this.youngColor, this.oldColor, context.age));
            assydemo.this.sphereDetail(16);
            assydemo.this.sphere(s);
        }
    }

    class Branch
    extends PlantPart {
        PlantPart tip;
        PlantPart branch;
        PVector endPos;
        int sideAmount;
        float maxBrancHeight;
        float branchMaxWidth;
        float minWidth;
        float branchChange;
        float maxOfset;
        int branchColor;
        int brancHeight;
        float branchStep;
        PVector branchEndPos;
        int numberOfBranches;
        float branchesInGrowDirection;

        Branch(PlantPart tip, PlantPart branch) {
            this(tip, branch, 0.3f, 20.0f, 70.0f);
        }

        Branch(PlantPart tip, PlantPart branch, float branchesInGrowDirection, float numBranches, float branchLength) {
            this.tip = null;
            this.branch = null;
            this.sideAmount = 12;
            this.maxBrancHeight = 70.0f;
            this.branchMaxWidth = 0.8f;
            this.minWidth = 0.05f;
            this.branchChange = this.branchMaxWidth - this.minWidth;
            this.maxOfset = 0.4f;
            this.branchColor = assydemo.this.color(222, 184, 135);
            this.brancHeight = 0;
            this.branchStep = 1.0f;
            this.branchEndPos = new PVector(0.0f, 0.0f, 0.0f);
            this.numberOfBranches = 10;
            this.branchesInGrowDirection = 0.3f;
            this.tip = tip;
            this.branch = branch;
            this.branchesInGrowDirection = branchesInGrowDirection;
            this.maxBrancHeight = branchLength;
            this.numberOfBranches = assydemo.max((int)0, (int)((int)numBranches));
        }

        Branch(float branchLength, int branchColor, float maxWidth, float minWidth) {
            this.tip = null;
            this.branch = null;
            this.sideAmount = 12;
            this.maxBrancHeight = 70.0f;
            this.branchMaxWidth = 0.8f;
            this.minWidth = 0.05f;
            this.branchChange = this.branchMaxWidth - this.minWidth;
            this.maxOfset = 0.4f;
            this.branchColor = assydemo.this.color(222, 184, 135);
            this.brancHeight = 0;
            this.branchStep = 1.0f;
            this.branchEndPos = new PVector(0.0f, 0.0f, 0.0f);
            this.numberOfBranches = 10;
            this.branchesInGrowDirection = 0.3f;
            this.maxBrancHeight = branchLength;
            this.numberOfBranches = 0;
            this.branchColor = branchColor;
            this.branchMaxWidth = this.branchMaxWidth;
            this.minWidth = minWidth;
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            assydemo.this.noStroke();
            this.drawBranch(context, random);
            assydemo.this.pushMatrix();
            assydemo.this.translate(this.branchEndPos.x, this.branchEndPos.y, this.branchEndPos.z);
            assydemo.this.scale(-0.1f * context.age);
            if (this.tip != null) {
                this.tip.drawPart(context, random.nextRandom());
            }
            assydemo.this.popMatrix();
        }

        public void drawBranch(PlantContext context, RandomSequence random) {
            float xofset = 0.0f;
            float yofset = 0.0f;
            this.brancHeight = (int)assydemo.this.mapClamp(context.age, 0.0f, 0.5f, 0.0f, this.maxBrancHeight);
            float prevR = context.age * (assydemo.pow((float)1.0f, (float)1.2f) * this.branchChange) * ((float)this.brancHeight / this.maxBrancHeight) + this.minWidth;
            float prevOfsetx = 0.0f;
            float prevOfsety = 0.0f;
            float prevY = 0.0f;
            float branchingAngle = random.nextFloat((float)Math.PI * 2);
            PlantContext branchContext = context.copy();
            int stepsBetweenBranch = this.numberOfBranches <= 0 ? Integer.MAX_VALUE : (int)this.maxBrancHeight / this.numberOfBranches;
            int stepsUntilNext = stepsBetweenBranch + (int)random.nextFloat(4.0f);
            int i = 1;
            while (i <= this.brancHeight) {
                float branchToTop = (float)(this.brancHeight - i) / (float)this.brancHeight;
                float r = context.age * (assydemo.pow((float)(((float)this.brancHeight - (float)i) / (float)this.brancHeight), (float)1.2f) * this.branchChange) * assydemo.pow((float)branchToTop, (float)1.5f) + this.minWidth;
                float ystep = this.branchStep * context.age * assydemo.pow((float)branchToTop, (float)2.0f);
                float y = prevY - ystep;
                this.drawLayer(prevY, y, prevR * context.age, r * context.age, prevOfsetx, prevOfsety, xofset += (random.nextFloat(2.0f * this.maxOfset) - this.maxOfset) * assydemo.pow((float)context.age, (float)2.0f) * branchToTop * branchToTop, yofset += (random.nextFloat(2.0f * this.maxOfset) - this.maxOfset) * assydemo.pow((float)context.age, (float)2.0f) * branchToTop * branchToTop);
                prevR = r;
                prevOfsetx = xofset;
                prevOfsety = yofset;
                float minAgeForChildBranches = 0.1f;
                if (stepsUntilNext <= 0 && this.branch != null && context.age >= minAgeForChildBranches) {
                    assydemo.this.pushMatrix();
                    assydemo.this.translate(this.branchEndPos.x, this.branchEndPos.y, this.branchEndPos.z);
                    assydemo.this.scale(0.9f);
                    assydemo.this.rotateY(branchingAngle);
                    branchingAngle += 2.3999631f;
                    assydemo.this.rotateX(this.branchesInGrowDirection * (float)Math.PI + random.nextGaussishFloat(0.0f, 0.4f));
                    branchContext.age = assydemo.this.mapClamp(context.age, 0.3f, 1.0f, 0.2f, 0.8f) * assydemo.pow((float)branchToTop, (float)1.5f);
                    this.branch.drawPart(branchContext, random.nextRandom());
                    stepsUntilNext = stepsBetweenBranch + random.nextInt(0, 3);
                    assydemo.this.popMatrix();
                }
                --stepsUntilNext;
                prevY = y;
                ++i;
            }
        }

        public void drawLayer(float prevY, float y, float prevR, float r, float prevOfsetx, float prevOfsety, float xofset, float yofset) {
            assydemo.this.beginShape(10);
            assydemo.this.fill(this.branchColor);
            int i = 0;
            while (i < this.sideAmount + 1) {
                this.drawVertex(i, y, r, xofset, yofset);
                this.drawVertex(i, prevY, prevR, prevOfsetx, prevOfsety);
                ++i;
            }
            assydemo.this.endShape(10);
        }

        public void drawVertex(float i, float y, float r, float xofset, float yofset) {
            float a = i * 1.0f / ((float)this.sideAmount + 0.001f);
            float x = assydemo.cos((float)((float)Math.PI * 2 * a)) * r + xofset;
            float z = assydemo.sin((float)((float)Math.PI * 2 * a)) * r + yofset;
            assydemo.this.vertex(x, y, z);
            this.branchEndPos.x = x;
            this.branchEndPos.y = y;
            this.branchEndPos.z = z;
        }
    }

    class CubePart
    extends PlantPart {
        CubePart() {
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            float size = context.age + 0.2f;
            assydemo.this.fill(200.0f, 0.0f, 70.0f);
            assydemo.this.translate(0.0f, -size / 2.0f, 0.0f);
            assydemo.this.box(size, size, size);
        }

        public void drawCylinder() {
        }
    }

    class Flower
    extends PlantPart {
        int petalAmount;
        PlantPart petal;
        PlantPart stalk;
        PlantPart leaf;
        float petalLenght;
        float stalkLength;
        int branchColor;
        int sideAmount;
        PVector branchEndPos;
        PVector pos;
        float flowerRot;

        Flower(PlantPart petal, PlantPart leaf, PVector pos) {
            this.petalAmount = 7;
            this.petalLenght = 1.5f;
            this.stalkLength = 3.0f;
            this.branchColor = assydemo.this.color(50, 200, 60);
            this.sideAmount = 12;
            this.branchEndPos = new PVector(0.0f, 0.0f, 0.0f);
            this.pos = new PVector(0.0f, 0.0f, 0.0f);
            this.flowerRot = 0.0f;
            this.petal = petal;
            this.pos = pos;
            this.petalLenght = 1.0f + assydemo.this.random(1.0f);
            this.stalkLength = 2.5f + assydemo.this.random(1.0f);
            this.leaf = leaf;
            this.flowerRot = assydemo.this.random(-1.0f, 1.0f);
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            assydemo.this.pushMatrix();
            assydemo.this.translate(this.pos.x, this.pos.y, this.pos.z);
            assydemo.this.pushMatrix();
            assydemo.this.rotateX((float)Math.PI);
            this.drawLayer(0.0f, this.stalkLength * context.age, 0.1f, 0.05f, 0.0f, 0.0f, 0.0f, 0.0f);
            assydemo.this.popMatrix();
            assydemo.this.pushMatrix();
            assydemo.this.translate(0.0f, -this.stalkLength * context.age, 0.0f);
            assydemo.this.scale(this.petalLenght * assydemo.pow((float)context.age, (float)2.0f));
            assydemo.this.rotateX(1.5707964f);
            assydemo.this.rotateY(0.5f + this.flowerRot);
            float rotateStep = (float)Math.PI * 2 / (float)this.petalAmount;
            int i = 0;
            while (i < this.petalAmount) {
                assydemo.this.rotateZ(rotateStep);
                this.petal.drawPart(context, random.nextRandom());
                ++i;
            }
            assydemo.this.popMatrix();
            assydemo.this.pushMatrix();
            assydemo.this.translate(0.0f, -this.stalkLength * context.age * 0.5f, 0.0f);
            assydemo.this.scale(this.petalLenght * assydemo.pow((float)context.age, (float)2.0f));
            assydemo.this.rotateY(0.5f);
            assydemo.this.rotateX(1.0995574f);
            this.leaf.drawPart(context, random.nextRandom());
            assydemo.this.popMatrix();
            assydemo.this.pushMatrix();
            assydemo.this.translate(0.0f, -this.stalkLength * context.age * 0.5f, 0.0f);
            assydemo.this.scale(this.petalLenght * assydemo.pow((float)context.age, (float)2.0f));
            assydemo.this.rotateY(0.5f);
            assydemo.this.rotateX(1.5707964f);
            assydemo.this.rotateZ((float)Math.PI);
            assydemo.this.rotateX(-0.47123894f);
            this.leaf.drawPart(context, random.nextRandom());
            assydemo.this.popMatrix();
            assydemo.this.popMatrix();
        }

        public void drawLayer(float prevY, float y, float prevR, float r, float prevOfsetx, float prevOfsety, float xofset, float yofset) {
            assydemo.this.beginShape(10);
            assydemo.this.fill(this.branchColor);
            assydemo.this.noStroke();
            int i = 0;
            while (i < this.sideAmount + 1) {
                this.drawVertex(i, y, r, xofset, yofset);
                this.drawVertex(i, prevY, prevR, prevOfsetx, prevOfsety);
                ++i;
            }
            assydemo.this.endShape(10);
        }

        public void drawVertex(float i, float y, float r, float xofset, float yofset) {
            float a = i * 1.0f / ((float)this.sideAmount + 0.001f);
            float x = assydemo.cos((float)((float)Math.PI * 2 * a)) * r + xofset;
            float z = assydemo.sin((float)((float)Math.PI * 2 * a)) * r + yofset;
            assydemo.this.vertex(x, y, z);
            this.branchEndPos.x = x;
            this.branchEndPos.y = y;
            this.branchEndPos.z = z;
        }
    }

    class Grass
    extends PlantPart {
        float stalkLength;
        int branchColor;
        int sideAmount;
        PVector branchEndPos;
        int grassAmount;
        float patchWidth;

        Grass() {
            this.stalkLength = 2.5f;
            this.branchColor = assydemo.this.color(50, 200, 60);
            this.sideAmount = 12;
            this.branchEndPos = new PVector(0.0f, 0.0f, 0.0f);
            this.grassAmount = 20;
            this.patchWidth = 10.0f;
        }

        Grass(int grassAmount, int patchWidth) {
            this.stalkLength = 2.5f;
            this.branchColor = assydemo.this.color(50, 200, 60);
            this.sideAmount = 12;
            this.branchEndPos = new PVector(0.0f, 0.0f, 0.0f);
            this.grassAmount = 20;
            this.patchWidth = 10.0f;
            this.grassAmount = grassAmount;
            this.patchWidth = patchWidth;
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            int i = 0;
            while (i < this.grassAmount) {
                assydemo.this.pushMatrix();
                assydemo.this.translate(random.nextFloat() * this.patchWidth - 0.5f * this.patchWidth, 0.0f, random.nextFloat() * this.patchWidth - 0.5f * this.patchWidth);
                assydemo.this.rotateX((float)Math.PI - random.nextFloat(0.25f));
                float stalkL = this.stalkLength * context.age * (random.nextFloat(0.5f) + 0.5f);
                this.drawLayer(0.0f, stalkL * 0.5f, 0.08f, 0.05f, 0.0f, 0.0f, 0.0f, 0.0f);
                this.drawLayer(stalkL * 0.5f, stalkL, 0.05f, 0.01f, 0.0f, 0.0f, random.nextFloat(0.5f) - 0.25f, 0.0f);
                assydemo.this.popMatrix();
                ++i;
            }
        }

        public void drawLayer(float prevY, float y, float prevR, float r, float prevOfsetx, float prevOfsety, float xofset, float yofset) {
            assydemo.this.beginShape(10);
            assydemo.this.fill(this.branchColor);
            assydemo.this.noStroke();
            int i = 0;
            while (i < this.sideAmount + 1) {
                this.drawVertex(i, y, r, xofset, yofset);
                this.drawVertex(i, prevY, prevR, prevOfsetx, prevOfsety);
                ++i;
            }
            assydemo.this.endShape(10);
        }

        public void drawVertex(float i, float y, float r, float xofset, float yofset) {
            float a = i * 1.0f / ((float)this.sideAmount + 0.001f);
            float x = assydemo.cos((float)((float)Math.PI * 2 * a)) * r + xofset;
            float z = assydemo.sin((float)((float)Math.PI * 2 * a)) * r + yofset;
            assydemo.this.vertex(x, y, z);
            this.branchEndPos.x = x;
            this.branchEndPos.y = y;
            this.branchEndPos.z = z;
        }
    }

    class Leaf
    extends PlantPart {
        private PVector p1;
        private PVector p2;
        private PVector p3;
        int leafCol;

        Leaf() {
            this.p1 = new PVector();
            this.p2 = new PVector();
            this.p3 = new PVector();
            this.leafCol = assydemo.this.color(50, 200, 60);
        }

        Leaf(int leafColor) {
            this.p1 = new PVector();
            this.p2 = new PVector();
            this.p3 = new PVector();
            this.leafCol = assydemo.this.color(50, 200, 60);
            this.leafCol = leafColor;
        }

        @Override
        public void doInit(RandomSequence random) {
        }

        @Override
        public void drawPart(PlantContext context, RandomSequence random) {
            int leafSegments = 6;
            float leafLength = 1.0f;
            float leafWidth = 0.5f;
            float upTilt = 0.3f;
            assydemo.this.fill(this.leafCol);
            assydemo.this.noStroke();
            assydemo.this.beginShape(9);
            int i = 0;
            while (i < leafSegments) {
                float relPos = assydemo.map((float)i, (float)0.0f, (float)leafSegments, (float)0.0f, (float)1.0f);
                float nextRelPos = assydemo.map((float)(i + 1), (float)0.0f, (float)leafSegments, (float)0.0f, (float)1.0f);
                this.leafEdgePoint(relPos, 0.5f * leafWidth, leafLength, upTilt, this.p1);
                this.leafCenterPoint(relPos, leafLength, this.p2);
                this.leafCenterPoint(nextRelPos, leafLength, this.p3);
                assydemo.this.addTriangle(this.p1, this.p2, this.p3);
                this.leafCenterPoint(nextRelPos, leafLength, this.p1);
                this.leafEdgePoint(nextRelPos, 0.5f * leafWidth, leafLength, upTilt, this.p2);
                this.leafEdgePoint(relPos, 0.5f * leafWidth, leafLength, upTilt, this.p3);
                assydemo.this.addTriangle(this.p1, this.p2, this.p3);
                this.leafCenterPoint(relPos, leafLength, this.p1);
                this.leafEdgePoint(relPos, -0.5f * leafWidth, leafLength, upTilt, this.p2);
                this.leafCenterPoint(nextRelPos, leafLength, this.p3);
                assydemo.this.addTriangle(this.p1, this.p2, this.p3);
                this.leafEdgePoint(nextRelPos, -0.5f * leafWidth, leafLength, upTilt, this.p1);
                this.leafCenterPoint(nextRelPos, leafLength, this.p2);
                this.leafEdgePoint(relPos, -0.5f * leafWidth, leafLength, upTilt, this.p3);
                assydemo.this.addTriangle(this.p1, this.p2, this.p3);
                ++i;
            }
            assydemo.this.endShape();
        }

        public void leafCenterPoint(float relPos, float leafLen, PVector pos) {
            float y = assydemo.this.mix(relPos, 0.0f, -leafLen);
            pos.x = 0.0f;
            pos.y = y;
            pos.z = 0.0f;
        }

        public void leafEdgePoint(float relPos, float leafR, float leafLen, float upTilt, PVector pos) {
            float cutoverPoint = 0.8f;
            float baseW = assydemo.pow((float)assydemo.this.mapClamp(relPos, 0.0f, cutoverPoint, 0.0f, 1.0f), (float)0.5f);
            float tipW = 0.5f * (1.0f + assydemo.cos((float)(assydemo.this.TURN * assydemo.this.mapClamp(relPos, cutoverPoint, 1.0f, 0.0f, 1.0f) * 0.5f)));
            float w = assydemo.this.mix(relPos, baseW, tipW);
            float x = 0.5f * leafR * w;
            float z = 0.0f + upTilt * assydemo.abs((float)leafR) * assydemo.sin((float)(0.5f * assydemo.this.TURN * assydemo.min((float)relPos, (float)(1.0f - relPos))));
            float y = assydemo.this.mix(relPos, 0.0f, -leafLen);
            pos.x = x;
            pos.y = y;
            pos.z = z;
        }
    }

    class Plant {
        PVector groundPos;
        PVector growDirection;
        long seed;
        PlantPart part;
        PlantContext context;
        private RandomSequence random;

        Plant(PVector pos, long seed, PlantPart part) {
            this.context = new PlantContext();
            this.random = new RandomSequence();
            this.seed = seed;
            this.part = part;
            this.groundPos = pos.copy();
            this.growDirection = new PVector(0.0f, 0.0f, 1.0f);
        }

        public void drawPlant() {
            this.random.setSeed(this.seed, new double[0]);
            assydemo.this.pushMatrix();
            assydemo.this.translate(this.groundPos.x, this.groundPos.y, this.groundPos.z);
            assydemo.this.rotateY(this.random.nextFloat(0.0f, (float)Math.PI * 2));
            assydemo.this.noFill();
            assydemo.this.stroke(255);
            this.part.drawPart(this.context, this.random);
            assydemo.this.popMatrix();
        }

        public void init(RandomSequence random) {
            this.part.init(random);
        }
    }

    class PlantContext {
        float age = 0.5f;
        float plantAge = 0.5f;

        PlantContext(float age) {
            this.age = age;
            this.plantAge = age;
        }

        PlantContext() {
        }

        public PlantContext copy() {
            PlantContext copy = new PlantContext(this.age);
            copy.plantAge = this.plantAge;
            copy.age = this.age;
            return copy;
        }
    }

    class PlantPart {
        private ArrayList<PlantPart> childParts = new ArrayList();

        PlantPart() {
        }

        public ArrayList<PlantPart> getChildParts() {
            return this.childParts;
        }

        public void addChildPart(PlantPart part) {
            this.childParts.add(part);
        }

        public final void init(RandomSequence random) {
            this.doInit(random.nextRandom());
            for (PlantPart part : this.getChildParts()) {
                part.init(random.nextRandom());
            }
        }

        public void doInit(RandomSequence random) {
        }

        public void drawPart(PlantContext context, RandomSequence random) {
        }
    }

    class RandomSequence {
        long state0 = 0L;
        long state1 = 0L;
        boolean haveExtraGaussian = false;
        private double extraGaussian;
        public static final long CONSTANT_A = -49064778989728563L;
        public static final long CONSTANT_B = -4265267296055464877L;

        RandomSequence() {
            this.setHashedSeed(this.hash(System.nanoTime()));
        }

        RandomSequence(long seed) {
            this.setHashedSeed(this.hash(seed));
        }

        public void setHashedSeed(long seed) {
            this.state0 = seed;
            this.state1 = this.hash(this.hash(seed));
            if (this.state0 == 0L) {
                this.state0 = 9045324987L;
            }
            if (this.state1 == 0L) {
                this.state1 = 3912353188L;
            }
        }

        public void setSeed(double seed, double ... additionalSeeds) {
            long hashedSeed = this.hash(Double.doubleToLongBits(seed));
            double[] dArray = additionalSeeds;
            int n = additionalSeeds.length;
            int n2 = 0;
            while (n2 < n) {
                double additionalSeed = dArray[n2];
                hashedSeed = this.hash(hashedSeed);
                hashedSeed ^= this.hash(Double.doubleToLongBits(additionalSeed));
                ++n2;
            }
            hashedSeed = this.hash(hashedSeed);
            this.haveExtraGaussian = false;
            this.setHashedSeed(hashedSeed);
        }

        public boolean nextBoolean(double probabilityForTrue) {
            return this.nextDouble() < probabilityForTrue;
        }

        public boolean nextBoolean(float probabilityForTrue) {
            return this.nextFloat() < probabilityForTrue;
        }

        public int nextInt() {
            return (int)(this.nextLong() >> 32);
        }

        public int nextInt(int minInt, int maxInt) {
            return this.nextInt() % (maxInt - minInt) + minInt;
        }

        public int nextInt(int maxInt) {
            return this.nextInt(0, maxInt);
        }

        public float nextFloat() {
            return (float)this.nextBits(24) / 1.6777216E7f;
        }

        public float nextFloat(float max) {
            if (max < 0.0f) {
                throw new IllegalArgumentException("max should not be negative, but it was " + max);
            }
            return this.nextFloat() * max;
        }

        public float nextFloat(float min, float max) {
            return assydemo.min((float)min, (float)max) + this.nextFloat(assydemo.abs((float)(max - min)));
        }

        public float nextGaussishFloat(float mean, float stdDev) {
            return this.nextFloat(-1.0f, 1.0f) * this.nextFloat(-1.0f, 1.0f) * this.nextFloat(-1.0f, 1.0f) * this.nextFloat(-1.0f, 1.0f) * stdDev + mean;
        }

        public double nextDouble() {
            return (double)this.nextBits(53) / 9.007199254740992E15;
        }

        private long nextBits(int numberOfBits) {
            return this.nextLong() >>> 64 - numberOfBits;
        }

        public long nextLong() {
            long result = this.state0 + this.state1;
            long t1 = this.state1 ^ this.state0;
            this.state0 = Long.rotateLeft(this.state0, 55) ^ t1 ^ t1 << 14;
            this.state1 = Long.rotateLeft(t1, 36);
            return result;
        }

        public RandomSequence nextRandom() {
            return new RandomSequence(this.nextLong());
        }

        public long hash(long input) {
            long value = input;
            if (value == 0L) {
                value = 8726312L;
            }
            value ^= value >>> 33;
            value *= -49064778989728563L;
            value ^= value >>> 33;
            return (value *= -4265267296055464877L) ^ value >>> 33;
        }
    }

    class Value {
        float start = 0.0f;
        float end = 1.0f;
        boolean smooth = false;

        Value() {
        }

        Value(boolean smooth) {
            this.smooth = smooth;
        }

        Value(float start, float end, boolean smooth) {
            this.start = start;
            this.end = end;
            this.smooth = smooth;
        }

        Value(float start, float end) {
            this(start, end, false);
        }

        public float get() {
            return this.get(0.5f);
        }

        public float get(PlantContext context) {
            return this.get(context.age);
        }

        public float get(float pos) {
            if (this.smooth) {
                return assydemo.this.smoothMix(pos, this.start, this.end);
            }
            return assydemo.this.mix(pos, this.start, this.end);
        }
    }
}

