/**
 * Created by Hans on 31-10-2016.
 */
// SPECTRUM COLOUR PICKER

function setLastUsedSettings() {
    if (localStorage.tanksLastBody !== undefined) {
        var colour = localStorage.tanksLastBody;
        $('#bodyColourField').spectrum("set", colour);
        $('#previewBody').css({'background-color': colour});
    }

    if (localStorage.tanksLastTurret !== undefined) {
        var colour = localStorage.tanksLastTurret;
        $('#turretColourField').spectrum("set", colour);
        $('#previewTurret').css({'background-color': colour});
    }

    if (localStorage.tanksLastBarrel !== undefined) {
        var colour = localStorage.tanksLastBarrel;
        $('#barrelColourField').spectrum("set", colour);
        $('#previewBarrel').css({'background-color': colour});
    }

    if (localStorage.tanksLastName !== undefined) {
        $('#nameField').val(localStorage.tanksLastName);
    }
}

$("#bodyColourField").spectrum({
    color: "#999",
    clickoutFiresChange: true,
    change: function(color) {
        $("#previewBody").css({'background-color': color.toHexString()});
        localStorage.tanksLastBody = color.toHexString();
    },
    move: function(color) {
        $("#previewBody").css({'background-color': color.toHexString()});
    },
    showPalette: true,
    showSelectionPalette: true, // true by default
    palette: [ ],
    localStorageKey: "spectrum.tanksPersonalPalette" // Any Spectrum with the same string will share selection
});
$("#turretColourField").spectrum({
    color: "#999",
    clickoutFiresChange: true,
    change: function(color) {
        $("#previewTurret").css({'background-color': color.toHexString()});
        localStorage.tanksLastTurret = color.toHexString();
    },
    move: function(color) {
        $("#previewTurret").css({'background-color': color.toHexString()});
    },
    showPalette: true,
    showSelectionPalette: true, // true by default
    palette: [ ],
    localStorageKey: "spectrum.tanksPersonalPalette" // Any Spectrum with the same string will share selection
});
$("#barrelColourField").spectrum({
    color: "#999",
    clickoutFiresChange: true,
    change: function(color) {
        $("#previewBarrel").css({'background-color': color.toHexString()});
        localStorage.tanksLastBarrel = color.toHexString();
    },
    move: function(color) {
        $("#previewBarrel").css({'background-color': color.toHexString()});
    },
    showPalette: true,
    showSelectionPalette: true, // true by default
    palette: [ ],
    localStorageKey: "spectrum.tanksPersonalPalette" // Any Spectrum with the same string will share selection
});