/**
 * Created by Hans on 25-10-2016.
 */
"use strict";
var socket = io();

var rotationSpeed = 0;
var moveSpeed = 0;
var shootTimer = 0;

var moveMultiplier = 1;
var shootMultiplier = 1;

var projectileAngle = 0;
var projectileX = 0;
var projectileY = 0;

var shootCooldown = undefined;
var gameLoop = undefined;
var world = undefined;

var myName = undefined;
var myId = undefined;
var myPlayer = undefined;

var players = [];
var projectiles = [];

var screenWidth = window.innerWidth;
var screenHeight = window.innerHeight;

var centerX = undefined;
var centerY = undefined;

var warningTicker = 0;
var tickerUp = true;
var warningBool = false;

var alive = false;
var clickedReady = false;

var wentOutside = undefined;

var canPressEnter = true;

function enableEnter(enable) {
    canPressEnter = enable;
}

socket.on('serverHandShake', function(data) {

    alive = true;

    rotationSpeed = data.behavior.rotationSpeed;
    moveSpeed = data.behavior.moveSpeed;
    shootTimer = data.behavior.shootTimer;
    world = data.world;

    myPlayer = data.player;
    myId = data.player.id;

    players = data.players;

    var worldDiv = $('#world');
    worldDiv.css({width: world.width, height: world.height});
    $('#treemap').css({width: world.width, height: world.height});

    placePuddles(world.puddles, worldDiv);
    placeTrees(world.trees, worldDiv);
    //placePowerUp(world.powerUps, worldDiv);

    addPlayerToField(myPlayer, true);

    addAllPlayersToField();
    resetAmmunitionMeter();

    gameLoop = setInterval(update, world.updateSpeed);
});

function placePowerUp(array, worldDiv) {
    var field = $('#field');
    for (let powerUp of array) {
        var pu = $('<div></div>')
            .addClass('powerUp')
            .css({
                'background-color': '#fff',
                'left': powerUp.worldX + 'px',
                'top': powerUp.worldY + 'px'
            })
            .text('S ' + Math.round((powerUp.multiplier * 100)) + '% ' + powerUp.time + 's')
            .data({
                id: powerUp.id,
                time: powerUp.time,
                type: powerUp.type,
                multi: powerUp.multiplier
            });
        /*
            .data('id', powerUp.id)
            .data('time', powerUp.time);
            */
        worldDiv.append(pu);
    }
}

function placePuddles(puddles, worldDiv) {
    for (let puddle of puddles) {
        worldDiv.append('<div style="width:' + puddle.size + 'px; height:' + puddle.size + 'px;' +
            'left:' + puddle.worldX + 'px; top:' + puddle.worldY + 'px;" class="puddle"></div>');
    }
}

function placeTrees(trees, worldDiv) {
    for (let tree of trees) {
        var x = tree.worldX - (tree.size / 2) + (tree.markerSize / 2);
        var y = tree.worldY - (tree.size / 2) + (tree.markerSize / 2);
        $('#treemap').append('<div style="width:' + tree.size + 'px; height:' + tree.size + 'px;' +
            'left:' + x + 'px; top:' + y + 'px;" class="tree"></div>');

        worldDiv.append('<div style="left:' + tree.worldX + 'px; top:' + tree.worldY + 'px;' +
            'width:' + tree.markerSize + 'px; height:' + tree.markerSize + 'px;" class="treeMarker"></div>');
    }
}

socket.on('serverNewHandShake', function(data) {
    if (alive) {
        players = data.allPlayers;

        addPlayerToField(data.newPlayer, false);
    }
});

socket.on('serverChangedKeyState', function(data) {
    if (alive) {
        updateSinglePlayer(data);
    }
});

function updateSinglePlayer(playerData) {
    for (var i = 0; i < players.length; i++) {
        if (playerData.id === players[i].id) {
            players[i] = playerData;
            break;
        }
    }
}

socket.on('serverNewProjectileFired', function(projectile) {
    if (alive) {
        initProjectile(projectile);
    }
});

socket.on('serverProjectileHit', function(toFrom) {
    if (alive) {
        displayProjectileHit(toFrom.toPlayer, toFrom.fromPlayer);
    }
});

socket.on('serverClientDied', function(death) {
    if (alive) {
        removePlayerFromField(death.player.id, false);

        displayUpdate(death.player, death.reason);
    }
});

socket.on('serverUpdateScoreboard', function(playerScores) {
    var board = $("#scoreBoardScores");
    board.empty();
    for (let player of playerScores) {
        board.append('<div class="scoreBlock">' +
            '<div class="scoreBlockName">' + player.name + '</div><div class="scoreBlockScore">' + player.score + '</div>' +
            '</div>');
    }
});

socket.on('newPowerUp', function(powerUp) {
    if (alive) {
        console.log(powerUp);

        placeNewPowerUp(powerUp);
    }
});
socket.on('removePowerUp', function(powerUp) {
    if (alive) {
        //console.log('this power up died:', powerUp);
        removePowerUp(powerUp.id);
    }
});

function placeNewPowerUp(powerUp) {
    var pu = $('<div></div>')
        .addClass('powerUp')
        .css({
            'background-color': '#f0f',
            'left': powerUp.worldX + 'px',
            'top': powerUp.worldY + 'px'
        })
        .text('S ' + Math.round((powerUp.multiplier * 100)) + '% ' + powerUp.time + 's')
        .data({
            id: powerUp.id,
            time: powerUp.time,
            type: powerUp.type,
            multi: powerUp.multiplier
        });
        /*.data('id', powerUp.id)
        .data('time', powerUp.time)
        .data('type', powerUp.type)
        .data('multi', powerUp.multiplier);
        */
    $('#world').append(pu);
}

function removePowerUp(id) {
    var powerUps = $('#world').children('.powerUp');
    //console.log(powerUps);
    for (let x of powerUps) {
        var pu = $(x);
        //console.log(pu);
        if (pu.data('id') === id) {
            pu.remove();
        }
    }
}

function displayUpdate(player, reason) {
    $('#updates').append('<div id="update_' + player.id + '" class="updateBig">' + player.name + ' ' + reason + '</div>');

    $('#update_' + player.id).fadeOut(1500, function() {
        $(this).remove();
    });
}

function initProjectile(projectile) {
    projectiles.push(projectile);

    var shotId = 'shot_' + projectile.playerId;

    $('#world').append('<div id="' + shotId + '" class="tankProjectileMarker"><div class="tankProjectile"></div></div>');
    $('#shot_' + projectile.playerId).css({
        left: projectile.originX,
        top: projectile.originY
    });

    var toX = projectile.originX + (world.projectileTravel * Math.sin(projectile.angle));
    var toY = projectile.originY - (world.projectileTravel * Math.cos(projectile.angle));

    $('#' + shotId).animate({
        left:toX,
        top:toY
    }, world.projectileLifetime, 'linear', function() {
        $(this).remove();
    });
}

// GAME LOOP

function update() {
    //var begin = Date.now();

    screenWidth = window.innerWidth;
    screenHeight = window.innerHeight;
    centerX = screenWidth / 2;
    centerY = screenHeight / 2;

    var player = undefined;
    for (var i = 0; i < players.length; i++) {
        player = players[i];
        if (player.id !== myId) {
            moveTank(player, false);
        }
    }

    moveTank(myPlayer, true);

    displayShootTimer();
    projectileHitDetection();

    //console.log(Date.now() - begin);
}

function projectileHitDetection() {
    var projectile = undefined;
    for (var i = 0; i < projectiles.length; i++) {
        projectile = projectiles[i];
        hitDetection(projectile.playerId);
    }
}

function displayShootTimer() {
    if (myPlayer.tank.hasShot) {
        var shootDuration = Date.now() - myPlayer.tank.lastShot;
        if (shootDuration >= shootTimer) {
            myPlayer.tank.hasShot = false;

            resetAmmunitionMeter();

        } else {

            var pct = Math.round(shootDuration * 100 / shootTimer);
            $('#ammunitionMeter').attr('class', 'ammunitionLoading').css({
                'width': pct + '%'
            }).html(pct + '%');

        }
    }
}

function resetAmmunitionMeter() {
    $('#ammunitionMeter').attr('class', 'ammunitionReady').css({
        'width':'100%'
    }).html('Shoot (Space)');
}

function hitDetection(playerId) {
    var shot = $('#shot_' + playerId);
    var hitTreeList = shot.collision('.tree');
    var hitList = shot.collision('.tankBody');

    if (hitTreeList.length > 0) {
        removeProjectile(playerId);
    }

    if (hitList.length > 0) {
        var body = hitList[0];
        if (body.id !== playerId) {

            socket.emit('clientProjectileHit', {
                fromPlayer: playerId,
                toPlayer: body.id
            });

            displayProjectileHit(body.id, playerId);
        }
    }
}

function displayProjectileHit(toId, fromId) {
    removeProjectile(fromId);

    if (toId === myPlayer.id) {
        killMe('was shot by ' + getPlayerById(fromId).name + '.', fromId);
    }

}

function removePlayerFromField(playerId, self) {
    var fadeOutTimer = 1000;

    removeProjectile(playerId);

    if (self) {
        explodePlayer(myPlayer);
    } else {
        var player = getPlayerById(playerId);

        explodePlayer(player);
    }
    $('#name_' + playerId).fadeOut(fadeOutTimer, 'linear', function() {
        $(this).remove();
    });
    $('#player_' + playerId).fadeOut( fadeOutTimer, 'linear', function() {
        $(this).remove();
        removePlayerById(playerId);

        if (self) {

            // RESETTING

            shootCooldown = undefined;
            world = undefined;

            myPlayer = undefined;

            players = [];
            projectiles = [];

            warningTicker = 0;
            tickerUp = true;
            warningBool = false;

            showPreview();

            $('#welcome').fadeIn(500, function() {
                $('#field').empty();
                $('#world').empty();
                $('#treemap').empty();
                $('#nameplates').empty();
                $('#updates').empty();
                enableEnter(true);
            });
        }
    });
}

function killMe(reason, credit) {
    if (alive) {
        alive = false;
        forceHaltTank();

        socket.emit('clientDied', {id: myPlayer.id, reason: reason, creditId: credit});
        displayUpdate(myPlayer, reason);

        clickedReady = false;
        clearTimeout(gameLoop);

        removePlayerFromField(myId, true);
    }
}

function forceHaltTank() {
    myPlayer.tank.moveUp = false;
    myPlayer.tank.moveDown = false;
    myPlayer.tank.moveLeft = false;
    myPlayer.tank.moveRight = false;

    socket.emit('clientChangedKeyState', myPlayer);
}

function removeProjectile(playerId) {
    removeProjectileById(playerId);
    $('#shot_' + playerId).stop().remove();
}

function removeProjectileById(playerId) {
    for (var i = 0; i < projectiles.length; i++) {
        if (projectiles[i].playerId === playerId) {
            projectiles.splice(i, 1);
            break;
        }
    }
}

function moveTank(player, self) {

    var tankDiv = $('#player_' + player.id);

    var setMoveSpeed = moveSpeed * moveMultiplier;
    var setRotationSpeed = rotationSpeed * moveMultiplier;
    var tankHitList = tankDiv.collision(".puddle");

    if (tankHitList.length > 0) {
        setMoveSpeed = moveSpeed * 0.5;
        setRotationSpeed = rotationSpeed * 0.75;
    }

    if (player.tank.moveLeft) {
        player.tank.rotation -= setRotationSpeed;
    }

    if (player.tank.moveRight) {
        player.tank.rotation += setRotationSpeed;
    }

    var degreeInRadians = player.tank.rotation * (Math.PI / 180);

    if (player.tank.moveUp) {
        player.tank.x += setMoveSpeed * Math.sin(degreeInRadians);
        player.tank.y -= setMoveSpeed * Math.cos(degreeInRadians);
    }

    if (player.tank.moveDown) {
        player.tank.x -= setMoveSpeed * Math.sin(degreeInRadians);
        player.tank.y += setMoveSpeed * Math.cos(degreeInRadians);
    }

    tankDiv.css({'transform': 'rotate(' + player.tank.rotation + 'deg)'});

    if (self) {
        tankDiv.css({left: centerX, top: centerY});

        world.relativeX = (centerX - player.tank.x);
        world.relativeY = (centerY - player.tank.y);

        $('#world').css({left: world.relativeX, top: world.relativeY});
        $('#treemap').css({left: world.relativeX, top: world.relativeY});

        /*
        var tankHitPowerUp = tankDiv.collision('.powerUp');
        if (tankHitPowerUp.length > 0) {
            var powerUp = $(tankHitPowerUp[0]);
            var id = powerUp.data('id');
            socket.emit('clientHitPowerUp', {id: id});
            applyPowerUp(powerUp);
            console.log(moveMultiplier);
        }
        */

        alertWhenOutside();
    } else {
        tankDiv.css({left: world.relativeX + player.tank.x, top: world.relativeY + player.tank.y});
    }

    moveNamePlate(player);
}

function applyPowerUp(powerUp) {
    console.log(powerUp.data('type'));
    console.log(powerUp.data('multi'));
    console.log(powerUp.data('time'));
    console.log(powerUp.data('id'));
    switch (powerUp.data('type')) {
        case 'speed':
            moveMultiplier = 1 + powerUp.data('multi');
            break;
    }
}

function moveNamePlate(player) {
    var namePlate = $('#name_' + player.id);
    namePlate.css({
        left: world.relativeX + player.tank.x - (namePlate.width() / 2),
        top: world.relativeY + player.tank.y - 100
    });
}

function alertWhenOutside() {
    if (myPlayer.tank.x < 0 || myPlayer.tank.x > world.width
    || myPlayer.tank.y < 0 || myPlayer.tank.y > world.height) {
        if (!warningBool) {
            warningBool = true;
            wentOutside = Date.now();
            $('#updates').append('<div id="warning">' +
                '<div class="updateBig">Return to the field</div>' +
                '<div class="updateSmall">You will die in <span id="warningCounter">5</span> seconds</div>' +
                '</div>');
        }
        flashWarning();
    } else {
        if (warningBool) {
            warningBool = false;
            tickerUp = true;
            warningTicker = 0;
            $('#warning').remove();
        }
    }
}

function flashWarning() {
    if (tickerUp) {
        warningTicker += 0.01;
        if (warningTicker > 0.5) {
            tickerUp = false;
        }
    } else {
        warningTicker -= 0.01;
        if (warningTicker < 0.1) {
            tickerUp = true;
        }
    }

    $('#warning').css({'background-color':'rgba(255,0,0,' + warningTicker + ')'});

    countDownWhenOutside();
}

function countDownWhenOutside() {
    if (warningBool) {
        if (Date.now() - wentOutside > world.outsideTimer) {
            $('#warning').empty();
            killMe('tried to escape.', 'world');
        } else {
            var timeLeft = (5000 - (Date.now() - wentOutside)) / 1000;
            $('#warningCounter').html(Math.round(timeLeft * 10) / 10);
        }
    }
}

// DOCUMENT EVENTS

$(document).ready(function() {
    showPreview();
});

$(window).blur(function() {
    if (alive) {
        forceHaltTank();
    }
});

function showPreview() {
    $('#preview').append('<div class="tankMarker" id="previewMarker">' +
        '<div class="tankTrack trackLeft"></div><div class="tankTrack trackRight"></div>' +
        '<div class="tankBody" id="previewBody"></div>' +
        '<div class="tankBarrel" id="previewBarrel"></div>' +
        '<div class="tankTurret" id="previewTurret"></div>' +
        '</div>');

    $('#previewMarker').css({top: '50%', left: '50%'});

    setLastUsedSettings();
}

$(document).on('keydown', function(e) {
    setKeys(e, true);
});

$(document).on('keyup', function(e) {
    setKeys(e, false);
});

$('#readyButton').click(function() {
    if (!clickedReady) {
        startGame();
    }
});

function startGame() {
    clickedReady = true;

    myName = $('#nameField').val();
    var bodyColour = $("#bodyColourField").spectrum("get").toHexString();
    var turretColour = $("#turretColourField").spectrum("get").toHexString();
    var barrelColour = $("#barrelColourField").spectrum("get").toHexString();

    localStorage.tanksLastName = myName;

    socket.emit('clientReady', {
        name: myName,
        body: bodyColour,
        turret: turretColour,
        barrel: barrelColour
    });
    $('#welcome').fadeOut(500, function() {
        enableEnter(false);
        $(this).hide();
        $('#preview').empty();
    });
}

// SERVICE FUNCTIONS

function addAllPlayersToField() {
    for (let player of players) {
        if (player.id !== myId) {
            addPlayerToField(player, false);
        }
    }
}

function addPlayerToField(player, self) {

    var idName = 'player_' + player.id;
    $('#field').append('<div id="' + idName + '" class="tankMarker" style="display:none;">' +
        '<div class="tankTrack trackLeft"></div><div class="tankTrack trackRight"></div>' +
        '<div class="tankBody" id="' + player.id + '" style="background-color:' + player.bodyColour + ';"></div>' +
        '<div class="tankBarrel" style="background-color:' + player.barrelColour + ';"></div>' +
        '<div class="tankTurret" style="background-color:' + player.turretColour + ';"></div>' +
        '</div>');
    $('#nameplates').append('<div id="name_' + player.id + '" class="namePlate">' + player.name + '</div>');

    moveNamePlate(player);

    var tankDiv = $('#' + idName);

    if (self) {
        addBumpers(tankDiv);
        // PLACE IN THE MIDDLE
        centerX = screenWidth / 2;
        centerY = screenHeight / 2;
        tankDiv.css({left: centerX, top: centerY});
        world.relativeX = (centerX - player.tank.x);
        world.relativeY = (centerY - player.tank.y);
        $('#world').css({left: world.relativeX, top: world.relativeY});
        $('#treemap').css({left: world.relativeX, top: world.relativeY});
    } else {
        // SET RELATIVE TO WORLD
        $('#' + idName).css({left: world.relativeX + player.tank.x, top: world.relativeY + player.tank.y});
    }

    tankDiv.fadeIn(500);

}

function addBumpers(tank) {
    tank.append('<div class="tankBumper" id="bumperTL"></div>');
    tank.append('<div class="tankBumper" id="bumperTR"></div>');
    tank.append('<div class="tankBumper" id="bumperBL"></div>');
    tank.append('<div class="tankBumper" id="bumperBR"></div>');
}

// KEY FUNCTIONS

function setKeys(e, down) {
    var changedState = false;

    if (alive) {

        if (e.which === 32 && down) {
            e.preventDefault();
            shoot();
        }

        if (e.key === 'w' || e.key === 'ArrowUp') {
            e.preventDefault();
            /*
            if (down) {
                if (hitObstacle('up')) {
                    changedState = changeKeyState('up', false);
                } else {
                    changedState = changeKeyState('up', true);
                }
            } else {
                changedState = changeKeyState('up', false);
            }
            */
            changedState = changeKeyState('up', down);
        }

        if (e.key === 's' || e.key === 'ArrowDown') {
            e.preventDefault();
            changedState = changeKeyState('down', down);
        }

        if (e.key === 'a' || e.key === 'ArrowLeft') {
            e.preventDefault();
            changedState = changeKeyState('left', down);
        }

        if (e.key === 'd' || e.key === 'ArrowRight') {
            e.preventDefault();
            changedState = changeKeyState('right', down);
        }

        if (changedState) {
            socket.emit('clientChangedKeyState', myPlayer);
        }

    } else {
        if (e.key === 'Enter') {
            if (canPressEnter) {
                startGame();
            }
        }
    }
}

function shoot() {

    if (!myPlayer.tank.hasShot) {
        myPlayer.tank.lastShot = Date.now();
        myPlayer.tank.hasShot = true;

        projectileAngle = myPlayer.tank.rotation * (Math.PI / 180);
        projectileX = myPlayer.tank.x + (60 * Math.sin(projectileAngle));
        projectileY = myPlayer.tank.y - (60 * Math.cos(projectileAngle));

        var projectile = {
            playerId: myPlayer.id,
            originX: projectileX,
            originY: projectileY,
            angle: projectileAngle
        };

        initProjectile(projectile, 0);

        socket.emit('clientProjectileFired', projectile);
    }
}

function changeKeyState(direction, isDown) {
    var changed = false;
    var myTank = myPlayer.tank;



    // IF HITTING TREE DONT CHANGE KEYSTATE

    // OLD CODE.. MAKE FIT HERE!

    /*

    */

    switch(direction) {
        case 'up':
            if (myTank.moveUp !== isDown) {
                myTank.moveUp = isDown;
                changed = true;
            }
            break;

        case 'down':
            if (myTank.moveDown !== isDown) {
                myTank.moveDown = isDown;
                changed = true;
            }
            break;

        case 'left':
            if (myTank.moveLeft !== isDown) {
                myTank.moveLeft = isDown;
                changed = true;
            }
            break;

        case 'right':
            if (myTank.moveRight !== isDown) {
                myTank.moveRight = isDown;
                changed = true;
            }
            break;
    }

    return changed;
}

function getPlayerById(clientId) {
    for (let player of players) {
        if (player.id === clientId) {
            return player;
        }
    }
}

function removePlayerById(playerId) {
    for (var i = 0; i < players.length; i++) {
        if (players[i].id === playerId) {
            players.splice(i, 1);
            break;
        }
    }
}

// AWESOME EXPLOSION PARTICLE GENERATOR

function explodePlayer(player) {

    var particles = 14;
    var spreadMin = 50;
    var spreadMax = 80;
    for (var i = 0; i < particles; i++) {
        var idName = 'particle_' + generateRandomId();
        var size = getRandomInt(12,20);

        var colour = '#000';

        var rand = getRandomInt(0, 3);
        switch (rand) {
            case 0:
                colour = player.bodyColour;
                break;

            case 1:
                colour = player.barrelColour;
                break;

            case 2:
                colour = player.turretColour;
                break;
        }

        // GENERATE PARTICLE
        $('#world').append('<div id="' + idName + '" style="' +
            'left:' + (player.tank.x - (size / 2)) + 'px; ' +
            'top:' + (player.tank.y - (size / 2)) + 'px;' +
            'width:' + size + 'px; height:' + size + 'px;' +
            'background-color:' + colour + '; position:absolute;' +
            'border-radius:' + (size / 2) + 'px;"></div>');

        var angle = getRandomInt(1, 360) * (Math.PI / 180);

        var spread = getRandomInt(spreadMin, spreadMax);

        var toX = player.tank.x + (spread * Math.sin(angle));
        var toY = player.tank.y + (spread * Math.cos(angle));

        //console.log(toX + ',' + toY);

        // MAKE IT GO AWAY
        $('#' + idName).animate({
            opacity:0,
            left:toX,
            top:toY
        }, getRandomInt(700,1500), function() {
            $(this).remove();
        });
    }
}

function generateRandomId() {
    var id = '';
    var chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    var idLength = 3;

    for (var i = 0; i < idLength; i++) {
        id += chars.charAt(getRandomInt(0, chars.length));
    }

    return id;
}


function hitObstacle(direction) {

    var treeDiv = $('.treeMarker');

    switch (direction) {
        case 'up':
            if (treeDiv.collision('#bumperTL').length > 0 || treeDiv.collision('#bumperTR').length > 0) {
                console.log('hit up');
                return true;
            }
            break;

        case 'down':
            if (treeDiv.collision('#bumperBL').length > 0 || treeDiv.collision('#bumperBR').length > 0) {
                console.log('hit down');
                return true;
            }
            break;

        case 'left':
            if (treeDiv.collision('#bumperTL').length > 0 || treeDiv.collision('#bumperBR').length > 0) {
                console.log('hit left');
                return true;
            }
            break;

        case 'right':
            if (treeDiv.collision('#bumperTR').length > 0 || treeDiv.collision('#bumperBL').length > 0) {
                console.log('hit right');
                return true;
            }
            break;
    }
}

function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}