extends Node

export (PackedScene) var Regular
export (PackedScene) var Runner
export (PackedScene) var Tank

enum Enemy {
	Regular,
	Runner,
	Tank
}

var mob_creators = [
	funcref(self, "create_regular"),
	funcref(self, "create_fast"),
	funcref(self, "create_tank")
]

func _ready():
	pass

func create_random_mob():
	return mob_creators[randi() % mob_creators.size()].call_func()

func create_specific_mob(type):
	return mob_creators[type].call_func()

func create_regular():
	return Regular.instance()

func create_fast():
	return Runner.instance()

func create_tank():
	return Tank.instance()