extends Area2D

signal invalid_location
signal valid_location
signal mouse_entered_base
signal mouse_exited_base
signal tower_activated
signal tower_deactivated

var is_built = false
var mouseover = false
var active = 0
var collisions = 0

# class member variables go here, for example:
# var a = 2
# var b = "textvar"

func _ready():
	pass

func _process(delta):
	if not get_tree().is_network_server():
		if mouseover:
			if not active and Input.is_mouse_button_pressed(BUTTON_RIGHT):
				rpc("set_tower_activation", true)
			elif active and not Input.is_mouse_button_pressed(BUTTON_RIGHT):
				rpc("set_tower_activation", false)

sync func set_tower_activation(state):
	active = state
	if state:
		emit_signal("tower_activated")
	else:
		emit_signal("tower_deactivated")

func set_built():
	is_built = true
	monitoring = false
	monitorable = true

func _on_TowerBase_area_entered( area ):
	if collisions == 0:
		emit_signal("invalid_location")
	collisions+=1

func _on_TowerBase_area_exited( area ):
	collisions = max(collisions-1, 0)
	if collisions == 0:
		emit_signal("valid_location")


func _on_TowerBase_mouse_entered():
	emit_signal("mouse_entered_base")
	mouseover = true

func _on_TowerBase_mouse_exited():
	emit_signal("mouse_exited_base")
	if active:
		active = false
		emit_signal("tower_deactivated")
	mouseover = false