
.model tiny
.code
.386

org 100h

start:

mov	ax,11h
int	10h

mov ax, 1000h
mov bx, 300h
int 10h

push 0a000h
pop es

fldz		; time

restart:
fadd d_time
mov word ptr n, 4			

n_rotate:
mov si, offset pixelX
mov di, offset buffer	

fild word ptr n
fmul k_n
fadd st(0),st(1)
fstp dword ptr [si+8]

fld1
xor cx, cx

branchloop:
mov dx, 1
shl dx, cl

nodeloop:
fld dword ptr [si+8]
	
fld st(2)
fsin
fmul st(0),st(0)
fmul k_n

fld st(0)
fadd st(0),st(2)
fstp dword ptr [di+8]

fld k_n
fsub			
fadd st(0),st(1)	
fstp dword ptr[di+8+12]
fsincos
fld st(2)
fmul st(1), st(0)
fmulp st(2), st(0)
mov ch, 80			
fldz

drawLoop:			
fld st(2)
fmul st(0),st(1)
fadd dword ptr [si+4]
fist word ptr [di]
mov bp, [di]		; Y 

fst dword ptr [di+4]
fstp dword ptr [di+4+12]
fld st(1)
fmul st(0),st(1)
fadd dword ptr [si]
fist word ptr [di]
mov ax,[di]			; X

fst dword ptr [di]
fstp dword ptr [di+12]

; cliping
;cmp ax,640
;jae nodraw
;cmp bp,480
;jae nodraw

push cx
imul bp,80
mov cl,al
and cl,7
shr ax,3
add bp,ax
mov al,128
shr al,cl
or screen[bp],al
pop cx

nodraw:

fld1
cmp cl,2
jl m1
fadd st(0),st(0)
dec ch
m1:
fadd
dec ch
jnz drawLoop

fucomp
fucompp

add di, 24
add si, 12
dec dx
jnz nodeloop

fmul lengthScale

inc cx
cmp cl, 10
jb branchloop

fucomp

dec word ptr n
jge n_rotate

xor di,di
mov ch,38400/2/256
copyclear:
xor ax,ax
xchg ax,word ptr screen[di] 
stosw
loop	copyclear

in al, 60h
dec al
jnz restart

retn	

lengthScale dd	0.64
d_time	dd	0.01
k_n		dd	1.256637	; = 2*pi/5
pixelX	dd	320.0
pixelY	dd	240.0
pixelAngle	dd	?
buffer	db	25000 dup (?)
n		dw	?
screen	db	38400 dup (?)

end	start
