effect_intro_1

	ld hl,russ_intro_str
	ld ix,russ_intro_delay

.loop

	push bc
	
	call display_copy

	ld c,(ix+0)
	ld b,(ix+1)
	ld a,b
	or c
	jr z,.jerk

	inc ix
	inc ix
	
	inc hl

.delay

	halt
	dec bc
	ld a,b
	or c
	jr nz,.delay

	jr .next
	
.jerk
	
	ld a,(music_pitch_msb)
	cp #0d
	jr nc,.jerk1
	inc hl
	jr .jerk2
.jerk1
	dec hl
.jerk2

	ld bc,20*4

	jr .delay
	
.next

	pop bc
	dec bc
	ld a,b
	or c
	jr nz,.loop

	ld a,#01				;enable music controlled led blinking
	ld (led_state),a

	ret
	
	
	
russ_intro_str

	ds 9,0
	db (DSA|DSB|DSE|DSF|DSG)		;r
	db (DSB|DSC|DSD|DSF|DSG)		;u
	db (DSA|DSD|DSE|DSF)			;s
	db (DSC|DSD|DSE|DSF|DSG)		;'
	db DSG							;-
	db SYM_1						;1
	db SYM_3						;3
	db (DSD|DSE|DSG|DSH)			;c.
	db 0,0,0
	db (DSA|DSD|DSE|DSF)			;[
	db (DSD|DSE|DSG)				;c
	db (DSA|DSB|DSC|DSD)			;]
	db 0
	db (DSA|DSB|DSE|DSF|DSG)		;P
	db (DSA|DSB|DSC|DSE|DSF|DSG)	;A
	db (DSA|DSC|DSD|DSF|DSG)		;S
	db (DSB|DSC|DSE|DSF|DSG)		;H
	db (DSA|DSB|DSC|DSE|DSF|DSG)	;A
	db 0,0
	db SYM_0						;0
	db SYM_9						;9
	db SYM_5						;5
	db DSG							;-
	db SYM_1						;1
	db SYM_6						;6
	db SYM_0						;0
	db SYM_5						;5
	db SYM_5						;5
	db SYM_3						;3
	db SYM_5						;5
	db DSG							;-
	ds 9,0

russ_intro_delay

	dw 1
	dw #1a*16
	dw #0e*16
	dw #0d*16
	dw #1b*16
	dw #0d*16
	dw #0d*16
	dw #1b*16
	dw #0d*16
	dw #0e*16
	dw 20*16
	dw 20*16
	dw 20*16
	dw 20*16
	dw 20*16
	dw 20*16
	dw 20*16
	dw 0
	
	
	
;------------------------------------------------------------------------------	
	
effect_intro_2

	push bc
	
	ld hl,display_buf
	ld de,display_buf1
	ld bc,9
	ldir
	
	pop bc
	
.loop1

	dec bc
	ld a,b
	or c
	ret z
	
	push bc
	
.loop11

	ld b,32
	halt
	djnz $-1
	
	ld a,(music_pitch_msb)
	cp #10
	jr c,.loop2
	
	ld hl,display_buf
	ld bc,#0900
	ld (hl),c
	inc hl
	djnz $-2
	
	pop bc
	jr .loop1

.loop2

	ld hl,display_buf1
	ld b,9
	
.loop3

	ld a,(hl)
	add a,31
	ld (hl),a
	inc hl
	djnz .loop3
	
	ld hl,display_buf1
	ld de,display_buf
	ld bc,9
	ldir

	pop bc
	jr .loop1
	
	
	
;------------------------------------------------------------------------------	
	
effect_intro_3

	push bc
	
	;collapse mux list into the topmost digit only
	
	ld de,display_mux_list+8
	ld c,9

.loop1

	ld a,8
	ld (de),a
	dec de
	
	ld hl,display_buf
	ld b,9
	
.loop2

	halt

	ld a,(hl)
	add a,7
	ld (hl),a
	inc hl
	
	djnz .loop2

	dec c
	jr nz,.loop1

	;delay, set 8 in the topmost digit if any sound is playing, otherwise clear

	pop bc
	
.loop3

	ld a,(sound_enable)
	and #10
	jr z,$+4
	ld a,#ff
	ld (display_buf),a

	halt
	dec bc
	ld a,b
	or c
	jr nz,.loop3

	call display_clear
	call display_set_normal_mux
	
	ret
