kernel

	ld bc,50000
	call delay
	
	call display_clear
	call display_set_normal_mux
	
	ld hl,music_data
	call music_play
	
	ei
		
	;intro sequence
		
	ld bc,37					;scroll
	call effect_intro_1
	ld bc,84					;glitches
	call effect_intro_2
	ld bc,1900					;8 buzz
	call effect_intro_3
	
	;pre-title sequence
	
	call effect_pre_title_1
	call effect_pre_title_2
	
	;title sequence
	
	ld a,28						;show
	call effect_title_1
	
	ld bc,60*16*60				;delay
	call delay
	
	ld a,8						;clear
	call effect_title_2

	call display_clear
	ld bc,60*16*60
	call delay
	
	;first effect sequence
	
	call effect_first_sequence
	
	;intermission
	
	call effect_lnhold
	call effect_rururus
	call effect_lnhold
	
	ld bc,50
	call effect_kitt
	
	;second effect sequence
	
	call effect_second_sequence
		
	;greets sequence
		
	call effect_greets_1
	call effect_greets_2
	call effect_greets_3
	
	;credit and final

	call effect_final_sequence

	call effect_credit
	
	ld b,4
.pause
	push bc
	ld bc,60*16*60
	call delay
	pop bc
	djnz .pause
	
	call effect_eggog
	
	halt
	jr $-1
	
	
	

;------------------------------------------------------------------------------

effect_lnhold

	ld hl,lhhold_blow
	ld de,60*16*8
	ld bc,0
	call effect_anim
	
	ld hl,lnhold_anim
	ld de,60*16*4+2
	ld bc,105
	call effect_anim
	
	call display_clear
	ld bc,60*16*16
	call delay

	ret
	
	
lhhold_blow

	db #00,#00,#00,#00,#3F,#00,#00,#00,#00
	db #00,#00,#00,#39,#00,#0F,#00,#00,#00
	db #00,#00,#39,#00,#3F,#00,#0F,#00,#00
	db #00,#39,#00,#39,#00,#0F,#00,#0F,#00
	db #39,#39,#39,#00,#00,#00,#0F,#0F,#0F
	db #39,#39,#00,#00,#00,#00,#00,#0F,#0F
	db #39,#00,#00,#00,#00,#00,#00,#00,#0F
	db #00,#00,#00,#00,#00,#00,#00,#00,#00

	db #ff
	
lnhold_anim

	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #00,#00,#00,#00,#10,#00,#00,#02,#00
	db #00,#00,#80,#00,#30,#08,#04,#06,#00
	db #00,#08,#84,#00,#70,#0C,#04,#46,#00
	db #00,#18,#C4,#00,#72,#1C,#06,#56,#00
	db #00,#38,#D4,#00,#76,#5C,#06,#5E,#00
	db #00,#38,#D4,#00,#76,#5C,#06,#5E,#00
	db #00,#38,#D4,#00,#76,#5C,#06,#5E,#00
	db #00,#38,#D4,#00,#76,#5C,#06,#5E,#00
	db #00,#38,#D4,#00,#76,#5C,#06,#5E,#00
	db #00,#30,#54,#00,#66,#54,#06,#5C,#00
	db #00,#20,#50,#00,#46,#50,#02,#58,#00
	db #00,#00,#10,#00,#06,#10,#02,#18,#00
	db #00,#00,#00,#00,#02,#00,#00,#08,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00

	db #ff
	
	
	
;------------------------------------------------------------------------------

effect_rururus

	ld hl,rururus_anim
	ld de,60*16*15
	ld bc,0
	call effect_anim
	
	ret
	
rururus_anim

	db #73,#6E,#39,#7C,#00,#00,#00,#00,#00
	db #73,#6E,#39,#7C,#00,#00,#00,#00,#00
	db #73,#6E,#39,#7C,#00,#00,#00,#00,#00
	db #73,#6E,#39,#7C,#00,#00,#00,#00,#00
	db #5C,#1C,#73,#6E,#40,#00,#00,#00,#00
	db #08,#08,#73,#6E,#40,#00,#00,#00,#00
	db #00,#00,#5C,#1C,#48,#73,#6E,#40,#00
	db #00,#00,#08,#08,#40,#73,#6E,#40,#00
	db #00,#00,#00,#00,#08,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#73,#6E,#39,#7C
	db #73,#6E,#40,#00,#00,#5C,#1C,#50,#18
	db #73,#6E,#40,#00,#00,#08,#00,#08,#00
	db #5C,#1C,#48,#73,#6E,#40,#00,#00,#00
	db #08,#08,#40,#73,#6E,#40,#00,#00,#00
	db #00,#00,#08,#5C,#1C,#48,#73,#6E,#00
	db #00,#00,#00,#08,#08,#40,#73,#6E,#00
	db #00,#00,#00,#00,#00,#40,#73,#6E,#00
	db #00,#00,#00,#00,#00,#40,#73,#6E,#00
	db #73,#6E,#40,#00,#00,#08,#5C,#1C,#00
	db #73,#6E,#40,#00,#00,#00,#08,#08,#00
	db #5C,#1C,#48,#73,#6E,#40,#00,#00,#00
	db #08,#08,#40,#73,#6E,#40,#00,#00,#00
	db #00,#00,#08,#5C,#1C,#73,#6E,#39,#7C
	db #00,#00,#00,#08,#08,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#73,#6E,#39,#7C
	db #00,#00,#00,#00,#00,#5C,#1C,#50,#18
	db #00,#00,#00,#00,#00,#08,#00,#08,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00

	db #ff
	
	
	
;------------------------------------------------------------------------------

effect_credit
	
	ld de,60*16*10

	ld hl,credit_in_anim
	ld bc,0
	call effect_anim
	
	ld de,60*16*3
	
	ld hl,credit_jump_anim
	ld bc,50
	call effect_anim

	ld de,60*16*10
	
	ld hl,credit_out_anim
	ld bc,0
	call effect_anim
	
	ret
	
	
	
credit_in_anim

	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #01,#00,#00,#00,#00,#00,#00,#00,#00
	db #43,#23,#20,#00,#00,#00,#00,#00,#00
	db #6D,#74,#10,#00,#00,#00,#00,#00,#00
	db #6D,#74,#10,#00,#01,#00,#00,#00,#00
	db #6D,#74,#10,#21,#62,#00,#00,#00,#00
	db #6D,#74,#10,#50,#1C,#00,#00,#00,#00
	db #6D,#74,#10,#50,#1C,#01,#01,#00,#00
	db #6D,#74,#10,#50,#1C,#61,#62,#00,#00
	db #6D,#74,#10,#50,#1C,#5B,#3F,#00,#00
	db #6D,#74,#10,#50,#1C,#5B,#3F,#00,#01
	db #6D,#74,#10,#50,#1C,#5B,#3F,#02,#63
	db #6D,#74,#10,#50,#1C,#5B,#3F,#06,#7F
	db #ff

	
credit_jump_anim

	db #6D,#74,#10,#50,#1C,#5B,#3F,#06,#7F
	db #43,#74,#10,#50,#1C,#5B,#3F,#06,#7F
	db #01,#23,#10,#50,#1C,#5B,#3F,#06,#7F
	db #43,#00,#20,#50,#1C,#5B,#3F,#06,#7F
	db #6D,#23,#00,#21,#1C,#5B,#3F,#06,#7F
	db #6D,#74,#20,#00,#62,#5B,#3F,#06,#7F
	db #6D,#74,#10,#21,#01,#61,#3F,#06,#7F
	db #6D,#74,#10,#50,#62,#01,#62,#06,#7F
	db #6D,#74,#10,#50,#1C,#61,#01,#02,#7F
	db #6D,#74,#10,#50,#1C,#5B,#62,#00,#63
	db #6D,#74,#10,#50,#1C,#5B,#3F,#02,#01
	db #6D,#74,#10,#50,#1C,#5B,#3F,#06,#63
	db #6D,#74,#10,#50,#1C,#5B,#3F,#06,#7F

	db #ff

credit_out_anim

	db #6D,#74,#10,#50,#1C,#5B,#3F,#06,#7F
	db #58,#74,#10,#50,#1C,#5B,#3F,#06,#7F
	db #08,#10,#10,#50,#1C,#5B,#3F,#06,#7F
	db #00,#00,#00,#50,#1C,#5B,#3F,#06,#7F
	db #00,#00,#00,#08,#1C,#5B,#3F,#06,#7F
	db #00,#00,#00,#00,#00,#5B,#3F,#06,#7F
	db #00,#00,#00,#00,#00,#4C,#3F,#06,#7F
	db #00,#00,#00,#00,#00,#08,#54,#06,#7F
	db #00,#00,#00,#00,#00,#00,#08,#04,#7F
	db #00,#00,#00,#00,#00,#00,#00,#00,#5C
	db #00,#00,#00,#00,#00,#00,#00,#00,#08
	db #00,#00,#00,#00,#00,#00,#00,#00,#00

	db #ff
	
	
	
;------------------------------------------------------------------------------

effect_eggog

	ld hl,eggor_anim
	ld de,60*16*30
	ld bc,0
	call effect_anim

	jr effect_eggog
	

	
eggor_anim

	db #00,#00,#79,#31,#31,#3F,#31,#00,#00
	db #00,#00,#79,#31,#31,#3F,#31,#00,#00
	db #00,#00,#79,#31,#31,#3F,#31,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00


	db #ff
	
	
	
;------------------------------------------------------------------------------

effect_first_sequence

	ld de,60*16*8
	
	ld hl,effect_first_anim_1
	call effect_anim
	ld hl,effect_first_anim_2
	call effect_anim

	ld de,60*(16*2-2)
	
	ld hl,effect_first_anim_3
	call effect_anim
	ld hl,effect_first_anim_4
	call effect_anim
	ld hl,effect_first_anim_3
	call effect_anim
	ld hl,effect_first_anim_4
	call effect_anim

	ld bc,60*16*60
	call delay
	
	ld hl,effect_first_anim_5
	ld de,60*16*2
	ld bc,0
	call effect_anim
	
	ld bc,60*16*68
	call delay
	
	ret
	

effect_first_anim_1

	db #08,#00,#00,#00,#00,#00,#00,#00,#00
	db #08,#08,#00,#00,#00,#00,#00,#00,#00
	db #44,#08,#08,#00,#00,#00,#00,#00,#00
	db #03,#44,#08,#08,#00,#00,#00,#00,#00
	db #18,#03,#44,#08,#08,#00,#00,#00,#00
	db #60,#18,#03,#44,#08,#08,#00,#00,#00
	db #01,#60,#18,#03,#44,#08,#08,#00,#00
	db #01,#01,#60,#18,#03,#44,#08,#08,#00
	db #42,#01,#01,#60,#18,#03,#44,#08,#08
	db #0C,#42,#01,#01,#60,#18,#03,#44,#08
	db #21,#0C,#42,#01,#01,#60,#18,#03,#44
	db #50,#21,#0C,#42,#01,#01,#60,#18,#03
	db #08,#50,#21,#0C,#42,#01,#01,#60,#18
	db #08,#08,#50,#21,#0C,#42,#01,#01,#60
	db #44,#08,#08,#50,#21,#0C,#42,#01,#01
	db #03,#44,#08,#08,#50,#21,#0C,#42,#01
	db #18,#03,#44,#08,#08,#50,#21,#0C,#42
	db #60,#18,#03,#44,#08,#08,#50,#21,#0C
	db #01,#60,#18,#03,#44,#08,#08,#50,#21
	db #01,#01,#60,#18,#03,#44,#08,#08,#50
	db #42,#01,#01,#60,#18,#03,#44,#08,#08
	db #0C,#42,#01,#01,#60,#18,#03,#44,#08
	db #21,#0C,#42,#01,#01,#60,#18,#03,#44
	db #50,#21,#0C,#42,#01,#01,#60,#18,#03
	db #08,#50,#21,#0C,#42,#01,#01,#60,#18
	db #08,#08,#50,#21,#0C,#42,#01,#01,#60
	db #44,#08,#08,#50,#21,#0C,#42,#01,#01
	db #03,#44,#08,#08,#50,#21,#0C,#42,#01
	db #18,#03,#44,#08,#08,#50,#21,#0C,#42
	db #60,#18,#03,#44,#08,#08,#50,#21,#0C
	db #01,#60,#18,#03,#44,#08,#08,#50,#21
	db #01,#01,#60,#18,#03,#44,#08,#08,#50
	db #42,#01,#01,#60,#18,#03,#44,#08,#08
	db #0C,#42,#01,#01,#60,#18,#03,#44,#08
	db #21,#0C,#42,#01,#01,#60,#18,#03,#44
	db #50,#21,#0C,#42,#01,#01,#60,#18,#03
	db #08,#50,#21,#0C,#42,#01,#01,#60,#18
	db #08,#08,#50,#21,#0C,#42,#01,#01,#60
	db #44,#08,#08,#50,#21,#0C,#42,#01,#01
	db #03,#44,#08,#08,#50,#21,#0C,#42,#01
	db #18,#03,#44,#08,#08,#50,#21,#0C,#42
	db #60,#18,#03,#44,#08,#08,#50,#21,#0C
	db #01,#60,#18,#03,#44,#08,#08,#50,#21
	db #01,#01,#60,#18,#03,#44,#08,#08,#50
	db #42,#01,#01,#60,#18,#03,#44,#08,#08
	db #0C,#42,#01,#01,#60,#18,#03,#44,#08
	db #21,#0C,#42,#01,#01,#60,#18,#03,#44
	db #50,#21,#0C,#42,#01,#01,#60,#18,#03
	db #08,#50,#21,#0C,#42,#01,#01,#60,#18
	db #08,#08,#50,#21,#0C,#42,#01,#01,#60
	db #00,#08,#08,#50,#21,#0C,#42,#01,#01
	db #00,#00,#08,#08,#50,#21,#0C,#42,#01
	db #00,#00,#00,#08,#08,#50,#21,#0C,#42
	db #00,#00,#00,#00,#08,#08,#50,#21,#0C
	db #00,#00,#00,#00,#00,#08,#08,#50,#21
	db #00,#00,#00,#00,#00,#00,#08,#08,#50
	db #00,#00,#00,#00,#00,#00,#00,#08,#08
	db #00,#00,#00,#00,#00,#00,#00,#00,#08
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

effect_first_anim_2

	db #00,#00,#00,#00,#00,#00,#00,#00,#08
	db #00,#00,#00,#00,#00,#00,#00,#08,#08
	db #00,#00,#00,#00,#00,#00,#08,#08,#5C
	db #00,#00,#00,#00,#00,#08,#08,#5C,#3F
	db #00,#00,#00,#00,#08,#08,#5C,#3F,#3F
	db #00,#00,#00,#08,#08,#5C,#3F,#3F,#63
	db #00,#00,#08,#08,#5C,#3F,#3F,#63,#01
	db #00,#08,#08,#5C,#3F,#3F,#63,#01,#01
	db #08,#08,#5C,#3F,#3F,#63,#01,#01,#63
	db #08,#5C,#3F,#3F,#63,#01,#01,#63,#3F
	db #5C,#3F,#3F,#63,#01,#01,#63,#3F,#3F
	db #3F,#3F,#63,#01,#01,#63,#3F,#3F,#5C
	db #3F,#63,#01,#01,#63,#3F,#3F,#5C,#08
	db #63,#01,#01,#63,#3F,#3F,#5C,#08,#08
	db #01,#01,#63,#3F,#3F,#5C,#08,#08,#5C
	db #01,#63,#3F,#3F,#5C,#08,#08,#5C,#3F
	db #63,#3F,#3F,#5C,#08,#08,#5C,#3F,#3F
	db #3F,#3F,#5C,#08,#08,#5C,#3F,#3F,#63
	db #3F,#5C,#08,#08,#5C,#3F,#3F,#63,#01
	db #5C,#08,#08,#5C,#3F,#3F,#63,#01,#01
	db #08,#08,#5C,#3F,#3F,#63,#01,#01,#63
	db #08,#5C,#3F,#3F,#63,#01,#01,#63,#3F
	db #5C,#3F,#3F,#63,#01,#01,#63,#3F,#3F
	db #3F,#3F,#63,#01,#01,#63,#3F,#3F,#5C
	db #3F,#63,#01,#01,#63,#3F,#3F,#5C,#08
	db #63,#01,#01,#63,#3F,#3F,#5C,#08,#08
	db #01,#01,#63,#3F,#3F,#5C,#08,#08,#5C
	db #01,#63,#3F,#3F,#5C,#08,#08,#5C,#3F
	db #63,#3F,#3F,#5C,#08,#08,#5C,#3F,#3F
	db #3F,#3F,#5C,#08,#08,#5C,#3F,#3F,#63
	db #3F,#5C,#08,#08,#5C,#3F,#3F,#63,#01
	db #5C,#08,#08,#5C,#3F,#3F,#63,#01,#01
	db #08,#08,#5C,#3F,#3F,#63,#01,#01,#63
	db #08,#5C,#3F,#3F,#63,#01,#01,#63,#3F
	db #5C,#3F,#3F,#63,#01,#01,#63,#3F,#3F
	db #3F,#3F,#63,#01,#01,#63,#3F,#3F,#5C
	db #3F,#63,#01,#01,#63,#3F,#3F,#5C,#08
	db #63,#01,#01,#63,#3F,#3F,#5C,#08,#08
	db #01,#01,#63,#3F,#3F,#5C,#08,#08,#5C
	db #01,#63,#3F,#3F,#5C,#08,#08,#5C,#3F
	db #63,#3F,#3F,#5C,#08,#08,#5C,#3F,#3F
	db #3F,#3F,#5C,#08,#08,#5C,#3F,#3F,#63
	db #3F,#5C,#08,#08,#5C,#3F,#3F,#63,#01
	db #5C,#08,#08,#5C,#3F,#3F,#63,#01,#01
	db #08,#08,#5C,#3F,#3F,#63,#01,#01,#63
	db #08,#5C,#3F,#3F,#63,#01,#01,#63,#3F
	db #5C,#3F,#3F,#63,#01,#01,#63,#3F,#3F
	db #3F,#3F,#63,#01,#01,#63,#3F,#3F,#5C
	db #3F,#63,#01,#01,#63,#3F,#3F,#5C,#08
	db #63,#01,#01,#63,#3F,#3F,#5C,#08,#08
	db #01,#01,#63,#3F,#3F,#5C,#08,#08,#00
	db #01,#63,#3F,#3F,#5C,#08,#08,#00,#00
	db #63,#3F,#3F,#5C,#08,#08,#00,#00,#00
	db #3F,#3F,#5C,#08,#08,#00,#00,#00,#00
	db #3F,#5C,#08,#08,#00,#00,#00,#00,#00
	db #5C,#08,#08,#00,#00,#00,#00,#00,#00
	db #08,#08,#00,#00,#00,#00,#00,#00,#00
	db #08,#00,#00,#00,#00,#00,#00,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

effect_first_anim_3

	db #10,#00,#00,#00,#00,#00,#00,#00,#00
	db #30,#00,#00,#00,#00,#00,#00,#00,#00
	db #31,#00,#00,#00,#00,#00,#00,#00,#00
	db #33,#00,#00,#00,#00,#00,#00,#00,#00
	db #37,#00,#00,#00,#00,#00,#00,#00,#00
	db #3F,#00,#00,#00,#00,#00,#00,#00,#00
	db #7F,#00,#00,#00,#00,#00,#00,#00,#00
	db #7F,#40,#00,#00,#00,#00,#00,#00,#00
	db #7F,#44,#00,#00,#00,#00,#00,#00,#00
	db #7F,#4C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#5C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7D,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#10,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#18,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1C,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1E,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#3F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#40,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#42,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#43,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#63,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#73,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#7B,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#20,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#21,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#23,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#63,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#73,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#7B,#00,#00,#00,#00
	db #5F,#7F,#7F,#7F,#7F,#00,#00,#00,#00
	db #5E,#7F,#7F,#7F,#7F,#20,#00,#00,#00
	db #5C,#7F,#7F,#7F,#7F,#21,#00,#00,#00
	db #58,#7F,#7F,#7F,#7F,#23,#00,#00,#00
	db #50,#7F,#7F,#7F,#7F,#27,#00,#00,#00
	db #40,#7F,#7F,#7F,#7F,#2F,#00,#00,#00
	db #00,#7F,#7F,#7F,#7F,#3F,#00,#00,#00
	db #00,#3D,#7F,#7F,#7F,#7F,#00,#00,#00
	db #00,#3C,#7F,#7F,#7F,#7F,#40,#00,#00
	db #00,#1C,#7F,#7F,#7F,#7F,#44,#00,#00
	db #00,#0C,#7F,#7F,#7F,#7F,#4C,#00,#00
	db #00,#04,#7F,#7F,#7F,#7F,#5C,#00,#00
	db #00,#00,#7F,#7F,#7F,#7F,#7C,#00,#00
	db #00,#00,#5F,#7F,#7F,#7F,#7D,#00,#00
	db #00,#00,#5E,#7F,#7F,#7F,#7F,#00,#00
	db #00,#00,#5C,#7F,#7F,#7F,#7F,#18,#00
	db #00,#00,#58,#7F,#7F,#7F,#7F,#1C,#00
	db #00,#00,#50,#7F,#7F,#7F,#7F,#5C,#00
	db #00,#00,#40,#7F,#7F,#7F,#7F,#7C,#00
	db #00,#00,#00,#7F,#7F,#7F,#7F,#7D,#00
	db #00,#00,#00,#3F,#7F,#7F,#7F,#7F,#00
	db #00,#00,#00,#3B,#7F,#7F,#7F,#7F,#10
	db #00,#00,#00,#33,#7F,#7F,#7F,#7F,#18
	db #00,#00,#00,#23,#7F,#7F,#7F,#7F,#1C
	db #00,#00,#00,#03,#7F,#7F,#7F,#7F,#1E
	db #00,#00,#00,#02,#7F,#7F,#7F,#7F,#1F
	db #00,#00,#00,#00,#7F,#7F,#7F,#7F,#3F
	db #00,#00,#00,#00,#6F,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#67,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#63,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#23,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#03,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#02,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#6F,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#67,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#63,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#61,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#60,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#40,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5F,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5E,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#1C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#0C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#04,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#00,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5F,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5E,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5C,#7F
	db #00,#00,#00,#00,#00,#00,#00,#58,#7F
	db #00,#00,#00,#00,#00,#00,#00,#50,#7F
	db #00,#00,#00,#00,#00,#00,#00,#40,#7F
	db #00,#00,#00,#00,#00,#00,#00,#00,#7F
	db #00,#00,#00,#00,#00,#00,#00,#00,#3F
	db #00,#00,#00,#00,#00,#00,#00,#00,#3D
	db #00,#00,#00,#00,#00,#00,#00,#00,#3C
	db #00,#00,#00,#00,#00,#00,#00,#00,#1C
	db #00,#00,#00,#00,#00,#00,#00,#00,#0C
	db #00,#00,#00,#00,#00,#00,#00,#00,#04
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

effect_first_anim_4

	db #00,#00,#00,#00,#00,#00,#00,#00,#04
	db #00,#00,#00,#00,#00,#00,#00,#00,#0C
	db #00,#00,#00,#00,#00,#00,#00,#00,#1C
	db #00,#00,#00,#00,#00,#00,#00,#00,#3C
	db #00,#00,#00,#00,#00,#00,#00,#00,#3D
	db #00,#00,#00,#00,#00,#00,#00,#00,#3F
	db #00,#00,#00,#00,#00,#00,#00,#00,#7F
	db #00,#00,#00,#00,#00,#00,#00,#40,#7F
	db #00,#00,#00,#00,#00,#00,#00,#50,#7F
	db #00,#00,#00,#00,#00,#00,#00,#58,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5C,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5E,#7F
	db #00,#00,#00,#00,#00,#00,#00,#5F,#7F
	db #00,#00,#00,#00,#00,#00,#00,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#04,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#0C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#1C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5C,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5E,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#5F,#7F,#7F
	db #00,#00,#00,#00,#00,#00,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#40,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#60,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#61,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#63,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#67,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#6F,#7F,#7F,#7F
	db #00,#00,#00,#00,#00,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#02,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#03,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#23,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#63,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#67,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#6F,#7F,#7F,#7F,#7F
	db #00,#00,#00,#00,#7F,#7F,#7F,#7F,#3F
	db #00,#00,#00,#02,#7F,#7F,#7F,#7F,#1F
	db #00,#00,#00,#03,#7F,#7F,#7F,#7F,#1E
	db #00,#00,#00,#23,#7F,#7F,#7F,#7F,#1C
	db #00,#00,#00,#33,#7F,#7F,#7F,#7F,#18
	db #00,#00,#00,#3B,#7F,#7F,#7F,#7F,#10
	db #00,#00,#00,#3F,#7F,#7F,#7F,#7F,#00
	db #00,#00,#00,#7F,#7F,#7F,#7F,#7D,#00
	db #00,#00,#40,#7F,#7F,#7F,#7F,#7C,#00
	db #00,#00,#50,#7F,#7F,#7F,#7F,#5C,#00
	db #00,#00,#58,#7F,#7F,#7F,#7F,#1C,#00
	db #00,#00,#5C,#7F,#7F,#7F,#7F,#18,#00
	db #00,#00,#5E,#7F,#7F,#7F,#7F,#00,#00
	db #00,#00,#5F,#7F,#7F,#7F,#7D,#00,#00
	db #00,#00,#7F,#7F,#7F,#7F,#7C,#00,#00
	db #00,#04,#7F,#7F,#7F,#7F,#5C,#00,#00
	db #00,#0C,#7F,#7F,#7F,#7F,#4C,#00,#00
	db #00,#1C,#7F,#7F,#7F,#7F,#44,#00,#00
	db #00,#3C,#7F,#7F,#7F,#7F,#40,#00,#00
	db #00,#3D,#7F,#7F,#7F,#7F,#00,#00,#00
	db #00,#7F,#7F,#7F,#7F,#3F,#00,#00,#00
	db #40,#7F,#7F,#7F,#7F,#2F,#00,#00,#00
	db #50,#7F,#7F,#7F,#7F,#27,#00,#00,#00
	db #58,#7F,#7F,#7F,#7F,#23,#00,#00,#00
	db #5C,#7F,#7F,#7F,#7F,#21,#00,#00,#00
	db #5E,#7F,#7F,#7F,#7F,#20,#00,#00,#00
	db #5F,#7F,#7F,#7F,#7F,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#7B,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#73,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#63,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#23,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#21,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#20,#00,#00,#00,#00
	db #7F,#7F,#7F,#7F,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#7B,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#73,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#63,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#43,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#42,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#40,#00,#00,#00,#00,#00
	db #7F,#7F,#7F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#3F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1F,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1E,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#1C,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#18,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#10,#00,#00,#00,#00,#00,#00
	db #7F,#7F,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7D,#00,#00,#00,#00,#00,#00,#00
	db #7F,#7C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#5C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#4C,#00,#00,#00,#00,#00,#00,#00
	db #7F,#44,#00,#00,#00,#00,#00,#00,#00
	db #7F,#40,#00,#00,#00,#00,#00,#00,#00
	db #7F,#00,#00,#00,#00,#00,#00,#00,#00
	db #3F,#00,#00,#00,#00,#00,#00,#00,#00
	db #37,#00,#00,#00,#00,#00,#00,#00,#00
	db #33,#00,#00,#00,#00,#00,#00,#00,#00
	db #31,#00,#00,#00,#00,#00,#00,#00,#00
	db #30,#00,#00,#00,#00,#00,#00,#00,#00
	db #10,#00,#00,#00,#00,#00,#00,#00,#00
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

effect_first_anim_5

	db #40,#00,#00,#00,#00,#00,#00,#00,#00
	db #40,#40,#00,#00,#00,#00,#00,#00,#00
	db #40,#40,#20,#00,#00,#00,#00,#00,#00
	db #40,#40,#21,#00,#00,#00,#00,#00,#00
	db #40,#40,#21,#01,#00,#00,#00,#00,#00
	db #00,#40,#21,#03,#00,#00,#00,#00,#00
	db #00,#00,#21,#07,#00,#00,#00,#00,#00
	db #00,#00,#01,#07,#08,#00,#00,#00,#00
	db #00,#00,#00,#07,#08,#08,#00,#00,#00
	db #00,#00,#00,#06,#08,#0C,#00,#00,#00
	db #00,#00,#00,#04,#08,#0E,#00,#00,#00
	db #00,#00,#00,#00,#08,#0E,#01,#00,#00
	db #00,#00,#00,#00,#00,#0E,#01,#20,#00
	db #00,#00,#00,#00,#00,#06,#01,#60,#00
	db #00,#00,#00,#00,#00,#02,#01,#60,#40
	db #00,#00,#00,#00,#00,#00,#01,#60,#40
	db #00,#00,#00,#00,#00,#00,#00,#60,#40
	db #00,#00,#00,#00,#00,#00,#00,#40,#40
	db #00,#00,#00,#00,#00,#00,#00,#00,#40
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

	
	
;------------------------------------------------------------------------------

effect_second_sequence

	ld hl,effect_second_anim_1
	ld de,60*16*10
	ld bc,0
	call effect_anim
	
	ld bc,75
	call effect_symfall
	
	ld hl,effect_second_anim_1
	ld de,60*16*10
	ld bc,0
	call effect_anim
	
	ld bc,5550
	ld a,0
	call effect_spectrum

	ld hl,effect_second_anim_1
	ld de,60*16*10
	ld bc,0
	call effect_anim
	
	ld bc,75
	call effect_symfall
	
	ld hl,effect_second_anim_1
	ld de,60*16*10
	ld bc,0
	call effect_anim
	
	ld bc,2500
	ld a,1
	call effect_spectrum
	
	call display_clear
	ld bc,60*16*15
	call delay
	
	ret
	
	
	
effect_second_anim_1

	db #00,#00,#00,#00,#7F,#00,#00,#00,#00
	db #00,#00,#00,#7F,#7F,#7F,#00,#00,#00
	db #00,#00,#7F,#3F,#3F,#3F,#7F,#00,#00
	db #00,#7F,#3F,#3F,#36,#3F,#3F,#7F,#00
	db #7F,#3F,#3F,#36,#00,#36,#3F,#3F,#7F
	db #3F,#3F,#36,#30,#00,#06,#36,#3F,#3F
	db #3F,#30,#30,#00,#00,#00,#06,#06,#3F
	db #30,#30,#00,#00,#00,#00,#00,#06,#06
	db #30,#00,#00,#00,#00,#00,#00,#00,#06
	db #00,#00,#00,#00,#00,#00,#00,#00,#00
	db #ff

	
	
;------------------------------------------------------------------------------

effect_final_sequence

	ld hl,effect_final_anim_1
	ld de,60*16*20
	ld bc,24
	call effect_anim
	
	ld hl,effect_final_anim_2
	ld de,6776;60*16*7
	ld bc,68
	call effect_anim
	
	ld hl,effect_final_anim_1
	ld de,60*16*20
	ld bc,23
	call effect_anim
	
	call display_clear
	
	ld bc,60*16*60
	call delay
	ld bc,60*16*60
	call delay
	ld bc,60*16*60
	call delay
	ld bc,60*16*60
	call delay
	
	ret
	
	
effect_final_anim_1

	db #00,#67,#00,#80,#00,#80,#00,#73,#00
	db #DC,#08,#00,#00,#00,#00,#00,#88,#5C
	db #08,#67,#00,#00,#00,#00,#00,#73,#08
	db #80,#00,#73,#00,#00,#00,#67,#00,#80
	db #00,#00,#88,#5C,#00,#DC,#08,#00,#00
	db #00,#00,#73,#08,#00,#08,#67,#00,#00
	db #ff


effect_final_anim_2

	db #00,#01,#01,#00,#00,#00,#B8,#8E,#00
	db #00,#60,#42,#00,#00,#04,#38,#0E,#10
	db #00,#B8,#8E,#00,#00,#40,#38,#0E,#40
	db #04,#38,#0E,#10,#00,#10,#38,#0E,#04
	db #40,#38,#0E,#40,#00,#00,#38,#0E,#80
	db #10,#38,#0E,#04,#00,#00,#60,#42,#00
	db #00,#38,#0E,#80,#00,#00,#01,#01,#00
	db #00,#60,#42,#00,#00,#00,#01,#01,#00
	db #00,#01,#01,#00,#00,#00,#60,#42,#00
	db #ff