	device zxspectrum48
	
	;the code size is kept under 8K to avoid messing up with the unusual ROM page layout
	;(ROM/RAM pages interleaved in 8K chunks)


	
DSEG=#7f				;segments for current digit, also used for keypad matrix scanning

DSA=#01					;display segment names
DSB=#02
DSC=#04
DSD=#08
DSE=#10
DSF=#20
DSG=#40
DSH=#80

PIT_A=#a7				;8253 registers
PIT_B=#af
PIT_C=#b7
PIT_W=#bf

PIO_A=#c7				;8255 registers
PIO_B=#cf
PIO_C=#d7
PIO_W=#df

TIMER_CLK=1000000		;8253 clock frequency
TIMER_ISR=(60*16)/2		;display fully refreshes at this rate/9, /2 is needed for 8253 square wave mode

;60*16 hz gives ~4160t per interrupt



;display common symbols

SYM_0=(DSA|DSB|DSC|DSD|DSE|DSF)
SYM_1=(DSB|DSC)
SYM_2=(DSA|DSB|DSD|DSE|DSG)
SYM_3=(DSA|DSB|DSC|DSD|DSG)
SYM_4=(DSB|DSC|DSF|DSG)
SYM_5=(DSA|DSC|DSD|DSF|DSG)
SYM_6=(DSA|DSC|DSD|DSE|DSF|DSG)
SYM_7=(DSA|DSB|DSC)
SYM_8=(DSA|DSB|DSC|DSD|DSE|DSF|DSG)
SYM_9=(DSA|DSB|DSC|DSD|DSF|DSG)

SYM_A=(DSA|DSB|DSC|DSE|DSF|DSG)
SYM_B=(DSC|DSD|DSE|DSF|DSG)
SYM_C=(DSA|DSD|DSE|DSF)
SYM_D=(DSB|DSC|DSD|DSE|DSG)
SYM_E=(DSA|DSD|DSE|DSF|DSG)
SYM_F=(DSA|DSE|DSF|DSG)
SYM_G=(DSA|DSC|DSD|DSE|DSF)
SYM_H=(DSB|DSC|DSE|DSF|DSG)
SYM_I=(DSE|DSF)
SYM_J=(DSB|DSC|DSD|DSE)
SYM_K=(DSB|DSC|DSE|DSF|DSG)
SYM_L=(DSD|DSE|DSF)
SYM_M=(DSA|DSC|DSE)
SYM_N=(DSA|DSB|DSC|DSE|DSF)
SYM_O=(DSA|DSB|DSC|DSD|DSE|DSF)
SYM_P=(DSA|DSB|DSE|DSF|DSG)
SYM_Q=(DSA|DSB|DSC|DSF|DSG)
SYM_R=(DSA|DSB|DSE|DSF)
SYM_S=(DSA|DSC|DSD|DSF|DSG)
SYM_T=(DSA|DSB|DSC)
SYM_U=(DSB|DSC|DSD|DSE|DSF)
SYM_V=(DSB|DSC|DSF)
SYM_W=(DSB|DSD|DSF)
SYM_X=(DSB|DSE|DSG)
SYM_Y=(DSB|DSC|DSD|DSF|DSG)
SYM_Z=(DSA|DSB|DSD|DSE|DSG)

	
	
	;ROM bank 0 starts at beginning of the address space, they're 8K large, interleaved with 8K RAM chunks
	
	org #0000
	
bank_0_begin

	di
	
	ld sp,#ffff


ram_clear

	ld hl,RAM_START
	ld bc,RAM_SIZE
	
.loop

	xor a
	ld (hl),a
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,.loop
	
setup_pio

	ld a,#82
	out (PIO_W),a
	
	xor a
	out (PIO_A),a
	out (PIO_C),a
	ld a,#f0
	out (PIO_B),a
		
setup_timer_isr

	ld a,#36			;channel 0 square wave lsb/msb binary
	out (PIT_W),a
	ld a,#b6			;channel 2 square wave lsb/msb binary
	out (PIT_W),a

	ld hl,TIMER_CLK/TIMER_ISR
	ld a,l
	out (PIT_A),a
	ld a,h
	out (PIT_A),a
	
	im 1

	;there is a gap in the ROM to make IM1 ISR trampoline
	
	jr start
		
	org #0038
	
	jp timer_isr
	
start

	ld a,#09
	ld (pio_c),a
	ld a,#09				;both leds disabled at startup
	ld (led_state),a
	
	ld a,#80				;d7 is always set to enable timer ch2, d4 is set when sound output is enabled
	ld (sound_enable),a

	ld a,#12
	ld (rand_1),a
	ld a,#34
	ld (rand_2),a
	ld a,#56
	ld (rand_3),a
	
	include "kernel.asm"



delay

.loop

	dec bc
	ld a,b
	or c
	jr nz,.loop
	
	ret
	
	

display_set_normal_mux

	ld hl,display_mux_list
	ld b,9
	
.loop

	ld (hl),l
	inc hl
	
	djnz .loop
	
	ld (hl),255
	
	ret
	
	
	
display_clear

	push bc
	push hl
	
	ld hl,display_buf
	ld bc,#0900
	
.loop

	ld (hl),c
	inc hl
	
	djnz .loop
	
	pop hl
	pop bc
	
	ret

	
	
display_copy

	push bc
	push de
	push hl
	
	ld de,display_buf
	ld bc,9
	ldir
	
	pop hl
	pop de
	pop bc
	
	ret
	
	
	
display_copy_offset

	push bc
	push de
	push hl
	
	ld hl,display_buf1
	ld de,display_buf
	ld b,9
	ld a,(display_offset)
	ld c,a
	
.loop

	push hl
	
	ld a,l
	add a,c
	ld l,a
	
	ld a,(hl)
	ld (de),a
	
	pop hl
	
	ld a,c
	inc a
	cp 9
	jr c,$+3
	xor a
	ld c,a

	inc de
	
	djnz .loop
	
	pop hl
	pop de
	pop bc
	
	ret
	
	
	
display_roll

	push af
	
	ld a,(display_dir)
	or a
	ld a,(display_offset)
	jr z,.roll2
	
	inc a
	cp 9
	jr c,$+3
	xor a

.done

	ld (display_offset),a

	pop af
	
	ret
	
.roll2
	
	dec a
	cp 9
	jr c,$+4
	ld a,8
	jr .done
	
	
	
display_roll_invert

	ld a,(display_dir)
	xor 1
	ld (display_dir),a
	
	ret
	
	
	
rand8
 
	push de
    ld a,(rand_1)
    ld d,a
    ld a,(rand_2)
    ld (rand_1),a
    add a,d
    ld d,a
    ld a,(rand_3)
    ld (rand_2),a
    add a,d
    rlca
    ld (rand_3),a
	pop de
	
	ret
	
	
timer_isr

	exa
	exx
	
	;update display
	
	xor a					;clear segments before changing digit
	out (DSEG),a
	
	ld hl,display_mux_ptr

	ld d,display_mux_list/256
	ld e,(hl)

	ld a,(de)
	inc a
	jr nz,$+3
	ld e,a
	
	ld a,(de)

	inc e
	ld (hl),e

	ld hl,sound_enable		;d4 enables sound, d7 is always set
	or (hl)

	out (PIO_A),a			;activate current digit

	and #0f					;digit offset in display buf
	inc a
	cp 9
	jr c,$+3
	xor a
	ld l,a
	ld h,display_buf/256

	ld a,(hl)				;display segments for current digit
	out (DSEG),a
		
	;music counter and update
	
	ld hl,music_frame
	
	inc (hl)
	ld a,(hl)
	and #0f

	call z,music_update
	
	exx
	exa

	ei
	ret

	
	
music_play

	ld (music_ptr),hl

	xor a
	ld (music_wait),a
	
	ret
	
	
	
music_update

	ld hl,music_wait
	ld a,(hl)
	or a
	jr z,music_read
	
	dec (hl)
	ret nz

music_read

	ld hl,(music_ptr)

	ld a,(hl)
	or a
	
	jr nz,music_no_bank
	
	inc hl					;read new pointer for cross-bank transitions and looping
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	
	or h
	ret z
	
	ld a,(hl)
	
music_no_bank

	and #7f
	ld (music_wait),a
	
	ld a,(hl)
	inc hl
	
	rla

	jr c,music_mute

music_tone

	ld a,(hl)
	inc hl
	out (PIT_C),a
	
	ld a,(hl)
	inc hl
	out (PIT_C),a
	ld (music_pitch_msb),a
	
	ld a,(led_state)
	cp #09
	jr z,$+4
	xor #09
	ld (led_state),a
	ld c,a
	
	ld a,(pio_c)
	and #b6
	or c
	ld (pio_c),a
	
	out (PIO_C),a			;change leds state
	
	ld a,#10+#80			;d4 enables sound, d7 is always set
	ld (sound_enable),a

	jp music_done

music_done

	ld (music_ptr),hl
	
	ret
	
music_mute

	ld a,(pio_c)
	or #49					;disable ch2, turn off both leds
	ld (pio_c),a
	
	out (PIO_C),a

	ld a,#80				;d7 is always set
	ld (sound_enable),a
	
	ld a,#ff
	ld (music_pitch_msb),a
	
	jp music_done

	
	
	include "e_intro.asm"
	include "e_pretitle.asm"
	include "e_title.asm"
	include "e_greets.asm"
	include "e_spectrum.asm"
	include "e_anim.asm"
	include "e_kitt.asm"
	include "e_symfall.asm"


	
	
	display "bank 0: ",/d,$-bank_0_begin	;show current address, to have idea how much of ROM is used up
	
	ds bank_0_begin+8192-$,0				;pad ROM bank to 8K

bank_0_end
	
	
	
	
	org #4000
	
bank_1_begin

music_data

	include "music_1.asm"
	
	display "bank 1: ",/d,$-bank_1_begin	;show current address, to have idea how much of ROM is used up
	
	ds bank_1_begin+8192-$,0				;pad ROM bank to 8K
	
bank_1_end



	org #8000
	
bank_2_begin

	include "music_2.asm"
	
	display "bank 2: ",/d,$-bank_2_begin	;show current address, to have idea how much of ROM is used up
	
	ds bank_2_begin+8192-$,0				;pad ROM bank to 8K
	
bank_2_end



	org #c000
		
bank_3_begin

	display "bank 3: ",/d,$-bank_3_begin	;show current address, to have idea how much of ROM is used up
	
	ds bank_3_begin+8192-$,0				;pad ROM bank to 8K
	
bank_3_end



	org #f800			;2K RAM


	
RAM_START
RAM_SIZE=8192


	align 256
	
display_mux_list		ds 128

display_mux_list_size=display_mux_list-$

display_mux_ptr			db 0

sound_enable			db 0

music_frame				db 0
music_ptr				dw 0
music_wait				db 0
music_pitch_msb			db 0

pio_c					db 0		;d0 led1, d3 led2, d4 snd lock, d7 ch2 lock
led_state				db 0

rand_1					db 0
rand_2					db 0
rand_3					db 0

effect_speed			db 0

anim_loop				dw 0
anim_delay				dw 0
anim_play_once			db 0

	align 256
	
display_buf				ds 9
display_buf1			ds 9
display_bright			ds 9
display_offset			db 0
display_dir				db 0

spectrum_buf			ds 9
spectrum_div			db 0
spectrum_inv			db 0

display_sequence		ds 9*8



	savebin "bank_0.bin",bank_0_begin,bank_0_end-bank_0_begin
	savebin "bank_1.bin",bank_1_begin,bank_1_end-bank_1_begin
	savebin "bank_2.bin",bank_2_begin,bank_2_end-bank_2_begin
	savebin "bank_3.bin",bank_3_begin,bank_3_end-bank_3_begin