pico-8 cartridge // http://www.pico-8.com
version 15
__lua__
--[[
*******************************
* TMR PRESENTS A LITTLE INTRO *
*  my first attempt to create *
*    something with PICO-8    *
*         released at         *
*   Chimpbembly Winter 2018   *
* fire effect by Ben Hickling *
*******************************
--]]

local p=0
local f=0
local t=0
ra=0
rb=0
rc=0
rd=0
re=0
music(0)

scrolltext={
"","","","","","","","","","","","","","","","","","","","","","","",
"*","t","m","r","*","",
"p","r","e","s","e","n","t","s","",
"a","",
"l","i","t","t","l","e","",
"i","n","t","r","o","",
"r","e","l","e","a","s","e","d","",
"a","t","",
"c","h","i","m","p","b","e","m","b","l","y","",
"1","0","t","h","","f","e","b","","2","0","1","8","!","","","",
"t","h","i","s","",
"i","s","",
"m","y","",
"f","i","r","s","t","",
"a","t","t","e","m","p","t","",
"t","o","",
"d","o","",
"s","o","m","e","t","h","i","n","g","",
"w","i","t","h","",
"p","i","c","o","-","8",".","","","",
"c","r","e","d","i","t","s",":","",
"c","o","d","e",",","","g","f","x","","&","","m","u","s","i","c","","b","y","","*","t","m","r","*",".",
"","","",
"f","i","r","e","","r","o","u","t","i","n","e","","b","y","","*","b","e","n","","h","i","c","k","l","i","n","g","*",
"","","",
"g","r","e","e","t","i","n","g","s","",
"t","o","",
"e","v","e","r","y","o","n","e","",
"h","e","r","e","",
"a","t","",
"c","h","i","m","p","b","e","m","b","l","y","!","","","","","",
"o","h","","n","o","e","s","!","","",
"t","h","e","",
"s","p","r","i","t","e","m","a","p","",
"i","s","",
"a","l","m","o","s","t","",
"f","u","l","l","!","","","",
"s","o","",
"i","t","'","s","",
"t","i","m","e","",
"t","o","",
"w","r","a","p","!","","","",
"p","r","e","s","s","",
"e","s","c","",
"t","o","",
"e","x","i","t","."
}

local slen=count(scrolltext)-1

function _update()
	t+=1/30
	f+=0.5
end

function scroll()
	x=0
	y=118-abs(sin(t)*4)
	for i=0,32 do
		local k=2+(i+flr(f/4))%slen
		local o=sin(k/32+t)*8
		color(1)
		print(scrolltext[k],x-f%4,y+o)
		color(7)
		print(scrolltext[k],(x-2)-f%4,(y-2)+o)
		x+=6
	end
end

function dobackground()
	for ra=0,128,(1/300) do
		rectfill(0,0,ra,24,6)
	end
	line(0,23,128,23,12)
	for rb=0,128,(1/300) do
		rectfill(0,25,rb,49,12)
	end
	line(0,48,128,48,13)
	for rc=0,128,(1/300) do
		rectfill(0,50,rc,74,13)
	end
	line(0,73,128,73,1)
	for rd=0,128,(1/300) do
		rectfill(0,75,rd,100,1)
	end
	line(0,102,128,102,1)
end

function movefigure()
	for sa=-128,0,(1/32) do
		spr(0,sa,0,14,13)
	end
end

function movelogo()
	for lpos=-24,4,(1/120) do
		spr(217,73,lpos,6,3)
	end
end

function draw_fire()
	for x=1,16 do
		for y=1,32 do
			cool_map[x][y]=rnd(32)
			val=(heat_map[x][y] +heat_map[x-1][y] + heat_map[x+1][y] + heat_map[x][y-1] + heat_map[x][y+1]) / 5.0
			cval=(cool_map[x][y]+ cool_map[x-1][y] + cool_map[x+1][y] + cool_map[x][y-1] + cool_map[x][y+1]) / 5.0
			heat_map[x][y-1]=val
			cool_map[x][y]=cval
			heat_map[x][y] -= cool_map[x][y]*0.5
			sset(x+90,y+34, fire_pal[flr(heat_map[x][y])])	-- x y
		end
	end
end

function scrollfadeleft()
	spr(255,0,104,1,1,true)
	spr(255,0,112,1,1,true)
	spr(255,0,120,1,1,true)
	spr(239,8,104,1,1,true)
	spr(239,8,112,1,1,true)
	spr(239,8,120,1,1,true)
end

function scrollfaderight()
	spr(255,120,104,1,1)
	spr(255,120,112,1,1)
	spr(255,120,120,1,1)
	spr(239,112,104,1,1)
	spr(239,112,112,1,1)
	spr(239,112,120,1,1)
end

function _init()
	cls()
	dobackground()
	movefigure()
	movelogo()
	fire_pal={13,2,2,4,4,4,8,8,8,8,9,9,9,9,9,10,10,10,10,10,10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7}
	heat_map={}
	cool_map={}
	for x=0,128 do
		heat_map[x]={}
		cool_map[x]={}
		for y=0,128 do
			heat_map[x][y]=0
			cool_map[x][y]=4+rnd(10)
		end
	end
	heat_map[32][32]=255
	fire_pow=128
end

function _draw()
	rectfill(0,25,128,49,12)
	rectfill(0,50,128,74,13)
	line(0,48,128,48,13)
	line(0,73,128,73,1)
	spr(0,0,0,15,13)
	spr(217,73,4,6,3)
	rectfill(0,104,128,128,0)
	scroll()
	for i=0,32 do
		heat_map[i][32]=rnd(fire_pow)
	end
	draw_fire()
	sspr(0,0,16,32)	-- fire sprites
	palt(9,true)
	palt(0,false)
	local pval=pget(93,58)	-- low flame reflection
	if pval == 7 then
		spr(208,40,41,3,3)
	end
	local pval=pget(94,56)	-- mid flame reflection
	if pval == 7 then
		spr(211,40,41,3,3)
	end
	local pval=pget(93,56)	-- high flame reflection
	if pval == 7 then
		spr(214,40,41,3,3)
	end
	scrollfadeleft()
	scrollfaderight()
	spr(223,91,62,1,1)		-- mask over flame bottom left
	spr(223,99,62,1,1,true)	-- mask over flame bottom right
	palt(0,true)
	palt(9,false)
end

__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000677777000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000676d67700000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000067777777ddd6777777770000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000067777777776d66d6d6dd5d6777d77700000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000006776dd55d5d5ddddd5dd5551566566700000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000676dd55d5d55d6d55555d51115dd66770000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000677d555d5d5ddd5dddd5d5dd5115d76677700000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000677d51dd555d5dddd66ddddd1d55ddd6d66777777700000000000000000000000000000000000000000000000000000000000000000000000000
00000000000067d515d66dd5555d66d5d55d55d6ddddddd6d6666777700000000000000000000000000000000000000000000000000000000000000000000000
0000000000067755dd66665dd5d6d55d5151115155d5d5d5d5d66d67770000000000000000000000000000000000000000000000000000000000000000000000
000000000006761dd6d6d6d5dddd55d11155555555115ddd5ddd5ddd677000000000000000000000000000000000000000000000000000000000000000000000
000000000006765d5d55676dd6d55d11155511155155d5d5d5ddd5d6d67700000000000000000000000000000000000000000000000000000000000000000000
00000000000676551555675d7d5d5511515111111d55555d55dddd5d6d6770000000000000000000000000000000000000000000000000000000000000000000
000000000006765d111d66d6d5d6d115151515551555115dd55ddddd566677000000000000000000000000000000000000000000000000000000000000000000
00000000006776111116dd6d5d5d11555555555551555155dd55dd5ddd6667700000000000000000000000000000000000000000000000000000000000000000
00000000006766d1115d555dd55115151555555d555555555dd5d5d5d6d666770000000000000000000000000000000000000000000000000000000000000000
00000000067766dd155d555d55115555555d51555515555555d55d5d5d6676670000000000000000000000000000000000000000000000000000000000000000
0000000006766dd51d5115555115551555d5d11555515515515d55d5ddd667670000000000000000000000000000000000000000000000000000000000000000
00000000677dd5611d511ddd51555555555d611d15511515511d5ddddd6667777000000000000000000000000000000000000000000000000000000000000000
00000000676d5d7115115d651115155555ddd555555515d5515dd5d5d6d666777000000000000000000000000000000000000000000000000000000000000000
0000000677dd5171151116d5115555dd656ddd555555115d5555655d6d6666777700000000000000000000000000000000000000000000000000000000000000
000000677dd1516511115d6115155d6ddd16dd5dd55d5115d155561d666676676700000000000000000000000000000000000000000000000000000000000000
000000c766151165111116d511551d67d55dd655d555dd11565516d5d66666767770000000000000000000000000000000000000000000000000000000000000
00000067d6151155151157d111d555d67555ddd1d5515d511d65556166d666677777000000000000000000000000000000000000000000000000000000000000
00000c77d6111155111157d511dd555d6d15d6d5dd55515155d6555d6d6d6d667777000000000000000000000000000000000000000000000000000000000000
0000c77dd5511151511116d111565615d651ddd5555551555d556d55d5d5d6d67767600000000000000000000000000000000000000000000000000000000000
000c77d5d55115d115115d6515565dd1ddd55d6d5555d555d5dd5d15655d5d676677700000000000000000000000000000000000000000000000000000000000
00c67655d5551d115111d6dd115d65551dd55dddd155dd55dd6d511d6dddd6d67677700000000000000000000000000000000000000000000000000000000000
00c77d565d5555151511676d15156d5d1d6d55d5d5555d65d7dd5556dd65d7666766700000000000000000000000000000000000000000000000000000000000
00c765d65dd1d151511576dd1155ddd5d5dd55dd5555d5d67d55d557dd7d66d6d666760000000000000000000000000000000000000000000000000000000000
00c7d5d65d55155511167ddd1555dd555ddd5d55515515d655d55dd75d65675d6dd6760000000000000000000000000000000000000000000000000000000000
00c76dd66555d551111d76dd11515dd151d5555d555555dd55dd55d7d6ddd7d66d6d770000000000000000000000000000000000000000000000000000000000
00c6756d5556551511516d6d155d55dd5115555155d555d55dddd5665656d656dddd670000000000000000000000000000000000000000000000000000000000
000c7ddd556dd5111d1166d51556d556d5111555d651dd5d55d5d56d5d566d5ddd5d670000000000000000000000000000000000000000000000000000000000
000c7655d56d11155111d6d115d66d5dd551515d5d55555d555d55dd555d65556d55670000000000000000000000000000000000000000000000000000000000
00c6755dddd5115551115d515d5dd6dd511515155551515555dd5d65d5dd5156d555770000000000000000000000000000000000000000000000000000000000
00c7615dddd1155515111515d5d56d55d555515555151115555d5ddd5dd515d5655d760000000000000000000000000000000000000000000000000000000000
00c751ddd5d15555511115dd5d5dd555151515515151115155555655dd555d55d157700000000000000000000000000000000000000000000000000000000000
00c7115dddd1151511115d5dd5d555d111111155151511d15dd55d6d5155d555d567600000000000000000000000000000000000000000000000000000000000
00c7111556515555511115dddd555555551511d555511555dd55dd55155d5d1d6677000000000000000000000000000000000000000000000000000000000000
00c75115d611551511115dddd55d155151d515555d555d5d515d5ddd555555567770000000000000000000000000000000000000000000000000000000000000
00c7d1156d5151511115d5dddd555555115551d515d555555d5555ddd51555d67600000000000000000000000000000000000000000000000000000000000000
00c7d1116d5515115151555d6d55155111d5155d5155515155515151115155d77000000000000000000000000000000000000000000000000000000000000000
00c7d115665151511115551ddd555555115555d5d555555555111111d5155d676000000000000000000000000000000000000000000000000000000000000000
00c76151dd55155511115155d655155111551d5551515151511115dd5115d6760000000000000000000000000000000000000000000000000000000000000000
00c67d555d55515551111515ddd55555115515d555551515d55d5111111677600000000000000000000000000000000000000000000000000000000000000000
000c77d155dd555d5511115156dd555551155dddd5511155d6d5dddd115776000000000000000000000000000000000000000000000000000000000000000000
000d7765d15d55d5515151155d6ddd5555115d6ddd551115d67655d651d760000000000000000000000000000000000000000000000000000000000000000000
000c77615515615dd51111555d6d555d555dddd6d55111515d66767755d760000000000000000000000000000000000000000000000000000000000000000000
000d766516d55dd56d5115155d6d515d515ddd67dd55111555d66667556770000000000000000000000000000000000000000000000000000000000000000000
00d67d6555ddd1ddd511115565dd5515d1155dd6d5511111515d6d6655d670000000000000000000000000000000000000000000000000000000000000000000
00d76dd5d556551d55511555dddd5151d515d5ddd51511111515dd6d115d76000000000000000000000000000000000000000000000000000000000000000000
00d7dd5ddd15d555d5111151dd5115155d555d5d5551111111555dd1155577000000000000000000000000000000000000000000000000000000000000000000
00d7d5dd5d15511d5151511151111111555555d55511111151155d111115d7000000000000000000000000000000000000000000000000000000000000000000
00d7dd5dd511d115d5111151111151155d555d55515111111155dd111111d7000000000000000000000000000000000000000000000000000000000000000000
00d76ddd555151555151155d5d515d5d555555d515111111151dd555167776000000000000000000000000000000000000000000000000000000000000000000
00d6765d5551555d5511115515d5ddd5555551515111111151d1155d677600000000000000000000000000000000000000000000000000000000000000000000
000d77555155155555511551555ddd55551555151151111515d51111d76000000000000000000000000000000000000000000000000000000000000000000000
000d67d51155155d5511115515d5d6d551555151511111115dd55d55670000000000000000000000000000000000000000000000000000000000000000000000
0000d765155555d6d5511551555d67d515151555111111155d5111d7700000000000000000000000000000000000000000000000000000000000000000000000
0000d67d5155d166d555155515d5d65151115551511111115d515677000000000000000000000000000000000000000000000000000000000000000000000000
00000d7651d5556d6d5155555d5d6d5511155155151511155ddd7770000000000000000000000000000000000000000000000000000000000000000000000000
0000d67655555d66dd551555d5ddd5d1111155155111111151dd7600000000000000000000000000000000000000000000000000000000000000000000000000
000d677655d5566d6d5155555ddd6d551151155511111111155d7000000000000000000000000000000000000000000000000000000000000000000000000000
d677776d155556dddd555d55dddddd51111151511111115151567000000000000000000000000000000000000000000000000000000000000000000000000000
676d6d1551555dd5d5d5d5555d5d55111111111115ddddddd6776000000000000000000000000000000000000000000000000000000000000000000000000000
76d55115d1555dddddddd555d551511511111511d777777777760000000000000000000000000000000000000000000000000000000000000000000000000000
76d5151dd55556ddd6d6dd515d551511111111156760000000000000000000000000000000000000000000000000000000000000000000000000000000000000
676d555dd551ddddddddddd5555151111111111d6700000000000000000000000000000000000000000000000000000000000000000000000000000000000000
d67765dd565dd5d55dd55dd55d5515115111115d6760000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0dd676ddd6dd5555555ddd55d6d55151111151d56770000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000d76d5d6d55ddddddd5ddd5d6d5d5515151d555d77000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00167d1d5dd5dddd5dd5ddddd5d65dd551515dd51567700000000000000000000000000000000000000000000000000000000000000000000000000000000000
0d676d55dd5dd5ddd55ddddddd66d5d65515dd655dd6760000000000000000000000000000000000000000000000000000000000000000000000000000000000
1676ddd5d5d6ddd551155dd5ddd66d56d155ddd51ddd776000000000000000000000000000000000000000000000000000000000000000000000000000000000
176ddd5ddd676d551151156d5ddd6655dd5d5d61556d667700000000000000000000000000000000000000000000000000000000000000000000000000000000
17d6dd56d676765115d555d6656d66515ddddd6d51566d67d0000000000000000000000000000000000000000000000000000000000000000000000000000000
176dddd6d7776d5515555dd67d6dd6d11dd6d6d5551d6dd77d000000000000000000000000000000000000000000000000000000000000000000000000000000
175dd6dd6777d6d5515555dd76dddd6515dddd65515555d677000000000000000000000000000000000000000000000000000155dd6d6d000000000000000000
176d6d6d67776d551555555d67d6d6d51115d5d55515155d67d000000000000000000000000000000000000000000000001d6777777777d00000000000000000
17ddd6656776d6d555555555d66ddddd15115d515611515dd770000000000000000000000000000000000000000000000167ddd5d511557d0000000000000000
17dd66d5666d6ddd5555555ddd7dd5dd511155511d51155d567d00000000000000000000000000000000155dd676d000177d1555551515560000000000000000
17d6d6dd66d6d6d555155555dd66d5ddd5151d5515d15155dd7700000000000000000000000000001d67777777777d1d67615555515515660000000000000000
1d7d66d56d6d6ddd5551555d5dd7dd5d65515515d6d515d55d6750000000000000000000000000016776d6d6d6d6777776d1551511515d7d0000000000000000
157666d5d6dddd6dd5111555ddd66d5ddd55515dd5d1556555d7d000000000000000000000000017766d6dddddd516776515d1511515d7600000000000000000
157d66d55ddddddd555111555ddd66ddd6dd5515dd655d6d55d7700000000000000000000000016766ddddd551115ddd51565511555577500000000000000000
1d7d66d5ddddd5ddd555111555ddd66d5d6d555dd666dd6dd5d67500000000000000000000001d766ddd551115d6dd5555d55115515775000000000000000000
176666d55ddd555ddd55515155dddd6dd566d5d5dd6666dd5dd67d00000000000000000000015776ddd55d66666d5155555551555567d0000000000000000000
176666d555555555d5d555155d5d5dd6d5dd6d5d56666d6dd55d770000000000000000000001776d6dd5d6d6dd5555d55d5515551d7600000000000000000000
77d666dd5d5d55555d5d5551555555d66d55666d66666665dd5d67d00000000000000000001776d6dd5dddd5d551515555555555577000000000000000000000
76d666d55555555555d5d555555d5d5dd6d5d666d6666d6d5dd5d770000000000000000001676d6dd5d5d5555515d55555555556770000000000000000000000
766666dd555555555dd6dd555555d5dd5d6d6d66666666d5d5dddd770000000000000000167dddddd5555151515d515151555d67700000000000000000000000
7d6666d55155555555dd7dd555d55ddd55ddd5d6d666d665155dd567d00000000000001577d5dddd5d55555515d515111515d776000000000000000000000000
766666dd55555155555dd65d555555d5d55ddd5d666d6651515dddd770000000000001d77d5dddd5d551515dd5111111515677d0000000000000000000000000
6d6666d5d55555155555d5d55555555d5d55d655d6d6d6151515d5d67d0000000000177655dddd5d5555ddd51111151556776000000000000000000000000000
66d66ddd5d515155515ddd5555555555ddd55dd15dd56d5151515d5d76000000001d77d55dddddd5dddd5151111155d7776d0000000000000000000000000000
d666d6ddd55515151515ddd5d55555555ddd55dd1d55d515151555d56700000001676d55ddddd5dd551515111115d777d5000000000000000000000000000000
6d666ddd5d55515151555d6d5555555555ddd55dd55565511151555dd7000000177655dddd5ddd6515511151515577d500000000000000000000000000000000
d666ddddd5d555111555ddd7d5d55555d55ddd55d55dd511511515d5d700001d77d55d5ddddd5dd15511155515567d0000000000000000000000000000000000
dd6ddddd5d55155151555ddd6d5d55d555d5ddd55ddd51511111515dd7001d776555d5dd5dd5d651515155515567600000000000000000000000000000000000
ddddddd5d55555111515ddd5d5d5d555555ddddd55d5151151511515d701d665155d5ddddd55dd15151515515d77000000000000000000000000000000000000
555555151111111111111555111515151151555551555111111111115615651111515151511d1111111111111d65000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
5d555d5d515d5ddd555555565d555d5d515d5ddd555555565d555d5d555d5ddd5d55d556000000000666660660000000000660000000000666600000d9999999
15d555555d5555ddd51555d615d555555d5555ddd51555d615d555555d55dd6e6d1d55d6000000666ee88e6e86066000006e86000006666ee8e6600069999999
5155515155515151115155d75151515555515151115155d75155515555d1d5d555d5dd6a000666ee88888888856e860000e88500066ee8888888e000d9a99999
d555555555110111d5155d67d555555555101011d5155d67d55555555d15555d6d5dd6e7066ee8888888888885e88560068785006e888888888886006d999999
51515151510115dd5115d67651515151511115dd5115d67651515151d1555d66d15d67a66e88888888888888858785600e8e8860e87e888888888500d6dad999
55551515d55d51111116776955551515d55d510111167769555515156dd6d55515577a79e87e888888888885508e88600888885088e88888888885009999a9a7
d5510155d6d5dddd11577699d5511155d66d666511d77699d551115d676d666655d7e79988e88888888885500e88885008888850888885558888850099699999
dd551115d67655d651d76999dd55151d6677dd67d56a6999dd55111d6777dd67d56a799908888888888850000e888850688888508885556e8e88850099999699
d55101515d667677d5d76999d5515155667e7a7add6e6999d5511151d67777776d677999005555558888500008888886e8888850888506e87888500099909090
dd55111555d6666755677999dd55111dd667a7aadd7a7999dd551115dd6777776d7779990000000088855000088888858888885088856e8e8885000099999909
d551101151d6666655d67999d5511515d56676e7dd67a999d551111151d676776d67799900000000888850006888888888888886888888888850000090909090
d51511511d5d6666115d7699d51511555d56667655d67699d5151111151d667655d676990000000088850000e888588888888885888888888500000099990909
5551151555ddd6655dd577995551155555ddd6655ddd7799555111111155d6611ddd77990000000e888500006888588888888885888888885000000099909090
55115155d55dd655551dd79955111155d556de55555d67995511111151155d111115d7990000000088850000e888508888858885888888550000000099999909
515115d555dd66555551d7995151151555dd665555556799515111111155dd100011d7990000000e88850000e885508888858885888888666600000090909090
1511555d5dd66ddd57777699151111515d566ddd5777769915111111151dd555167776990000000888850000888850888855888588888888ee66000099990909
51155d55dd6dddd67a76999951101115d1655dd6777699995111111151d1055d677699990000000888850000888500e88885888588888888888e660000000000
1151555d5dedddd567799999115115151d6d1011676999991151111515d51111d76999990000000e88850000888500088850e8858888888888888e6009090000
51155d55d66dd6dda7999999511011115dd55d5567999999511110115dd55d55679999990000000e88850000888500088850088588855588888888e600000000
1015155dded5556a79999999111101155d5011d779999999111111155d5101d77999999900000000888500008885000e88500d5de88500d55888888d09000900
51015155d6d5d7e799999999510111115d51567799999999511111015d515677999999990000000e888500008885000085d00000888500000d55888590000000
1515101dd66e7a7999999999151510155ddd777999999999151510155ddd77799999999900000000888500008885000000000000e88500000000d55509090000
51111111d5667699999999995111111151dd7699999999995111110151dd76999999999900000000d5550000e85d000000000000e88500000000000000000000
1111111115d679999999999911110111155d79999999999911101010155d799999999999000000000000000000000000000000000d5500000000000009000900
__sfx__
000100000c100000000c200000000c300000000c40000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000c152000000c232000000c352000000c432000000c152000000c232000000c352000000c432000000c152000000c232000000c352000000c432000000c152000000c232000000c352000000c43200000
001000001a3421a3321c332183321f3321a3301c7001a340180001c34018000183421a3321c3301c000183421a3421a3321c332183321f3321a3301c7001a340180001c34018000183421a3321c3301c00018332
001000001c0621c0421c0321c0321c0221c0221c0121c01218062180421803218032180221802218012180121c0621c0421c0321c0321c0221c0221c0121c0121806218042180321803218022180221801218012
011000001c3521d2521f1521c0521d0521c0501c7001835218252181521804218032180221801218000180001c3521d2521f1521c0521d0521c0501c700183521825218152180421803218022180121800000000
00100000183421a000183421f240181401d2401d140041001c3421c2321c2221c2101b0001f0000000000000183421a000183451f240181401d2401d140041001c3421c2321c2221c2101c100000000000000000
001000000c0631c3000c0431c3001c0630c0460c0430c0230c063000000c043000001c0630c0460c0430c0230c063000000c043000001c0630c0460c0430c0230c063000000c043000001c0630c0460c0430c023
00100000183421a2401a002183421a2401f0021d34221222181421a1401a0021d3421c2401f0021d34221222181421a1401a0021c3421d2401f0021f342212221c1421a1401a00218232182301f0021823218220
__music__
00 01404306
01 01020306
00 01020306
00 01040306
00 01040306
00 01050306
00 01050306
00 01040306
00 01040306
00 01070306
02 01070306
