#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;

//uniform image2D destTexPos;
//uniform image2D destTexCol;
float   hash(float v);
vec2    rhash(vec2 uv);

layout(binding = 0) writeonly uniform image2D destTexPos;
layout(binding = 1) writeonly uniform image2D destTexVel;
layout(binding = 2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture;

uniform sampler2D ColorTexture;
uniform sampler3D CurlTexture;
uniform sampler2D VoronoiTexture;

uniform sampler2D OriginalPositionTexture;
uniform sampler2D SuperOriginalPositionTexture;
uniform sampler2D OriginalUVTexture;
uniform sampler2D OriginalColorTexture;

uniform sampler2D StoneTexture2;


uniform sampler2D OriginalPositionTexture_Text;
uniform sampler2D OriginalColorTexture_Text;

uniform sampler2D Swirl_Texture;


uniform sampler1D Original1DTexture;
layout(local_size_x = 16, local_size_y = 16) in;

layout(std140, binding = 4) buffer Pos{ vec4 Positions[]; };
layout(std140, binding = 5) buffer Vel{ vec4 Velocities[]; };
layout(std140, binding = 6) buffer Col{ vec4 Colors[]; };
uniform float Invocation;

const float InverseMaxInt = 1.0 / 4294967295.0;




float hash(float v)
{
	return fract(fract(v / 1e4)*v - 1e6);
}

vec2 rhash(vec2 uv) {
	const mat2 t = mat2(.12121212, .13131313, -.13131313, .12121212);
	const vec2 s = vec2(1e4, 1e6);
	uv *= t;
	uv *= s;
	return  fract(fract(uv / s)*uv);
}



float voronoi(const in vec2 uv)
{
	vec2 p = floor(uv);
	vec2 f = fract(uv);
	float v = 0.;
	for (int j = -1; j <= 1; j++)
		for (int i = -1; i <= 1; i++)
		{
			vec2 b = vec2(i, j);
			vec2 r = b - f + rhash(p + b);
			v += 1. / pow(dot(r, r), 8.);
		}
	return pow(1. / v, 0.0625);
}




vec3 Rotate(vec3 Input, mat4 RotationM) {
	vec4 Inn = Input.xyzz;
	Inn.w = 1.0;
	Inn = RotationM*Inn;

	float fc = 1.0 - clamp(pow(length(Input)*1.1, 1.0) + 0.0, 0.3, 1.0);
	fc = 0.4 + 0.4*sin(1 * length(Input) + ttime);
	fc *= clamp((ttime - 100)*0.5, 0.0, 1.0);
	fc = 0;
	Inn.xyz += (Input - Inn.xyz)*fc;

	return Inn.xyz;

};


vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};



float randhash(uint seed, float b)
{
	uint i = (seed ^ 12345391u) * 2654435769u;
	i ^= (i << 6u) ^ (i >> 26u);
	i *= 2654435769u;
	i += (i << 5u) ^ (i >> 12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3(uint seed) {
	float x = randhash(seed, 1.0) - 0.5;
	float y = randhash(seed + 413, 1.0) - 0.5;
	float z = randhash(seed * 2 + 12, 1.0) - 0.5;
	return vec3(x, y, z);

};

vec3 GetCurl(vec3 Pos) {

	return texture(CurlTexture, Pos.xyz).xyz;
};



float Octave(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*0.073, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x - ttime*0.053, fvy + UV.y - ttime*0.02 + ttime*0.0));
	// fy+=sin(voronoi (6*vec2(UV.x+ttime*0.073,UV.y-ttime*0.02+ttime*0.0)));
	fy += (voronoi(10.4*vec2(UV.x - ttime*0.043, fv + UV.y - ttime*0.023 + ttime*0.0)));

	fy *= 1 * voronoi(4 * vec2(UV.x - ttime*0.043, fvy + UV.y + ttime*0.0 + ttime*0.0));
	fy += 1.4*voronoi(33.4*vec2(fv + UV.x - ttime*0.042, UV.y + fvy - ttime*0.01 + ttime*0.0))		*voronoi(6.4*vec2(fv + UV.x - ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.2)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);

	// fy*=0.5;
	//fy=voronoi (vec2(UV.x,UV.y)*8.0)*0.0;
	return fy;



};



float Octave2(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*1.043, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime*0.043, fvy + UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(6 * vec2(UV.x + ttime*0.143, UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime*0.043, fv + UV.y - ttime*0.02 + ttime*0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime*0.053, UV.y + fvy - ttime*0.01 + ttime*0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime*0.223, fvy + UV.y - ttime*0.01 + ttime*0.0));
	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};



float Octave3(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime * 0 * 1.043, fvy + UV.y + ttime * 0 * 0.03 + ttime * 0 * 0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime * 0 * 0.043, fvy + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(6 * vec2(UV.x + ttime * 0 * 0.143, UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime * 0 * 0.043, fv + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.053, UV.y + fvy - ttime * 0 * 0.01 + ttime * 0 * 0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.033, UV.y + fvy - ttime * 0 * 0.03 + ttime * 0 * 0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime * 0 * 0.223, fvy + UV.y - ttime * 0 * 0.01 + ttime * 0 * 0.0));
	fy += 0.3*sin(ttime * 0 + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};


vec3 Texture(vec2 UV) {



	return vec3(1.0)*pow((1.0 - length(UV - vec2(0.5))), 2.0);



	UV += vec2(100.0);
	ivec2 iUV = ivec2(UV*256.0);
	if ((iUV.x + iUV.y) % 2 == 0)
		return vec3(1.0);
	else
		return vec3(0.3);




};

/*
vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};
*/

//#define INVOCATION_SIZE (2001)
//#define INVOCATION_SIZEF (2001.0)
void main() {


	int INVOCATION_SIZE = int(Invocation) + 1;
	float INVOCATION_SIZEF = Invocation+1.0;


	float TotalParticles = 1.0 / float(INVOCATION_SIZE*INVOCATION_SIZE);

	uint MyIndex = gl_GlobalInvocationID.x + gl_GlobalInvocationID.y*INVOCATION_SIZE;
	float fMyIndex = float(MyIndex);
	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
	float fMyIndexX = float(gl_GlobalInvocationID.x)*1.0 / INVOCATION_SIZEF;
	float fMyIndexY = float(gl_GlobalInvocationID.y)*1.0 / INVOCATION_SIZEF;

	vec2 fMyIndexXY = vec2(fMyIndexX, fMyIndexY);
	float fr1 = randhash(MyIndex, 1.0);
	int MeshID = int(texture(OriginalPositionTexture, fMyIndexXY).w);


	vec3 OriginalPos;
	vec3 OriginalCol;


	//OriginalPos.xyz*=2.0;
	//OriginalPos.y=abs (OriginalPos.y);



	float fup=1.0-clamp ((ttime - (-3.7))*0.25,0.0,1.0);

	OriginalPos.xyz = texture(OriginalPositionTexture, fMyIndexXY).xyz+vec3 (0.0,0.0,0.0);
	OriginalPos*=0.92;
	OriginalPos.z+=0.2;
	//OriginalPos.xy=Rot (OriginalPos.xy,sin(ttime*0.45)*0.08,vec2 (0.0));

		if (MyIndex%1000==0)
		{
			OriginalPos.xyz = vec3(randhash(MyIndex * 32, 1.0), randhash(MyIndex * 532 + 3, 1.0), randhash(MyIndex * 31, 1.0))*1.0 - vec3(0.5);
			OriginalPos.xyz*=20.0;
			float fyy=1.0+clamp ((ttime-8.0)*0.1,0.0,10.0);
			
			OriginalPos.y-=ttime*(0.1+fr1)*fyy;
				OriginalPos.z=-1.0;
		}

	float fxx=clamp ((OriginalPos.x),-100.0,100.0)*0.2;
	//OriginalPos.xz=Rot(OriginalPos.xz, ttime*0.0-PosY, vec2 (0.0,0));

	//OriginalPos.xz=Rot(OriginalPos.xz, ttime*0.0+PosY, vec2 (0.0,0));




	vec3 SuperOriginalPos= texture(SuperOriginalPositionTexture, fMyIndexXY).xyz;
	vec3 NewOriginalPos= texture(OriginalPositionTexture, fMyIndexXY).xyz+vec3 (0.0,0.0,5.0);


	//Colors[MyIndex].xyz=vec3 (texture (OriginalPositionTexture, fMyIndexXY).w)*0.1;

	vec3 Normal = texture(OriginalColorTexture, fMyIndexXY).xyz;
	float fcc = 0.5 + 0.5*dot(Normal, vec3(sin(ttime), 0.0, cos(ttime)));
	float fcw = texture(OriginalColorTexture, fMyIndexXY).w;
	//fcc=pow (1.0*fcc,13.0);










	if (ttime < 0.25)
		if (ttime > 0.2) {

			Velocities[MyIndex].xyz = vec3(0.0, 0.0, 0.0);

		};



	Velocities[MyIndex].xyz = GetCurl(Positions[MyIndex].xyz*0.126*0.6+vec3 (ttime)*0.03)*0.34;
	Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.415*0.6+vec3 (ttime)*-0.03)*0.24;
	//SuperOriginalPos.xyz-=vec3 (0.0,1.5,0.0);
	Velocities[MyIndex].xy += (SuperOriginalPos.xy)*0.4;

if (MyIndex%50==0)
	Velocities[MyIndex].xy += (SuperOriginalPos.xy)*fr1*0.5;

	Velocities[MyIndex].z-=1.2;
	







	//Velocities[MyIndex].xyz += vec3 (0.0,2.0,0.0);
	//(SuperOriginalPos.yz)*0.5;

	//Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.76)*0.54;
	//Velocities[MyIndex].xyz+=GetCurl (Positions[MyIndex].xyz*0.1)*1.0;
	




	//Velocities[MyIndex].yz += SuperOriginalPos.yz*1.0;
	//GetCurl (Positions[MyIndex].xyz*0.3)*0.2;

	//if (ttime < 0.2)


	//		if (ttime<0.5+fMyIndex*0.001) 
	//		if (ttime<0.5+fr1*0.2+5.0-fMyIndex*0.0005) 

	//float fdist=Positions[MyIndex]

	float ftheta = 100.1*texture(VoronoiTexture, vec2(0.5) + 3.4*Positions[MyIndex].xy).x;
	//ftheta+=100.1*texture (VoronoiTexture, vec2 (0.5)+2.4*OriginalPos.yz).x;
	ftheta += OriginalPos.y*10.4;
	

	float fpull = sin(fMyIndex*0.001);

	float ttimedown=ttime+1-6;

		//OriginalPos.y-=clamp (ttimedown*0.45*0.5-1.2,0.0,100.0);
		//SuperOriginalPos.y-=clamp (ttime*0.35*0.5-0.5,0.0,100.0);



	fpull =1.0*sin (15.1*texture(VoronoiTexture, vec2(0.5) +0.0*OriginalPos.xz+ 0.1*SuperOriginalPos.xz).x+ttime*0.0);
			//Velocities[MyIndex].xyz += vec3(0.0, fpull, 0.0);


	float fss=OriginalPos.x*-0.0;

	fpull+=0.0+ttimedown*3.0*0.2+fss+0.0*pow (0.5+0.5*sin(OriginalPos.y*27.0),5.0)-length (OriginalPos.xz)*0.0+0.0+0.0*OriginalPos.x*0.0+OriginalPos.y*1.4-1.5;
	fpull+=clamp (ttime-6.0+length (OriginalPos.x*2.0),0.0,10.0)*0.15;
	fpull+=1.0*clamp (sin (OriginalPos.x*OriginalPos.z*2.0),0.0,1.0);
	//fpull+=ttime*0.1;
//	fpull+=0.2;
	{

vec2 VP=	Positions[MyIndex].xy;
	
float vor1=2.0*voronoi(VP*0.6+vec2 (-0.1*ttime))*VP.x;
//*clamp (-Positions[MyIndex].y+1,0.0,100.0);
//r1*=1.9*voronoi(Positions[MyIndex].xz*1.1+vec2 (0.0*ttime));
vor1=pow (vor1*1.1,7.0);
vor1=clamp (vor1,0.0,1.0)*1.0;

if (ttime>2.0)
{
	fpull+=vor1;
}



	}

	float Intp=	clamp (fpull-fr1*0.1-0.7,0.0,100.0)*1.5;
 
	
	//fcw+=(0.0-fcw)*0.5;
	//fcw*=1.0+(clamp (fpull,0.0,100.0))*4.15;

//	fcw*=1.0-clamp (fpull-1.5,0.0,1.0);
	/*
	if (fpull>1.5+fr1)
		if (MyIndex%35!=0)
		Positions[MyIndex].xyz=vec3 (1000.);
		*/
	Positions[MyIndex].y+=-0.12*pow (fpull,3.0)*DeltaT*clamp ((ttime-2.0)*0.2,0.0,10.0);

	fpull = clamp(fpull, 0.0, 1.0);
	//fpull=pow(fpull,100.0);
	if (fpull<0.9){

	}
	
//	fcw*=1.0-clamp (1.0*(fpull-0.8),0.0,1.0);

	//fpull=1.0-pow(1.0-fpull,2.0);
	//fcw=pow (fcw,1.0);
	//fcw*=0.0;


	Positions[MyIndex].w=1.0;
	
	//if (MyIndex%7300==0) Positions[MyIndex].w=clamp ((fpull-0.5),0.0,1000.0)*50.0;



	if (MyIndex%1500==0)
	if (fpull>1.0)
	{
		
		Positions[MyIndex].w=1+(fpull-1.3)*50.0;
	Velocities[MyIndex].xyz+=vec3 (0.0,0.2,0.0);
	}


	//ull=0.1;
	//			ftheta=Octave3 (OriginalPos.xy*25.0)*10.0-0.0;
	//		ftheta+=OriginalPos.y*130.4;




	//if (ttime<0.5+fMyIndex*0.00005) 
	Positions[MyIndex].xyz += 1.0*Velocities[MyIndex].xyz*DeltaT;
	//ositions[MyIndex].y=clamp (Positions[MyIndex].y,0.0,1000.0);

	Positions[MyIndex].xyz+=(OriginalPos-Positions[MyIndex].xyz)*clamp (1.0-fpull,-0.0,1.0);
	//fpull=clamp (fpull,0.0,1.0);
	if (MyIndex%1000==0)
	Positions[MyIndex].xyz=OriginalPos;





	//Positions[MyIndex].xyz+=(NewOriginalPos-Positions[MyIndex].xyz)*pow (fpull-1.0,1.0);

	

	if (ttime < 0.5)
	{
		Positions[MyIndex].xyz = OriginalPos.xyz;

	}




	/*
	if (ttime<0.5+ftheta*0.4)
	{
	Positions[MyIndex].xyz = OriginalPos.xyz+vec3 (0.0,0.0,0.0);


	}
	else
	{

	Positions[MyIndex].xyz += 1.0*Velocities[MyIndex].xyz*DeltaT;
	}
	*/











	//	Positions[MyIndex].y=clamp (Positions[MyIndex].y,0.0,1000.0);


	if (ttime < 0.2)
	{
		Velocities[MyIndex].xyz = vec3(0.0);
		//Positions[MyIndex].xyz=OriginalPos.xyz;
	}


	/*
	if (MyIndex%12000==0)

	Positions[MyIndex].y=5.0;
	*/
	//if (MyIndex%2!=0)		fcw=0.0;

	//Velocities[MyIndex].y-=0.2*DeltaT;



	float frp = randhash(uint(MyIndex * 5245), 1.0);
	frp = length(Positions[MyIndex].xz)*10.1;
	//Positions[MyIndex].xyz+=vec3 (0.0,1.0,0.0)*clamp (ttime-frp,0.0,10000.0);





	fcw=clamp (fcw,0.0,1.0);
	//fcw=fpull*fcw;
	//fcw=0.0;
	Normal=(texture(OriginalColorTexture, fMyIndexXY).xyz-vec3 (0.5))*2.0;
	//fdot=1.0;
	//Normal.xyz=abs(Normal.xyz);
	vec3 StoneTex=texture2D (StoneTexture2, SuperOriginalPos.xy*0.253+vec2 (0.4)+Normal.xz*0.2).xyz;
	 StoneTex*=texture2D (StoneTexture2, SuperOriginalPos.xy*0.1+vec2 (0.5)+Normal.xz*0.0).xyz;
	//Normal.x+=-pow (1.1*StoneTex,vec3 (30.0)).x;

	//Normal+=StoneTex.xyz*5.0;
	//Normal=normalize(Normal);
	vec3 Light=vec3 (0.0,-0.2*ttime,0.0)+SuperOriginalPos.xyz;
	
	//Light.x+=-10.5*pow (1.1*StoneTex,vec3 (17.0)).x;

	Light=normalize(Light);
	float fdot;
	
	fdot=0.8+0.4*pow(fdot,15.0);

	float fdot2;
	//=0.8+0.3*pow (1.0*dot (Normal,vec3 (ttime*0.4-2.0,0.0,0.5)),1.0);

	fdot2=1.0;
	//vec3 (sin(ttime),cos(ttime),0.0));
	//fdot=0.5;
	//fdot=1.0;
	

	StoneTex=pow (StoneTex,vec3(1.0));
	//fdot=0.8;
	vec3 White=(Normal.xyz*0.5+vec3 (1.0))*0.4;
	White+=(vec3 (1.0)-White)*0.7;

	Colors[MyIndex].xyz = fcw*StoneTex.xyz*White*1.0;


//if (MyIndex%10==0)
//Colors[MyIndex].xyz+=(vec3 (0.5,0.0,0.0)-Colors[MyIndex].xyz)*Intp;
	float multt=1.7-1.3*clamp ((ttime-6.0)*0.2,0.0,1.0);
Colors[MyIndex].xyz+=(Colors[MyIndex].xyz*multt-Colors[MyIndex].xyz)*Intp;


//Colors[MyIndex].xyz*=0.5+0.5*voronoi(Positions[MyIndex].xz+Normal.xy+vec2 (0.2*ttime));




float vor1=0.3+voronoi(Positions[MyIndex].xy*0.5+vec2 (-0.3*ttime));
vor1*=1.9*voronoi(Positions[MyIndex].xz*1.0+vec2 (0.2*ttime));
vor1+=0.3;
Colors[MyIndex].xyz*=vor1*vec3 (0.9,1.0,1.0);
//vec3 (1.0)*(0.8+0.8*voronoi(Positions[MyIndex].xy*2.0+Normal.xy*0.0+vec2 (0.4*ttime)));
Colors[MyIndex]*=1.0-clamp ((ttime-9.0)*0.1,0.0,10.0);


	Colors[MyIndex].xyz*=clamp (ttime*0.3+0.5*OriginalPos.y,0.0,1.0);

	//Colors[MyIndex].xyz = vec3 (fdot2)*0.15;
	
	//Colors[MyIndex].xyz = White;
	//*vec3(1.5);

		//Colors[MyIndex].xyz*=vec3 (1.0-clamp (fpull-0.4,0.0,1.0));
		//Normal.xyz=normalize(Normal.xyz);
	//Colors[MyIndex].xyz =Normal.xyz;//vec3 (1.0,0.0,0.0)));

	//+Normal.xyz*vec3 (0.5,0.6,0.7)*0.2;

	//Colors[MyIndex].xyz = fdot*vec3 (0.5);
	//vec3(0.5)+Normal.xyz*vec3 (0.5,0.6,0.7)*0.1;

	//Colors[MyIndex].xyz = vec3(fdot)*0.3;
	//ot*vec3 (1.0,1.0,1.2)*StoneTex.xyz;
 	//Normal.xyz;
	
	//0.5,0.4,0.3);

	//Colors[MyIndex].xyz=texture (OriginalUVTexture, fMyIndexXY).yxx;

	//Colors[MyIndex].xyz *= texture(StoneTexture2, texture(OriginalUVTexture, fMyIndexXY).xy).zyx;

	//Texture (Reflect.xy*0.2);
	//Texture (0.03*Normal.xz)*fcw;

	//		Positions[MyIndex].xyz=vec3 (ivec3 (Positions[MyIndex].xyz*100.0))/100.0;


	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime,-ttime,ttime)*0.01+0.6*Positions[MyIndex].xyz)*0.02;
	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime,-ttime,ttime)*0.02+0.1*Positions[MyIndex].xyz)*0.12;





	imageStore(destTexPos, storePos, Positions[MyIndex]);
	//imageStore(destTexVel, storePos, Velocities[MyIndex]);
	imageStore(destTexCol, storePos, Colors[MyIndex]);
}
