#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;
uniform float PosX;

//uniform image2D destTexPos;
//uniform image2D destTexCol;
float   hash(float v);
vec2    rhash(vec2 uv);

layout(binding = 0) writeonly uniform image2D destTexPos;
layout(binding = 1) writeonly uniform image2D destTexVel;
layout(binding = 2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture;

uniform sampler2D ColorTexture;
uniform sampler3D CurlTexture;
uniform sampler2D VoronoiTexture;

uniform sampler2D OriginalPositionTexture;
uniform sampler2D SuperOriginalPositionTexture;
uniform sampler2D OriginalUVTexture;
uniform sampler2D OriginalColorTexture;

uniform sampler2D StoneTexture2;


uniform sampler2D OriginalPositionTexture_Text;
uniform sampler2D OriginalColorTexture_Text;

uniform sampler2D Swirl_Texture;


uniform sampler1D Original1DTexture;
layout(local_size_x = 16, local_size_y = 16) in;

layout(std140, binding = 4) buffer Pos{ vec4 Positions[]; };
layout(std140, binding = 5) buffer Vel{ vec4 Velocities[]; };
layout(std140, binding = 6) buffer Col{ vec4 Colors[]; };
uniform float Invocation;

const float InverseMaxInt = 1.0 / 4294967295.0;

float hash(float v)
{
	return fract(fract(v / 1e4)*v - 1e6);
}

vec2 rhash(vec2 uv) {
	const mat2 t = mat2(.12121212, .13131313, -.13131313, .12121212);
	const vec2 s = vec2(1e4, 1e6);
	uv *= t;
	uv *= s;
	return  fract(fract(uv / s)*uv);
}



float voronoi(const in vec2 uv)
{
	vec2 p = floor(uv);
	vec2 f = fract(uv);
	float v = 0.;
	for (int j = -1; j <= 1; j++)
		for (int i = -1; i <= 1; i++)
		{
			vec2 b = vec2(i, j);
			vec2 r = b - f + rhash(p + b);
			v += 1. / pow(dot(r, r), 8.);
		}
	return pow(1. / v, 0.0625);
}




vec3 Rotate(vec3 Input, mat4 RotationM) {
	vec4 Inn = Input.xyzz;
	Inn.w = 1.0;
	Inn = RotationM*Inn;

	float fc = 1.0 - clamp(pow(length(Input)*1.1, 1.0) + 0.0, 0.3, 1.0);
	fc = 0.4 + 0.4*sin(1 * length(Input) + ttime);
	fc *= clamp((ttime - 100)*0.5, 0.0, 1.0);
	fc = 0;
	Inn.xyz += (Input - Inn.xyz)*fc;

	return Inn.xyz;

};





float randhash(uint seed, float b)
{
	uint i = (seed ^ 12345391u) * 2654435769u;
	i ^= (i << 6u) ^ (i >> 26u);
	i *= 2654435769u;
	i += (i << 5u) ^ (i >> 12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3(uint seed) {
	float x = randhash(seed, 1.0) - 0.5;
	float y = randhash(seed + 413, 1.0) - 0.5;
	float z = randhash(seed * 2 + 12, 1.0) - 0.5;
	return vec3(x, y, z);

};

vec3 GetCurl(vec3 Pos) {

	return texture(CurlTexture, Pos.xyz).xyz;
};



float Octave(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*0.073, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x - ttime*0.053, fvy + UV.y - ttime*0.02 + ttime*0.0));
	// fy+=sin(voronoi (6*vec2(UV.x+ttime*0.073,UV.y-ttime*0.02+ttime*0.0)));
	fy += (voronoi(10.4*vec2(UV.x - ttime*0.043, fv + UV.y - ttime*0.023 + ttime*0.0)));

	fy *= 1 * voronoi(4 * vec2(UV.x - ttime*0.043, fvy + UV.y + ttime*0.0 + ttime*0.0));
	fy += 1.4*voronoi(33.4*vec2(fv + UV.x - ttime*0.042, UV.y + fvy - ttime*0.01 + ttime*0.0))		*voronoi(6.4*vec2(fv + UV.x - ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.2)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);

	// fy*=0.5;
	//fy=voronoi (vec2(UV.x,UV.y)*8.0)*0.0;
	return fy;



};



float Octave2(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*1.043, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime*0.043, fvy + UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(6 * vec2(UV.x + ttime*0.143, UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime*0.043, fv + UV.y - ttime*0.02 + ttime*0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime*0.053, UV.y + fvy - ttime*0.01 + ttime*0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime*0.223, fvy + UV.y - ttime*0.01 + ttime*0.0));
	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};



float Octave3(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime * 0 * 1.043, fvy + UV.y + ttime * 0 * 0.03 + ttime * 0 * 0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime * 0 * 0.043, fvy + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(6 * vec2(UV.x + ttime * 0 * 0.143, UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime * 0 * 0.043, fv + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.053, UV.y + fvy - ttime * 0 * 0.01 + ttime * 0 * 0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.033, UV.y + fvy - ttime * 0 * 0.03 + ttime * 0 * 0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime * 0 * 0.223, fvy + UV.y - ttime * 0 * 0.01 + ttime * 0 * 0.0));
	fy += 0.3*sin(ttime * 0 + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};


vec3 Texture(vec2 UV) {



	return vec3(1.0)*pow((1.0 - length(UV - vec2(0.5))), 2.0);



	UV += vec2(100.0);
	ivec2 iUV = ivec2(UV*256.0);
	if ((iUV.x + iUV.y) % 2 == 0)
		return vec3(1.0);
	else
		return vec3(0.3);




};


vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};
/*

vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};

*/

//#define INVOCATION_SIZE (2001)
//#define INVOCATION_SIZEF (2001.0)
void main() {


	int INVOCATION_SIZE = int(Invocation) + 1;
	float INVOCATION_SIZEF = Invocation;


	float TotalParticles = 1.0 / float(INVOCATION_SIZE*INVOCATION_SIZE);

	uint MyIndex = gl_GlobalInvocationID.x + gl_GlobalInvocationID.y*INVOCATION_SIZE;
	float fMyIndex = float(MyIndex);
	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
	float fMyIndexX = float(gl_GlobalInvocationID.x)*1.0 / INVOCATION_SIZEF;
	float fMyIndexY = float(gl_GlobalInvocationID.y)*1.0 / INVOCATION_SIZEF;

	vec2 fMyIndexXY = vec2(fMyIndexX, fMyIndexY);
	float fr1 = randhash(MyIndex, 1.0);
	int MeshID = int(texture(OriginalPositionTexture, fMyIndexXY).w);


	vec3 OriginalPos;
	vec3 OriginalCol;

	Colors[MyIndex].xyz = vec3(randhash(MyIndex * 132, 1.0), randhash(MyIndex * 32 + 63, 1.0), randhash(MyIndex * 71 + 3, 1.0));

	OriginalPos.xyz = vec3(randhash(MyIndex * 32, 1.0), randhash(MyIndex * 532 + 3, 1.0), randhash(MyIndex * 31, 1.0))*1.0 - vec3(0.5);
	//OriginalPos.xyz*=2.0;
	//OriginalPos.y=abs (OriginalPos.y);

	OriginalPos.xyz *= 1.0;

	OriginalPos.xyz = texture(OriginalPositionTexture, fMyIndexXY).xyz;
	
	OriginalPos.xz=Rot(OriginalPos.xz, 1, vec2 (0.42,-3.55));
	OriginalPos.xyz+=vec3 (0.0,0.2,-4.0)+vec3 (0,-3,36.0-ttime*1.1);

	vec3 SuperOriginalPos= texture(OriginalPositionTexture, fMyIndexXY).xyz;
	vec3 NewOriginalPos= texture(OriginalPositionTexture, fMyIndexXY).xyz+vec3 (0.0,0.0,-6.0);

	Colors[MyIndex].xyz = texture(OriginalColorTexture, fMyIndexXY).xyz*texture(OriginalPositionTexture, fMyIndexXY).w*0.1;
	//Colors[MyIndex].xyz=vec3 (texture (OriginalPositionTexture, fMyIndexXY).w)*0.1;

	vec3 Normal = texture(OriginalColorTexture, fMyIndexXY).xyz;
	float fcc = 0.5 + 0.5*dot(Normal, vec3(sin(ttime), 0.0, cos(ttime)));
	float fcw = texture(OriginalColorTexture, fMyIndexXY).w;
	//fcc=pow (1.0*fcc,13.0);
	Colors[MyIndex].xyz = vec3(1.0)*fcc*texture(OriginalColorTexture, fMyIndexXY).w;

	fcw = pow(fcw, 1.0);








	if (ttime < 0.25)
		if (ttime > 0.2) {

			Velocities[MyIndex].xyz = vec3(0.0, 0.0, 0.0);

		};



	Velocities[MyIndex].xyz = GetCurl(Positions[MyIndex].xyz*0.106*1.0+vec3 (ttime)*0.01)*0.54*0.5;
	Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.065*1.0+vec3 (ttime)*-0.02)*0.34*0.5;
	//Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.76)*0.54;
	//Velocities[MyIndex].xyz+=GetCurl (Positions[MyIndex].xyz*0.1)*1.0;
	Velocities[MyIndex].xyz += vec3(0.0, 0.6  ,-1.3);


	//Velocities[MyIndex].yxz += SuperOriginalPos.yxz*0.5;
	//GetCurl (Positions[MyIndex].xyz*0.3)*0.2;

	//if (ttime < 0.2)


	//		if (ttime<0.5+fMyIndex*0.001) 
	//		if (ttime<0.5+fr1*0.2+5.0-fMyIndex*0.0005) 

	//float fdist=Positions[MyIndex]

	float ftheta = 100.1*texture(VoronoiTexture, vec2(0.5) + 3.4*Positions[MyIndex].xy).x;
	//ftheta+=100.1*texture (VoronoiTexture, vec2 (0.5)+2.4*OriginalPos.yz).x;
	ftheta += OriginalPos.y*10.4;
	

	float fpull = sin(fMyIndex*0.001);
		float ttimedown=(ttime-19.0)*0.8;
		float fdd=pow (clamp (ttimedown*0.25*1.2+1.0,0.0,100.0),2.0);
		OriginalPos.y-=fdd;

	Velocities[MyIndex].xyz += vec3(0.0, -fdd*0.2*(fr1*0.2+1.0),0);


		//SuperOriginalPos.y-=clamp (ttime*0.35*0.5-0.5,0.0,100.0);

		// dejia


	fpull = 0.7*sin (55.1*texture(VoronoiTexture, vec2(0.5) +0.0*OriginalPos.xz+ 0.2*SuperOriginalPos.xz).x+ttime*0.0);

			//Velocities[MyIndex].xyz += vec3(0.0, fpull, 0.0);

	fpull+=0.0+ttimedown*2.7*0.8-1.7-SuperOriginalPos.x*0.25-OriginalPos.y*0.1+0.1+3.5;
	fpull*=clamp (SuperOriginalPos.z+4,0.0,1.0);

	//fpull+=ttime*0.1;

	fcw+=(0.0-fcw)*0.5;
	fcw*=(fpull)*4.15;
	fcw*=1.0-clamp (fpull-1.5,0.0,1.0);
	
	
	if (fpull>1.4+fr1)
		if (MyIndex%75!=0)
		Positions[MyIndex].xyz=vec3 (1000.);
		

	float fcc2=clamp ((ttime-25.0)*0.35,0.0,1.0);
	fcc2=1.0-pow (1.0-fcc2,4.0);
	
	if (fcc2>fr1)
		Positions[MyIndex].xyz=vec3 (1000.);





	fpull = clamp(fpull, 0.0, 1.0);
	//fpull=1.0-pow(1.0-fpull,2.0);
	//fcw=pow (fcw,1.0);
	//fcw*=0.0;

	if (fpull<0.9){

		fcw=clamp (10.0*(fpull-0.8),0.0,1.0);
	}

	Positions[MyIndex].w=1.0;
	if (MyIndex%1500==0)
	if (fpull>1.0)
	{
		
		Positions[MyIndex].w=1+(fpull-1.3)*50.0;
	Velocities[MyIndex].xyz+=vec3 (0.0,0.2,0.0);
	}







	//ull=0.1;
	//			ftheta=Octave3 (OriginalPos.xy*25.0)*10.0-0.0;
	//		ftheta+=OriginalPos.y*130.4;


	//if (ttime<0.5+fMyIndex*0.00005) 
	Positions[MyIndex].xyz += 1.0*Velocities[MyIndex].xyz*DeltaT;
	//ositions[MyIndex].y=clamp (Positions[MyIndex].y,0.0,1000.0);

	Positions[MyIndex].xyz+=(OriginalPos-Positions[MyIndex].xyz)*clamp (1.0-fpull,-0.0,1.0);
	//fpull=clamp (fpull,0.0,1.0);
	

	//Positions[MyIndex].xyz+=(NewOriginalPos-Positions[MyIndex].xyz)*pow (fpull-1.0,1.0);

	

	if (ttime < 0.5)
	{
		Positions[MyIndex].xyz = OriginalPos.xyz;

	}


	/*
	if (ttime<0.5+ftheta*0.4)
	{
	Positions[MyIndex].xyz = OriginalPos.xyz+vec3 (0.0,0.0,0.0);


	}
	else
	{

	Positions[MyIndex].xyz += 1.0*Velocities[MyIndex].xyz*DeltaT;
	}
	*/











	//	Positions[MyIndex].y=clamp (Positions[MyIndex].y,0.0,1000.0);


	if (ttime < 0.2)
	{
		Velocities[MyIndex].xyz = vec3(0.0);
		//Positions[MyIndex].xyz=OriginalPos.xyz;
	}

	else
	{
		//Velocities[MyIndex].xyz*=0.95;
		//vec3 (0.0,0.0,1.0);



	}

	/*
	if (MyIndex%12000==0)

	Positions[MyIndex].y=5.0;
	*/
	//if (MyIndex%2!=0)		fcw=0.0;

	//Velocities[MyIndex].y-=0.2*DeltaT;



	float frp = randhash(uint(MyIndex * 5245), 1.0);
	frp = length(Positions[MyIndex].xz)*10.1;
	//Positions[MyIndex].xyz+=vec3 (0.0,1.0,0.0)*clamp (ttime-frp,0.0,10000.0);



	Colors[MyIndex].xyz = vec3(fcc)*fcw;
	Colors[MyIndex].xyz = Texture(0.01*Positions[MyIndex].xz)*fcw;

	vec3 Reflect = reflect(vec3(sin(ttime), 0.0, cos(ttime)), Normal);

	Colors[MyIndex].xyz = vec3(0.0);

	Colors[MyIndex].xyz = (vec3(0.5) + 0.3*Reflect.xyz)*fcw;
	Colors[MyIndex].xyz = vec3(fcw)*2.0;



	fcw=clamp (fcw,0.0,1.0);
	Colors[MyIndex].xyz = vec3(0.7,0.35,0.2)*fcw*2.3;


	//0.5,0.4,0.3);

	//Colors[MyIndex].xyz=texture (OriginalUVTexture, fMyIndexXY).yxx;

	//Colors[MyIndex].xyz *= texture(StoneTexture2, texture(OriginalUVTexture, fMyIndexXY).xy).zyx;

	//Texture (Reflect.xy*0.2);
	//Texture (0.03*Normal.xz)*fcw;

	//		Positions[MyIndex].xyz=vec3 (ivec3 (Positions[MyIndex].xyz*100.0))/100.0;


	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime,-ttime,ttime)*0.01+0.6*Positions[MyIndex].xyz)*0.02;
	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime,-ttime,ttime)*0.02+0.1*Positions[MyIndex].xyz)*0.12;





	imageStore(destTexPos, storePos, Positions[MyIndex]);
	imageStore(destTexVel, storePos, Velocities[MyIndex]);
	imageStore(destTexCol, storePos, Colors[MyIndex]);
}
