
#version 430
#define float4 vec4
#define float3 vec3
#define float2 vec2
#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D
varying vec2 UV;
float ffc;

#define SSAO se= ep+1*ddd*sign (dot (ray,norm))*ray; occluderFragment = tex2D(Texture2,se.xy);shadow=occluderFragment.w;occluderFragment.a=1.0*tex2D (TextureDepth,se.xy).x;occNorm = (occluderFragment.xyz*2.0)-vec3 (1.0);\
depthDifference = 10.0*(depth-occluderFragment.a);normDiff = 1.0-1.0*dot(occNorm,norm); \
if (depthDifference<0.0) depthDifference=0.0; if (depthDifference>0.10) depthDifference=0.0; addition=depthDifference*normDiff*10.0;\
ffc=depthDifference*10.0; ffc=1-ffc; addition *=ffc; bl += addition*2.0;
//bl += addition*2.0;
bool dontint = false;

//ffc=depthDifference*20.0; ffc=1-ffc; addition *=ffc; bl += addition*2.0;
//#define SSAO se= ep+ddd*sign (dot (ray,norm))*ray; occluderFragment = tex2D(texture2d_1,se.xy); shadow=occluderFragment.w;occluderFragment.a=tex2D (texture2d_2,se.xy).x;occNorm = (occluderFragment.xyz*2.0)-vec3 (1.0);depthDifference = 40.0*(depth-occluderFragment.a);normDiff = 1.0-1.0*dot(occNorm,norm); addition=step(0.00002,depthDifference)*normDiff*(1.0-smoothstep(0.0002,0.20,depthDifference)); bl += addition;



//addition=step(0.00002,depthDifference)*normDiff*(1.0-smoothstep(0.0002,0.20,depthDifference));\

vec3 FinalNormal;

uniform sampler2D VideoTexture;
uniform sampler2D Texture1;
uniform sampler2D Credit1;
uniform sampler2D Credit2;
uniform sampler2D Texture2;
uniform sampler2D TextureDepth;
uniform sampler2D texture2d_random;
uniform float PosY;
uniform float Limit;
uniform float ttime;

uniform vec3 ScreenDiff;

uniform mat4 ProjectionMatrix;
float fnn;
float GIfactor = 0;
vec4 NormNow = vec4(0.0);
vec4 NormJump = vec4(0.0);
vec4 GIColor = vec4(0.0);
vec4 ReflNorm = vec4(0.0);


float cloudreach = 0.0;




const float InverseMaxInt = 1.0 / 4294967295.0;



vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};


mat3 setCamera(in vec3 ro, in vec3 ta, float cr)
{
	vec3 cw = normalize(ta - ro);
	vec3 cp = vec3(sin(cr), cos(cr), 0.0);
	vec3 cu = normalize(cross(cw, cp));
	vec3 cv = normalize(cross(cu, cw));
	return mat3(cu, cv, cw);
}



float randhash(uint seed, float b)
{
	uint i = (seed ^ 12345391u) * 2654435769u;
	i ^= (i << 6u) ^ (i >> 26u);
	i *= 2654435769u;
	i += (i << 5u) ^ (i >> 12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3(uint seed) {
	float x = randhash(seed, 1.0) - 0.5;
	float y = randhash(seed * 3 + 1413, 1.0) - 0.5;
	float z = randhash(seed * 7 + 42, 1.0) - 0.5;
	return vec3(x, y, z);

};

float hashv(vec3 p)
{
	p = fract(p*0.3183099 + .1); p *= 17.0;
	return fract(p.x*p.y*p.z*(p.x + p.y + p.z));
}
// hash

float hash(float n)
{
	return fract(sin(n)*43758.5453);
}

// noise

// map


float noise(in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);
	f = f*f*(3.0 - 2.0*f);

	return mix(mix(mix(hashv(p + vec3(0, 0, 0)),
		hashv(p + vec3(1, 0, 0)), f.x),
		mix(hashv(p + vec3(0, 1, 0)),
		hashv(p + vec3(1, 1, 0)), f.x), f.y),
		mix(mix(hashv(p + vec3(0, 0, 1)),
		hashv(p + vec3(1, 0, 1)), f.x),
		mix(hashv(p + vec3(0, 1, 1)),
		hashv(p + vec3(1, 1, 1)), f.x), f.y), f.z);
}


vec4 map(in vec3 p)
{
	//altitude
	float d = -0.005 - p.y + sin(ttime) / 4.0;
	d = 0.05 - p.y;
	//wind
	vec3 q = p - vec3(-0.4, 0.0, sin(ttime) / 1500.0 - 0.5) * ttime*0.1;
	q = p + vec3(0.0, 0.0, 0.5) * ttime*0.13*0.5;


	float f;
	q *= 4.0;
	f = 0.5000*noise(q); q = q*2.02;
	f += 0.2500*noise(q); q = q*2.03;
	f += 0.1250*noise(q); q = q*2.01;
	f += 0.0625*noise(q);
	//f=pow(f,1.2);
	//density
	d += 4.0 * f;

	d = clamp(d, 0.0, 1.0);

	vec4 res = vec4(d);

	// diffuse is here actually
	//	res.xyz = mix( 1.15*vec3(1.0,0.95,0.8), vec3(0.7,0.7,0.7), res.x );
	res.xyz = mix(1.1*vec3(1.0, 1.1, 1.2), vec3(0.7, 0.7, 0.7), res.x);

	return res;
}

// sundir

vec3 sundir = vec3(1.0, -0.2, 0.0);

// raymarch
float steps = 0.0;

vec4 raymarch(in vec3 ro, in vec3 rd)
{
	vec4 sum = vec4(0, 0, 0, 0);
	//ro.xy+=CamPos.xy*10.0;
	//ro.x-=CamPos.x;
	float t = 0.0;
	for (int i = 0; i<10; i++)
	{

		if (sum.a > 0.99) continue;
		steps += 0.1;
		vec3 pos = ro + t*rd;
		vec4 col = map(pos);

#if 1
		float dif = clamp((col.w - map(pos + 0.3*sundir).w) / 0.6, 0.0, 1.0);
		float constrast = 0.5;
		//fake for now, but will change soon
		vec3 skylighting = vec3(0.4, 0.88, 1.2)*0.1 + 0.0;
		vec3 sunlighting = vec3(1.0, 1.0, 1.0)*0.7 + 0.0;


		vec3 lin = sunlighting + skylighting;
		col.xyz *= lin;
		col.xyz *= pow(col.xyz, vec3(constrast));
#endif

		col.a *= 0.25;
		col.rgb *= col.a;

		sum = sum + col*(1.0 - sum.a);

#if 0
		t += 0.1;
#else
		t += max(0.1, 0.02*t)*1.0;
#endif
	}

	sum.xyz /= (0.001 + sum.w);

	return clamp(sum, 0.0, 1.0);
}







#define iGlobalTime time
#define iTime ttime
#define iResolution vec2 (1280.0,720.0)

#define DRAG_MULT 4.0


#define wave(uv, emitter, speed, phase, timeshift) pow(1.+3., sin(distance(uv, emitter) * phase - (0.31*iTime + timeshift) * speed)-1.)

vec2 wavedrag(vec2 uv, vec2 emitter){
	return normalize(uv - emitter);
}

float getwaves(vec2 position){
	position *= 0.1;
	float iter = 0.0;
	float phase = 6.0;
	float speed = 2.0;
	float weight = 1.0;
	float w = 0.0;
	float ws = 0.0;
	for (int i = 0; i < 16; i++){
		vec2 p = vec2(sin(iter), cos(iter)) * 30.0;
		float res = wave(position, p, speed, phase, 0.0);
		float res2 = wave(position, p, speed, phase, 0.006);
		position -= wavedrag(position, p) * (res - res2) * weight * DRAG_MULT;
		w += res * weight;
		iter += 12.0;
		ws += weight;
		weight = mix(weight, 0.0, 0.2);
		phase *= 1.2;
		speed *= 1.02;
	}
	return w / ws;
}
float getwavesHI(vec2 position){
	position *= 0.1;
	float iter = 0.0;
	float phase = 6.0;
	float speed = 2.0;
	float weight = 1.0;
	float w = 0.0;
	float ws = 0.0;
	for (int i = 0; i < 40; i++){
		vec2 p = vec2(sin(iter), cos(iter)) * 30.0;
		float res = wave(position, p, speed, phase, 0.0);
		float res2 = wave(position, p, speed, phase, 0.006);
		position -= wavedrag(position, p) * (res - res2) * weight * DRAG_MULT;
		w += res * weight;
		iter += 12.0;
		ws += weight;
		weight = mix(weight, 0.0, 0.2);
		phase *= 1.2;
		speed *= 1.02;
	}
	return w / ws;
}

float H = 0.0;
vec3 normal(vec2 pos, float e, float depth){
	vec2 ex = vec2(e, 0);
	H = getwavesHI(pos.xy) * depth;
	vec3 a = vec3(pos.x, H, pos.y);
	return normalize(cross(normalize(a - vec3(pos.x - e, getwavesHI(pos.xy - ex.xy) * depth, pos.y)),
		normalize(a - vec3(pos.x, getwavesHI(pos.xy + ex.yx) * depth, pos.y + e))));
}
mat3 rotmat(vec3 axis, float angle)
{
	axis = normalize(axis);
	float s = sin(angle);
	float c = cos(angle);
	float oc = 1.0 - c;

	return mat3(oc * axis.x * axis.x + c, oc * axis.x * axis.y - axis.z * s, oc * axis.z * axis.x + axis.y * s,
		oc * axis.x * axis.y + axis.z * s, oc * axis.y * axis.y + c, oc * axis.y * axis.z - axis.x * s,
		oc * axis.z * axis.x - axis.y * s, oc * axis.y * axis.z + axis.x * s, oc * axis.z * axis.z + c);
}
#define mouse vec2 (0.5)
vec3 getRay(vec2 uv){
	uv = (uv * 2.0 - 1.0)* vec2(iResolution.x / iResolution.y, 1.0);
	vec3 proj = normalize(vec3(uv.x, uv.y, 1.0) + vec3(uv.x, uv.y, -1.0) * pow(length(uv), 2.0) *0.05);
	if (iResolution.x < 400.0) return proj;
	vec3 ray = rotmat(vec3(0.0, -1.0, 0.0), mouse.x * 2.0 - 1.0) * rotmat(vec3(1.0, 0.0, 0.0), 0.5 * (mouse.y * 2.0 - 1.0)) * proj;
	return ray;
}

float rand2sTimex(vec2 co){
	return fract(sin(dot(co.xy * iTime, vec2(12.9898, 78.233))) * 43758.5453);
}

vec3 hsv2rgb(vec3 inn)
{

float innx=inn.x;
if (ttime<81)
if (ttime>54)
innx*=1.3;

if (ttime>140.0)
innx*=10.0;




float      hh, p, q, t, ff;
	int        i;
	vec3         outt;

	if (inn.y <= 0.0) {       // < is bogus, just shuts up warnings
		outt.r = inn.z;
		outt.g = inn.z;
		outt.b = inn.z;
		return outt;
	}
	hh = innx;
	hh = mod(hh, 360.0);
	//if(hh >= 360.0) hh = 0.0;
	hh /= 60.0;
	i = int(hh);
	ff = hh - i;
	p = inn.z * (1.0 - inn.y);
	q = inn.z * (1.0 - (inn.y * ff));
	t = inn.z * (1.0 - (inn.y * (1.0 - ff)));

	switch (i) {
	case 0:
		outt.r = inn.z;
		outt.g = t;
		outt.b = p;
		break;
	case 1:
		outt.r = q;
		outt.g = inn.z;
		outt.b = p;
		break;
	case 2:
		outt.r = p;
		outt.g = inn.z;
		outt.b = t;
		break;

	case 3:
		outt.r = p;
		outt.g = q;
		outt.b = inn.z;
		break;
	case 4:
		outt.r = t;
		outt.g = p;
		outt.b = inn.z;
		break;
	case 5:
	default:
		outt.r = inn.z;
		outt.g = p;
		outt.b = q;
		break;
	}
	return outt;
}


float raymarchwater(vec3 camera, vec3 start, vec3 end, float depth){
	vec3 pos = start;
	float h = 0.0;
	float hupper = depth;
	float hlower = 0.0;
	vec2 zer = vec2(0.0);
	vec3 dir = normalize(end - start);
	for (int i = 0; i<318; i++){
		h = getwaves(pos.xz) * depth - depth;
		if (h + 0.01 > pos.y) {
			return distance(pos, camera);
		}
		pos += dir * (pos.y - h);
	}
	return -1.0;
}

float intersectPlane(vec3 origin, vec3 direction, vec3 point, vec3 normal)
{
	return clamp(dot(point - origin, normal) / dot(direction, normal), -1.0, 9991999.0);
}

vec3 getatm(vec3 ray){
	return mix(vec3(0.9), vec3(0.2, 0.2, 0.2)*0.0, sqrt(abs(ray.y)));

}

float sun(vec3 ray){
	vec3 sd = normalize(vec3(1.0));
	ray.y = 0.0;
	//ray=normalize(ray);
	return 0.0;
	float sn = dot(ray, sd);
	//sn=pow(sn,5.0);
	sn = 1.0 - 15.0*length(ray.x - ttime*0.1 + 1 + ray.y*11.0);
	sn = clamp(sn, 0.0, 1.0);
	//return 0.0;
	return 101.0*sn;

	return pow(0.5 + 0.5*sin(sn*40.0 - ttime*0.0), 10)*3.0;
	return pow(max(0.0, dot(ray, sd)), 128.0) * 110.0;
}

vec3 getColor(vec2 uv){

	float waterdepth = 0.8;

	//waterdepth*=1.0-clamp (ttime-17.0-uv.x*5.0,0.0,1.0);
	vec3 wfloor = vec3(0.0, -waterdepth, 0.0);
	vec3 wceil = vec3(0.0, 0.0, 0.0);
	float fz = 0.0;
	if (ttime >= 13.0)
		if (ttime < 16.0)
			fz = 1.0;

	vec3 orig = vec3(-ttime * 2, 0.5 - fz*0.5, 0.0 + fz);



	vec3 ray = getRay(uv);
	float hihit = intersectPlane(orig, ray, wceil, vec3(0.0, 1.0, 0.0));
	if (ray.y >= -0.01){
		vec3 C = getatm(ray) * 2.0 + sun(ray);
		//tonemapping
		C = normalize(C) * sqrt(length(C));
		return C;
	}
	float lohit = intersectPlane(orig, ray, wfloor, vec3(0.0, 1.0, 0.0));
	vec3 hipos = orig + ray * hihit;
	vec3 lopos = orig + ray * lohit;
	float dist = raymarchwater(orig, hipos, lopos, waterdepth);
	vec3 pos = orig + ray * dist;

	vec3 N = normal(pos.xz, 0.01, waterdepth);
	FinalNormal = N;
	vec2 velocity = N.xz * (1.0 - N.y);
	N = mix(vec3(0.0, 1.0, 0.0), N, 1.0 / (dist * dist * 0.01 + 1.0));
	vec3 R = reflect(ray, N);
	float fresnel = (0.04 + (1.0 - 0.04)*(pow(1.0 - max(0.0, dot(-N, ray)), 5.0)));

	vec3 C = fresnel * getatm(R) * 2.0 + fresnel * sun(R);

	// water sprays, TimoKinnunen comment on 2017-Apr-2
	C += smoothstep(.09, .2, length(velocity));

	//tonemapping
	C = normalize(C) * sqrt(length(C));

	return C;
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	vec2 uv = fragCoord.xy / iResolution.xy;

	vec3 ray = getRay(uv);
	vec3 C = vec3(0.0);
	vec2 dfx = 1.0 / iResolution.xy;
	vec2 supersampler = dfx;
	vec2 diff = uv;
	float W = 0.0;
	for (int i = 0; i < 1; i++){
		C += getColor(uv + vec2(rand2sTimex(diff), rand2sTimex(diff + 100.0)) * supersampler);
		diff += 200.0;
		W += 1.0;
	}
	C /= W;
	fragColor = vec4(C, 1.0);
}












float hash(vec3 p)
{
	p = fract(p*0.3183099 + .1); p *= 17.0;
	return fract(p.x*p.y*p.z*(p.x + p.y + p.z));
}

float map5(in vec3 p)
{
	vec3 q = p - vec3(0.0, 0.1, 0.0)*ttime;
	//q.y += sin(time + q.x*2.0)*cloudup;

	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q); q = q*2.03;
	f += 0.12500*noise(q); q = q*2.01;
	f += 0.06250*noise(q); q = q*2.02;
	f += 0.03125*noise(q);
	return clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
}

float map4(in vec3 p)
{
	vec3 q = p - vec3(0.0, 0.1, 0.0)*ttime;
	//q.y += sin(time + q.x)*cloudup;
	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q); q = q*2.03;
	f += 0.12500*noise(q); q = q*2.01;
	f += 0.06250*noise(q);
	return clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
}

float map3(in vec3 p)
{
	vec3 q = p - vec3(0.0, 0.1, 0.0)*ttime;
	//q.y += sin(time + q.x)*cloudup;
	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q); q = q*2.03;
	f += 0.12500*noise(q);
	return clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
}

float map2(in vec3 p)
{
	vec3 q = p - vec3(0.0, 0.1, 0.0)*ttime;
	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q);;
	return clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
}

float mapN(in vec3 p)
{
	vec3 q = p - vec3(0.0, 0.1, 1.0)*0.0;
	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q);;
	return f;
	//clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
}

float Aalpha = 1.0;
vec4 integrate(in vec4 sum, in float dif, in float den, in vec3 bgcol, in float t)
{
	// lighting
	vec3 lin = vec3(0.6, 0.7, 0.75)*1.4 + vec3(1.0, 0.6, 0.3)*dif;
	vec4 col = vec4(mix(vec3(1.0, 0.95, 0.8), vec3(0.25, 0.3, 0.35), den), den);
	col.xyz *= lin;
	col.xyz = mix(col.xyz, bgcol, 1.0 - exp(-0.003*t*t));
	// front to back blending    
	col.a *= 1.0;
	col.rgb *= col.a;
	//Aalpha*=0.95;

	return sum + col*(1.0 - sum.a);
}

#define MARCH(STEPS,MAPLOD) for(int i=0; i<STEPS; i++) { vec3  pos = ro + t*rd; if( pos.y<-3.0 || pos.y>2.0 || sum.a > 0.99 ) break; float den = MAPLOD( pos ); if( den>0.01 ) { float dif =  clamp((den - MAPLOD(pos+1.0*0.3*sundir))/0.6, 0.0, 1.0 ); sum = integrate( sum, dif, den, bgcol, t ); } t += 1.5*max(0.05,0.02*t); cloudreach=t; }

vec4 raymarch(in vec3 ro, in vec3 rd, in vec3 bgcol, in ivec2 px)
{

	vec4 sum = vec4(0.0);
	float t = 0.0;//0.05*texelFetch( iChannel0, px&255, 0 ).x;

	MARCH(30, map5);
	MARCH(30, map4);

	MARCH(30, map3);
	MARCH(30, map2);
	//fcc=1.0;
	//MARCH(30, map2);
	//	sum += (SumP - sum)*vec4(1.0 - fcc);
	return clamp(sum, 0.0, 1.0);
}


vec4 render(in vec3 ro, in vec3 rd, in ivec2 px)
{
	// background sky     

	float sun = clamp(dot(sundir, rd), 0.0, 1.0);
	vec3 col = 0.98*vec3(0.6, 0.71, 0.75) - rd.y * 2 * vec3(1.0, 0.5, 0.0) + 0.5;
	//2.6;
	//col=clamp (col,vec3 (0.0),vec3 (0.789));
	//col += 1.2*vec3(1.0, .6, 0.1)*pow(sun, 1.0);
	//col=vec3 (0.1);
	// clouds    
	vec4 res = raymarch(ro, rd, col, px);
	col = col*(clamp(1.0 - res.w*1.0, 0.0, 1.0)) + res.xyz;

	//float sunup = clamp((time - 62.0)*0.5, 1.0, 2.5);
	//sunup *= 1.0 - clamp((time - 86.0)*0.1, 0.0, 1.0);
	// sun glare    
	col = pow(col, vec3(3.0))*0.5;
	//col += 0.3*vec3(1.0, 0.4, 0.2)*pow(sun, 4.0)*	1.0;
	//sunup;
	//col*=0.0;
	return vec4(col, 1.0);
}



void main(void)
{
	float4 cl;
	float depth;


	


	float beat = 1.0*pow(clamp(cos(-0.1 + 130.0 / 60.0*ttime*3.14159126535), 0.0, 1.0), 1.0);
	float beat2 = beat;
	//1.0*pow(clamp(cos(-0.1 + 130.0 / 60.0*ttime*3.14159126535), 0.0, 1.0), 1.0);
	beat = pow(beat, 40.0);

	// random vector
	//vec3 fres = normalize((texture2D(texture2d_random,UV.xy*2.0+float2 (Limit*1.0)).xyz*2.0) - vec3(1.0));

	vec3 fres = normalize(randhash3(int(ttime * 52524) + int(UV.x * 728423) + int(UV.y * 52454661)));
	//es*=0.1;

	// depth 
	depth = tex2D(TextureDepth, UV.xy).x;

	vec3 ep = vec3(UV.xy, depth);
	float bl = 0.0;
	vec3 ray;
	vec3 sea;
	vec3 se;
	vec3 occNorm;
	float depthDifference, normDiff;
	float3 norm = ((tex2D(Texture2, UV.xy).xyz - 0.5)*2.0);
	float4 GlobalIllumination = float4(0.0);
	bl = 1.0;



	float ddd = 0.01;
	//ddd/=pow (depth,2.0);
	float shadow;
	float addition;
	vec4 occluderFragment;

	//for (int i=0;i<24;i++) 

	bool occluder;
	occluder = true;
	//if (tex2D(Texture1,UV.xy).w<0.9) occluder=false;


	//occluder=true;

	//bl=0.0;
	//bl = 1.0;
	norm = normalize(norm);
	// SS lighting
	float ccl = 1.0 - 0.0*pow(dot(norm, float3(0.0, 0.0, 1.0)), 2.0);




	vec4 colo = vec4(0.0);
	//inImage(colo, gl_FragCoord.xy);
	colo = pow(colo, vec4(2.0));


	// shadow

	//bl=1.0;
	//bl*=1.0-tex2D(Texture1,UV.xy).w*0.5;


	// SS Reflections
	//float4 NormMot=norm.xyzz;
	float2 DiffusedUV = norm.xy*0.0135*bl + UV.xy;
	float4 Refl = 1.0*tex2D(TextureDepth, DiffusedUV);


	vec2 UVV = UV;
	vec2 UVV2=UV;


	if (ttime < 20.0)
		if (UVV.x > 0.5) 		UVV.x = 1.0 - UVV.x;

	vec3 Video = pow(texture2D(VideoTexture, vec2(UV.x, 1.0 - UV.y)).zyx, vec3(1.0));
	vec3 VideoX = pow(texture2D(VideoTexture, 1.0*vec2(0.5, UV.y)).zyx, vec3(1.0));

	float mxx=0.4;
	if (ttime>25.0)
		if (ttime<83.0)
			mxx=0.3;
	
	if (ttime>88) 
		mxx=0.2;



	UVV.xy+=clamp (pow (VideoX.x*3.5,6.0),0.0,1.0)*0.023*mxx;
	UVV2.xy+=clamp (pow (VideoX.x*3.5,6.0),0.0,1.0)*0.023;

	//UVV.x+=Video.x*beat;

	uint seed=uint (UV.x*1280.0+UV.y*1280*1280+int (ttime*24242));

	//gl_FragData[0].xyz *= 1.0*(randhash (seed,1.0)*1.5+0.65);
	
	
	
	//	UVV.xy+=clamp (pow (VideoX.x*3.5,6.0),0.0,1.0)*0.013;


	//UVV.x+=pow (clamp (sin (UVV.y*552.0+ttime+Video.x),0.0,1.0),10.0)*0.02;

	// (UVV.y>0.5) 		UVV.y=1.0-UVV.y;




	//if (UV.t<0.45) UVV+=FinalNormal.xy*0.1;
	//UVV+=vec2 (colo.x)*0.03;

	//gl_FragData[0]=vec4 (bl);
	gl_FragData[0] = vec4(0.0);


	vec3 Output = vec3(0.0);
	float tot = 0.0;
	for (int y = -3; y < 4; y++)
		for (int x = -3; x < 4; x++)
		{
			vec2 NUV = UVV + vec2(float(x), float(y))*0.00174*1.0;
			float dst = 1.0 / (1.0 + 0.8*length(vec2(x, y)));
			Output += pow(texture2D(Texture1, NUV).xyz, vec3(1.0))*dst;
			tot += dst;
		}

	Output /= tot;





	vec3 Output2 = vec3(0.0);
	tot = 0.0;
	float fyy = 0.5 + 0.5*sin(ttime*3.1 + 6.0*UV.y);
	fyy *= fyy;
	for (int x = -90; x < 91; x++)
	{
		vec2 NUV = UVV + vec2(float(x), 0.0)*0.00224*0.6;
		float dst = 1.0 / (1.0 + 1.3*length(vec2(x, 0)));
		//float dst=1.0;
		dst *= fyy;
		Output2 += pow(1.3*texture2D(Texture1, NUV).xyz, vec3(6.0))*dst;
		tot += dst;
	}

	Output2 /= tot;
	Output2 *= 1.2 + 0.3*sin(ttime*5.0 + UV.y)*sin(ttime*3.1 + 5.0*UV.y);

	Output2 += (vec3(0.7)*length(Output2) - Output2)*0.5;
	Output2 *= 1.6;
	if (ttime>66)
if (ttime<74)

	Output2 *= 2.0;


	if (ttime<97)
	if (ttime>87){
		Output2*=0.25;
		Output*=0.25;
	
	}
		//Output
	//Output2*=clamp (ttime*0.08,0.0,1.0);
	/*
	vec3 AccumC=vec3 (0.0);
	float clm=0.0;
	for (int t=0;t<20;t++) {
	float fc=float(t)/20.0;
	clm+=(1.0-fc);
	AccumC+=(1.0-fc)*texture2D (Texture1, UV.xy+ScreenDiff.xy*fc*-0.0*vec2 (-1.0,1.0)).xyz;

	};

	AccumC/=clm;
	*/
	//gl_FragData[0].xyz*0
	gl_FragData[0].xyz += Output2*0.7 + Output*0.5;




	{
		vec3 Output = vec3(0.0);
		float tot = 0.0;
		for (int y = -3; y < 4; y++)
			for (int x = -3; x < 4; x++)
			{
				vec2 NUV = UVV + vec2(float(x), float(y))*0.00174*0.25;
				Output += pow(texture2D(Texture1, NUV).xyz, vec3(1.0));
				tot += 1.0;
			}

		Output /= tot;
		Output *= 5.0;
		Output = clamp(Output, vec3(0.0), vec3(1.0));
		float fcc = clamp(length(Output.xyz)*4.0, 0.0, 1.0);
		//if (length (Output.xyz)>0.001) 
		//if (length(gl_FragData[0].xyz)<0.001)
		float fint = 1.0 - length(gl_FragData[0].xyz);
		fint *= 2.0;
		fint = clamp(fint, 0.0, 1.0);




		vec2 UVvideo = UV;
		float redd = gl_FragData[0].x*10.0 + 15.0;
		//UVvideo=vec2 (ivec2(UVvideo*redd))/redd;
		//UVvideo.y*=0;
		//16.0/9.0;

		//Video*=Output;

		//Video=pow (Video,vec3 (4.0));
		//Video=vec3 (ivec3 (Video*13.0))/13.0;
		//Video*=0.2;
		//c=0.0;
		//gl_FragData[0].xyz+=(texture2D(VideoTexture, UVV).xxx*fcc-gl_FragData[0].xyz)*fint;

		//		gl_FragData[0].xyz*=clamp (pow (texture2D(VideoTexture, UVV).x*2.0,5.0),0.0,1.0);
		//gl_FragData[0].xyz*=clamp (pow (texture2D(VideoTexture, UVV).x*1.1,3.0),0.0,1.0);

		//gl_FragData[0].xyz+=Video;



		//Video.xyz= hsv2rgb(vec3 (Video.x*200.0,0.6,1.0*length (Video.xyz)));

		float fw = length(vec2(16.0 / 9.0, 1.0)*(UVV.xy - vec2(0.5)));
		//gl_FragData[0].xyz=sin (5.0*gl_FragData[0].xyz);
		//(vec3(1.0)-gl_FragData[0].xyz)*Output.x;
		//gl_FragData[0].xyz+=Output;
		
		
		if (ttime<20.0)
		gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 200 + Video.x * 0 + ttime * 150 + gl_FragData[0].z*10.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));
		else
			if (ttime<83.0)
		gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 200+ Video.x * 0 + ttime * 50 + gl_FragData[0].z*10.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));
			else
		
				if (ttime<97.0)
				gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 20- UVV.y*0+Video.y* 10 + ttime * 0 + gl_FragData[0].z*10.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));
				else
				gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 400- UVV.y*20+Video.y* 0 + ttime * 50 + gl_FragData[0].z*10.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));

		if (ttime<105)
				gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 200- UVV.y*20+Video.y* 0 + ttime * 50 + gl_FragData[0].y*100.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));

		if (ttime>105) if (ttime<109)
				gl_FragData[0].xyz = 1.0*hsv2rgb(vec3(fw * 1100- UVV.y*20+Video.y* 0 + ttime * 50 + gl_FragData[0].y*100.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));

		if (ttime>109)
				gl_FragData[0].xyz = 0.5*hsv2rgb(vec3(fw * 0+ UVV.y*0+Video.y* 0 + ttime * 50 + gl_FragData[0].y*100.0 + 0 + UVV.y*0.0, 0.8, 5.1*gl_FragData[0].x));

		if (ttime<20.0)
		gl_FragData[0].xyz *= 1.0 - ttime*0.1*Video*vec3(1.0, 1.0, 1.0);
		//gl_FragData[0].xyz=Video;	

	}


	if ((ttime>11.0) && (ttime<16.0))
	gl_FragData[0].xyz = 2.0*hsv2rgb(vec3( UVV.y*20+Video.y* 0 + ttime * 50 + gl_FragData[0].y*1000.0 + 0 + UVV.y*0.0, 0.8, 1.1*gl_FragData[0].x));

	else
	gl_FragData[0] += tex2D(Texture1, UVV.xy)*vec4(1.0, 0.0, 0.5, 1.0) + tex2D(Texture1, UVV.xy + vec2(0.002, 0.0))*vec4(0.0, 1.0, 0.5, 1.0);



	if (ttime < 20.0) {

		if (ttime>7.0)
		if (ttime<12.0)
		{
				gl_FragData[0].xyz *=1.0+100* tex2D(Credit1, vec2 (-1.0,-0.95)+3.0*vec2 (UVV2.x, 1.0-UV.y)*vec2 (1,0.9)).xyz*Video;
		}
		else
		{

if (ttime<16.0) { 		
			gl_FragData[0].xyz *= 1.0 + 10 * tex2D(Credit2, vec2(-1.0, -0.95) + 3.0*vec2(UVV2.x, 1.0 - UV.y)*vec2(1, 0.9)).xyz*Video;
			gl_FragData[0].xyz += 10.3*tex2D(Credit2, vec2 (-1.0,-0.95)+3.0*vec2 (UVV2.x, 1.0-UV.y)*vec2 (1,0.9)).xyz*Video;
}

		}
	}
	gl_FragData[0].xyz *= clamp(ttime, 0.0, 1.0);


	if (ttime<155)
	if (ttime>105)
	{
			float fw = length(vec2(16.0 / 9.0, 1.0)*(UVV.xy - vec2(0.5)));
			gl_FragData[0].xyz =  Output2*0.2 + Output*0.2;
			vec3 FC=tex2D(Texture1, UVV.xy).xyz*vec3(1.0, 0.0, 0.5) + tex2D(Texture1, UVV.xy + vec2(0.002, 0.0)).xyz*vec3(0.0, 1.0, 0.5);
			FC+=gl_FragData[0].xyz;
	gl_FragData[0].xyz = 0.5*hsv2rgb(vec3(ttime * 350 + fw*100+FC.y*50.0 + 0 + UVV.y*30.0, 0.8, 4.1*FC.x));
	}

	
	if (ttime>155)
	{
			float fw = length(vec2(16.0 / 9.0, 1.0)*(UVV.xy - vec2(0.5)));
			gl_FragData[0].xyz =  Output2*0.3 + Output*0.1;
			vec3 FC=tex2D(Texture1, UVV.xy).xyz*vec3(1.0, 0.0, 0.5) + tex2D(Texture1, UVV.xy + vec2(0.002, 0.0)).xyz*vec3(0.0, 1.0, 0.5);
			FC+=gl_FragData[0].xyz;
	gl_FragData[0].xyz = 0.5*hsv2rgb(vec3(ttime * 50 + fw*100+FC.y*150.0*clamp (ttime-155,0.0,1.0) + 0 + UVV.y*30.0, 0.8, 4.1*FC.x));
	}

	if (ttime>20.0)
	{
		gl_FragData[0].xyz *= clamp(ttime - 20.0, 0.0, 1.0);
			//gl_FragData[0].xyz *=1.0+5.0*Video;

	}
	if (ttime>83.0)
	{
		gl_FragData[0].xyz *= clamp((ttime - 83.0)*1.0, 0.0, 1.0);
			//gl_FragData[0].xyz *=1.0+5.0*Video;

	}
	if (ttime<97.0)
	{
		//gl_FragData[0].xyz *= 1.0-clamp((ttime - 95.0)*0.5, 0.0, 1.0);
			//gl_FragData[0].xyz *=1.0+5.0*Video;

	}

	if (ttime>=97)
		gl_FragData[0].xyz *= clamp((ttime - 97.0), 0.0, 1.0);

	//gl_FragData[0].xyz *= 1.0-clamp((ttime - 166.0)*0.5, 0.0, 1.0);
	//gl_FragData[0].xyz =vec3 (ivec3(gl_FragData[0].xyz *3.0))/3.0;

	if (ttime>14.0)
		if (ttime<21)
	gl_FragData[0].xyz *= 1.0 -2.3*pow (Video.x*1.2,100.0);


	if (ttime>51.0)
		if (ttime<54)
	gl_FragData[0].xyz *= 1.0 -2.3*pow (Video.x*1.2,100.0);
		
	
	if (ttime>83.0)
		if (ttime<86)
	gl_FragData[0].xyz *= 1.0 -1.3*pow (Video.x*1.1,100.0);

	if (ttime>54.0)
		if (ttime<83.0)
		{
			gl_FragData[0].xyz += (gl_FragData[0].xxx-gl_FragData[0].xyz )*0.0;
		//gl_FragData[0].y*=0.8;
		//gl_FragData[0].xz*=1.5;
		//gl_FragData[0].x;
			if (ttime>76.0)
				if (ttime<77.5)
			gl_FragData[0].xyz-=Output2*0.2;
			//gl_FragData[0].xyz=	gl_FragData[0].zxy;
		}

	


	gl_FragData[0].xyz *= 1.0*(randhash (seed,1.0)*1.5+0.4);
	//gl_FragData[0].xyz *= 1.0+25.0*beat;
	//*(randhash (seed,1.0)*1.5+0.4);
	
	//(gl_FragData[0].xxx-gl_FragData[0].xyz )*0.3;

	
	//1.0 -1.3*pow (Video.x*1.1,100.0);
	//_FragData[0].xyz *= 1.0 -2.3*pow (Video.x*1.2,100.0);

	//gl_FragData[0].xyz *=2.0;
	//*Video;
	//*vec4 (1.0,0.0,0.5,1.0)+tex2D(Texture1, UVV.xy+vec2 (0.002,0.0))*vec4 (0.0,1.0,0.5,1.0);



	//if (length ((16.0/9.0)*(UVV.x-(0.5)))<0.0+ttime*0.005) 		gl_FragData[0]*=0.0;
	//gl_FragData[0].xyz*=vec3 (1.0,0.0,0.0);
	if (ttime>45.0)
		if (ttime<81.0)
	gl_FragData[0].xyz*=1.0+beat*100.0;
	
	if (ttime<160.0)
	if (ttime>111.0)
	gl_FragData[0].xyz*=1.0+beat*100.0;
	


	// edge
	if (ttime>22.0)
		if (ttime<34)
	{

		float Output = 0.0;
		float tot = 0.0;
		for (int y = -3; y < 4; y++)
			for (int x = -3; x < 4; x++)
			{
				vec2 NUV = UVV + vec2(float(x), float(y))*0.00174*0.1;
				Output += pow(texture2D(TextureDepth, NUV).x, 5.0);
				tot += 1.0;
			}

		Output /= tot;

				float Output2 = pow(texture2D(TextureDepth, UV).x, 5.0);
				float Error=25.0*abs (Output2-Output);
				gl_FragData[0].xyz+=vec3 (Error)*vec3 (1.0,0.0,0.0);

	}




		if (ttime>36.9)
		if (ttime<44.0)
		{

			float fc=ttime-38.0;
fc=1.0-clamp (fc*0.5,0.0,1.0);

			gl_FragData[0].x= (fc)-gl_FragData[0].x;
		}
	


	if (ttime>36.9) { 

float fc=ttime-37.0;
fc=1.0-clamp (fc*1.5,0.0,1.0);
gl_FragData[0].xyz+=vec3 (fc);

	}

	//gl_FragData[0].xyz+=vec3 (0.0)+vec3 (11.0)*pow (cos(132.0/60.0*ttime*2*3.14159126535),8.0);
	//+Output;

	//gl_FragData[0].xyz=AccumC*1.0;

if (ttime<80.85)
	if (ttime>80.5) { 

		gl_FragData[0].xyz*=1.0-clamp ((ttime-80.5)*2.0,0.0,1.0);

	}




	//if (ttime>80.85) 
	if (ttime>81.2) 
	{ 

float fc=ttime-81.6;
fc=1.0-clamp (fc*1.0,0.0,1.0);
gl_FragData[0].xyz+=vec3 (fc);

	}






	if (ttime<99.0)
	if (ttime>81.0)
	{

		float Output = 0.0;
		float tot = 0.0;
		for (int y = -3; y < 4; y++)
			for (int x = -3; x < 4; x++)
			{
				vec2 NUV = UVV + vec2(float(x), float(y))*0.00174*0.1;
				Output += pow(texture2D(TextureDepth, NUV).x, 5.0);
				tot += 1.0;
			}

		Output /= tot;

				float Output2 = pow(texture2D(TextureDepth, UV).x, 5.0);
				float fcc=1.0-clamp (ttime-163.0,0.0,1.0);
				float Error=fcc*150.0*abs (Output2-Output);
				gl_FragData[0].xyz+=vec3 (Error)*vec3 (1.0,0.0,0.0);

	}




	if (ttime>110.6) { 

float fc=ttime-110.8;
fc=1.0-clamp (fc*1.0,0.0,1.0);
gl_FragData[0].xyz+=vec3 (fc);

	}


	if (ttime>140.0) { 

float fc=ttime-140.2;
fc=1.0-clamp (fc*1.0,0.0,1.0);
gl_FragData[0].xyz+=vec3 (fc);

	}



	if (ttime<20.0) { 


		if (UVV.y>0.9)			gl_FragData[0].xyz*=0.0;
		if (UVV.y<0.1)			gl_FragData[0].xyz*=0.0;



	}
	
	if (ttime<54.0)
	if (ttime>51.0) { 
		float fzz=1.0-clamp ((ttime-51.0)*2.0,0.0,1.0);


		if (UVV.y>0.9-0.4*fzz)			gl_FragData[0].xyz*=0.0;
		if (UVV.y<0.1+0.4*fzz)			gl_FragData[0].xyz*=0.0;



	}
	if (ttime<81.0)
	if (ttime>51.5) {

gl_FragData[0].xyz*=1.0+Video.xyz*beat2*20.0;
gl_FragData[0].xyz+=Video.xyz*beat*0.5;
	}


	if (ttime<170.0)
	if (ttime>140.5) {

gl_FragData[0].xyz*=1.0+Video.xyz*beat2*20.0;
gl_FragData[0].xyz+=Video.xyz*beat*0.5;
	}


	if (ttime>155.0) { 

float fc=ttime-155.0;
fc=1.0-clamp (fc*1.0,0.0,1.0);
gl_FragData[0].xyz+=vec3 (fc);

	}

		if (ttime>155.0)
		{

			gl_FragData[0].xyz= gl_FragData[0].xxx;
		}


		float fm=max (gl_FragData[0].x,max (gl_FragData[0].z,gl_FragData[0].y));

		if (ttime<22.0)
		gl_FragData[0].xyz+= (fm*vec3 (1.0)-gl_FragData[0].xyz)*0.7;
		else
		if (ttime<54.0)
		{
		
		
			gl_FragData[0].xyz+= (fm*vec3 (1.0)-gl_FragData[0].xyz)*1.0;
		
		
		
		
		}
		
		
		else
					if (ttime<81.5)
					{
			if (length (gl_FragData[0].xyz-vec3 (1.0,1.0,1.0))>0.7) 
						gl_FragData[0].xyz+= (gl_FragData[0].x*vec3 (1.0)-gl_FragData[0].xyz)*0.9;
					}

		else
		if (ttime<122.0)
		gl_FragData[0].xyz+= (gl_FragData[0].x*vec3 (1.0)-gl_FragData[0].xyz)*0.5;


//gl_FragData[0].xyz=Video.xyz;
//*beat2*20.0;
//gl_FragData[0].xyz+=Output.xyz*Video.x*beat*100.0;
//gl_FragData[0].xyz=Output2.xyz;

/*
	if (beat>0.3) 
		if (length (gl_FragData[0].xyz)>0.1) 
			gl_FragData[0].xyz=vec3 (1.0);
			*/
	//gl_FragData[0].x= (1.0)-gl_FragData[0].x;

	//colo=vec3 (0.5);
	//col*=0.0;

	//colo.xyz+=(vec3 (0.5)-colo.xyz)*clamp (ttime-5,0.0,1.0);
	//colo=vec3 (0.5);

	//gl_FragData[0].xyz+=vec3 (col*2.0);



	//gl_FragData[0].xyz*=clamp (vec3 (col)*31.0,vec3 (0.0), vec3 (1.0));







	//gl_FragData[0] = tex2D(Texture1, UVV.xy);
	//*vec4 (1.0,0.0,0.5,1.0)+tex2D(Texture1, UVV.xy+vec2 (0.0017,0.0))*vec4 (0.0,1.0,0.5,1.0);

	//gl_FragData[0]=texture2D (Texture1, UV.xy).xyzz;




	/*


	{
	vec3 Output = vec3(0.0);
	float tot = 0.0;

	vec3 minn=vec3(0.0);
	float minnv=0.0;
	for (int y = 0; y < 18; y++)
	for (int x = 0; x < 18; x++)
	{
	float theta=2*3.1415926535*float(x)/17.0f;
	vec2 NUV = UV + vec2(float(x), float(y))*0.00174*1.0;
	NUV=UV+0.005*vec2 (sin(theta), cos(theta))*float(y+1)/17.0f;

	float dst = 1.0 / (1.0 + 0.0*length(vec2(x, y)));
	//		if (length (vec2 (x,y))>12.0) continue;

	vec3 Ress=pow(texture2D(Texture1, NUV).xyz, vec3(1.0))*dst;

	if (length (Ress)>minnv) {
	minnv=length (Ress);
	minn=Ress;
	}

	Output += Ress;
	tot += dst;
	}

	Output /= tot;






	gl_FragData[0].xyz=Output;
	}

	*/











	//clamp (ttime*2.0,0.0,1.0);

	//clamp (ttime*2.0,0.0,1.0);

	//gl_FragData[0].xyz+=0.3*vec3 (map5 (vec3 (UVVn.xy*0.5*vec2(16.0/9.0,1.0),ttime*0.2)));


	/*
	float map5(in vec3 p)
	{
	vec3 q = p - vec3(0.0, 0.1, 0.0)*ttime;
	//q.y += sin(time + q.x*2.0)*cloudup;

	float f;
	f = 0.50000*noise(q); q = q*2.02;
	f += 0.25000*noise(q); q = q*2.03;
	f += 0.12500*noise(q); q = q*2.01;
	f += 0.06250*noise(q); q = q*2.02;
	f += 0.03125*noise(q);
	return clamp(1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0);
	}

	*/

	//_FragData[0].xyz=texture2D(Texture1, UV.xy).xyz;

	//vec3 (col*2.0);

	/*

	{

	vec3 Output3 = vec3(0.0);
	float tot = 0.0;

	int coun=0;
	float dist=0.0;

	vec3 Mid=vec3(0.0);
	//texture2D(Texture1, UV).xyz;
	for (int y = -13; y <14; y++)
	for (int x = -13; x < 14; x++)
	{



	//vec2 NUV = UV + vec2(float(x), float(y))*0.00174*0.15;

	vec2 Add= Rot(vec2(float(x), float(y))*vec2 (9.0/16.0)*0.00174*1.25, x*5+y*5, vec2(0,0));
	vec2 NUV=UV+Add;
	vec3 V=texture2D(Texture1, NUV).xyz;
	if (length (V)>dist) {

	dist=length (V);
	gl_FragData[0].xyz=V;
	}
	coun++;
	Mid+=texture2D(Texture1, NUV).xyz;
	}
	Mid/=49.0;

	vec3 Po=gl_FragData[0].xyz;
	if (length (Po)<1.399) {
	Po*=0.0;
	}
	else
	Output.xyz*=0.0;

	gl_FragData[0].xyz=Output.xyz*1.0+Po;

	//if (UV.x>0.5)gl_FragData[0].xyz=Mid;


	//gl_FragData[0].xyz=V[5];
	}
	*/






	/*

{

float vig=length (UV-vec2 (0.5));
vig*=vig;
// tilt shift
vec4 col=vec4 (0.0);
float tot=0;
for (int rx = -4; rx < 4; rx++)
for (int ry = -4; ry < 4; ry++)
{

vec2 ScreenDiff=vec2 (rx,ry)*0.0045*vig;
col+=texture2D(Texture1, UV.xy + ScreenDiff.xy).xyzw;
tot+=1.0;


}
col/=tot;
gl_FragData[0].xyz*=1.0-3.0*vig;

}

*/





	//gl_FragData[0].xyz=vec3 (1.0,0.0,0.0);





	//gl_FragData[0].xyz+=1.0*Output.xyz/tot;








	//gl_FragData[0]=tex2D (Texture1, UV.xy);
	//gl_FragData[0]=vec4 (0.0,0,0,0)+tex2D (Texture1, UV.xy);


	//gl_FragData[0]=vec4 (1.0)*pow(tex2D (Texture1, UV.xy).x,40.0);
	//gl_FragData[0]=vec4 (bl);
	//gl_FragData[0].xyz=fres;


}

















/*

#version 110
#define float4 vec4
#define float3 vec3
#define float2 vec2

#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D
varying vec2 UV;

varying vec4 Color;
uniform sampler2D Texture1;
uniform sampler2D Texture2;
uniform sampler2D Texture3;
uniform sampler2D TextureDepth;


#define SSAO se= ep+ddd*sign (dot (ray,norm))*ray;sea= ep+10.0*ddd*sign (dot (ray,norm))*ray;GIColor+=tex2D (TextureDepth,sea.xy); NormJump=tex2D (Texture1,sea.xy)*2.0-vec4 (1.0);  fnn=0.24+clamp(-(dot (NormJump.xyz,norm.xyz)),0.0,1.0); GIfactor+=fnn; occluderFragment = tex2D(Texture1,se.xy);shadow=occluderFragment.w;occluderFragment.a=tex2D (Texture2,se.xy).x;occNorm = (occluderFragment.xyz*2.0)-vec3 (1.0);depthDifference = 40.0*(depth-occluderFragment.a);normDiff = 1.0-1.0*dot(occNorm,norm); addition=step(0.00002,depthDifference)*normDiff*(1.0-smoothstep(0.0002,0.20,depthDifference)); bl += addition;




vec3 Smooth (vec2 UV0) {

float depth=texture2D (TextureDepth, UV0).x;
float tot=0.0;



for (int y=-8;y<9;y++)
for (int x=-8;x<9;x++)
{
vec2 NUV=UV0+vec2 (float(x), float(y))*0.00104;
float dst=1.0/(1.0+0.5*length (vec2 (x,y)));
depth+=texture2D (TextureDepth, NUV).x*dst;
tot+=dst;

}
depth/=tot;




//depth=texture2D (TextureDepth, UV0).x;

tot=0.0;
depth=1.0-pow (1.95-depth,40.6);


depth=clamp (depth,0.0,1.0);
depth=sin(depth*3.14159);
//depth-1-depth;
vec3 Output=vec3 (0.0);

for (int y=-8;y<9;y++)
for (int x=-8;x<9;x++)
{
vec2 NUV=UV0+vec2 (float(x), float(y))*0.00104*depth;
float dst=1.0/(1.0+0.5*length (vec2 (x,y)));

Output+=texture2D (Texture1, NUV).xyz*dst;
tot+=dst;

}

Output/=tot;
//Output=vec3 (depth);
return Output;
//* (1.0-depth);


};



vec3 Smooth2 (vec2 UV0) {

//depth-1-depth;
vec3 Output=vec3 (0.0);
float tot=0.0;
for (int y=-8;y<9;y++)
for (int x=-8;x<9;x++)
{
vec2 NUV=UV0+vec2 (float(x), float(y))*0.00174*0.3;
float dst=1.0/(1.0+0.5*length (vec2 (x,y)));
Output+=texture2D (Texture1, NUV).xyz*dst;
tot+=dst;

}

Output/=tot;
//Output*=Output;
//Output=vec3 (depth);
return Output;
//* (1.0-depth);


};




void main (void)
{


//		float depth = texture2D(texture2d_depth, UV.xy).x;
gl_FragData[0].xyz = vec3(1.0,1.0,1.0);
vec2 NewUV=UV;
//NewUV.x=float(int (NewUV.x*200.0))/200.0;
//NewUV.y=float(int (NewUV.y*200.0))/200.0;

gl_FragData[0].xyz=texture2D (Texture2, NewUV.xy).xyz;
float depth=texture2D (TextureDepth, NewUV.xy).x;
depth=pow (depth,10.0);
gl_FragData[0].xyz=vec3 (depth);


gl_FragData[0].xyz=texture2D (Texture1 , NewUV.xy).xyz+vec3 (1.0,0.0,0.0);



//+vec3 (0,0.2,0);

//gl_FragData[0].xyz=Smooth (UV)*100.0;

gl_FragData[0].xyz=1.0*texture2D (Texture2, UV.xy).xyz;
gl_FragData[0].xyz=vec3 (1.0)*pow (texture2D (TextureDepth, UV.xy).x,14.0);
//		gl_FragData[0].xyz=1.0*Smooth2 (UV.xy);

gl_FragData[0].w=1.0;

}




*/









