

#version 330 core
#define tex2D texture2D
layout(location = 0) in vec3 vertexPosition_modelspace;
//layout(location = 1) in vec4 vertexColor;
layout(location = 2) in vec3 vertexUV;
layout(location = 3) in vec3 vertexNormals;


uniform mat4 MV;
uniform mat4 MP;
uniform mat4 LightMVP;
uniform mat4 LightMVP2;

uniform mat4 Local;
varying vec3 Normal;
varying vec3 NormalCamera;
uniform float PosY;
uniform float ttime; 

varying vec4 Color;
uniform float SplatSize;
varying float fog;

varying vec4 ShadowPosZ;
varying vec4 ShadowPosZ2;
uniform float Material;
varying vec2 ReflectionUV;
varying float AOfactor;
uniform float object;
uniform float Refl;
varying vec4 ThePos;

vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};



void main()
{
	int iobject=int(object);
	int iMaterial=int (Material);
	




	
	AOfactor=vertexUV.z;
	vec4 glVertex = vertexPosition_modelspace.xyzz;;
	glVertex.w = 1.0;

	float reduce=200+190*sin(ttime+glVertex.y*1000.0);

	reduce=150;

	//glVertex.xyz=vec3 (ivec3 (glVertex.xyz*reduce))/reduce;
	vec3 CubePos=vec3 (ivec3 (glVertex.xyz*reduce))/reduce;
	float fcc=500+500*sin(ttime+glVertex.y*10.0);
	float Dist=fcc*length (CubePos-glVertex.xyz);


	//Vertex.y=CubePos.y;
	//CubePos;


	ShadowPosZ = LightMVP*(glVertex*Local);
	glVertex*=0.5;
	
	glVertex=glVertex*Local;
	glVertex.w=1.0;
	
	if (iobject==0)
	{ 
		 //glVertex.xz=Rot(glVertex.xz, -150,vec2 (-2.0));
	glVertex.z+=5.0-ttime*1.1;
	glVertex.x+=7.0;
	glVertex.y-=2.0;
	}
	if (iobject==1)
	{
		 glVertex.xz=Rot(glVertex.xz, 0.8,vec2 (-2.0));
		glVertex.z+=15.0-ttime*1.1;
	glVertex.x+=9.0;
	glVertex.y-=8.0;

	if (ttime>=13)
		glVertex.z+=10.0;
	}

	if (iobject==2)
	{
	
		
		 glVertex.xz=Rot(glVertex.xz, -0.5,vec2 (-2.0));
		
		glVertex.z+=13.0-ttime*1.1;
	glVertex.x+=4.0;
	
	if (ttime>=13)
glVertex.z+=5.0;
	
	glVertex.y-=10.5-ttime*0.15;
	}

	if (Refl>0.5)
	{
	glVertex.y+=0.5;
		glVertex.y*=-1;
	glVertex.y-=0.5;

	}

	gl_Position = MV *  (glVertex);
	Color = vec4 (1.0);

	ThePos = glVertex;


	fog = clamp(1.0*pow(2.0 / gl_Position.w, 2.0), 0.0, 1.0);

	// normals
	// normals
	// normals

	Normal=vertexNormals.xyz;
	NormalCamera=Normal*mat3 (transpose(MV));

	// normals
	// normals
	// normals


	Color=vec4 (1.0)*fog;

	






	/// reflection
	/// reflection
	/// reflection


	vec3 CamVector=vec3 (0,0,1);
	vec3 NormalVector=NormalCamera.xyz;
	vec3 Refl=reflect (-CamVector, NormalVector);
	Refl=normalize(Refl)*0.5+vec3 (0.5);
	ReflectionUV=Refl.xy;


	/// reflection
	/// reflection
	/// reflection



}











