/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBES2Compatibility {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;

    protected ARBES2Compatibility() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glReleaseShaderCompiler, caps.glShaderBinary, caps.glGetShaderPrecisionFormat, caps.glDepthRangef, caps.glClearDepthf);
    }

    public static native void glReleaseShaderCompiler();

    public static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6);

    public static void glShaderBinary(@NativeType(value="const GLuint *") IntBuffer shaders, @NativeType(value="GLenum") int binaryformat, @NativeType(value="const void *") ByteBuffer binary) {
        ARBES2Compatibility.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4);

    public static void glGetShaderPrecisionFormat(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int precisiontype, @NativeType(value="GLint *") IntBuffer range, @NativeType(value="GLint *") IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)range, 2);
            Checks.check((Buffer)precision, 1);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetShaderPrecisionFormat(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int precisiontype, @NativeType(value="GLint *") IntBuffer range) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)range, 2);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer precision = stack.callocInt(1);
            ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
            int n = precision.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void glDepthRangef(@NativeType(value="GLfloat") float var0, @NativeType(value="GLfloat") float var1);

    public static native void glClearDepthf(@NativeType(value="GLfloat") float var0);

    public static void glShaderBinary(@NativeType(value="const GLuint *") int[] shaders, @NativeType(value="GLenum") int binaryformat, @NativeType(value="const void *") ByteBuffer binary) {
        long __functionAddress = GL.getICD().glShaderBinary;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shaders.length, shaders, binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glGetShaderPrecisionFormat(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int precisiontype, @NativeType(value="GLint *") int[] range, @NativeType(value="GLint *") int[] precision) {
        long __functionAddress = GL.getICD().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(range, 2);
            Checks.check(precision, 1);
        }
        JNI.callPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    static {
        GL.initialize();
    }
}

