/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;

final class SharedLibraryLoader {
    private static Path extractPath;

    private SharedLibraryLoader() {
    }

    static FileChannel load(String name, String libName, URL libURL) {
        try {
            Path extractedFile = SharedLibraryLoader.extractFile(libName, libURL);
            try {
                FileChannel fc = FileChannel.open(extractedFile, new OpenOption[0]);
                if (fc.tryLock(0L, Long.MAX_VALUE, true) == null) {
                    if (Configuration.DEBUG_LOADER.get(false).booleanValue()) {
                        APIUtil.apiLog("\tFile is locked by another process, waiting...");
                    }
                    fc.lock(0L, Long.MAX_VALUE, true);
                }
                return fc;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to lock the extracted file.", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\tFailed to extract " + name + " library", e);
        }
    }

    private static Path extractFile(String libraryFile, URL libURL) throws IOException {
        Path extractedFile = SharedLibraryLoader.getExtractedFile(extractPath, libraryFile);
        if (extractPath == null) {
            extractPath = extractedFile.getParent();
            String libPath = Configuration.LIBRARY_PATH.get();
            libPath = libPath == null || libPath.isEmpty() ? extractPath.toAbsolutePath().toString() : extractPath.toAbsolutePath() + File.pathSeparator + libPath;
            System.setProperty(Configuration.LIBRARY_PATH.getProperty(), libPath);
            Configuration.LIBRARY_PATH.set(libPath);
        }
        SharedLibraryLoader.extractFile(libURL, extractedFile);
        return extractedFile;
    }

    private static Path getExtractedFile(Path libraryPath, String fileName) {
        if (libraryPath != null && Files.isDirectory(libraryPath, new LinkOption[0])) {
            return libraryPath.resolve(fileName);
        }
        if (Configuration.SHARED_LIBRARY_EXTRACT_PATH.get() != null) {
            return Paths.get(Configuration.SHARED_LIBRARY_EXTRACT_PATH.get(), fileName);
        }
        String version = Version.getVersion().replace(' ', '-');
        String tempDirectory = Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl" + System.getProperty("user.name"));
        Path file = Paths.get(System.getProperty("java.io.tmpdir") + "/" + tempDirectory + "/" + version, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        tempDirectory = Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl");
        file = Paths.get(System.getProperty("user.home") + "/." + tempDirectory + "/" + version, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        file = Paths.get("." + tempDirectory + "/" + version, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        try {
            file = Files.createTempFile("lwjgl", "", new FileAttribute[0]);
            Files.delete(file);
            file = file.resolve(fileName);
            if (SharedLibraryLoader.canWrite(file)) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Failed to find an appropriate directory to extract the native library");
    }

    private static void extractFile(URL libURL, Path extractedFile) throws IOException {
        Throwable throwable;
        InputStream input;
        if (Files.exists(extractedFile, new LinkOption[0])) {
            input = libURL.openStream();
            throwable = null;
            try (InputStream target = Files.newInputStream(extractedFile, new OpenOption[0]);){
                if (SharedLibraryLoader.crc(input) == SharedLibraryLoader.crc(target)) {
                    APIUtil.apiLog(String.format("\tFound at: %s", extractedFile));
                    return;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (input != null) {
                    SharedLibraryLoader.$closeResource(throwable, input);
                }
            }
        }
        APIUtil.apiLog(String.format("\tExtracting: %s", libURL.getPath()));
        Files.createDirectories(extractedFile.getParent(), new FileAttribute[0]);
        input = libURL.openStream();
        throwable = null;
        try {
            Files.copy(input, extractedFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (input != null) {
                SharedLibraryLoader.$closeResource(throwable, input);
            }
        }
    }

    private static long crc(InputStream input) throws IOException {
        int n;
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        while ((n = input.read(buffer)) != -1) {
            crc.update(buffer, 0, n);
        }
        return crc.getValue();
    }

    private static boolean canWrite(Path file) {
        Path testFile;
        Path parent = file.getParent();
        if (Files.exists(file, new LinkOption[0])) {
            if (!Files.isWritable(file)) {
                return false;
            }
            testFile = parent.resolve(".lwjgl.test");
        } else {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException ignored) {
                return false;
            }
            testFile = file;
        }
        try {
            Files.write(testFile, new byte[0], new OpenOption[0]);
            Files.delete(testFile);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

