/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.dyncall;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class DynLoad {
    protected DynLoad() {
        throw new UnsupportedOperationException();
    }

    public static native long ndlLoadLibrary(long var0);

    @NativeType(value="DLLib *")
    public static long dlLoadLibrary(@NativeType(value="const char *") ByteBuffer libpath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(libpath);
        }
        return DynLoad.ndlLoadLibrary(MemoryUtil.memAddress(libpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DLLib *")
    public static long dlLoadLibrary(@NativeType(value="const char *") CharSequence libpath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer libpathEncoded = stack.ASCII(libpath);
            long l = DynLoad.ndlLoadLibrary(MemoryUtil.memAddress(libpathEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndlFreeLibrary(long var0);

    public static void dlFreeLibrary(@NativeType(value="DLLib *") long pLib) {
        if (Checks.CHECKS) {
            Checks.check(pLib);
        }
        DynLoad.ndlFreeLibrary(pLib);
    }

    public static native long ndlFindSymbol(long var0, long var2);

    @NativeType(value="void *")
    public static long dlFindSymbol(@NativeType(value="DLLib *") long pLib, @NativeType(value="const char *") ByteBuffer pSymbolName) {
        if (Checks.CHECKS) {
            Checks.check(pLib);
            Checks.checkNT1(pSymbolName);
        }
        return DynLoad.ndlFindSymbol(pLib, MemoryUtil.memAddress(pSymbolName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long dlFindSymbol(@NativeType(value="DLLib *") long pLib, @NativeType(value="const char *") CharSequence pSymbolName) {
        if (Checks.CHECKS) {
            Checks.check(pLib);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pSymbolNameEncoded = stack.ASCII(pSymbolName);
            long l = DynLoad.ndlFindSymbol(pLib, MemoryUtil.memAddress(pSymbolNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ndlSymsInit(long var0);

    @NativeType(value="DLSyms *")
    public static long dlSymsInit(@NativeType(value="const char *") ByteBuffer libPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1(libPath);
        }
        return DynLoad.ndlSymsInit(MemoryUtil.memAddress(libPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="DLSyms *")
    public static long dlSymsInit(@NativeType(value="const char *") CharSequence libPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer libPathEncoded = stack.ASCII(libPath);
            long l = DynLoad.ndlSymsInit(MemoryUtil.memAddress(libPathEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void ndlSymsCleanup(long var0);

    public static void dlSymsCleanup(@NativeType(value="DLSyms *") long pSyms) {
        if (Checks.CHECKS) {
            Checks.check(pSyms);
        }
        DynLoad.ndlSymsCleanup(pSyms);
    }

    public static native int ndlSymsCount(long var0);

    public static int dlSymsCount(@NativeType(value="DLSyms *") long pSyms) {
        if (Checks.CHECKS) {
            Checks.check(pSyms);
        }
        return DynLoad.ndlSymsCount(pSyms);
    }

    public static native long ndlSymsName(long var0, int var2);

    @NativeType(value="const char *")
    public static String dlSymsName(@NativeType(value="DLSyms *") long pSyms, @NativeType(value="int") int index) {
        if (Checks.CHECKS) {
            Checks.check(pSyms);
        }
        long __result = DynLoad.ndlSymsName(pSyms, index);
        return MemoryUtil.memASCII(__result);
    }

    public static native long ndlSymsNameFromValue(long var0, long var2);

    @NativeType(value="const char *")
    public static String dlSymsNameFromValue(@NativeType(value="DLSyms *") long pSyms, @NativeType(value="void *") long value) {
        if (Checks.CHECKS) {
            Checks.check(pSyms);
            Checks.check(value);
        }
        long __result = DynLoad.ndlSymsNameFromValue(pSyms, value);
        return MemoryUtil.memASCII(__result);
    }

    static {
        Library.initialize();
    }
}

