/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.Linearity;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020#J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006'"}, d2={"Lorg/openrndr/color/ColorHSVa;", "", "h", "", "s", "v", "a", "(DDDD)V", "getA", "()D", "getH", "getS", "unit", "getUnit", "()Lorg/openrndr/color/ColorHSVa;", "getV", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "scaleHue", "shift", "scaleSaturation", "scale", "scaleValue", "shiftHue", "shiftSaturation", "shiftValue", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "Companion", "openrndr-color"})
public final class ColorHSVa {
    private final double h;
    private final double s;
    private final double v;
    private final double a;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorHSVa scaleHue(double shift) {
        return ColorHSVa.copy$default(this, this.h + shift, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorHSVa shiftHue(double shift) {
        return ColorHSVa.copy$default(this, this.h + shift, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorHSVa scaleSaturation(double scale) {
        return ColorHSVa.copy$default(this, 0.0, this.s * scale, 0.0, 0.0, 13, null);
    }

    @NotNull
    public final ColorHSVa shiftSaturation(double shift) {
        return ColorHSVa.copy$default(this, 0.0, this.s + shift, 0.0, 0.0, 13, null);
    }

    @NotNull
    public final ColorHSVa shiftValue(double shift) {
        return ColorHSVa.copy$default(this, 0.0, 0.0, this.v + shift, 0.0, 11, null);
    }

    @NotNull
    public final ColorHSVa scaleValue(double scale) {
        return ColorHSVa.copy$default(this, 0.0, 0.0, this.v * scale, 0.0, 11, null);
    }

    @NotNull
    public final ColorHSVa getUnit() {
        return ColorHSVa.copy$default(this, (this.h % (double)360 + (double)360) % (double)360, 0.0, 0.0, 0.0, 14, null);
    }

    @NotNull
    public final ColorRGBa toRGBa() {
        double p = 0.0;
        double q = 0.0;
        double t = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        ColorHSVa hsv = this;
        double sh = hsv.h / (double)60;
        int i = (int)Math.floor(sh);
        double f = sh - (double)i;
        p = hsv.v * (1.0 - hsv.s);
        q = hsv.v * (1.0 - hsv.s * f);
        t = hsv.v * (1.0 - hsv.s * (1.0 - f));
        switch (i) {
            case 0: {
                r = hsv.v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = hsv.v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = hsv.v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = hsv.v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = hsv.v;
                break;
            }
            default: {
                r = hsv.v;
                g = p;
                b = q;
            }
        }
        String string = "" + r + ' ' + g + ' ' + b;
        System.out.println((Object)string);
        return new ColorRGBa(r, g, b, hsv.a, Linearity.SRGB);
    }

    public final double getH() {
        return this.h;
    }

    public final double getS() {
        return this.s;
    }

    public final double getV() {
        return this.v;
    }

    public final double getA() {
        return this.a;
    }

    public ColorHSVa(double h, double s, double v, double a) {
        this.h = h;
        this.s = s;
        this.v = v;
        this.a = a;
    }

    public /* synthetic */ ColorHSVa(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        this(d, d2, d3, d4);
    }

    public final double component1() {
        return this.h;
    }

    public final double component2() {
        return this.s;
    }

    public final double component3() {
        return this.v;
    }

    public final double component4() {
        return this.a;
    }

    @NotNull
    public final ColorHSVa copy(double h, double s, double v, double a) {
        return new ColorHSVa(h, s, v, a);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorHSVa copy$default(ColorHSVa colorHSVa, double d, double d2, double d3, double d4, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorHSVa.h;
        }
        if ((n & 2) != 0) {
            d2 = colorHSVa.s;
        }
        if ((n & 4) != 0) {
            d3 = colorHSVa.v;
        }
        if ((n & 8) != 0) {
            d4 = colorHSVa.a;
        }
        return colorHSVa.copy(d, d2, d3, d4);
    }

    public String toString() {
        return "ColorHSVa(h=" + this.h + ", s=" + this.s + ", v=" + this.v + ", a=" + this.a + ")";
    }

    public int hashCode() {
        return ((Double.hashCode(this.h) * 31 + Double.hashCode(this.s)) * 31 + Double.hashCode(this.v)) * 31 + Double.hashCode(this.a);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorHSVa)) break block3;
                ColorHSVa colorHSVa = (ColorHSVa)object;
                if (Double.compare(this.h, colorHSVa.h) != 0 || Double.compare(this.s, colorHSVa.s) != 0 || Double.compare(this.v, colorHSVa.v) != 0 || Double.compare(this.a, colorHSVa.a) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/color/ColorHSVa$Companion;", "", "()V", "fromRGBa", "Lorg/openrndr/color/ColorHSVa;", "rgb", "Lorg/openrndr/color/ColorRGBa;", "openrndr-color"})
    public static final class Companion {
        @NotNull
        public final ColorHSVa fromRGBa(@NotNull ColorRGBa rgb) {
            Intrinsics.checkParameterIsNotNull(rgb, "rgb");
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            ColorRGBa.Component maxArg = null;
            if (rgb.getR() <= rgb.getB() && rgb.getR() <= rgb.getG()) {
                min = rgb.getR();
            }
            if (rgb.getG() <= rgb.getB() && rgb.getG() <= rgb.getR()) {
                min = rgb.getG();
            }
            if (rgb.getB() <= rgb.getR() && rgb.getB() <= rgb.getG()) {
                min = rgb.getB();
            }
            if (rgb.getR() >= rgb.getB() && rgb.getR() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.R;
                max = rgb.getR();
            }
            if (rgb.getG() >= rgb.getB() && rgb.getG() >= rgb.getR()) {
                maxArg = ColorRGBa.Component.G;
                max = rgb.getG();
            }
            if (rgb.getB() >= rgb.getR() && rgb.getB() >= rgb.getG()) {
                maxArg = ColorRGBa.Component.B;
                max = rgb.getB();
            }
            double s = 0.0;
            double v = max;
            double delta = max - min;
            if (max == 0.0) {
                s = 0.0;
                double h = 0.0;
                return new ColorHSVa(h, s, v, rgb.getA());
            }
            s = delta / max;
            double h = Intrinsics.areEqual((Object)maxArg, (Object)ColorRGBa.Component.R) ? (rgb.getG() - rgb.getB()) / delta : (Intrinsics.areEqual((Object)maxArg, (Object)ColorRGBa.Component.G) ? (double)2 + (rgb.getB() - rgb.getR()) / delta : (double)4 + (rgb.getR() - rgb.getG()) / delta);
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
            String string = "rgb-> hsv " + h + ' ' + s + ' ' + v;
            System.out.println((Object)string);
            return new ColorHSVa(h, s, v, rgb.getA());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

