/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.FilterKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J!\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0015R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/draw/Filter;", "", "shader", "Lorg/openrndr/draw/Shader;", "(Lorg/openrndr/draw/Shader;)V", "parameters", "", "", "getParameters", "()Ljava/util/Map;", "getShader", "()Lorg/openrndr/draw/Shader;", "apply", "", "source", "", "Lorg/openrndr/draw/ColorBuffer;", "target", "([Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "([Lorg/openrndr/draw/ColorBuffer;Lorg/openrndr/draw/ColorBuffer;)V", "(Lorg/openrndr/draw/ColorBuffer;[Lorg/openrndr/draw/ColorBuffer;)V", "Lorg/openrndr/draw/RenderTarget;", "Companion", "openrndr-core"})
public class Filter {
    @NotNull
    private final Map<String, Object> parameters;
    @NotNull
    private final Shader shader;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> getParameters() {
        return this.parameters;
    }

    public final void apply(@NotNull RenderTarget source, @NotNull RenderTarget target) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Collection collection = source.getColorBuffers();
        Filter filter = this;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = v0;
        ColorBuffer[] colorBufferArray = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColorBuffer[] colorBufferArray2 = colorBufferArray;
        Collection collection2 = $receiver$iv = (Collection)target.getColorBuffers();
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv = collection2;
        ColorBuffer[] colorBufferArray3 = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColorBuffer[] colorBufferArray4 = colorBufferArray3;
        filter.apply(colorBufferArray2, colorBufferArray4);
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer[] target) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        RenderTarget renderTarget = RenderTarget.Companion.create(target[0].getWidth(), target[0].getHeight());
        for (Object element$iv : (Object[])target) {
            ColorBuffer it = (ColorBuffer)element$iv;
            renderTarget.attach(it);
        }
        renderTarget.bind();
        if (FilterKt.access$getFilterQuad$p() == null) {
            Object object = new VertexFormat();
            VertexBuffer.Companion companion = VertexBuffer.Companion;
            Object $receiver = object;
            ((VertexFormat)$receiver).position(2);
            ((VertexFormat)$receiver).textureCoordinate(2);
            VertexFormat vertexFormat = object;
            VertexBuffer fq = companion.createDynamic(vertexFormat, 6);
            $receiver = object = fq.getShadow().writer();
            $receiver.write(new Vector2(0.0, 1.0));
            $receiver.write(new Vector2(0.0, 0.0));
            $receiver.write(new Vector2(0.0, 0.0));
            $receiver.write(new Vector2(0.0, 1.0));
            $receiver.write(new Vector2(1.0, 0.0));
            $receiver.write(new Vector2(1.0, 1.0));
            $receiver.write(new Vector2(0.0, 1.0));
            $receiver.write(new Vector2(0.0, 0.0));
            $receiver.write(new Vector2(1.0, 1.0));
            $receiver.write(new Vector2(1.0, 0.0));
            $receiver.write(new Vector2(1.0, 0.0));
            $receiver.write(new Vector2(1.0, 1.0));
            VertexBufferShadow.DefaultImpls.upload$default(fq.getShadow(), 0, 0, 3, null);
            fq.getShadow().destroy();
            FilterKt.access$setFilterQuad$p(fq);
        }
        this.shader.begin();
        Object $receiver$iv = source;
        int index$iv = 0;
        int n = ((Object[])$receiver$iv).length;
        for (int $i$a$2$apply = 0; $i$a$2$apply < n; ++$i$a$2$apply) {
            void colorBuffer;
            Object item$iv = $receiver$iv[$i$a$2$apply];
            int n2 = index$iv++;
            ColorBuffer $i$a$1$forEach = (ColorBuffer)item$iv;
            int index = n2;
            colorBuffer.bind(index);
            this.shader.uniform("tex" + index, index);
        }
        Driver.Companion.getInstance().setState(FilterKt.access$getFilterDrawStyle$p());
        this.shader.uniform("projectionMatrix", TransformsKt.ortho(0.0, target[0].getWidth(), target[0].getHeight(), 0.0, -1.0, 1.0));
        this.shader.uniform("targetSize", new Vector2(target[0].getWidth(), target[0].getHeight()));
        Object object = $receiver$iv = this.parameters;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $uniform_value;
            Map.Entry entry = $uniform_value = (element$iv = iterator2.next());
            String uniform2 = (String)entry.getKey();
            entry = $uniform_value;
            Object value = entry.getValue();
            if ((entry = value) instanceof Float) {
                this.shader.uniform(uniform2, ((Number)value).floatValue());
                continue;
            }
            if (entry instanceof Double) {
                this.shader.uniform(uniform2, (float)((Number)value).doubleValue());
                continue;
            }
            if (entry instanceof Matrix44) {
                this.shader.uniform(uniform2, (Matrix44)value);
                continue;
            }
            if (entry instanceof Vector2) {
                this.shader.uniform(uniform2, (Vector2)value);
                continue;
            }
            if (entry instanceof Vector3) {
                this.shader.uniform(uniform2, (Vector3)value);
                continue;
            }
            if (entry instanceof Vector4) {
                this.shader.uniform(uniform2, (Vector4)value);
                continue;
            }
            if (entry instanceof ColorRGBa) {
                this.shader.uniform(uniform2, (ColorRGBa)value);
                continue;
            }
            if (entry instanceof Integer) {
                this.shader.uniform(uniform2, ((Number)value).intValue());
                continue;
            }
            if (!(entry instanceof Object[]) || ((Object[])value).length <= 0) continue;
            Object object2 = ((Object[])value)[0];
            if (object2 instanceof Vector2) {
                Object v = value;
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector2>");
                }
                this.shader.uniform(uniform2, (Vector2[])v);
                continue;
            }
            if (object2 instanceof Vector3) {
                Object v = value;
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector3>");
                }
                this.shader.uniform(uniform2, (Vector3[])v);
                continue;
            }
            if (!(object2 instanceof Vector4)) continue;
            Object v = value;
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.openrndr.math.Vector4>");
            }
            this.shader.uniform(uniform2, (Vector4[])v);
        }
        Driver driver = Driver.Companion.getInstance();
        VertexBuffer vertexBuffer = FilterKt.access$getFilterQuad$p();
        if (vertexBuffer == null) {
            Intrinsics.throwNpe();
        }
        driver.drawVertexBuffer(this.shader, CollectionsKt.listOf(vertexBuffer), DrawPrimitive.TRIANGLES, 0, 6);
        this.shader.end();
        renderTarget.unbind();
        renderTarget.detachColorBuffers();
        renderTarget.destroy();
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer target) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.apply(new ColorBuffer[]{source}, new ColorBuffer[]{target});
    }

    public final void apply(@NotNull ColorBuffer source, @NotNull ColorBuffer[] target) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.apply(new ColorBuffer[]{source}, target);
    }

    public final void apply(@NotNull ColorBuffer[] source, @NotNull ColorBuffer target) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        Intrinsics.checkParameterIsNotNull(target, "target");
        this.apply(source, new ColorBuffer[]{target});
    }

    @NotNull
    public final Shader getShader() {
        return this.shader;
    }

    public Filter(@NotNull Shader shader2) {
        Map map;
        Intrinsics.checkParameterIsNotNull(shader2, "shader");
        this.shader = shader2;
        Filter filter = this;
        filter.parameters = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/draw/Filter$Companion;", "", "()V", "filterVertexCode", "", "getFilterVertexCode", "()Ljava/lang/String;", "openrndr-core"})
    public static final class Companion {
        @NotNull
        public final String getFilterVertexCode() {
            return Driver.Companion.getInstance().internalShaderResource("filter.vert");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

