/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBImage;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.internal.gl3.ColorBufferGL3Kt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "", "width", "", "height", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "data", "Ljava/nio/ByteBuffer;", "(IILorg/openrndr/draw/ColorFormat;Lorg/openrndr/draw/ColorType;Ljava/nio/ByteBuffer;)V", "getData", "()Ljava/nio/ByteBuffer;", "getFormat", "()Lorg/openrndr/draw/ColorFormat;", "getHeight", "()I", "getType", "()Lorg/openrndr/draw/ColorType;", "getWidth", "Companion", "openrndr-gl3"})
public final class ColorBufferDataGL3 {
    private final int width;
    private final int height;
    @NotNull
    private final ColorFormat format;
    @NotNull
    private final ColorType type;
    @NotNull
    private final ByteBuffer data;
    public static final Companion Companion = new Companion(null);

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final ColorFormat getFormat() {
        return this.format;
    }

    @NotNull
    public final ColorType getType() {
        return this.type;
    }

    @NotNull
    public final ByteBuffer getData() {
        return this.data;
    }

    public ColorBufferDataGL3(int width, int height, @NotNull ColorFormat format, @NotNull ColorType type, @NotNull ByteBuffer data) {
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        Intrinsics.checkParameterIsNotNull(data, "data");
        this.width = width;
        this.height = height;
        this.format = format;
        this.type = type;
        this.data = data;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/internal/gl3/ColorBufferDataGL3$Companion;", "", "()V", "fromUrl", "Lorg/openrndr/internal/gl3/ColorBufferDataGL3;", "urlString", "", "openrndr-gl3"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final ColorBufferDataGL3 fromUrl(@NotNull String urlString) {
            Intrinsics.checkParameterIsNotNull(urlString, "urlString");
            URL url = new URL(urlString);
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                ColorFormat colorFormat;
                void size;
                InputStream it = (InputStream)closeable;
                byte[] byteArray = new byte[0xA00000];
                Ref.IntRef intRef = new Ref.IntRef();
                intRef.element = 0;
                while (it.available() > 0) {
                    int a = it.available();
                    ColorBufferGL3Kt.access$getLogger$p().info((Function0<? extends Object>)new Function0<String>((Ref.IntRef)size){
                        final /* synthetic */ Ref.IntRef $size;

                        @NotNull
                        public final String invoke() {
                            return "bytes available " + this.$size.element;
                        }
                        {
                            this.$size = intRef;
                            super(0);
                        }
                    });
                    it.read(byteArray, size.element, a);
                    size.element += a;
                }
                ColorBufferGL3Kt.access$getLogger$p().info("total size " + size.element);
                ByteBuffer buffer = BufferUtils.createByteBuffer(size.element);
                buffer.rewind();
                buffer.put(byteArray, 0, size.element);
                buffer.rewind();
                int[] wa = new int[1];
                int[] ha = new int[1];
                int[] ca = new int[1];
                STBImage.stbi_set_flip_vertically_on_load(true);
                STBImage.nstbi_set_unpremultiply_on_load(0);
                ByteBuffer data = STBImage.stbi_load_from_memory(buffer, wa, ha, ca, 0);
                int n = wa[0];
                int n2 = ha[0];
                switch (ca[0]) {
                    case 1: {
                        colorFormat = ColorFormat.R;
                        break;
                    }
                    case 2: {
                        colorFormat = ColorFormat.RG;
                        break;
                    }
                    case 3: {
                        colorFormat = ColorFormat.RGB;
                        break;
                    }
                    case 4: {
                        colorFormat = ColorFormat.RGBa;
                        break;
                    }
                    default: {
                        throw (Throwable)new Exception("invalid component count " + ca[0]);
                    }
                }
                ByteBuffer byteBuffer = data;
                Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "data");
                ColorBufferDataGL3 colorBufferDataGL3 = new ColorBufferDataGL3(n, n2, colorFormat, ColorType.UINT8, byteBuffer);
                return colorBufferDataGL3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

