/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0000\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u0000\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\u0000\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a.\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a&\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u000f"}, d2={"bezier", "", "x0", "c0", "x1", "t", "c1", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "derivative", "p0", "p1", "p2", "p3", "normal", "openrndr-math"})
public final class BezierKt {
    public static final double bezier(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return it2 * x0 + 2.0 * it * t * c0 + t2 * x1;
    }

    public static final double derivative(double x0, double c0, double x1, double t) {
        double it = 1.0 - t;
        return 2.0 * it * (c0 - x0) + 2.0 * t * (x1 - c0);
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        double it = 1.0 - t;
        return new Vector2((double)2 * it - (c0.getX() - x0.getX()) + (double)2 * t * (x1.getX() - c0.getX()), (double)2 * it - (c0.getX() - x0.getX()) + (double)2 * t * (x1.getX() - c0.getX()));
    }

    @NotNull
    public static final Vector2 derivative(@NotNull Vector2 p0, @NotNull Vector2 p1, @NotNull Vector2 p2, @NotNull Vector2 p3, double t) {
        Intrinsics.checkParameterIsNotNull(p0, "p0");
        Intrinsics.checkParameterIsNotNull(p1, "p1");
        Intrinsics.checkParameterIsNotNull(p2, "p2");
        Intrinsics.checkParameterIsNotNull(p3, "p3");
        double it = 1.0 - t;
        return p1.minus(p0).times(3.0 * it * it).plus(p2.minus(p1).times(6.0 * it * t)).plus(p3.minus(p2).times(3.0 * t * t));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Vector2 normal(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        void x;
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        Vector2 vector2 = BezierKt.derivative(x0, c0, x1, t);
        double d = vector2.component1();
        double y = vector2.component2();
        return new Vector2(-y, (double)x).getNormalized();
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 x1, double t) {
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return new Vector2(it2 * x0.getX() + (double)2 * it * t * c0.getX() + t2 * x1.getX(), it2 * x0.getY() + (double)2 * it * t * c0.getY() + t2 * x1.getY());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 x1, double t) {
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double t2 = t * t;
        return new Vector3(it2 * x0.getX() + (double)2 * it * t * c0.getX() + t2 * x1.getX(), it2 * x0.getY() + (double)2 * it * t * c0.getY() + t2 * x1.getY(), it2 * x0.getZ() + (double)2 * it * t * c0.getZ() + t2 * x1.getZ());
    }

    public static final double bezier(double x0, double c0, double c1, double x1, double t) {
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return it3 * x0 + 3.0 * it2 * t * c0 + 3.0 * it * t2 * c1 + t3 * x1;
    }

    @NotNull
    public static final Vector2 bezier(@NotNull Vector2 x0, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 x1, double t) {
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(c1, "c1");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return new Vector2(it3 * x0.getX() + (double)3 * it2 * t * c0.getX() + (double)3 * it * t2 * c1.getX() + t3 * x1.getX(), it3 * x0.getY() + (double)3 * it2 * t * c0.getY() + (double)3 * it * t2 * c1.getY() + t3 * x1.getY());
    }

    @NotNull
    public static final Vector3 bezier(@NotNull Vector3 x0, @NotNull Vector3 c0, @NotNull Vector3 c1, @NotNull Vector3 x1, double t) {
        Intrinsics.checkParameterIsNotNull(x0, "x0");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(c1, "c1");
        Intrinsics.checkParameterIsNotNull(x1, "x1");
        double it = 1.0 - t;
        double it2 = it * it;
        double it3 = it2 * it;
        double t2 = t * t;
        double t3 = t2 * t;
        return new Vector3(it3 * x0.getX() + (double)3 * it2 * t * c0.getX() + (double)3 * it * t2 * c1.getX() + t3 * x1.getX(), it3 * x0.getY() + (double)3 * it2 * t * c0.getY() + (double)3 * it * t2 * c1.getY() + t3 * x1.getY(), it3 * x0.getZ() + (double)3 * it2 * t * c0.getZ() + (double)3 * it * t2 * c1.getZ() + t3 * x1.getZ());
    }
}

