/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourProjection;
import org.openrndr.shape.Segment;
import org.openrndr.shape.SegmentProjection;
import org.openrndr.shape.ShapeToolsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00032\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000bJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u00142\b\b\u0002\u0010 \u001a\u00020\u000b\u00a2\u0006\u0002\u0010!J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Lorg/openrndr/shape/ShapeContour;", "", "segments", "", "Lorg/openrndr/shape/Segment;", "closed", "", "(Ljava/util/List;Z)V", "getClosed", "()Z", "length", "", "getLength", "()D", "reversed", "getReversed", "()Lorg/openrndr/shape/ShapeContour;", "getSegments", "()Ljava/util/List;", "adaptivePositions", "Lorg/openrndr/math/Vector2;", "distanceTolerance", "equidistantPositions", "pointCount", "", "mod", "a", "b", "normal", "ut", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "plus", "other", "position", "project", "Lorg/openrndr/shape/ContourProjection;", "sampleEquidistant", "sampleLinear", "sub", "t0", "t1", "transform", "Lorg/openrndr/math/Matrix44;", "Companion", "openrndr-shape"})
public final class ShapeContour {
    @NotNull
    private final List<Segment> segments;
    private final boolean closed;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final double getLength() {
        void var2_2;
        Iterable $receiver$iv = this.segments;
        double sum$iv = 0.0;
        for (Object element$iv : $receiver$iv) {
            void it;
            Segment segment = (Segment)element$iv;
            double d = sum$iv;
            double d2 = it.getLength();
            sum$iv = d + d2;
        }
        return (double)var2_2;
    }

    @NotNull
    public final ShapeContour plus(@NotNull ShapeContour other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        double epsilon = 0.001;
        List segments = new ArrayList();
        segments.addAll((Collection)this.segments);
        if (this.segments.get(this.segments.size() - 1).getEnd().minus(other.segments.get(0).getStart()).getLength() > epsilon) {
            segments.add(new Segment(this.segments.get(this.segments.size() - 1).getEnd(), other.segments.get(0).getStart()));
        }
        segments.addAll((Collection)other.segments);
        return new ShapeContour(segments, false);
    }

    @NotNull
    public final Vector2 position(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t * (double)this.segments.size());
        double segmentOffset = t * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).position(segmentOffset);
    }

    @NotNull
    public final Vector2 normal(double ut) {
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        int segment = (int)(t * (double)this.segments.size());
        double segmentOffset = t * (double)this.segments.size() - (double)segment;
        return this.segments.get(Math.min(this.segments.size() - 1, segment)).normal(segmentOffset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> adaptivePositions(double distanceTolerance) {
        List adaptivePoints = new ArrayList();
        Vector2 last = null;
        for (Segment segment : this.segments) {
            List<Vector2> samples = segment.sampleAdaptive(distanceTolerance);
            Collection collection = samples;
            if (!(!collection.isEmpty())) continue;
            Vector2 r = samples.get(0);
            if (last == null || last.minus(r).getLength() > 0.01) {
                adaptivePoints.add(r);
            }
            int n = 1;
            int n2 = samples.size();
            while (n < n2) {
                void i;
                adaptivePoints.add(samples.get((int)i));
                last = samples.get((int)i);
                ++i;
            }
        }
        return adaptivePoints;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List adaptivePositions$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.adaptivePositions(d);
    }

    @NotNull
    public final List<Vector2> equidistantPositions(int pointCount) {
        return ShapeToolsKt.sampleEquidistant(ShapeContour.adaptivePositions$default(this, 0.0, 1, null), pointCount);
    }

    @NotNull
    public final ShapeContour sampleLinear(double distanceTolerance) {
        return Companion.fromPoints(this.adaptivePositions(distanceTolerance), this.closed);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ShapeContour sampleLinear$default(ShapeContour shapeContour, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return shapeContour.sampleLinear(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sampleEquidistant(int pointCount) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<Vector2> points = this.equidistantPositions(pointCount);
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, points.size() - 1);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)));
            collection.add(segment);
        }
        List segments = (List)destination$iv$iv;
        return new ShapeContour(segments, this.closed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour transform(@NotNull Matrix44 transform) {
        Collection<Segment> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ShapeContour shapeContour;
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Iterable iterable = this.segments;
        ShapeContour shapeContour2 = shapeContour;
        ShapeContour shapeContour3 = shapeContour;
        void var3_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            Segment segment2 = it.transform(transform);
            collection.add(segment2);
        }
        collection = (List)destination$iv$iv;
        shapeContour2((List<Segment>)collection, this.closed);
        return shapeContour3;
    }

    public final double mod(double a, double b) {
        return (a % b + b) % b;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour sub(double t0, double t1) {
        double length;
        int segment0;
        double t02 = t0;
        double t12 = t1;
        if ((this.closed && t02 < 0.0 || t12 > 1.0 || t12 < 0.0 || t12 > 1.0) && (t02 = this.mod(t02, 1.0)) > (t12 = this.mod(t12, 1.0))) {
            return this.sub(t02, 1.0).plus(this.sub(0.0, t12));
        }
        t02 = RangesKt.coerceIn(t02, 0.0, 1.0);
        t12 = RangesKt.coerceIn(t12, 0.0, 1.0);
        double z0 = t02;
        double z1 = t12;
        if (t02 > t12) {
            z0 = t12;
            z1 = t02;
        }
        double segmentOffset0 = (segment0 = (int)(z0 * (length = (double)this.segments.size()))) < this.segments.size() ? z0 * length % 1.0 : 1.0;
        int segment1 = (int)(z1 * length);
        double segmentOffset1 = segment1 < this.segments.size() ? z1 * length % 1.0 : 1.0;
        segment1 = Math.min(this.segments.size() - 1, segment1);
        segment0 = Math.min(this.segments.size() - 1, segment0);
        List newSegments = new ArrayList();
        double epsilon = 1.0E-6;
        int n = segment0;
        int n2 = segment1;
        if (n <= n2) {
            while (true) {
                void s;
                if (s == segment0 && s == segment1) {
                    newSegments.add(this.segments.get((int)s).sub(segmentOffset0, segmentOffset1));
                } else if (s == segment0) {
                    if (segmentOffset0 < 1.0 - epsilon) {
                        newSegments.add(this.segments.get((int)s).sub(segmentOffset0, 1.0));
                    }
                } else if (s == segment1) {
                    if (segmentOffset1 > epsilon) {
                        newSegments.add(this.segments.get((int)s).sub(0.0, segmentOffset1));
                    }
                } else {
                    newSegments.add(this.segments.get((int)s));
                }
                if (s == n2) break;
                ++s;
            }
        }
        ShapeContour newContour = new ShapeContour(newSegments, false);
        return newContour;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        int n = 0;
        int n2 = this.segments.size();
        while (n < n2) {
            void i;
            Double st = this.segments.get((int)i).on(point, error);
            if (st != null) {
                return ((double)i + st) / (double)this.segments.size();
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Double on$default(ShapeContour shapeContour, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return shapeContour.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ContourProjection project(@NotNull Vector2 point) {
        Object v1;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(point, "point");
        Iterable $receiver$iv = this.segments;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            void index;
            int n = index$iv$iv++;
            Segment segment = (Segment)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            Pair<Integer, SegmentProjection> pair = new Pair<Integer, SegmentProjection>((int)index, it.project(point));
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            Pair it = (Pair)minElem$iv;
            double minValue$iv = ((SegmentProjection)it.getSecond()).getDistance();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                Pair it2 = (Pair)e$iv;
                double v$iv = ((SegmentProjection)it2.getSecond()).getDistance();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v1 = minElem$iv;
        }
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        Pair nearest = v1;
        return new ContourProjection((SegmentProjection)nearest.getSecond(), (((Number)nearest.getFirst()).doubleValue() + ((SegmentProjection)nearest.getSecond()).getProjection()) / (double)this.segments.size(), ((SegmentProjection)nearest.getSecond()).getDistance(), ((SegmentProjection)nearest.getSecond()).getPoint());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ShapeContour getReversed() {
        void var3_5;
        Collection<Segment> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ShapeContour shapeContour;
        Iterable iterable = this.segments;
        ShapeContour shapeContour2 = shapeContour;
        ShapeContour shapeContour3 = shapeContour;
        void var2_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Segment segment = (Segment)item$iv$iv;
            collection = destination$iv$iv;
            Segment segment2 = it.getReverse();
            collection.add(segment2);
        }
        collection = (List)var3_5;
        shapeContour2((List<Segment>)collection, this.closed);
        return shapeContour3;
    }

    @NotNull
    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public ShapeContour(@NotNull List<Segment> segments, boolean closed) {
        Intrinsics.checkParameterIsNotNull(segments, "segments");
        this.segments = segments;
        this.closed = closed;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/openrndr/shape/ShapeContour$Companion;", "", "()V", "fromPoints", "Lorg/openrndr/shape/ShapeContour;", "points", "", "Lorg/openrndr/math/Vector2;", "closed", "", "openrndr-shape"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShapeContour fromPoints(@NotNull List<Vector2> points, boolean closed) {
            Collection<Segment> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            ShapeContour shapeContour;
            Intrinsics.checkParameterIsNotNull(points, "points");
            Iterable iterable = RangesKt.until(0, points.size() - 1);
            ShapeContour shapeContour2 = shapeContour;
            ShapeContour shapeContour3 = shapeContour;
            void var4_6 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                Segment segment = new Segment(points.get((int)it), points.get((int)(it + true)));
                collection.add(segment);
            }
            collection = (List)destination$iv$iv;
            shapeContour2((List<Segment>)collection, closed);
            return shapeContour3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

