/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.openrndr.math.Vector2;
import org.openrndr.svg.Command;
import org.openrndr.svg.SVGDocument;
import org.openrndr.svg.SVGGroup;
import org.openrndr.svg.SVGPath;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lorg/openrndr/svg/SVGLoader;", "", "()V", "handleCircle", "", "group", "Lorg/openrndr/svg/SVGGroup;", "e", "Lorg/jsoup/nodes/Element;", "handleEllipse", "handleGroup", "parent", "handleLine", "handlePath", "handlePolygon", "handleRectangle", "loadSVG", "Lorg/openrndr/svg/SVGDocument;", "svg", "", "openrndr-svg"})
public final class SVGLoader {
    @NotNull
    public final SVGDocument loadSVG(@NotNull String svg) {
        Intrinsics.checkParameterIsNotNull(svg, "svg");
        Document doc = Jsoup.parse(svg, "", Parser.xmlParser());
        Element root = doc.select("svg").first();
        SVGGroup rootGroup = new SVGGroup(null, 1, null);
        Element element = root;
        Intrinsics.checkExpressionValueIsNotNull(element, "root");
        this.handleGroup(rootGroup, element);
        return new SVGDocument(rootGroup);
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePolygon(SVGGroup group, Element e) {
        void $receiver$iv;
        SVGPath sVGPath;
        Object object;
        void $receiver$iv$iv;
        Object element$iv$iv2;
        Object object2;
        CharSequence charSequence;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        String string = e.attr("points");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"points\")");
        Object object3 = string;
        Object object4 = "[ ,\n]+";
        object4 = new Regex((String)object4);
        int n = 0;
        object3 = ((Regex)object4).split((CharSequence)object3, n);
        object4 = $receiver$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            charSequence = it;
            void v1 = charSequence;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object2 = ((Object)StringsKt.trim((CharSequence)v1)).toString();
            collection.add(object2);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            it = (String)element$iv$iv2;
            charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List tokens = (List)destination$iv$iv;
        Iterable $receiver$iv3 = RangesKt.until(0, tokens.size() / 2);
        destination$iv$iv = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv3, 10));
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Vector2 vector2;
            void it2;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)element$iv$iv2).nextInt();
            collection = destination$iv$iv2;
            String $i$a$2$filter = (String)tokens.get((int)(it2 * 2));
            Vector2 $i$f$filterTo = vector2;
            object = vector2;
            double d = Double.parseDouble($i$a$2$filter);
            $i$a$2$filter = (String)tokens.get((int)(it2 * 2 + true));
            double d2 = Double.parseDouble($i$a$2$filter);
            $i$f$filterTo(d, d2);
            object2 = object;
            collection.add(object2);
        }
        List points = (List)destination$iv$iv2;
        SVGPath $receiver = sVGPath = new SVGPath();
        $receiver.setId(e.id());
        $receiver.parseDrawAttributes(e);
        $receiver.getCommands().add(new Command("M", ((Vector2)points.get(0)).getX(), ((Vector2)points.get(0)).getY()));
        element$iv$iv2 = RangesKt.until(1, points.size());
        Collection destination$iv = $receiver.getCommands();
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            void it3;
            int item$iv;
            int $i$f$filterTo = item$iv = ((IntIterator)iterator2).nextInt();
            object = destination$iv;
            Command command = new Command("L", ((Vector2)points.get((int)it3)).getX(), ((Vector2)points.get((int)it3)).getY());
            object.add(command);
        }
        $receiver.getCommands().add(new Command("Z", new double[0]));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    /*
     * Unable to fully structure code
     */
    private final void handleGroup(SVGGroup parent, Element e) {
        $receiver = var4_3 = new SVGGroup(null, 1, null);
        $receiver.setId(e.id());
        $receiver.parseTransform(e);
        group = var4_3;
        parent.getElements().add(group);
        v0 = e.children();
        Intrinsics.checkExpressionValueIsNotNull(v0, "e.children()");
        $receiver$iv = v0;
        for (T element$iv : $receiver$iv) {
            block13: {
                block17: {
                    block16: {
                        block15: {
                            block12: {
                                block14: {
                                    block11: {
                                        c = (Element)element$iv;
                                        v1 = var8_8 = c.tagName();
                                        if (v1 == null) continue;
                                        switch (v1.hashCode()) {
                                            case 3433509: {
                                                if (!var8_8.equals("path")) ** break;
                                                break block11;
                                            }
                                            case 3496420: {
                                                if (!var8_8.equals("rect")) ** break;
                                                break block12;
                                            }
                                            case 100313435: {
                                                if (!var8_8.equals("image")) ** break;
                                                break block13;
                                            }
                                            case 3321844: {
                                                if (!var8_8.equals("line")) ** break;
                                                break block14;
                                            }
                                            case 103: {
                                                if (!var8_8.equals("g")) ** break;
                                                break;
                                            }
                                            case -1656480802: {
                                                if (!var8_8.equals("ellipse")) ** break;
                                                break block15;
                                            }
                                            case -1360216880: {
                                                if (!var8_8.equals("circle")) ** break;
                                                break block16;
                                            }
                                            case 561938880: {
                                                if (!var8_8.equals("polyline")) ** break;
                                                break block17;
                                            }
                                        }
                                        v2 = c;
                                        Intrinsics.checkExpressionValueIsNotNull(v2, "c");
                                        this.handleGroup(group, v2);
                                        ** break;
                                    }
                                    v3 = c;
                                    Intrinsics.checkExpressionValueIsNotNull(v3, "c");
                                    this.handlePath(group, v3);
                                    ** break;
                                }
                                v4 = c;
                                Intrinsics.checkExpressionValueIsNotNull(v4, "c");
                                this.handleLine(group, v4);
                                ** break;
                            }
                            v5 = c;
                            Intrinsics.checkExpressionValueIsNotNull(v5, "c");
                            this.handleRectangle(group, v5);
                            ** break;
                        }
                        v6 = c;
                        Intrinsics.checkExpressionValueIsNotNull(v6, "c");
                        this.handleEllipse(group, v6);
                        ** break;
                    }
                    v7 = c;
                    Intrinsics.checkExpressionValueIsNotNull(v7, "c");
                    this.handleCircle(group, v7);
                    ** break;
                }
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            throw (Throwable)new NotImplementedError(null, 1, null);
lbl73:
            // 15 sources

        }
    }

    private final void handleEllipse(SVGGroup group, Element e) {
        double d;
        CharSequence it;
        double d2;
        CharSequence it2;
        double d3;
        CharSequence it3;
        double d4;
        String string;
        String it4;
        String string2 = it4 = (string = e.attr("cx"));
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d4 = 0.0;
        } else {
            charSequence = it4;
            d4 = Double.parseDouble((String)charSequence);
        }
        double x = d4;
        CharSequence charSequence2 = it3 = (charSequence = e.attr("cy"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence2, "it");
        CharSequence charSequence3 = charSequence2;
        if (charSequence3.length() == 0) {
            d3 = 0.0;
        } else {
            charSequence3 = it3;
            d3 = Double.parseDouble((String)charSequence3);
        }
        double y = d3;
        CharSequence charSequence4 = it2 = (charSequence3 = e.attr("rx"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence4, "it");
        CharSequence charSequence5 = charSequence4;
        if (charSequence5.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence5 = it2;
            d2 = Double.parseDouble((String)charSequence5);
        }
        double width = d2 * 2.0;
        CharSequence charSequence6 = it = (charSequence5 = e.attr("ry"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence6, "it");
        CharSequence charSequence7 = charSequence6;
        if (charSequence7.length() == 0) {
            d = 0.0;
        } else {
            charSequence7 = it;
            d = Double.parseDouble((String)charSequence7);
        }
        double height = d * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = (x -= width / (double)2) + width;
        double ye = (y -= height / (double)2) + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        SVGPath path = new SVGPath();
        path.setId(e.id());
        path.parseDrawAttributes(e);
        path.parseTransform(e);
        path.getCommands().add(new Command("M", x, ym));
        path.getCommands().add(new Command("C", x, ym - oy, xm - ox, y, xm, y));
        path.getCommands().add(new Command("C", xm + ox, y, xe, ym - oy, xe, ym));
        path.getCommands().add(new Command("C", xe, ym + oy, xm + ox, ye, xm, ye));
        path.getCommands().add(new Command("C", xm - ox, ye, x, ym + oy, x, ym));
        path.getCommands().add(new Command("z", new double[0]));
        group.getElements().add(path);
    }

    private final void handleCircle(SVGGroup group, Element e) {
        double d;
        CharSequence it;
        double d2;
        CharSequence it2;
        double d3;
        CharSequence it3;
        double d4;
        String string;
        String it4;
        String string2 = it4 = (string = e.attr("cx"));
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d4 = 0.0;
        } else {
            charSequence = it4;
            d4 = Double.parseDouble((String)charSequence);
        }
        double x = d4;
        CharSequence charSequence2 = it3 = (charSequence = e.attr("cx"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence2, "it");
        CharSequence charSequence3 = charSequence2;
        if (charSequence3.length() == 0) {
            d3 = 0.0;
        } else {
            charSequence3 = it3;
            d3 = Double.parseDouble((String)charSequence3);
        }
        double y = d3;
        CharSequence charSequence4 = it2 = (charSequence3 = e.attr("r"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence4, "it");
        CharSequence charSequence5 = charSequence4;
        if (charSequence5.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence5 = it2;
            d2 = Double.parseDouble((String)charSequence5);
        }
        double width = d2 * 2.0;
        CharSequence charSequence6 = it = (charSequence5 = e.attr("r"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence6, "it");
        CharSequence charSequence7 = charSequence6;
        if (charSequence7.length() == 0) {
            d = 0.0;
        } else {
            charSequence7 = it;
            d = Double.parseDouble((String)charSequence7);
        }
        double height = d * 2.0;
        double kappa = 0.5522848;
        double ox = width / (double)2 * kappa;
        double oy = height / (double)2 * kappa;
        double xe = (x -= width / (double)2) + width;
        double ye = (y -= height / (double)2) + height;
        double xm = x + width / (double)2;
        double ym = y + height / (double)2;
        SVGPath path = new SVGPath();
        path.setId(e.id());
        path.parseDrawAttributes(e);
        path.parseTransform(e);
        path.getCommands().add(new Command("M", x, ym));
        path.getCommands().add(new Command("C", x, ym - oy, xm - ox, y, xm, y));
        path.getCommands().add(new Command("C", xm + ox, y, xe, ym - oy, xe, ym));
        path.getCommands().add(new Command("C", xe, ym + oy, xm + ox, ye, xm, ye));
        path.getCommands().add(new Command("C", xm - ox, ye, x, ym + oy, x, ym));
        path.getCommands().add(new Command("z", new double[0]));
        group.getElements().add(path);
    }

    private final void handleRectangle(SVGGroup group, Element e) {
        SVGPath sVGPath;
        double d;
        CharSequence it;
        double d2;
        String string;
        String it2;
        String string2 = it2 = (string = e.attr("x"));
        Intrinsics.checkExpressionValueIsNotNull(string2, "it");
        CharSequence charSequence = string2;
        if (charSequence.length() == 0) {
            d2 = 0.0;
        } else {
            charSequence = it2;
            d2 = Double.parseDouble((String)charSequence);
        }
        double x = d2;
        CharSequence charSequence2 = it = (charSequence = e.attr("y"));
        Intrinsics.checkExpressionValueIsNotNull(charSequence2, "it");
        CharSequence charSequence3 = charSequence2;
        if (charSequence3.length() == 0) {
            d = 0.0;
        } else {
            charSequence3 = it;
            d = Double.parseDouble((String)charSequence3);
        }
        double y = d;
        String string3 = e.attr("width");
        Intrinsics.checkExpressionValueIsNotNull(string3, "e.attr(\"width\")");
        charSequence3 = string3;
        double width = Double.parseDouble((String)charSequence3);
        String string4 = e.attr("height");
        Intrinsics.checkExpressionValueIsNotNull(string4, "e.attr(\"height\")");
        String string5 = string4;
        double height = Double.parseDouble(string5);
        SVGPath $receiver = sVGPath = new SVGPath();
        $receiver.setId(e.id());
        $receiver.parseTransform(e);
        $receiver.parseDrawAttributes(e);
        $receiver.getCommands().add(new Command("M", x, y));
        $receiver.getCommands().add(new Command("h", width));
        $receiver.getCommands().add(new Command("v", height));
        $receiver.getCommands().add(new Command("h", -width));
        $receiver.getCommands().add(new Command("z", new double[0]));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    private final void handleLine(SVGGroup group, Element e) {
        SVGPath sVGPath;
        String string = e.attr("x1");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"x1\")");
        String string2 = string;
        double x1 = Double.parseDouble(string2);
        String string3 = e.attr("x2");
        Intrinsics.checkExpressionValueIsNotNull(string3, "e.attr(\"x2\")");
        String string4 = string3;
        double x2 = Double.parseDouble(string4);
        String string5 = e.attr("y1");
        Intrinsics.checkExpressionValueIsNotNull(string5, "e.attr(\"y1\")");
        String string6 = string5;
        double y1 = Double.parseDouble(string6);
        String string7 = e.attr("y2");
        Intrinsics.checkExpressionValueIsNotNull(string7, "e.attr(\"y2\")");
        String string8 = string7;
        double y2 = Double.parseDouble(string8);
        SVGPath $receiver = sVGPath = new SVGPath();
        $receiver.parseDrawAttributes(e);
        $receiver.getCommands().add(new Command("M", x1, y1));
        $receiver.getCommands().add(new Command("L", x2, y2));
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }

    private final void handlePath(SVGGroup group, Element e) {
        SVGPath sVGPath;
        String string = e.attr("d");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"d\")");
        SVGPath $receiver = sVGPath = SVGPath.Companion.fromSVGPathString(string);
        $receiver.setId(e.id());
        $receiver.parseDrawAttributes(e);
        $receiver.parseTransform(e);
        SVGPath path = sVGPath;
        group.getElements().add(path);
    }
}

