/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.camera;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.KeyboardModifier;
import org.openrndr.Program;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Quaternion;
import org.openrndr.math.QuaternionKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;
import studio.rndr.camera.CameraKey;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020A2\u0006\u0010E\u001a\u00020FJ\u0006\u0010H\u001a\u00020AR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0006\"\u0004\b$\u0010\bR\u001a\u0010%\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0006\"\u0004\b'\u0010\bR\u001a\u0010(\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\bR\u001a\u0010+\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0006\"\u0004\b-\u0010\bR\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010!\"\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010!R\u001a\u0010:\u001a\u00020;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006I"}, d2={"Lstudio/rndr/camera/FirstPersonCamera;", "", "()V", "aperture", "", "getAperture", "()D", "setAperture", "(D)V", "cameraQuat", "Lorg/openrndr/math/Quaternion;", "getCameraQuat", "()Lorg/openrndr/math/Quaternion;", "setCameraQuat", "(Lorg/openrndr/math/Quaternion;)V", "centerX", "getCenterX", "setCenterX", "centerY", "getCenterY", "setCenterY", "exposure", "getExposure", "setExposure", "focalLength", "getFocalLength", "setFocalLength", "focalPlane", "getFocalPlane", "setFocalPlane", "forward", "Lorg/openrndr/math/Vector3;", "getForward", "()Lorg/openrndr/math/Vector3;", "fov", "getFov", "setFov", "keyPitch", "getKeyPitch", "setKeyPitch", "keyRoll", "getKeyRoll", "setKeyRoll", "keyYaw", "getKeyYaw", "setKeyYaw", "lastMousePosition", "Lorg/openrndr/math/Vector2;", "getLastMousePosition", "()Lorg/openrndr/math/Vector2;", "setLastMousePosition", "(Lorg/openrndr/math/Vector2;)V", "position", "getPosition", "setPosition", "(Lorg/openrndr/math/Vector3;)V", "up", "getUp", "viewMatrix", "Lorg/openrndr/math/Matrix44;", "getViewMatrix", "()Lorg/openrndr/math/Matrix44;", "setViewMatrix", "(Lorg/openrndr/math/Matrix44;)V", "fromFrame", "", "frame", "Lstudio/rndr/camera/CameraKey;", "mouseMoved", "event", "Lorg/openrndr/Program$Mouse$MouseEvent;", "mouseScrolled", "update", "demo-paddock"})
public final class FirstPersonCamera {
    @NotNull
    private Matrix44 viewMatrix = Matrix44.Companion.getIDENTITY();
    @NotNull
    private Quaternion cameraQuat = Quaternion.Companion.getIDENTITY();
    @NotNull
    private Vector3 position = Vector3.Companion.getZERO();
    private double keyPitch;
    private double keyYaw;
    private double keyRoll;
    private double fov = 90.0;
    private double aperture = 1.0;
    private double focalPlane = 100.0;
    private double focalLength = 10.0;
    private double exposure = 1.0;
    private double centerX;
    private double centerY;
    @NotNull
    private Vector2 lastMousePosition = new Vector2(0.0, 0.0);

    @NotNull
    public final Matrix44 getViewMatrix() {
        return this.viewMatrix;
    }

    public final void setViewMatrix(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.viewMatrix = matrix44;
    }

    @NotNull
    public final Quaternion getCameraQuat() {
        return this.cameraQuat;
    }

    public final void setCameraQuat(@NotNull Quaternion quaternion) {
        Intrinsics.checkParameterIsNotNull(quaternion, "<set-?>");
        this.cameraQuat = quaternion;
    }

    @NotNull
    public final Vector3 getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Vector3 vector3) {
        Intrinsics.checkParameterIsNotNull(vector3, "<set-?>");
        this.position = vector3;
    }

    public final double getKeyPitch() {
        return this.keyPitch;
    }

    public final void setKeyPitch(double d) {
        this.keyPitch = d;
    }

    public final double getKeyYaw() {
        return this.keyYaw;
    }

    public final void setKeyYaw(double d) {
        this.keyYaw = d;
    }

    public final double getKeyRoll() {
        return this.keyRoll;
    }

    public final void setKeyRoll(double d) {
        this.keyRoll = d;
    }

    public final double getFov() {
        return this.fov;
    }

    public final void setFov(double d) {
        this.fov = d;
    }

    public final double getAperture() {
        return this.aperture;
    }

    public final void setAperture(double d) {
        this.aperture = d;
    }

    public final double getFocalPlane() {
        return this.focalPlane;
    }

    public final void setFocalPlane(double d) {
        this.focalPlane = d;
    }

    public final double getFocalLength() {
        return this.focalLength;
    }

    public final void setFocalLength(double d) {
        this.focalLength = d;
    }

    public final double getExposure() {
        return this.exposure;
    }

    public final void setExposure(double d) {
        this.exposure = d;
    }

    public final double getCenterX() {
        return this.centerX;
    }

    public final void setCenterX(double d) {
        this.centerX = d;
    }

    public final double getCenterY() {
        return this.centerY;
    }

    public final void setCenterY(double d) {
        this.centerY = d;
    }

    @NotNull
    public final Vector2 getLastMousePosition() {
        return this.lastMousePosition;
    }

    public final void setLastMousePosition(@NotNull Vector2 vector2) {
        Intrinsics.checkParameterIsNotNull(vector2, "<set-?>");
        this.lastMousePosition = vector2;
    }

    public final void fromFrame(@NotNull CameraKey frame) {
        Intrinsics.checkParameterIsNotNull(frame, "frame");
        this.position = frame.getPosition();
        this.cameraQuat = frame.getOrientation();
        this.fov = frame.getFov();
        this.aperture = frame.getAperture();
        this.focalLength = frame.getFocalLength();
        this.focalPlane = frame.getFocalPlane();
        this.exposure = frame.getExposure();
        this.centerX = frame.getCenterX();
        this.centerY = frame.getCenterY();
        this.update();
    }

    @NotNull
    public final Vector3 getForward() {
        Matrix44 mat = this.cameraQuat.getMatrix().getTransposed();
        return mat.get(2).getXyz();
    }

    @NotNull
    public final Vector3 getUp() {
        Matrix44 mat = this.cameraQuat.getMatrix().getTransposed();
        return mat.get(1).getXyz();
    }

    public final void mouseScrolled(@NotNull Program.Mouse.MouseEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Matrix44 mat = this.cameraQuat.getMatrix().getTransposed();
        Vector3 foward = mat.get(2).getXyz();
        Vector3 strafe = mat.get(0).getXyz();
        Vector3 up = mat.get(1).getXyz();
        if (event.getModifiers().contains((Object)KeyboardModifier.CTRL) && !event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            this.aperture += event.getPosition().getY() * 0.1;
            this.exposure += event.getPosition().getX() * 0.05;
        } else if (event.getModifiers().contains((Object)KeyboardModifier.CTRL) && event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            this.focalPlane += event.getPosition().getY();
            this.focalLength += event.getPosition().getX();
            String string = "focal plane: " + this.focalPlane;
            System.out.println((Object)string);
            string = "focal length " + this.focalLength;
            System.out.println((Object)string);
        } else if (event.getModifiers().contains((Object)KeyboardModifier.ALT) && !event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            this.fov += event.getPosition().getY();
        } else if (event.getModifiers().contains((Object)KeyboardModifier.ALT) && event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            this.centerX += event.getPosition().getX() * 0.1;
            this.centerY += event.getPosition().getY() * 0.1;
        } else {
            this.position = event.getModifiers().contains((Object)KeyboardModifier.SHIFT) ? this.position.plus(up.times(event.getPosition().getY()).times(10.0)) : this.position.plus(foward.times(event.getPosition().getY()).times(10.0));
            this.position = this.position.plus(strafe.times(event.getPosition().getX()).times(3.0));
        }
        this.update();
    }

    public final void mouseMoved(@NotNull Program.Mouse.MouseEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        Vector2 delta = event.getPosition().minus(this.lastMousePosition);
        if (event.getModifiers().contains((Object)KeyboardModifier.SHIFT)) {
            this.keyYaw = delta.getX() * 0.01;
        } else {
            this.keyPitch = delta.getX() * 0.01;
            this.keyRoll = delta.getY() * 0.01;
        }
        this.lastMousePosition = event.getPosition();
        this.update();
    }

    public final void update() {
        Quaternion keyQuat = QuaternionKt.fromAngles(this.keyPitch, this.keyRoll, this.keyYaw);
        this.cameraQuat = keyQuat.times(this.cameraQuat);
        this.keyPitch = 0.0;
        this.keyYaw = 0.0;
        this.keyRoll = 0.0;
        this.viewMatrix = this.cameraQuat.getMatrix().times(TransformsKt.translate(this.position.times(-1.0)));
    }
}

