/*
 * Decompiled with CFR 0.152.
 */
package ch.bildspur.postfx.builder;

import ch.bildspur.postfx.PostFXSupervisor;
import ch.bildspur.postfx.builder.PostFX;
import ch.bildspur.postfx.pass.BloomPass;
import ch.bildspur.postfx.pass.BlurPass;
import ch.bildspur.postfx.pass.BrightPass;
import ch.bildspur.postfx.pass.BrightnessContrastPass;
import ch.bildspur.postfx.pass.ChromaticAberrationPass;
import ch.bildspur.postfx.pass.DenoisePass;
import ch.bildspur.postfx.pass.GrayScalePass;
import ch.bildspur.postfx.pass.InvertPass;
import ch.bildspur.postfx.pass.NoisePass;
import ch.bildspur.postfx.pass.Pass;
import ch.bildspur.postfx.pass.PixelatePass;
import ch.bildspur.postfx.pass.RGBSplitPass;
import ch.bildspur.postfx.pass.SaturationVibrancePass;
import ch.bildspur.postfx.pass.SobelPass;
import ch.bildspur.postfx.pass.ToonPass;
import ch.bildspur.postfx.pass.VignettePass;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PGraphics;

public class PostFXBuilder {
    private PostFXSupervisor supervisor;
    private PostFX fx;
    private Map<String, Pass> passes;

    PostFXBuilder(PostFX fx, PostFXSupervisor supervisor) {
        this.fx = fx;
        this.supervisor = supervisor;
        this.passes = new HashMap<String, Pass>();
    }

    <T extends Pass> T getPass(Class<T> type) {
        if (this.passes.containsKey(type.getName())) {
            return (T)this.passes.get(type.getName());
        }
        Pass pass = null;
        try {
            Constructor<T> constructor = type.getConstructor(PApplet.class);
            pass = (Pass)constructor.newInstance(this.fx.sketch);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.passes.put(type.getName(), pass);
        return (T)pass;
    }

    Map<String, Pass> getPasses() {
        return this.passes;
    }

    public void compose() {
        this.supervisor.compose();
    }

    public void compose(PGraphics graphics) {
        this.supervisor.compose(graphics);
    }

    public PostFXBuilder custom(Pass pass) {
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder blur(int blurSize, float sigma) {
        this.blur(blurSize, sigma, false);
        this.blur(blurSize, sigma, true);
        return this;
    }

    public PostFXBuilder blur(int blurSize, float sigma, boolean horizontal) {
        BlurPass pass = this.getPass(BlurPass.class);
        pass.setBlurSize(blurSize);
        pass.setSigma(sigma);
        pass.setHorizontal(horizontal);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder brightPass(float threshold) {
        BrightPass pass = this.getPass(BrightPass.class);
        pass.setThreshold(threshold);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder sobel() {
        SobelPass pass = this.getPass(SobelPass.class);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder toon() {
        ToonPass pass = this.getPass(ToonPass.class);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder invert() {
        InvertPass pass = this.getPass(InvertPass.class);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder brightnessContrast(float brightness, float contrast) {
        BrightnessContrastPass pass = this.getPass(BrightnessContrastPass.class);
        pass.setBrightness(brightness);
        pass.setContrast(contrast);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder pixelate(float amount) {
        PixelatePass pass = this.getPass(PixelatePass.class);
        pass.setAmount(amount);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder chromaticAberration() {
        ChromaticAberrationPass pass = this.getPass(ChromaticAberrationPass.class);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder grayScale() {
        GrayScalePass pass = this.getPass(GrayScalePass.class);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder bloom(float threshold, int blurSize, float sigma) {
        BloomPass pass = this.getPass(BloomPass.class);
        pass.setThreshold(threshold);
        pass.setBlurSize(blurSize);
        pass.setSigma(sigma);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder rgbSplit(float delta) {
        RGBSplitPass pass = this.getPass(RGBSplitPass.class);
        pass.setDelta(delta);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder vignette(float amount, float falloff) {
        VignettePass pass = this.getPass(VignettePass.class);
        pass.setAmount(amount);
        pass.setFalloff(falloff);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder noise(float amount, float speed) {
        NoisePass pass = this.getPass(NoisePass.class);
        pass.setAmount(amount);
        pass.setSpeed(speed);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder denoise(float exponent) {
        DenoisePass pass = this.getPass(DenoisePass.class);
        pass.setExponent(exponent);
        this.supervisor.pass(pass);
        return this;
    }

    public PostFXBuilder saturationVibrance(float saturation, float vibrance) {
        SaturationVibrancePass pass = this.getPass(SaturationVibrancePass.class);
        pass.setSaturation(saturation);
        pass.setVibrance(vibrance);
        this.supervisor.pass(pass);
        return this;
    }
}

