#version 330

uniform float my_time;

in vec2 texCoord;
out vec4 my_out;

mat4 camera(vec3 eye, vec3 lookat, vec3 up) {
  vec3 f = normalize(lookat-eye);
  vec3 s = normalize(cross(f, up));
  vec3 u = cross(s, f);
  return mat4(vec4(s, 0.0),
              vec4(u, 0.0),
              vec4(-f, 0.0),
              vec4(0.0, 0.0, 0.0, 1.0));
}

void rot(inout vec2 w,float h) {
  w=w*cos(h)+sin(h)*vec2(w.y,-w.x);
}

void main() {
  vec3 location = vec3(-1+sin(my_time/3000.),-1+cos(my_time/5000.), 1+sin(my_time/2000.0));
  vec3 lookat = vec3(0, 0, 0);
  vec3 up = vec3(0, 1.0, 0);
 mat4 cam = camera(location, lookat, up);

  vec4 d = vec4(texCoord.xy-0.5, 1.5, 1.0);
  vec4 d2 = vec4(0, 0, 1.0, 1.0);
  d = d*cam;
  d /= d.w;
  d2 = d2*cam;
  d2 /= d2.w;
 vec3 o = location;
  vec3 start = location.xyz + vec3(my_time/2000.0, my_time/2500, -my_time/3000);
  vec3 direction = normalize(d.xyz - d2.xyz);

	vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
	float distanceTraveled = 0;

	for (int x = 0; x < 50 && (distanceTraveled < (14800.-my_time)/15.); x++) {
		// Find closest integer solution along direction
		float xdist = 20000.0;
		float ydist = 20000.0;
		float zdist = 20000.0;

		// distance to next x solution;
		if (direction.x > 0) {
			float xdiff = floor(start.x + 1.0) - start.x;
			xdist = xdiff / direction.x;
		} else if (direction.x < 0) {
			float xdiff = floor(start.x - 1.0) - start.x;
			xdist = xdiff / direction.x;
		}

		// distance to next y solution;
		if (direction.y > 0) {
			float ydiff = floor(start.y + 1.0) - start.y;
			ydist = ydiff / direction.y;
		} else if (direction.y < 0) {
			float ydiff = floor(start.y - 1.0) - start.y;
			ydist = ydiff / direction.y;
		}

		// distance to next z zolution;
		if (direction.z > 0) {
			float zdiff = floor(start.z + 1.0) - start.z;
			zdist = zdiff / direction.z;
		} else if (direction.z < 0) {
			float zdiff = floor(start.z - 1.0) - start.z;
			zdist = zdiff / direction.z;
		}

		float power = 100 - 90*pow(1-fract(my_time*0.25*13./6000.), 5);
		power = min(power, 100 - 90*pow(1-fract( (my_time*0.25*13./6000.) + (0.30 * 13./6.)), 5));
		vec4 c;
		if (xdist <= ydist && xdist <= zdist) {
			start += direction * xdist;
			distanceTraveled += xdist;
			c = vec4(0.0, 
			         pow(1.0 - fract(abs(start.y)), power), 
					 pow(1.0 - fract(abs(start.z)), power), 
					 1.0);
		} else if (ydist <= zdist) {
			start += direction * ydist;
			distanceTraveled += ydist;
			c = vec4(pow(1.0 - fract(abs(start.x)), power), 0.0, pow(1.0 - fract(abs(start.z)), power), 1.0);
		} else {
			start += direction * zdist;
			distanceTraveled += zdist;
			c = vec4(pow(1.0 - fract(abs(start.x)), power), pow(1.0 - fract(abs(start.y)), power), 0.0, 1.0);
		}

		c *= pow(0.9, distanceTraveled);
		color += c;
	}

	my_out = color;
}