#version 330

uniform float my_time;
uniform sampler2D my_texture;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

const vec3 lampLightPosition = vec3(0.0, -10.0, 0.0);
const vec3 lampLightColor = vec3(0.5, 0.5, 0.0);
const vec3 ambientLightPosition1 = vec3(50.0, 0.0, -50.0);
const vec3 ambientLightColor1 = vec3(0.5, 0.0, 0.5);
const vec3 ambientLightPosition2 = vec3(-50.0, 0.0, -50.0);
const vec3 ambientLightColor2 = vec3(0.0, 0.5, 0.5);
const vec3 spectralLightPosition = vec3(0, 10, 50.);

const int maxLavaSteps = 1000;
const int maxFrustrumSteps = 1000;

float sdCone( vec3 p, vec2 c ) {
    float q = 20*length(p.xz);
    return dot(normalize(c),vec2(q,p.y));
}

float sdCappedCone( in vec3 p, in float h, in float r1, in float r2 )
{
    vec2 q = vec2( length(p.xz), p.y );
    
    vec2 k1 = vec2(r2,h);
    vec2 k2 = vec2(r2-r1,2.0*h);
    vec2 ca = vec2(q.x-min(q.x,(q.y < 0.0)?r1:r2), abs(q.y)-h);
    vec2 cb = q - k1 + k2*clamp( dot(k1-q,k2)/dot(k2,k2), 0.0, 1.0 );
    float s = (cb.x < 0.0 && ca.y < 0.0) ? -1.0 : 1.0;
    return s*sqrt( min(dot(ca,ca),dot(cb,cb)) );
}

float sdPlane( vec3 p, vec4 n ) {
	return dot(p,n.xyz) + n.w;
}

float smoothing(float x, float y) {
    return pow(1.0 - clamp(x/y,0.0,1.0), 5);
}

float blob(vec3 p, vec3 c, float size, float influence) {
    return size*smoothing(length(p-c), influence);
}

float lava(vec3 p) {
    vec3 b1 = vec3(0.8*cos(my_time/3000.0), ((1.0+cos(my_time/4000.0))/2.0)*4.-2., 0.4*sin(my_time/2000.0));
    vec3 b2 = vec3(0.4*sin(my_time/1500.0), ((1.0+cos(my_time/2000.0))/2.0)*3.-1.75, 0.2*cos(my_time/2000.));
    vec3 b3 = vec3(0.3*cos(my_time/1000.0), ((1.0+sin(my_time/3000.0))/2.0)*2.75-2.25, 0.3*cos(my_time/4000.0));
	vec3 b4 = vec3(0.6*sin(my_time/2000.0), ((1.0+cos(my_time/1500.0))/2.0)*2.5-1.5, 0.15*cos(my_time/3000.));
    return blob(p, b1, 2., 2.5) + 
	       blob(p, b2, 3., 3.5) + 
		   blob(p, b3, 2.5, 3.) +
		   blob(p, b4, 1., 1.5);
}

float lavaLamp(vec3 o, vec3 d) {
    float t=5.0;
	for(int i=0; i < maxLavaSteps; i++) {
	    vec3 p = o + t*d;
		float v = lava(p) - 0.5;
		if (v > 0.0) {
		    return t;
		}
		t += max(0.05, abs(v));
		if (t>100.0) {
		    return 0;
		}
	}
	return 0;
}

float sdTorus( vec3 p, vec2 t ) {
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float frustrums(vec3 p) {
	float f1 = sdCappedCone(p + vec3(0, 6, 0), 1, 0.5, 0.75);
	float f2 = sdCappedCone(p + vec3(0, -6, 0), 2.5, 2, 0.75);
	float f3 = sdCappedCone(p + vec3(0, -8.5, 0), 2.5, 0.75, 2);

	return min(f1, 
	       min(f2, f3));
//		   min(f3, f4)));
}

float glass(vec3 p) {
	return sdCappedCone(p + vec3(0, 0.75, 0), 6 - (3.5/2), 0.75, 2);
}

float frustrums(vec3 o, vec3 d) {
	float t = 0;
	for(int i = 0; i < maxFrustrumSteps; i++) {
		vec3 p = o + t*d;
		float v = frustrums(p);
		if (abs(v) < 0.1) {
			return t + v;
		}
		t += v;
		if (t > 500.0) {
			return 0;
		}
	}
	return 0;
}

float glass(vec3 o, vec3 d) {
	float t = 0;
	for(int i = 0; i < maxFrustrumSteps; i++) {
		vec3 p = o + t*d;
		float v = glass(p);
		if (abs(v) < 0.1) {
			return t;
		}
		t += v;
		if (t > 500.0) {
			return 0;
		}
	}
	return 0;
}

vec3 lavaNormal(vec3 p ) {
    float e = 0.0001;
	vec3 n = vec3(lava(vec3(p.x+e, p.y, p.z)),
	              lava(vec3(p.x, p.y+e, p.z)),
				  lava(vec3(p.x, p.y, p.z+e)));
	return normalize(n - vec3(lava(p)));
}

vec3 frustrumNormal(vec3 p) {
    float e = 0.0001;
	vec3 n = vec3(frustrums(vec3(p.x+e, p.y, p.z)),
	              frustrums(vec3(p.x, p.y+e, p.z)),
				  frustrums(vec3(p.x, p.y, p.z+e)));
	return normalize(n - vec3(frustrums(p)));
}

vec3 glassNormal(vec3 p) {
    float e = 0.0001;
	vec3 n = vec3(glass(vec3(p.x+e, p.y, p.z)),
	              glass(vec3(p.x, p.y+e, p.z)),
				  glass(vec3(p.x, p.y, p.z+e)));
	return normalize(n - vec3(glass(p)));
}

vec3 colorLava(vec3 p, vec3 color) {
	vec3 ln = lavaNormal(p);
    float diff = 1 + dot(ln, normalize(lampLightPosition - p));
	float ambientDiff1 = 1 + dot(ln, normalize(ambientLightPosition1 - p));
	float ambientDiff2 = 1 + dot(ln, normalize(ambientLightPosition2 - p));

	return (color + 
			(ambientDiff1 * ambientLightColor1 + 
			ambientDiff2 * ambientLightColor2)/2. + 
			2*diff * lampLightColor) / 4.;
}

vec3 brdf2(vec3 lightdir, vec3 eyedir,vec3 norm,vec3 color1,vec3 matParam)
{
  vec3 halfvec=normalize(eyedir+lightdir); // if both 1, div by 2?
  float roughSq=matParam.z*matParam.z,			// Precalc FFS!
	    lightContrib=max(0,dot(norm,lightdir)),
		rimContrib=max(0,dot(norm,halfvec)),
		k=rimContrib*rimContrib*(roughSq*roughSq-1)+1,
		hRoughSq=roughSq*.5;
  return lightContrib*( color1*(1-matParam.y)+ // diffuse
	                    matParam.x*
						roughSq*roughSq / (3.14*k*k) * // Trowbridge-Reitz NDF
						  (matParam.y + (1-matParam.y)*pow(1-max(0,dot(lightdir,halfvec)),5)) / // Schlick approx Fresnel
						    ((lightContrib*(1-hRoughSq)+hRoughSq)*(max(0,dot(norm,eyedir))*(1-hRoughSq)+hRoughSq)));
}

vec3 colorFrustrums(vec3 p, vec3 color, vec3 eyedir)
{
	vec3 material = vec3(.131/*4KS:MaterChromeSpec:3*/, .49/*4KS:MaterChromeFresnel:3*/, .43/*4KS:MaterChromeRough:3*/);
	return brdf2(normalize(spectralLightPosition - p), eyedir, frustrumNormal(p), color, material) +
		ambientLightColor1 * brdf2(normalize(ambientLightPosition1 - p), eyedir, frustrumNormal(p), color, material) +
		ambientLightColor2 * brdf2(normalize(ambientLightPosition2 - p), eyedir, frustrumNormal(p), color, material) +
		3.7/*4KS:Lamp*/ * lampLightColor * brdf2(normalize(vec3(0) - p), eyedir, frustrumNormal(p), color, material); // make sure interior of Frustrums is not black
		
}

vec3 colorGlass(vec3 p, vec3 color) {
	vec3 gn = glassNormal(p);
	float ambientDiff1 = 1.0 + dot(gn, normalize(ambientLightPosition1 - p));
	float ambientDiff2 = 1.0 + dot(gn, normalize(ambientLightPosition2 - p));
	float lampDiff = 1.0 + dot(gn, normalize(lampLightPosition - p));

	return (color + 
			ambientDiff1 * ambientLightColor1 + 
			ambientDiff2 * ambientLightColor2 + 
			lampDiff * lampLightColor) / 4.;
}

void rot(inout vec2 s, float v)
{
	s = vec2(cos(v)*s.x + sin(v)*s.y, -sin(v)*s.x + cos(v)*s.y);
}

void main() {
	vec2 pixel = ( (texCoord.xy - 0.5) * vec2(resX/resY));
	vec3 rd = normalize(vec3( vec2(pixel.x * resX / resY, pixel.y)*0.6, -1.0));
	vec3 ro = vec3(0, 0, 5.*sin(my_time/1700/*4KS:ZoomSpeed*/) + 15);

	ro -= vec3(0/*4KS:CamX*/, 0/*4KS:CamY*/, 0/*4KS:CamZ*/);

	rot(ro.yz, .2*sin(my_time / 2000/*4KS:RotateSpeed*/));
	rot(rd.yz, .2*sin(my_time / 2000/*4KS:RotateSpeed*/));

	rot(ro.xz, my_time / 1299/*4KS:TiltupdownSpeed*/);
	rot(rd.xz, my_time/1299/*4KS:TiltupdownSpeed*/);

	ro.z += 3;

	float t;
    vec3 rgb = vec3(0,0,0);
	float lavaDistance = lavaLamp(ro, rd);
	float glassDistance = glass(ro, rd);
	if (lavaDistance > 0.0 && glassDistance > 0.0) {
	    rgb = colorLava(ro + lavaDistance*rd, vec3(0.95,0.25,0.0));
	} else if (glassDistance > 0.0) {
		rgb = colorGlass(ro + glassDistance*rd, rgb);
	}

    t = frustrums(ro, rd);
    if (t > 0) {
  	  vec3 pos = ro + t*rd;
	  rgb = colorFrustrums(ro + t*rd, vec3(212./255., 175./255., 0./255.), - rd); 
   }

   	float fadeIn = 1000.0-my_time;
	if (fadeIn > 0) {
		fadeIn = fadeIn/1000.0;
	} else {
		fadeIn = 0;
	}

	float fadeOut = (16.0*4.0*60000.0/130.0) - 1000.0 - my_time;
	if (fadeOut > 0) {
		fadeOut = 0;
	} else {
		fadeOut = -fadeOut/1000.0;
	}
    my_out=vec4(mix(mix(rgb, vec3(0), fadeIn), vec3(0), fadeOut), 1.0);
}