#version 330

uniform float my_time;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

float v=.0008*my_time, mat;

void rot(inout vec2 w,float h)
{
  w=w*cos(h)+sin(h)*vec2(w.y,-w.x);
}

float smoothm(float a, float b, float k)
{
	float h = clamp(.5 - .5*(b - a) / k, 0, 1);
	return mix(b, a, h) + k*h*(1 - h);
}

 float rand(float v)
 {
	return fract(v*6.97/*4KS:Rand_Seed1:5*/*fract(v*123.47/*4KS:Rand_Seed2:5*/));
}

// "random" grid-aligned noise between -.5 and .5
float noise(vec3 x) 
{ 
	vec3 v=floor(x);
	x-=v;
	x*=x*(3-2*x); 
	float m=v.x// scale factor 1 is fixed here 
		  +v.y*19+38*v.z; 
	
	return mix(mix(mix(rand(m+18),
					   rand(m+19),x.x),
				   mix(rand(m+37),
				       rand(m+38),x.x),x.y),
			   (x.z > 0.0)?mix(mix(rand(m+56),
						   rand(m+57),x.x),
					   mix(rand(m+75),
					       rand(m+76),x.x),x.y):0,x.z)-.5;
} 

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float scene(vec3 r) // distance
{
	float v2 = smoothm( 0, v - 4.9/*4KS:RotateFullSpeed*/, 1/*4KS:RotateSmooth*/);

	// terrain

	float d=r.y;
	mat = 0;

	// base
	float x = max(length(r.xz) - 2.5/*4KS:BaseRadius*/, r.y - 1/*4KS:BaseHeight*/);
	if ( x<d)
		d=x, mat=2;

	// outer holder
	r.y+=-5.5/*4KS:HolderHeight*/;
	x = max( sdTorus(r.xzy, vec2(4.8/*4KS:HolderRadius*/,.19/*4KS:HolderThickness*/)),  r.y );
	x = min(x, length(r.yz)- .06/*4KS:Orbit1Thickness*/);
	x = max(x, length(r)- (4.8/*4KS:HolderRadius*/+.19/*4KS:HolderThickness*/));
	x = max(x, -length(r)+ (3.9/*4KS:Orbit1Radius*/+.06/*4KS:Orbit1Thickness*/));

	// orbit 1
	rot(r.zy, 2/*4KS:Orbit1Amplitude*/*sin(v2*3/*4KS:Orbit1Speed*/));
	x = min(x, sdTorus(r.xzy, vec2(3.9/*4KS:Orbit1Radius*/,.06/*4KS:Orbit1Thickness*/)));
	x = min(x, length(r+(3.9/*4KS:Orbit1Radius*/+.15/*4KS:PusherRadius*/)*vec3(0,-1,0))-.15/*4KS:PusherRadius*/);

	x = min(x, max(r.y,
				max(
					max(-length(r)+ 3.9/*4KS:Orbit1Radius*/+.06/*4KS:Orbit1Thickness*/,
					    length(r)- 3.9/*4KS:Orbit1Radius*/-.06/*4KS:Orbit1Thickness*/-.4/*4KS:MagnetThickness*/
					   ),									    
					length(r.xz)-.3/*4KS:MagnetRadius*/
					)
				   ));

	// axis
	rot(r.xy, .45/*4KS:AxisAngle*/);
	x=min(x, max(length(r)- (3.9/*4KS:Orbit1Radius*/+.06/*4KS:Orbit1Thickness*/),length(r.xz)-.06/*4KS:Orbit1Thickness*/));

	// orbit 2
	rot(r.xz, v2*1.7/*4KS:Orbit2Speed*/);
	x = min(x, sdTorus(r.xzy, vec2(3/*4KS:Orbit2Radius*/,.04/*4KS:Orbit2Thickness*/)));

	x = min(x, length(r+3/*4KS:Orbit2Radius*/*vec3(1,0,0))-.2/*4KS:Planet2Radius*/);
	x = min(x, length(r+3/*4KS:Orbit2Radius*/*vec3(-1,0,0))-.2/*4KS:Planet2Radius*/);
	
	
	// orbit 3
	rot(r.xz, v2*0.95/*4KS:Orbit3Speed*/);
	x = min(x, sdTorus(r.xzy, vec2(2.2/*4KS:Orbit3Radius*/,.04/*4KS:Orbit3Thickness*/)));
	x = min(x, length(r+2.2/*4KS:Orbit3Radius*/*vec3(.70,.71,0))-.2/*4KS:Planet2Radius*/);
	x = min(x, length(r+2.2/*4KS:Orbit3Radius*/*vec3(cos(2.7),sin(2.7),0))-.2/*4KS:Planet2Radius*/);
	x = min(x, length(r+2.2/*4KS:Orbit3Radius*/*vec3(cos(5),sin(5),0))-.2/*4KS:Planet2Radius*/);

	// orbit 4

	rot(r.xz, v2*.58/*4KS:Orbit4Speed*/);
	x = min(x, sdTorus(r.xzy, vec2(1.4/*4KS:Orbit4Radius*/,.04/*4KS:Orbit4Thickness*/)));
	x = min(x, length(r+1.4/*4KS:Orbit4Radius*/*vec3(cos(-.7),sin(-.7),0))-.2/*4KS:Planet2Radius*/);
	x = min(x, length(r+1.4/*4KS:Orbit4Radius*/*vec3(-cos(-.7),-sin(-.7),0))-.2/*4KS:Planet2Radius*/);


	x = min(x, length(r)-.5/*4KS:Planet5Radius*/);

	if ( x<d)
		d=x, mat=1;

	return d;
}



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// x= specular brightness? Range .1 to .3
// matParam.y = F0 fresnel 
// matParam.z = Roughness (Alpha) in Trowbridge-Reitz NDF (Normal Distribution function)
vec3 brdf2(vec3 lightdir, vec3 eyedir,vec3 norm,vec3 color1,vec3 matParam)
{
  vec3 halfvec=normalize(eyedir+lightdir); // if both 1, div by 2?
  float roughSq=matParam.z*matParam.z,			// Precalc FFS!
	    lightContrib=max(0,dot(norm,lightdir)),
		rimContrib=max(0,dot(norm,halfvec)),
		k=rimContrib*rimContrib*(roughSq*roughSq-1)+1,
		hRoughSq=roughSq*.5;
  return lightContrib*( color1*(1-matParam.y)+ // diffuse
	                    matParam.x*
						roughSq*roughSq / (3.14*k*k) * // Trowbridge-Reitz NDF
						  (matParam.y + (1-matParam.y)*pow(1-max(0,dot(lightdir,halfvec)),5)) / // Schlick approx Fresnel
						    ((lightContrib*(1-hRoughSq)+hRoughSq)*(max(0,dot(norm,eyedir))*(1-hRoughSq)+hRoughSq)));
}

void GetMaterial(vec3 p, float tmat, inout vec3 t, out vec3 matcol, out vec3 matprop, out vec3 emissive) //
{	
	if( tmat==0) // table	
	{	
		// generic wavy pattern
		p.x += 1.8/*4KS:MaterWoodWave1Ampl*/*sin(p.z*9.3/*4KS:MaterWoodWave1Freq*/);

		p.z += .1/*4KS:MaterWoodWaveNoiseAmpl*/*noise(p*.75/*4KS:MaterWoodWaveNoiseScale*/);

		p.x += 60/*4KS:MaterWoodWave2Ampl*/*sin(p.z*1/*4KS:MaterWoodWave2Freq*/);

		// nerves
		float intensity = pow(max(0,.36/*4KS:MaterWoodNerveOffset*/+.66/*4KS:MaterWoodNerveAmpl*/*sin(p.x*1.13/*4KS:MaterWoodNerveFreq*/)),11/*4KS:MaterWoodNervePow*/);
		// micro grain
		intensity += .7/*4KS:MaterWoodGrainAmpl*/*noise(p*17/*4KS:MaterWoodGrainScale*/);
		// darkening
		intensity += 2.5/*4KS:MaterWoodStainAmpl*/*noise(p*.2/*4KS:MaterWoodStainScale*/);
		
		matcol = 0.01*mix(vec3(.83/*4KS:MaterWood0ColR*/,.48/*4KS:MaterWood0ColG*/,.16/*4KS:MaterWood0ColB*/),
						  vec3(.45/*4KS:MaterWood1ColR*/,.15/*4KS:MaterWood1ColG*/,.09/*4KS:MaterWood1ColB*/),
						  max(0, min(1,intensity)));


		matprop = vec3(.016/*4KS:MaterWood0Spec:3*/,.261/*4KS:MaterWood0Fresnel:3*/,.656/*4KS:MaterWood0Rough:3*/);	

	}
	if( tmat==1) // chrome
	{		
		matcol = 0.01*vec3(.21/*4KS:MaterChromeColR*/,.21/*4KS:MaterChromeColG*/,.21/*4KS:MaterChromeColB*/);
		matprop = vec3(.008/*4KS:MaterChromeSpec:3*/,.153/*4KS:MaterChromeFresnel:3*/,.18/*4KS:MaterChromeRough:3*/);	
	}	

	if( tmat==2) // pedestal. TODO: marble?
	{		
		matcol = 0.01*vec3(.02/*4KS:MaterPedestalColR*/,.02/*4KS:MaterPedestalColG*/,.02/*4KS:MaterPedestalColB*/);
		matprop = vec3(.001/*4KS:MaterPedestalSpec:3*/,.002/*4KS:MaterPedestalFresnel:3*/,.233/*4KS:MaterPedestalRough:3*/);	
	}	
	
}

float soft;
float FindDistance( vec3 m, vec3 g, float nrSteps, float maxDist, float pixelRadius, out float skyHit, out vec3 p)
{
	soft=4/*4KS:ShadowSoftness*/;
	
	skyHit = 0; // reuse skyhit as distance travelled
	float candidate_error = 1000;
	float candidate_t = .01/*4KS:HitDist*/; // TODO: does this make sense, or set to 0?
	float candidate_z = maxDist;
	
	for (float i = 0; i < nrSteps; ++i)
	{
		float signedRadius = scene(m*skyHit + g);
	
		float error = abs(signedRadius) / skyHit;
		if ( error < candidate_error) 
		{
			candidate_t = skyHit;
			candidate_error = error;
			candidate_z = signedRadius;
		}
		if (error < pixelRadius || skyHit > maxDist)
			break;

		soft = min( soft, (13/*4KS:ShadowSharpness*/*signedRadius)*(1./skyHit));

		skyHit += signedRadius;
	}

	
	 if (skyHit > maxDist || candidate_error > pixelRadius*4/*4KS:RMM_PixelsCorrection*/ )
	 {
		 p=m*skyHit+g; // SkyHit
		 skyHit = 1;
	 }
	 else
	 {
		soft=0;
		p = m*candidate_t + g;
		skyHit = 0;
	 }

	 return candidate_z;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main()
{
	vec2 m2=(2*gl_FragCoord.xy/vec2(resX,resY)-1)*vec2(resX/resY,1);


	float waveOutStart = 13*4.0*60000.0/130.0;
	float effectEnd = 14.0*4.0*60000.0/130;
	if( my_time > waveOutStart ) {
		float waveAmp = log(1-(my_time - waveOutStart)/(effectEnd-waveOutStart));
		m2.x += waveAmp * 2.0 * sin((m2.y + my_time/2000.0)*8.);

	}

	float z;
	float e=0;
	
	vec3 m=normalize(vec3(m2, 3.51/*4KS:CamFOV*/)),	

		//todo: move light
	sunL=normalize(vec3(+1.59/*4KS:SunX*/,1.95/*4KS:SunY*/,-1.11/*4KS:SunZ*/));
		
	// camera
	vec3 g;
	g = vec3( 0, +5.5/*4KS:HolderHeight*/, 0) + vec3(-8.92/*4KS:CamX*/, 8/*4KS:CamY*/, -16.7/*4KS:CamZ*/) * mix(1, .3+.2*sin(v), smoothstep(0, 10, v));

	float camRot = smoothm(0, v-3/*4KS:CamRotFullspeed*/, 2/*4KS:CamRotSmooth*/);
	rot(g.xz, -camRot);
	rot(m.zy,+.47/*4KS:CamLookdown*/ + smoothstep(9, 22, v)*.07*cos(v*.3));
	rot(m.xz,+.6/*4KS:CamLookLeft*/+ smoothstep(5, 20, v)*.4*cos(v*.8) );
	rot(m.xz, -camRot);
	
	
	g+=.03/*4KS:CamMotionNoiseAmpl*/*vec3(noise(vec3(g.xy,3*v*1.5/*4KS:CamMotionNoiseFreq*/)),
										 noise(vec3(g.x,2*v*1.5/*4KS:CamMotionNoiseFreq*/,g.z)),
										 noise(vec3(v*1.5/*4KS:CamMotionNoiseFreq*/,g.yz)));

	
	vec3 i= vec3(0), // cummulative color current ray
		p, // endpoint ray 1
	
		start = g,
		dir = m,
		pt = g;
	
	vec3 reflectInt=vec3(1);
	for (float ray = 0; ray <4/*4KS:NrRays*/; ray++)
	{
		vec3 matcol, matprop, tempcol;
	
		float skyHit;
		z=FindDistance(dir, start, 240./*4KS:RayMarchSteps1:f*/, 1300./*4KS:Horizon:f*/, (.11/*4KS:RMM_PixelRad:3*/+ray*4/*4KS:RMM_PixelRadRefl:3*/) / (.5*resY), skyHit, pt);
	 
		float tmat = mat;
		
		vec3 t,a=vec3(.91/*4KS:SkyColR*/,.91/*4KS:SkyColG*/,1/*4KS:SkyColB*/)+// blue sky
			(ray==0?
			25/*4KS:SunIntensity*/*vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/)*pow(max(dot(dir,sunL),.0),200/*4KS:SunSize:0*/):vec3(0)); // yellow sun

		float occ=1;
		
		t=normalize(vec3(scene(pt+vec3(.0001/*4KS:RM_Epsilon:5*/,0,0)),
							  scene(pt+vec3(0,.0001/*4KS:RM_Epsilon:5*/,0)),
							  scene(pt+vec3(0,0,.0001/*4KS:RM_Epsilon:5*/)))-z); //normal

		vec3 emissive = vec3(0);

		// inline?
		GetMaterial(pt, tmat, t, matcol, matprop, emissive);
			
		for(e=1;e<6;e++)
			occ-=(e*.3/*4KS:AO_Intense*/-scene(pt+t*e*.3/*4KS:AO_Distance*/))/pow(2/*4KS:AO_Falloff*/,e);
	
		float temp1;
		vec3 temp2;
		FindDistance( sunL, pt+t*.01/*4KS:HitDist*/*3/*4KS:ShadowJumpstart*/, 70./*4KS:ShadowSteps:f*/, 50./*4KS:ShadowMaxDist:f*/, (4/*4KS:RMM_PixelRadShad:3*/+ray*4/*4KS:RMM_PixelRadRefl:3*/) / (.5*resY) / (.5*resY) , temp1, temp2);

		tempcol =max( // sun Intensity
					brdf2(sunL, -dir, t, matcol, matprop ) * 25/*4KS:SunIntensity*/*pow(vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/)
					  									   * vec3(clamp( soft, 0,1) ),
																 vec3(1/*4KS:SunShadowR*/,.9/*4KS:SunShadowG*/,.8/*4KS:SunShadowB*/))
					// Sky Intensity: don't use brdf or you get extra specular highlight. Just use normal.y!
				  + occ * (t.y+1) * matcol * 10.14/*4KS:SkyIntensity*/*vec3(.91/*4KS:SkyColR*/,.91/*4KS:SkyColG*/,1/*4KS:SkyColB*/)

				 // emmisive
				  + emissive,
				  0.);
			
		if(skyHit > 0.0) // pure sky
			tempcol=a;

		vec3 fog=mix(a,// sky sun horizonfog
				25/*4KS:SunIntensity*/*vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/),// yellowish
				pow(max(dot(dir,sunL),.0),200/*4KS:SunSize:0*/));

		tempcol=mix(tempcol,fog,1.-exp(-length(pt.xz-start.xz)*.002/*4KS:FogPower:4*/));
			
		
			i+= reflectInt * tempcol; // add contribution of current ray			
			p = pt;

			if ( matprop.z < .5 && skyHit==0 && ray < 4/*4KS:NrRays*/ - 1)
			{
				vec3 refdir = reflect(dir,t);
				reflectInt *= occ*brdf2(refdir, -dir, t, matcol, matprop); // 

				dir = refdir;
				pt += dir*(z+.1/*4KS:ReflectionJumpstart*/);
				start = pt;
			}
			else break;
	}	

	float rf2_1=dot(m2,m2)*.1/*4KS:PostVignettingAmount*/+1/*4KS:PostVignettingFade*/;

	float c = 2000.0-my_time;
	if (c > 0) {
		c = c/2000.0;
	} else {
		c = 0;
	}

	my_out = vec4(pow(i*(1-.2/*4KS:PostGrainAmount*/+.2/*4KS:PostGrainAmount*/*rand(dot(m2,m2)*1000/*4KS:PostGrainScaling*/+v)),
						 vec3(.45/*4KS:PostLightToneMapping*/))/(rf2_1*rf2_1), 1.0);
	my_out = mix(my_out, vec4(1.0), c);
}