
RENDER_GEAR_CX			FDB 64
RENDER_GEAR_CY			FDB	40
RENDER_GEAR_MINRAD		FDB	48
RENDER_GEAR_MAXRAD		FDB	56
RENDER_GEAR_LOWSTEP		FCB	10
RENDER_GEAR_HIGHSTEP	FCB	6	; LOWSTEP+HIGHSTEP must be 256/N
RENDER_GEAR_ANGLE0		FCB	0
RENDER_GEAR_INSIDECIRCLE_RAD	FDB	30

RENDER_GEAR_LINEBUF		EQU	COMMON_LINEBUFPTR

RENDER_GEAR			PSHS	A,B,X,Y,U
					CLR		RENDER_GEAR_I,PCR
					CLR		RENDER_GEAR_LINECOUNT,PCR
					CLR		RENDER_GEAR_END,PCR

					LDU		#RENDER_GEAR_LINEBUF
					CLR		,U+
					CLR		,U+
					LDA		#80
					STA		,U+
					CLR		,U
					INC		,U+
					CLR		,U+		; Line count

					LDY		#0

					LDA		RENDER_GEAR_I,PCR
					ADDA	RENDER_GEAR_ANGLE0,PCR
					STA		ROTATE2D_A

					LDX		RENDER_GEAR_MINRAD,PCR
					STX		ROTATE2D_X,PCR
					STY		ROTATE2D_Y,PCR

					LBSR	ROTATE2D

					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+

RENDER_GEAR_LOOP
					CLRA
					LDB		RENDER_GEAR_I,PCR
					ADDB	RENDER_GEAR_LOWSTEP,PCR
					ADCA	RENDER_GEAR_END,PCR
					STA		RENDER_GEAR_END,PCR
					STB		RENDER_GEAR_I,PCR


					; Tangential-low
					LDA		RENDER_GEAR_I,PCR
					ADDA	RENDER_GEAR_ANGLE0,PCR
					STA		ROTATE2D_A

					LDX		RENDER_GEAR_MINRAD,PCR
					STX		ROTATE2D_X,PCR
					STY		ROTATE2D_Y,PCR

					LBSR	ROTATE2D

					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+
					INC		RENDER_GEAR_LINECOUNT,PCR


					; Vertical
					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+

					LDA		RENDER_GEAR_I,PCR
					ADDA	RENDER_GEAR_ANGLE0,PCR
					STA		ROTATE2D_A

					LDX		RENDER_GEAR_MAXRAD,PCR
					STX		ROTATE2D_X,PCR
					STY		ROTATE2D_Y,PCR

					LBSR	ROTATE2D

					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+
					INC		RENDER_GEAR_LINECOUNT,PCR


					; First point of the tangential (High)
					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+

					CLRA
					LDB		RENDER_GEAR_I,PCR
					ADDB	RENDER_GEAR_HIGHSTEP,PCR
					ADCA	RENDER_GEAR_END,PCR
					STA		RENDER_GEAR_END,PCR
					STB		RENDER_GEAR_I,PCR

					; Second point of the tangential (High)
					LDA		RENDER_GEAR_I,PCR
					ADDA	RENDER_GEAR_ANGLE0,PCR
					STA		ROTATE2D_A

					LDX		RENDER_GEAR_MAXRAD,PCR
					STX		ROTATE2D_X,PCR
					STY		ROTATE2D_Y,PCR

					LBSR	ROTATE2D

					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+
					INC		RENDER_GEAR_LINECOUNT,PCR

					; Vertical 
					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+

					LDA		RENDER_GEAR_I,PCR
					ADDA	RENDER_GEAR_ANGLE0,PCR
					STA		ROTATE2D_A

					LDX		RENDER_GEAR_MINRAD,PCR
					STX		ROTATE2D_X,PCR
					STY		ROTATE2D_Y,PCR

					LBSR	ROTATE2D

					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+
					INC		RENDER_GEAR_LINECOUNT,PCR

					; First point of the next tangential (Low)
					LDD		ROTATE2D_X,PCR
					ADDD	RENDER_GEAR_CX,PCR
					STD		,U++
					LDD		ROTATE2D_Y,PCR
					ASRA
					RORB
					ADDD	RENDER_GEAR_CY,PCR
					STB		,U+

					TST		RENDER_GEAR_END,PCR
					LBEQ	RENDER_GEAR_LOOP

RENDER_GEAR_LOOPOUT

					LDA		RENDER_GEAR_LINECOUNT,PCR
					STA		RENDER_GEAR_LINEBUF+4

					LDU		#COMMON_LINEBUFPTR
					STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					LDX		#$8000
					STX		,U
					LBSR	CALL_LINEDDA_SUBCPU ; CALL_CLS_AND_LINEDDA_SUBCPU
					LDX		#$4000
					STX		,U
					LBSR	CALL_LINEDDA_SUBCPU ; CALL_CLS_AND_LINEDDA_SUBCPU


					LDX		RENDER_GEAR_CX,PCR
					STX		DRAW_CIRCLE_SUBCPU_CX,PCR
					LDX		RENDER_GEAR_CY,PCR
					STX		DRAW_CIRCLE_SUBCPU_CY,PCR
					LDX		RENDER_GEAR_INSIDECIRCLE_RAD,PCR
					STX		DRAW_CIRCLE_SUBCPU_R,PCR
					LDX		#COMMON_LINEBUFPTR
					STX		DRAW_CIRCLE_BUFFADDR,PCR

					LDX		#$4000
					STX		DRAW_CIRCLE_VRAMADDR,PCR
					LBSR	DRAW_CIRCLE_SUBCPU
					LDX		#$8000
					STX		DRAW_CIRCLE_VRAMADDR,PCR
					LBSR	DRAW_CIRCLE_SUBCPU


					PULS	A,B,X,Y,U,PC



RENDER_GEAR_I			FCB	0
RENDER_GEAR_LINECOUNT	FCB	0
RENDER_GEAR_END			FCB	0
