					; Requires: subcpu.asm, linedda.asm


					EXPORT		INSTALL_LINEDDA_IN_SUBCPU

					EXPORT		LINEDDA_IN_SUBCPU_BUFFER

					EXPORT		CALL_LINEDDA_SUBCPU_DATAADDR
					EXPORT		CALL_LINEDDA_SUBCPU


; From $6800 up to 255 16-bit (X,Y)s. (Not 256 due to first 5 bytes.)
LINEDDA_IN_SUBCPU_BUFFER	EQU	COMMON_LINEBUFPTR


INSTALL_LINEDDA_IN_SUBCPU
					; LINEDDA_INPUTADDR -> SubCPU $C000
					; Address to Call	-> SubCPU $C002
					; Size LINEDDA_LASTADDR-LINEDDA_INPUTADDR

					PSHS		A,B,X

					LDX			LINEDDA_BITA_D409,PCR
					LDA			LINEDDA_BITA_D409+2,PCR
					STX			LINEDDAM_VRAMACCESSON,PCR
					STA			LINEDDAM_VRAMACCESSON+2,PCR

					LDX			LINEDDA_STA_D409,PCR
					LDA			LINEDDA_STA_D409+2,PCR
					STX			LINEDDAM_VRAMACCESSOFF,PCR
					STA			LINEDDAM_VRAMACCESSOFF+2,PCR


					; Data will be from SubCPU $C700
					LDX			#$C700
					STX			LINEDDAM_INPUTADDR,PCR

					LEAX		LINEDDAM_INPUTADDR,PCR
					STX			MAIN_TO_SUB_MAINADDR,PCR

					LDX			#$C000
					STX			MAIN_TO_SUB_SUBADDR,PCR

					LDX			#(LINEDDA_LASTADDR-LINEDDAM_INPUTADDR)
					STX			MAIN_TO_SUB_LENGTH,PCR

					LBSR		MAIN_TO_SUB


					LDX			#$1212 ; NOPNOP
					LDA			#$12 ; NOP
					STX			LINEDDAM_VRAMACCESSON,PCR
					STA			LINEDDAM_VRAMACCESSON+2,PCR
					STX			LINEDDAM_VRAMACCESSOFF,PCR
					STA			LINEDDAM_VRAMACCESSOFF+2,PCR

					PULS		A,B,X
					RTS

CALL_LINEDDA_SUBCPU_DATAADDR	FDB			0
CALL_LINEDDA_SUBCPU	PSHS	A,B,X
					LDX		#$C700
					STX		MAIN_TO_SUB_SUBADDR,PCR

					LDX		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					STX		MAIN_TO_SUB_MAINADDR,PCR

					LDA		#6
					LDB		4,X
					MUL
					ADDD	#5
					STD		MAIN_TO_SUB_LENGTH,PCR

					LBSR	MAIN_TO_SUB

					LDX		#$C002
					STX		CALL_SUB_CPU_ADDR,PCR
					LBSR	CALL_SUB_CPU

					PULS	A,B,X
					RTS


CALL_CLS_AND_LINEDDA_SUBCPU
					PSHS	A,B,X
					LDX		#$C700
					STX		MAIN_TO_SUB_SUBADDR,PCR

					LDX		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
					LDD		,X ; VRAMADDR
					STD		CLEAR_BITPLANE_VRAMADDR,PCR

					STX		MAIN_TO_SUB_MAINADDR,PCR

					LDA		#6
					LDB		4,X
					MUL
					ADDD	#5
					STD		MAIN_TO_SUB_LENGTH,PCR

					LBSR	MAIN_TO_SUB

					LDX		#$C002
					STX		CALL_SUB_CPU_ADDR,PCR
					LBSR	CLS_AND_CALL_SUB_CPU

					PULS	A,B,X
					RTS


