
SPRING0			FDB		50	; X coord
				FCB		92	; L0
				FCB		100	; L
				FCB		0	; Phase shift
SPRING1			FDB		185	; X coord
				FCB		92	; L0
				FCB		100	; L
				FCB		32	; Phase shift
SPRING2			FDB		320	; X coord
				FCB		92	; L0
				FCB		100	; L
				FCB		64	; Phase shift
SPRING3			FDB		455	; X coord
				FCB		92	; L0
				FCB		100	; L
				FCB		96	; Phase shift
SPRING4			FDB		590	; X coord
				FCB		92	; L0
				FCB		100	; L
				FCB		128	; Phase shift


SPRINGDEMO_MUSICSTOP	FDB	BGM_FIRST_THEME_END
SPRINGDEMO_PHASE	FCB	0
SPRINGDEMO_VRAMADDR	FDB	0

SPRINGDEMO		PSHS	A,B,X,Y,U
				LBSR	PSGPLAY_GET_10MS_TICK
				STD		SPRINGDEMO_TIMER0

SPRINGDEMO_MAINLOOP
				BSR		SPRINGDEMO_MOVE_ONESTEP
				LBSR	SPRINGDEMO_UPDATE_MESSAGE
				LBSR	SPRINGDEMO_RENDER
				LBSR	SPRINGDEMO_SWAPBUFFERS

				LDA		$FD04
				BITA	#2
				BEQ		SPRINGDEMO_END				

				LBSR	PSGPLAY_GET_COUNTER
				CMPD	SPRINGDEMO_MUSICSTOP,PCR
				BLE		SPRINGDEMO_MAINLOOP

SPRINGDEMO_END	PULS	A,B,X,Y,U,PC



SPRINGDEMO_MOVE_ONESTEP
				;LEAX	SPRING0,PCR
				;BSR		SPRINGDEMO_MOVE_ONESPRING
				LEAX	SPRING1,PCR
				BSR		SPRINGDEMO_MOVE_ONESPRING
				LEAX	SPRING2,PCR
				BSR		SPRINGDEMO_MOVE_ONESPRING
				LEAX	SPRING3,PCR
				BSR		SPRINGDEMO_MOVE_ONESPRING
				;LEAX	SPRING4,PCR
				;BSR		SPRINGDEMO_MOVE_ONESPRING

				LDA		#24
				ADDA	SPRINGDEMO_PHASE,PCR
				STA		SPRINGDEMO_PHASE,PCR

				LDA		SPRING_NEXTCOLOR,PCR
				INCA
				CMPA	#5
				BLE		SPRINGDEMO_UPDATE_COLOR
				LDA		#1
SPRINGDEMO_UPDATE_COLOR
				STA		SPRING_NEXTCOLOR,PCR

				RTS

SPRINGDEMO_MOVE_ONESPRING
				LDB		2,X
				LSRB
				CLRA
				STD		SIN_MULTIPLIER,PCR
				LDA		4,X
				ADDA	SPRINGDEMO_PHASE,PCR
				STA		SIN_ANGLE,PCR
				LBSR	CALC_SIN

				LDD		SIN_MULTIPLIER,PCR
				ADDB	2,X
				STB		3,X
				RTS



SPRINGDEMO_RENDER
				LEAY	COMMON_LINEBUFPTR,PCR

				; 2  PTR    VRAM ADDRESS
				; 1  UCHAR  BYTES PER LINE
				; 1  UCHAR  Must be 1
				; 1  UCHAR  # LINES
				; 2  UINT   X0
				; 1  UINT   Y0
				; 2  UINT   X1
				; 1  UINT   Y1
				;     :
				;     :
				;     :

				LDD		SPRINGDEMO_VRAMADDR,PCR
				STD		,Y++
				LDA		#80
				STA		,Y+
				LDA		#1
				STA		,Y+
				CLR		,Y+	; COMMON_LINEBUFPTR+4 = # of lines

				;LEAX	SPRING0,PCR
				;LBSR	SPRINGDEMO_RENDER_ONESPRING
				LEAX	SPRING1,PCR
				LBSR	SPRINGDEMO_RENDER_ONESPRING
				LEAX	SPRING2,PCR
				BSR		SPRINGDEMO_RENDER_ONESPRING
				LEAX	SPRING3,PCR
				BSR		SPRINGDEMO_RENDER_ONESPRING
				;LEAX	SPRING4,PCR
				;BSR		SPRINGDEMO_RENDER_ONESPRING

				RTS



SPRINGDEMO_RENDER_ONESPRING

				LDA		3,X		; Current length
				LSRA
				LSRA
				STA		SPRING_MINY,PCR

				LDU		,X
				STU		,Y++
				CLR		,Y+
				STU		,Y++
				STA		,Y+

				NEGA
				ADDA	3,X
				STA		SPRING_MAXY,PCR

				LDU		,X
				STU		,Y++
				STA		,Y+
				STU		,Y++
				LDA		3,X
				STA		,Y+

				INC		COMMON_LINEBUFPTR+4,PCR
				INC		COMMON_LINEBUFPTR+4,PCR

				LDA		SPRING_MAXY,PCR
				SUBA	SPRING_MINY,PCR
				LBCS	SPRINGDEMO_RENDER_ONESPRING_END
				LBEQ	SPRINGDEMO_RENDER_ONESPRING_END

				STA		SPRING_BALANCE,PCR
				LEAU	SPRING_YOFFSET,PCR

				; MID HIGH MID LOW MID HIGH ....
				;    1    1   1   1   1    segments
				; 16 segments
				; Run DDA (0,0)-(16,MAXY-MINY)
				LDA		SPRING_MINY,PCR
				STA		SPRING_Y,PCR
				LDA		SPRING_BALANCE,PCR
				LDB		#16
				STB		SPRING_SEG_REMAIN,PCR
SPRINGDEMO_MAKE_OFFSET_LOOP_OUTER
				SUBA	#16
				BCC		SPRINGDEMO_MAKE_OFFSET_LOOP_POSITIVEBALANCE

SPRINGDEMO_MAKE_OFFSET_LOOP_INNER
				LDB		SPRING_Y,PCR
				STB		,U+
				DEC		SPRING_SEG_REMAIN,PCR
				BEQ		SPRINGDEMO_MAKE_OFFSET_LOOP_BREAK
				ADDA	SPRING_BALANCE,PCR
				BCC		SPRINGDEMO_MAKE_OFFSET_LOOP_INNER

SPRINGDEMO_MAKE_OFFSET_LOOP_POSITIVEBALANCE
				INC		SPRING_Y,PCR
				BRA		SPRINGDEMO_MAKE_OFFSET_LOOP_OUTER
SPRINGDEMO_MAKE_OFFSET_LOOP_BREAK


				LDD		,X
				STD		SPRING_LASTX,PCR
				LDA		SPRING_MINY,PCR
				STA		SPRING_LASTY,PCR
				LDB		#8
				STB		SPRING_SEG_REMAIN,PCR
				LEAU	SPRING_YOFFSET,PCR
SPRINGDEMO_ADD_SPRING_SCHEMATIC_LOOP
				LDD		SPRING_LASTX,PCR
				STD		,Y++
				LDA		SPRING_LASTY,PCR
				STD		,Y+

				LDD		,X
				ADDD	SPRING_XOFFSET,PCR
				STD		,Y++
				STD		SPRING_LASTX,PCR
				LDB		,U++
				STB		,Y+
				STB		SPRING_LASTY,PCR

				INC		COMMON_LINEBUFPTR+4,PCR

				LDD		#0
				SUBD	SPRING_XOFFSET,PCR
				STD		SPRING_XOFFSET,PCR

				DEC		SPRING_SEG_REMAIN,PCR
				BNE		SPRINGDEMO_ADD_SPRING_SCHEMATIC_LOOP

				LDD		SPRING_LASTX,PCR
				STD		,Y++
				LDA		SPRING_LASTY,PCR
				STA		,Y+
				LDD		,X
				STD		,Y++
				LDA		SPRING_MAXY,PCR
				STA		,Y+

				INC		COMMON_LINEBUFPTR+4,PCR

				LDU		,X
				LEAU	-32,U
				LDA		3,X

				STU		,Y++
				STA		,Y+
				LEAU	64,U
				STU		,Y++
				STA		,Y+
				INC		COMMON_LINEBUFPTR+4,PCR

				STU		,Y++
				STA		,Y+
				ADDA	#32
				STU		,Y++
				STA		,Y+
				INC		COMMON_LINEBUFPTR+4,PCR

				STU		,Y++
				STA		,Y+
				LEAU	-64,U
				STU		,Y++
				STA		,Y+
				INC		COMMON_LINEBUFPTR+4,PCR

				STU		,Y++
				STA		,Y+
				SUBA	#32
				STU		,Y++
				STA		,Y+
				INC		COMMON_LINEBUFPTR+4,PCR


SPRINGDEMO_RENDER_ONESPRING_END
				RTS

SPRING_MINY		FCB		0
SPRING_MAXY		FCB		0
SPRING_Y		FCB		0
SPRING_SEG_REMAIN	FCB	0
SPRING_BALANCE	FCB		0
SPRING_YOFFSET	RZB		16
SPRING_XOFFSET	FDB		32
SPRING_LASTX	FDB		0
SPRING_LASTY	FCB		0
SPRING_NEXTCOLOR	FCB		7


SPRINGDEMO_SWAPBUFFERS
				LEAU	COMMON_LINEBUFPTR,PCR
				STU		CALL_LINEDDA_SUBCPU_DATAADDR,PCR
				LBSR	CALL_CLS_AND_LINEDDA_SUBCPU

				LDD		SPRINGDEMO_VRAMADDR,PCR
				CMPD	#$4000
				BEQ		SPRINGDEMO_SWAPBUFFERS_4000

				; Finished Drawing Blue Enable Red Plane
				; 001		000
				; 010		NEXTCOLOR
				; 011		NEXTCOLOR
				; 100		111
				; 101		111
				; 110		111
				; 111		111

				CLR		$FD39
				LDA		SPRING_NEXTCOLOR,PCR
				STA		$FD3A
				STA		$FD3B
				LDA		#7
				STA		$FD3C
				STA		$FD3D
				STA		$FD3E
				STA		$FD3F
				LDD		#$4000
				STD		SPRINGDEMO_VRAMADDR,PCR
				BRA		SPRINGDEMO_SWPBUFFERS_EXIT
SPRINGDEMO_SWAPBUFFERS_4000
				; Finished Drawing Red Enable Blue Plane
				; 001		NEXTCOLOR
				; 010		000
				; 011		NEXTCOLOR
				; 100		111
				; 101		111
				; 110		111
				; 111		111
				LDA		SPRING_NEXTCOLOR,PCR
				STA		$FD39
				CLR		$FD3A
				STA		$FD3B
				LDA		#7
				STA		$FD3C
				STA		$FD3D
				STA		$FD3E
				STA		$FD3F
				LDD		#$0
				STD		SPRINGDEMO_VRAMADDR,PCR

SPRINGDEMO_SWPBUFFERS_EXIT
				STD		SPRINGDEMO_VRAMADDR,PCR
				RTS



; 6 messages in 18 seconds.  Works out well.
SPRINGDEMO_UPDATE_MESSAGE
				LBSR	PSGPLAY_GET_10MS_TICK
				SUBD	SPRINGDEMO_TIMER0,PCR
				TFR		D,X

				LDA		SPRINGDEMO_MESSAGECOUNTER,PCR
				BNE		SPRINGDEMO_UPDATE_MESSAGE_2

				LEAX	SPRINGDEMO_PRINT_MESSAGE_1,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_1_END-SPRINGDEMO_PRINT_MESSAGE_1+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
				RTS

SPRINGDEMO_UPDATE_MESSAGE_2
				DECA
				BNE		SPRINGDEMO_UPDATE_MESSAGE_3
				CMPX	#300
				BCS		SPRINGDEMO_UPDATE_MESSAGE_2_RTS

				LEAX	SPRINGDEMO_PRINT_MESSAGE_2,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_2_END-SPRINGDEMO_PRINT_MESSAGE_2+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
SPRINGDEMO_UPDATE_MESSAGE_2_RTS
				RTS

SPRINGDEMO_UPDATE_MESSAGE_3
				DECA
				BNE		SPRINGDEMO_UPDATE_MESSAGE_4
				CMPX	#600
				BCS		SPRINGDEMO_UPDATE_MESSAGE_3_RTS

				LEAX	SPRINGDEMO_PRINT_MESSAGE_3,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_3_END-SPRINGDEMO_PRINT_MESSAGE_3+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
SPRINGDEMO_UPDATE_MESSAGE_3_RTS
				RTS

SPRINGDEMO_UPDATE_MESSAGE_4
				DECA
				BNE		SPRINGDEMO_UPDATE_MESSAGE_5
				CMPX	#900
				BCS		SPRINGDEMO_UPDATE_MESSAGE_4_RTS

				LEAX	SPRINGDEMO_PRINT_MESSAGE_4,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_4_END-SPRINGDEMO_PRINT_MESSAGE_4+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
SPRINGDEMO_UPDATE_MESSAGE_4_RTS
				RTS

SPRINGDEMO_UPDATE_MESSAGE_5
				DECA
				BNE		SPRINGDEMO_UPDATE_MESSAGE_6
				CMPX	#1200
				BCS		SPRINGDEMO_UPDATE_MESSAGE_5_RTS

				LEAX	SPRINGDEMO_PRINT_MESSAGE_5,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_5_END-SPRINGDEMO_PRINT_MESSAGE_5+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
SPRINGDEMO_UPDATE_MESSAGE_5_RTS
				RTS

SPRINGDEMO_UPDATE_MESSAGE_6
				DECA
				BNE		SPRINGDEMO_UPDATE_MESSAGE_6_RTS
				CMPX	#1500
				BCS		SPRINGDEMO_UPDATE_MESSAGE_6_RTS

				LEAX	SPRINGDEMO_PRINT_MESSAGE_6,PCR
				LDB		#SPRINGDEMO_PRINT_MESSAGE_6_END-SPRINGDEMO_PRINT_MESSAGE_6+1
				LBSR	SUBCPU_EXEC_COMMAND
				LBSR	INSTALL_LINEDDA_IN_SUBCPU
				LBSR	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
				LBSR	INSTALL_VERTICAL_CLEAR_IN_SUBCPU
				INC		SPRINGDEMO_MESSAGECOUNTER,PCR
SPRINGDEMO_UPDATE_MESSAGE_6_RTS
				RTS






SPRINGDEMO_TIMER0	FDB		0
SPRINGDEMO_MESSAGECOUNTER	FCB	0


SPRINGDEMO_PRINT_MESSAGE_1
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		"    FUJITSU MICRO 7     "
					FCB		"    WAS BORN IN 1982    "
SPRINGDEMO_PRINT_MESSAGE_1_END



SPRINGDEMO_PRINT_MESSAGE_2
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		"     EQUIPPED WITH      "
					FCB		"     TWO 6809 CPUs      "
SPRINGDEMO_PRINT_MESSAGE_2_END



SPRINGDEMO_PRINT_MESSAGE_3
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		"SUB-CPU WAS IN CHARGE OF"
					FCB		"GRAPHICS, BUT....       "
SPRINGDEMO_PRINT_MESSAGE_3_END



SPRINGDEMO_PRINT_MESSAGE_4
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		" ARBITRARY CODE COULD   "
					FCB		" BE RUN ON THE SUB-CPU. "
SPRINGDEMO_PRINT_MESSAGE_4_END



SPRINGDEMO_PRINT_MESSAGE_5
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		" FUJITSU MICRO COMPUTERS"
					FCB		" HAD INTRODUCED....     "
SPRINGDEMO_PRINT_MESSAGE_5_END



SPRINGDEMO_PRINT_MESSAGE_6
					FCB		0,0
					FCB		7		  ; PUTC
					FCB		9,22	  ; X1,Y1
					FCB		9+24-1,23 ; X2,y2
					FCB		7			; COLOR
					FCB		48		  ; 48 letters
					FCB		"     THE WORLD FIRST    "
					FCB		"   GENERAL-PURPOSE GPU  "
SPRINGDEMO_PRINT_MESSAGE_6_END
