#include <stdio.h>
#include <stdlib.h>
#include "../concorde.h"


PAGE *YGH_initPage(PAGE *p,int seg,int adr,int wdx,int wdy)
{
	if(p==NULL)p=(PAGE *)malloc(sizeof(PAGE));

	if(p)
	{
		p->seg = seg;
		p->adr = adr;
		p->wdx = wdx;
		p->wdy = wdy;
		p->vx1 = 0;
		p->vy1 = 0;
		p->vx2 = wdx-1;
		p->vy2 = wdy-1;
		p->plt = NULL;
		p->pen = 32767;
		p->col = 32767;

		p->odw =  wdx*2;
		p->oup = -wdx*2;
	}

	return p;
}



int   YGH_color(PAGE *p,int pen)
{
	p->pen=pen;
	if( p->plt==NULL )
	{
		p->col=pen;
	}
	else
	{
		p->col=p->plt[pen];
	}
	return 0;
}



int   YGH_palette(PAGE *p,int pen,int col)
{
	if(p->plt==NULL)return 1;

	p->plt[pen]=col;
	if(p->pen==pen)p->col=col;

	return 0;
}



int   YGH_viewPort(PAGE *p,int vx1,int vy1,int vx2,int vy2)
{
	if(vx1>vx2){vx1=vx1-vx2; vx2=vx1+vx2; vx1=vx2-vx1;}
	if(vy1>vy2){vy1=vy1-vy2; vy2=vy1+vy2; vy1=vy2-vy1;}

	if(vx1<0 || vy1<0 || vx2>=p->wdx || vy2>=p->wdy)return 1;

	p->vx1=vx1;
	p->vy1=vy1;
	p->vx2=vx2;
	p->vy2=vy2;

	return 0;
}




int   YGH_makePaletteBlock(PAGE *p)
{
	int i;

	if(p->plt)return 1;

	if( (p->plt = malloc(sizeof(short)*32768))==NULL )return 2;

	for(i=0; i<32768; i++)p->plt[i]=i;
	return 0;
}





int   YGH_deletePaletteBlock(PAGE *p)
{
	if( p->plt==NULL )return 1;

	free( p->plt );
	return 0;
}
