		.386p
		ASSUME	CS:CODE
		INCLUDE	YGHASM.H

		PUBLIC	YGH_clearPage,YGH_clearView

CODE		SEGMENT
YGH_clearPage	PROC
#COL		EQU	ESP+28
#PAGE		EQU	ESP+24
#RETADR		EQU	ESP+20
#EBP		EQU	ESP+16
#ESI		EQU	ESP+12
#EDI		EQU	ESP+8
#EBX		EQU	ESP+4
#ES		EQU	ESP

		PUSH	EBP
		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		PUSH	ES

		MOV	EDI,[#PAGE]
		MOV	EAX,[EDI+YGH_SEG]
		MOV	ES,AX
		MOV	EAX,[EDI+YGH_WDX]
		MOV	ECX,[EDI+YGH_WDY]
		IMUL	ECX,EAX
		MOV	EBX,ECX
		SHR	ECX,1
		AND	EBX,1

		MOV	EDI,[EDI+YGH_ADR]
		MOV	EDX,[#COL]
		MOV	EAX,EDX
		SHL	EAX,16
		MOV	AX,DX

		CLD	;Ô
		REP	STOSD
		AND	EBX,EBX
		JE	#EXIT
		STOSW

#EXIT:		POP	ES
		POP	EBX
		POP	EDI
		POP	ESI
		POP	EBP
		MOV	EAX,0
		RET
YGH_clearPage	ENDP


		ALIGN	4
YGH_clearView	PROC
;ESI:VRAMlineTop  EAX:color  EBX:X1  EDX:X2  EBP:ODW
;All registers will be destroyed
ONELINE		MACRO
		MOV	EDI,ESI
		MOV	ES:[EDI+EBX*2],AX
		MOV	ES:[EDI+EDX*2],AX
		MOV	ECX,[#NREPEAT]
		REP	STOSD
		ADD	ESI,EBP
		ENDM

#COL		EQU	ESP+36
#PAGE		EQU	ESP+32
#RETADR		EQU	ESP+28
#ESI		EQU	ESP+24
#EDI		EQU	ESP+20
#EBX		EQU	ESP+16
#EBP		EQU	ESP+12
#ES		EQU	ESP+8
#ESPOFS		EQU	8
#LCOUNT		EQU	ESP+4
#NREPEAT	EQU	ESP

		PUSH	ESI
		PUSH	EDI
		PUSH	EBX
		PUSH	EBP
		PUSH	ES

		SUB	ESP,#ESPOFS

		MOV	EDI,[#PAGE]

		MOV	EAX,[EDI+YGH_VX1]
		MOV	EBX,[EDI+YGH_VY1]
		MOV	ECX,[EDI+YGH_VX2]
		MOV	EDX,[EDI+YGH_VY2]

		SUB	EDX,EBX
		INC	EDX
		MOV	[#LCOUNT],EDX		;K1͂͂łB

		IMUL	EBX,[EDI+YGH_ODW]
		ADD	EBX,[EDI+YGH_ADR]
		MOV	ESI,EBX			;ESI will be the VRAM pointer.

		MOV	EDX,[EDI+YGH_SEG]
		MOV	ES,DX

		MOV	EBP,[EDI+YGH_ODW]	;EBP:Offset Downward

		MOV	EBX,EAX			;EBX will be relative x1
		MOV	EDX,ECX			;EDX will be relative x2 

		INC	EAX
		AND	AL,0FEH
		SUB	ECX,EAX
		INC	ECX
		SHR	ECX,1
		MOV	[#NREPEAT],ECX
		SUB	EBX,EAX			;EBX:relative x1
		SUB	EDX,EAX			;EDX:relative x2
		LEA	EAX,[EAX*2]
		ADD	ESI,EAX

		MOV	ECX,[#COL]
		MOV	EAX,ECX
		SHL	EAX,16
		MOV	AX,CX

		MOV	ECX,[#LCOUNT]
		AND	ECX,15
		JMP	CS:[#JTBL+ECX*4]

		ALIGN	4
#JTBL		DD  OFFSET #L00,OFFSET #L01,OFFSET #L02,OFFSET #L03
		DD  OFFSET #L04,OFFSET #L05,OFFSET #L06,OFFSET #L07
		DD  OFFSET #L08,OFFSET #L09,OFFSET #L10,OFFSET #L11
		DD  OFFSET #L12,OFFSET #L13,OFFSET #L14,OFFSET #L15
#L00:		ONELINE
#L15:		ONELINE
#L14:		ONELINE
#L13:		ONELINE
#L12:		ONELINE
#L11:		ONELINE
#L10:		ONELINE
#L09:		ONELINE
#L08:		ONELINE
#L07:		ONELINE
#L06:		ONELINE
#L05:		ONELINE
#L04:		ONELINE
#L03:		ONELINE
#L02:		ONELINE
#L01:		ONELINE
		SUB	[#LCOUNT],DWORD PTR 16
		JG	#L00

#EXIT:		ADD	ESP,#ESPOFS
		POP	ES
		POP	EBP
		POP	EBX
		POP	EDI
		POP	ESI
		MOV	EAX,0
		RET
YGH_clearView	ENDP


CODE		ENDS
		END
