#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "MAIN.h"
#include "UTIL.h"
#include "EGBCTRL.h"
#include "PAGECTRL.h"
#include "FASTMODE.h"
#include "BGM.h"
#include "DEF.h"

#include "ACRODEMO.h"
#include "BALLDEMO.h"
#include "SPRGDEMO.h"
#include "MAZEDEMO.h"
#include "YS11MARK.h"


int bailOut=0;

int *unitCube100cm=NULL;
int *a10a=NULL,*f117a=NULL,*f16c=NULL;
int *ducky=NULL;
LAXIS *map=NULL;

void MakeGradation(int *r,int *g,int *b,int t)
{
	// t 0  31 32 63
	// R 0   0  0 31
	// G 0  31 31  0
	// B 31  0  0  0

	t=t&63;
	if(t<32)
	{
		*r=0;
		*g=t;
		*b=31-t;
	}
	else
	{
		*r=t-32;
		*g=63-t;
		*b=0;
	}
}

void Title(PAGE rp[2],int bgmStop,int bgmChange[3])
{
	SetUpEGB320x240_320x240();
	SetUpPage320x240_320x240();

	int writePage=0;
	int t=0,vt=1;
	int modelCtr=0;

	HideBuffers();
	clock_t t0=clock();
	for(;;)
	{
		int r,g,b;
		int camera[6]={0,0,0,0,0,0};
		int mdlpos[6]={0,0,180,0,0,0};
		PRJSCRN prj;

		int elapsed=(clock()-t0)*100/CLOCKS_PER_SEC;
		int colorCtr=((clock()-t0)*25/CLOCKS_PER_SEC)&127;
		if(64<=colorCtr)
		{
			colorCtr=127-colorCtr;
		}

		MakeGradation(&r,&g,&b,colorCtr);

		mdlpos[3]=elapsed*256;
		mdlpos[4]=elapsed*128;
		mdlpos[5]=elapsed*64;
		prj.prj.cx=160;
		prj.prj.cy=120;
		prj.prj.mag=100;
		prj.cpz=10;
		prj.lx=160;
		prj.ly=120;


		t+=vt;
		if((63<=t && 0<vt) || (t<=0 && vt<0))
		{
			vt=-vt;
		}

		YGH_clearPage(&rp[writePage],g*1024+r*32+b);

		AL_Set_Eye(camera,&prj);
		switch(modelCtr)
		{
		case 0:
			AL_Insert_Model(unitCube100cm,mdlpos);
			break;
		case 1:
			AL_Insert_Model(ducky,mdlpos);
			break;
		case 2:
			AL_Insert_Model(unitCube100cm,mdlpos);
			break;
		case 3:
			AL_Insert_Model(ducky,mdlpos);
			break;
		}
		AL_Flush_Buffer(&rp[writePage]);

		YGH_color(&rp[writePage],32767);
		int y=32;
		YGH_print8font(&rp[writePage],32,y+=10,"["DEMO_TITLE"]");
		YGH_print8font(&rp[writePage],32,y+=10,"IN DEMOSPLASH 2018");
		y=182;
		YGH_print8font(&rp[writePage],32,y+=10,"PROGRAMMED FOR FM TOWNS");
		YGH_print8font(&rp[writePage],32,y+=10,"BY CAPTAIN YS");

		int markx=240;
		YGH_put(&rp[writePage],YS11mark,markx,y,markx+63,y+31);

		YGH_print8font(&rp[writePage],32,y+=10,"  (FORMERLY KNOWN AS YS11)");
		YGH_print8font(&rp[writePage],32,y+=10,"  WWW.YSFLIGHT.COM");

		ShowBuffer(writePage);
		writePage=1-writePage;

		int bgmCtr=GetBGMCounter();
		if(modelCtr<4 && bgmChange[modelCtr]<=bgmCtr)
		{
			++modelCtr;
		}

		if(0!=CheckButtonPress() || bgmStop<=bgmCtr)
		{
			break;
		}
	}
}

void EndTitle(PAGE rp[2])
{
	SetUpEGB320x240_320x240();
	SetUpPage320x240_320x240();

	int i=0;
	int writePage=0;
	int t=0,vt=1;

	HideBuffers();

	int r,g,b;
	int camera[6]={0,0,0,0,0,0};
	int mdlpos[6]={0,0,180,0,0,0};
	PRJSCRN prj;

	MakeGradation(&r,&g,&b,t);

	mdlpos[3]=i*256;
	mdlpos[4]=i*128;
	mdlpos[5]=i*64;
	prj.prj.cx=160;
	prj.prj.cy=120;
	prj.prj.mag=100;
	prj.cpz=10;
	prj.lx=160;
	prj.ly=120;


	t+=vt;
	if((63<=t && 0<vt) || (t<=0 && vt<0))
	{
		vt=-vt;
	}

	YGH_clearPage(&rp[writePage],0);

	// AL_Set_Eye(camera,&prj);
	// AL_Insert_Model(unitCube100cm,mdlpos);
	// AL_Flush_Buffer(&rp[writePage]);

	YGH_color(&rp[writePage],32767);
	int y=20;
	YGH_print8font(&rp[writePage],0,y+=10,"["DEMO_TITLE"]");
	y+=10;
	YGH_print8font(&rp[writePage],0,y+=10,"BY CAPTAIN YS");
	YGH_print8font(&rp[writePage],0,y+=10,"  (FORMERLY KNOWN AS YS11)");
	YGH_print8font(&rp[writePage],0,y+=10,"  WWW.YSFLIGHT.COM");
	y+=10;
	YGH_print8font(&rp[writePage],0,y+=10,"HGFMDATA.FMB IS USED IN COURTESY OF");
	YGH_print8font(&rp[writePage],0,y+=10,"OH!FM MAGAZINE MUSIC GROUP");
	YGH_print8font(&rp[writePage],0,y+=10,"(PUBLISHED IN DECEMBER 1989 EDITION)");
	y+=10;
	YGH_print8font(&rp[writePage],0,y+=10,"BEST WISHES TO MY FRIENDS");
	YGH_print8font(&rp[writePage],0,y+=10,"IN FMTOWNS FORUM OF NIFTY-SERVE");

	YGH_print8font(&rp[writePage],0,200,"END");

	ShowBuffer(writePage);

	while(0==CheckButtonPress())
	{
	}
}

void FastSpin(PAGE rp[2],int bgmStop1,int bgmStop2,int bgmStop3)
{
	SetUpEGB320x240_320x240();
	SetUpPage320x240_320x240();

	int i=0;
	int writePage=0;
	int t=0,vt=1;
	clock_t t0=clock();

	HideBuffers();
	for(;;)
	{
		int r,g,b;
		int camera[6]={0,0,0,0,0,0};
		int mdlpos[6]={0,0,180,0,0,0};
		PRJSCRN prj;
		int *modelPtr=unitCube100cm;

		int elapsed=(clock()-t0)*100/CLOCKS_PER_SEC;
		int colorCtr=((clock()-t0)*25/CLOCKS_PER_SEC)&127;
		if(64<=colorCtr)
		{
			colorCtr=127-colorCtr;
		}

		if(GetBGMCounter()<bgmStop1)
		{
			MakeGradation(&r,&g,&b,colorCtr);

			modelPtr=ducky;
			mdlpos[3]=32768+elapsed*512;
			mdlpos[4]=-1024;
			mdlpos[5]=0;
			prj.prj.cx=160;
			prj.prj.cy=120;
			prj.prj.mag=100;
			prj.cpz=10;
			prj.lx=160;
			prj.ly=120;
		}
		else if(GetBGMCounter()<bgmStop2)
		{
			MakeGradation(&r,&g,&b,colorCtr);
			modelPtr=unitCube100cm;

			mdlpos[3]=elapsed*512;
			mdlpos[4]=elapsed*256;
			mdlpos[5]=elapsed*320;
			prj.prj.cx=160;
			prj.prj.cy=120;
			prj.prj.mag=100;
			prj.cpz=10;
			prj.lx=160;
			prj.ly=120;
		}
		else
		{
			modelPtr=unitCube100cm;

			r=rand()&31;
			g=rand()&31;
			b=rand()&31;

			mdlpos[3]=i*20480;
			mdlpos[4]=i*10240;
			mdlpos[5]=i*6400;
			prj.prj.cx=160;
			prj.prj.cy=120;
			prj.prj.mag=100;
			prj.cpz=10;
			prj.lx=160;
			prj.ly=120;
		}


		t+=vt;
		if((63<=t && 0<vt) || (t<=0 && vt<0))
		{
			vt=-vt;
		}

		YGH_clearPage(&rp[writePage],g*1024+r*32+b);

		AL_Set_Eye(camera,&prj);
		AL_Insert_Model(modelPtr,mdlpos);
		AL_Flush_Buffer(&rp[writePage]);

		ShowBuffer(writePage);
		writePage=1-writePage;

		if(0!=CheckButtonPress() || bgmStop3<=GetBGMCounter() || 0==IsBGMPlaying())
		{
			break;
		}
		++i;
	}
}

void LoadResource(PAGE rp[2])
{
	int writePage=0;

	HideBuffers();
	YGH_clearPage(&rp[writePage],31);

	ShowBuffer(writePage);

	int y=8;
	YGH_color(&rp[writePage],32767);

	YGH_print8font(&rp[writePage],0,y,"LOADING CUBE.");
	unitCube100cm=LoadBinaryFile("DATA/cube100c.t3d");
	y+=8;

	YGH_print8font(&rp[writePage],0,y,"LOADING Ducky.");
	ducky=LoadBinaryFile("DATA/DUCKY.SLD");
	y+=8;

	YGH_print8font(&rp[writePage],0,y,"LOADING F-117A Nighthawk.");
	f117a=LoadBinaryFile("DATA/f117a.sld");
	y+=8;

	YGH_print8font(&rp[writePage],0,y,"LOADING A-10A Thunderbolt II.");
	a10a=LoadBinaryFile("DATA/a10a.sld");
	y+=8;

	YGH_print8font(&rp[writePage],0,y,"LOADING F-16C Fighting Falcon.");
	f16c=LoadBinaryFile("DATA/f16c.sld");
	y+=8;

	YGH_print8font(&rp[writePage],0,y,"LOADING MAP.");
	map=LoadLax("DATA/map.lax");
	y+=8;
}

void DemoMain(PAGE rp[2])
{
	LoadResource(rp);
	StartBGM();

	SetFastMode();

	int bgmChange[3]={
		CARMEN_MAINTHEME_1_1,
		CARMEN_MAINTHEME_1_2,
		CARMEN_MAINTHEME_1_3
	};
	Title(rp,CARMEN_MAINTHEME_1_LAST,bgmChange);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	SpringDemo(CARMEN_MAINTHEME_1_LAST,CARMEN_MAINTHEME_2_LAST);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	MazeDemo(CARMEN_MAINTHEME_3_BEGIN);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	BallDemo(CARMEN_SECONDTHEME_1,/*resume=*/0);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	AcroDemo(rp,CARMEN_SECONDTHEME_CLIMBING,CARMEN_SECONDTHEME_2,CARMEN_MAINTHEME_4_BEGIN);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	BallDemo(CARMEN_MAINTHEME_4_CLIMBING,/*resume=*/1);
	if(0!=bailOut || 0!=CheckButtonPress())
	{
		goto ENDDEMO;
	}

	FastSpin(rp,CARMEN_GOING_CLIMAX,CARMEN_CLIMAX,CARMEN_LASTTONE);

	EndTitle(rp);

ENDDEMO:
	EndBGM();
}

