#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#include "MAZEDEMO.h"


#include "MAIN.h"
#include "UTIL.h"
#include "EGBCTRL.h"
#include "PAGECTRL.h"
#include "BGM.h"

#include "../airforce/airforce.h"
#include "../tomahawk/tomahawk.h"
#include "../ysmaze2/YSMAZE2.h"


int duckywid=32;
int duckyhei=32;
unsigned short duckyptn[32*32]={
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0, 12672, 19008, 22176, 22176, 22176, 21120, 10560,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0, 16896, 23232, 26400, 27456, 28512, 27456, 26400, 23232, 19008,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0, 14784, 21120, 25344, 28512, 29568, 30624, 30624, 29568, 28512, 24288, 17952,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,  2112, 20064, 24288, 27456, 30624, 31680, 32736, 32736, 31680, 29568, 27456, 22176,
 14784,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0, 13728, 21120,    27,    27, 31681, 32744, 32745, 32737, 31680, 30624, 28512, 24288,
 19008,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0, 16896, 21120,    24,    27, 31681, 32748, 32755, 32749, 32741, 31680, 29568, 26400,
 20064,  8448,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0, 17952, 22176,    24,    26, 31681, 32748, 32759, 32760, 32749, 32738, 28512, 25344,
 20064, 12672,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,  5509,  8775, 23232, 24288, 26400, 28512, 31682, 32748, 32754, 32752, 32741, 27456, 24288,
 20064, 12672,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,  6630,  8808, 10985, 11050, 24288, 26400, 27456, 29569, 32745, 32743, 31685, 26400, 22176,
 17952,  9504,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,  5509,  6630,  7719,  8807,  9864,  9929, 24288, 26400, 26400, 27456, 26400, 25344, 23232, 19008,
 14784,  6336,     0,     0,     0,     0,     0,     0, 14784, 14784,     0,     0,     0,     0,     0,     0,
     0,     0,  3299,  4420,  5477,  6565,  6630,  7719, 21120, 22176, 23232, 24288, 23232, 22176, 20064, 15840,
 11616,     0,     0,     0,     0,     0,     0, 17952, 17952, 16896, 16896,     0,     0,     0,     0,     0,
     0,     0,     0,     0,  1121,  2210,  9504, 12672, 16896, 19008, 20064, 20064, 20064, 17952, 16896, 17952,
 14784, 14784, 17952, 17952, 17952, 17952, 17952, 17952, 17952, 17952, 17952, 17952,     0,     0,     0,     0,
     0,     0,     0,     0,     0,  4224,  8448, 12672, 14784, 16896, 17952, 20064, 22176, 23232, 24288, 24288,
 21120, 23232, 23232, 22176, 22176, 22176, 22176, 22176, 22176, 22176, 22176, 22176, 17952,     0,     0,     0,
     0,     0,     0,     0,     0,     0, 10560, 16896, 20064, 23232, 24288, 25344, 27456, 29568, 30624, 29568,
 28512, 28512, 28512, 28512, 27456, 26400, 26400, 26400, 26400, 25344, 25344, 23232, 21120,     0,     0,     0,
     0,     0,     0,     0,     0,     0, 12672, 19008, 24288, 27456, 29569, 29569, 30625, 32738, 32737, 31680,
 30624, 29568, 29568, 29568, 29568, 29568, 29568, 29568, 28512, 27456, 25344, 22176, 20064, 15840,     0,     0,
     0,     0,     0,     0,     0, 11616, 19008, 23232, 26400, 29568, 31682, 32738, 32739, 32739, 32738, 32737,
 32737, 31680, 31680, 31680, 30624, 30624, 30624, 29568, 28512, 27456, 25344, 22176, 20064, 16896,     0,     0,
     0,     0,     0,     0,  8448, 19008, 23232, 25344, 28512, 30625, 32739, 32740, 32740, 32740, 32739, 32738,
 32738, 32737, 32736, 32736, 31680, 30624, 29568, 29568, 28512, 27456, 25344, 22176, 20064, 16896, 13728,     0,
     0,     0,     0,     0, 17952, 22176, 24288, 27456, 30625, 32738, 32740, 32741, 32742, 32741, 32740, 32739,
 32738, 32737, 32736, 31680, 30624, 30624, 29568, 28512, 27456, 27456, 25344, 23232, 20064, 16896, 13728,     0,
     0,     0,     0,  2112, 20064, 23232, 26400, 28512, 30625, 32738, 32740, 32741, 32741, 32740, 32739, 32738,
 32737, 31680, 31680, 30624, 30624, 29568, 28512, 28512, 27456, 26400, 25344, 23232, 20064, 14784,  9504,     0,
     0,     0,     0, 13728, 19008, 22176, 25344, 28512, 29568, 31681, 32738, 32740, 32740, 32739, 32738, 32737,
 31680, 30624, 30624, 29568, 29568, 28512, 27456, 27456, 26400, 25344, 25344, 21120, 16896, 11616,     0,     0,
     0,     0,     0, 15840, 19008, 21120, 24288, 27456, 28512, 29568, 31681, 32738, 32739, 32738, 32737, 31680,
 30624, 29568, 29568, 28512, 28512, 27456, 26400, 26400, 24288, 23232, 22176, 17952, 12672,  7392,     0,     0,
     0,     0,     0, 14784, 17952, 21120, 23232, 26400, 27456, 28512, 29568, 31681, 32738, 31681, 30624, 30624,
 29568, 28512, 28512, 27456, 27456, 25344, 24288, 23232, 22176, 20064, 17952, 14784,  8448,  3168,     0,     0,
     0,     0,     0, 14784, 16896, 20064, 23232, 25344, 26400, 27456, 28512, 29568, 31681, 30624, 29568, 29568,
 28512, 27456, 26400, 25344, 24288, 23232, 22176, 20064, 19008, 16896, 14784, 10560,  5280,     0,     0,     0,
     0,     0,     0, 12672, 15840, 19008, 22176, 24288, 25344, 26400, 27456, 28512, 29568, 28512, 27456, 26400,
 25344, 24288, 23232, 22176, 21120, 20064, 19008, 16896, 14784, 13728, 12672,  8448,  3168,     0,     0,     0,
     0,     0,     0,  9504, 12672, 15840, 19008, 22176, 23232, 24288, 25344, 26400, 26400, 25344, 24288, 22176,
 22176, 21120, 20064, 20064, 19008, 16896, 15840, 13728, 12672, 11616,  9504,  5280,     0,     0,     0,     0,
     0,     0,     0,     0,  9504, 12672, 15840, 19008, 20064, 21120, 22176, 22176, 22176, 21120, 20064, 20064,
 19008, 17952, 16896, 15840, 14784, 13728, 12672, 11616, 10560,  8448,  7392,     0,     0,     0,     0,     0,
     0,     0,     0,     0,  6336,  9504, 12672, 15840, 17952, 17952, 19008, 19008, 19008, 17952, 16896, 15840,
 14784, 13728, 13728, 12672, 11616,  9504,  8448,  7392,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,  3168,  6336,  9504, 12672, 14784, 14784, 14784, 14784, 13728, 12672, 12672, 11616,
 10560, 10560,  9504,  8448,  7392,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,  3168,  5280,  7392,  9504, 10560, 10560,  9504,  8448,  7392,  6336,  5280,
  5280,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,  1056,  3168,  5280,  6336,  5280,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
};


static MAZEMAP mz;
static MAZESCREEN ms;
static int writePage=0;

#define YES 1
#define NO  0

static int LoadMaze(char *fname,MAZEMAP *mz)
{
	int siz;
	FILE *fp;
	short *dat;

	if((fp=fopen(fname,"rb"))==NULL)
	{
		return NO;
	}

	fread(&mz->bl,4,1,fp);  /* 1ubN̕ǂ̒ (cm) */
	fread(&mz->bh,4,1,fp);  /* ǂ̍(cm) */
	fread(&mz->lx,4,1,fp);  /* H̉ubN */
	fread(&mz->ly,4,1,fp);  /* H̏cubN */

	siz=mz->lx*mz->ly;
	if((dat=(short *)malloc(sizeof(short)*siz))==NULL)
	{
		return NO;
	}

	mz->map = dat;          /* H̕//Vf[^ */
	fread(dat,sizeof(short),siz,fp);

	fclose(fp);
	return YES;
}

static void Progress(MAZEMAP *mz,int *x,int *y,int dir,int v)
{
	int vx,vy;
	int lx,ly;
	int x2,y2,bx,by,bx2,by2;

	lx=mz->bl * mz->lx;   /* HŜ̉TCY(cm) */
	ly=mz->bl * mz->ly;   /* HŜ̏cTCY(cm) */

	vx=-MulSin(v,dir);    /* iƂxNg */
	vy=-MulCos(v,dir);

	bx= *x/(mz->bl);      /* ݈ʒu(ubN) */
	by= *y/(mz->bl);

	x2= *x+vx;            /* ړ̍W(cm)ɌvZ */
	y2= *y+vy;

	while(x2<  0)x2+=lx;  /* W𐳋K */
	while(x2>=lx)x2-=lx;
	while(y2<  0)y2+=ly;
	while(y2>=ly)y2-=ly;

	bx2= x2/mz->bl;       /* ړ̍W(ubN) */
	by2= y2/mz->bl;

	if     (vx>0 && bx2!=bx && MazePass(mz,bx,by,3))return;
	else if(vx<0 && bx2!=bx && MazePass(mz,bx,by,1))return;
	else bx=bx2;

	if     (vy>0 && by2!=by && MazePass(mz,bx,by,2))return;
	else if(vy<0 && by2!=by && MazePass(mz,bx,by,0))return;

	*x=x2;
	*y=y2;
}

void MazeDemoInit(void)
{
	ms.cx=160;     /* H\̒SW */
	ms.cy=120;

	ms.x0=0;      /* ʕ`͈ */
	ms.y0=0;
	ms.x1=319;
	ms.y1=239;

	ms.wc=25368;  /* ǂ̐F(O[ []) */
	ms.dc=10570;  /* hA̐F(O[ []) */
	ms.cont=5;    /* ɑ΂Px̌ */
	ms.mag=64;    /* g嗦(1mO1m̖_hbg) */

	LoadMaze("DATA\\SAMPLE1.MAZ",&mz);

	mz.bh=mz.bl;

	for(int i=0; i<duckywid*duckyhei; ++i)
	{
		if(duckyptn[i]==0)
		{
			duckyptn[i]=0x8000;
		}
	}
}

static clock_t WalkForward(int *mx,int *my,int dir,int nBlk,int bgmStop,clock_t t0,int byThisTime)
{
	MAZEZBUF buf[320];  // Must be as long as the screen width.
	int mx0=*mx,my0=*my;

	clock_t lastClock;
	int totalMove=nBlk*mz.bl;
	for(;;)
	{
		lastClock=clock();
		int elapsed=(lastClock-t0)*100/CLOCKS_PER_SEC;
		if(byThisTime<elapsed)
		{
			elapsed=byThisTime;
		}

		int accumMove=totalMove*elapsed/byThisTime;
		*mx=mx0;
		*my=my0;
		Progress(&mz,mx,my,dir,accumMove);

		if(byThisTime<=elapsed)
		{
			// Break before drawing.
			break;
		}

		MazeGetLines(buf,&mz,&ms,*mx,*my,dir,1500);
		MazeDrawWalls(&rp[writePage],&mz,&ms,buf);

		MazePrepareInsertBitmap(*mx,*my,dir,1500,&ms);
		MazeInsertBitmap((char *)duckyptn,duckywid,duckyhei,400,400,5*mz.bl-mz.bl/2,5*mz.bl-mz.bl/4);
		MazeFlushBitmap(&rp[writePage],buf,(char *)GetVirtualVRAM());

		ShowBuffer(writePage);
		writePage=1-writePage;

		if(0!=CheckButtonPress() || bgmStop<=GetBGMCounter())
		{
			break;
		}
	}

	return lastClock;
}

static clock_t Turn(int mx,int my,int *dir,int stepAngle,int n,int bgmStop,clock_t t0,int byThisTime)
{
	MAZEZBUF buf[320];  // Must be as long as the screen width.
	int dir0=*dir;

	clock_t lastClock;
	int totalRotation=stepAngle*n;
	for(;;)
	{
		lastClock=clock();
		int elapsed=(lastClock-t0)*100/CLOCKS_PER_SEC;
		if(byThisTime<elapsed)
		{
			elapsed=byThisTime;
		}

		int accumRotation=totalRotation*elapsed/byThisTime;
		*dir=dir0+accumRotation;

		if(byThisTime<=elapsed)
		{
			// Break before drawing.
			break;
		}

		MazeGetLines(buf,&mz,&ms,mx,my,*dir,1500);
		MazeDrawWalls(&rp[writePage],&mz,&ms,buf);

		MazePrepareInsertBitmap(mx,my,*dir,1500,&ms);
		MazeInsertBitmap((char *)duckyptn,duckywid,duckyhei,400,400,5*mz.bl-mz.bl/2,5*mz.bl-mz.bl/4);
		MazeFlushBitmap(&rp[writePage],buf,(char *)GetVirtualVRAM());

		ShowBuffer(writePage);
		writePage=1-writePage;

		if(0!=CheckButtonPress() || bgmStop<=GetBGMCounter())
		{
			break;
		}
	}
	return lastClock;
}

static clock_t Static(int mx,int my,int dir,int bgmStop)
{
	MAZEZBUF buf[320];  // Must be as long as the screen width.

	clock_t lastClock;
	for(;;)
	{
		lastClock=clock();

		MazeGetLines(buf,&mz,&ms,mx,my,dir,1500);
		MazeDrawWalls(&rp[writePage],&mz,&ms,buf);

		MazePrepareInsertBitmap(mx,my,dir,1500,&ms);
		MazeInsertBitmap((char *)duckyptn,duckywid,duckyhei,400,400,5*mz.bl-mz.bl/2,5*mz.bl-mz.bl/4);
		MazeFlushBitmap(&rp[writePage],buf,(char *)GetVirtualVRAM());

		ShowBuffer(writePage);
		writePage=1-writePage;

		if(0!=CheckButtonPress() || bgmStop<=GetBGMCounter())
		{
			break;
		}
	}
	return lastClock;
}

void MazeDemoMain(int bgmStop)
{
	int mx,my,dir;

	mx=mz.bl /2;
	my=mz.bl /2;
	dir=49152;

	clock_t t0=clock();
	int totalNumSecX100=1460;
	int totalUnitCount=23;

	t0=WalkForward(&mx,&my,dir,mz.lx-1,bgmStop,t0,totalNumSecX100*9/totalUnitCount);
	t0=Turn(mx,my,&dir,-4096,8,bgmStop,        t0,totalNumSecX100*2/totalUnitCount);
	t0=WalkForward(&mx,&my,dir,1,bgmStop,      t0,totalNumSecX100*1/totalUnitCount);
	t0=Turn(mx,my,&dir,4096,4,bgmStop,         t0,totalNumSecX100*1/totalUnitCount);
	t0=WalkForward(&mx,&my,dir,1,bgmStop,      t0,totalNumSecX100*1/totalUnitCount);
	t0=Turn(mx,my,&dir,-4096,4,bgmStop,        t0,totalNumSecX100*1/totalUnitCount);
	t0=WalkForward(&mx,&my,dir,4,bgmStop,      t0,totalNumSecX100*4/totalUnitCount);
	t0=Turn(mx,my,&dir,4096,4,bgmStop,         t0,totalNumSecX100*1/totalUnitCount);
	t0=WalkForward(&mx,&my,dir,3,bgmStop,      t0,totalNumSecX100*3/totalUnitCount);
	t0=Static(mx,my,dir,bgmStop);
}

void MazeDemoCleanUp(void)
{
}

void MazeDemo(int bgmStop)
{
	SetUpEGB320x240_320x240();
	SetUpPage320x240_320x240();

	MazeDemoInit();
	MazeDemoMain(bgmStop);
	MazeDemoCleanUp();

	while(0==CheckButtonPress() && GetBGMCounter()<bgmStop)
	{
	}
}

