#ifndef TOMAHAWK_H_IS_INCLUDED
#define TOMAHAWK_H_IS_INCLUDED

#define DEG90  16384
#define DEG180 32768
#define DEG270 49152
#define DEG360 65536



#ifndef TOMAHAWK
#define TOMAHAWK
typedef struct {
	int cx,cy,mag;
} PROJ;
#endif

extern int Fx_sintbl[],Fx_costbl[],Fx_tantbl[];
extern int Fx_asintbl[],Fx_acostbl[],Fx_atantbl[];

int FxMul(int,int);
int FxDiv(int,int);

int MulSin(int,int);
int MulCos(int,int);
int MulTan(int,int);

int MulSinHq(int,int);
int MulCosHq(int,int);
int MulTanHq(int,int);

int FxSinHq(int);
int FxCosHq(int);
int FxTanHq(int);

int FxAsin(int);
int FxAcos(int);
int FxAtan(int);
int FxAngle(int,int);

int InnerSgn(int *,int *);

void Rot(int *x,int *y,int ang);
void RotFast(int *x,int *y,int *ang);
void RotHq(int *x,int *y,int ang);

void RotGtoV(int n,int *d,int *s,int *ang);
void RotGtoVFast(int n,int *d,int *s,int *ang);
void RotGtoVHq(int n,int *d,int *s,int *ang);
void RotVtoG(int n,int *d,int *s,int *ang);
void RotVtoGFast(int n,int *d,int *s,int *ang);
void RotVtoGHq(int n,int *d,int *s,int *ang);
void Move3D(int n,int *d,int *s,int *vect);

void Projection(int n,int *d,int *s,PROJ *prj);

int ClipPolyg3D(int *d,int *s,int cpz);
int ClipLine3D(int *d,int *s,int cpz);

int FxLength(int x,int y);

int PitchUp(int *d,int *s,int ang);
int YawLeft(int *d,int *s,int ang);

void InterpolateAngle(int o[3],int a1[3],int a2[3],int a,int b);
void InterpolateVector(int o[3],int v1[3],int v2[3],int a,int b);
void AngleToVector(int e[3],int u[3],int a[3]);
void VectorToAngle(int an[3],int ev[3],int uv[3]);

#endif
