#include <stdio.h>
#include <concorde.h>
#include <ysmaze2.h>


static void MazeDrawOneWall
            (PAGE *wp,int sx,int sy,int vx,int vy,int l,int wal,int pas);



static int wallCol      =0x7fff;
static int spaceCol     =0x0000;
static int secretDoorCol=0x7c00;

void MazeDrawMapColor(int wall,int space,int secretDoor)
{
	wallCol=wall;
	spaceCol=space;
	secretDoorCol=secretDoor;
}


void MazeDrawMapOneWall
     (PAGE *wp,MAZEMAP *mz,int sx,int sy,int bx,int by,int dir,int l)
{
	int wal,pas,p,vx,vy;
	p= by*(mz->lx) +bx;

	switch(dir)
	{
	default:
		return;
	case 0:
		wal= mz->map[p] & 3;
		pas= mz->map[p] & 16;
		vx=1;vy=0;
		break;
	case 1:
		wal=(mz->map[p] & 12)/4;
		pas= mz->map[p] & 32;
		vx=0;vy=1;
		break;
	case 2:
		if( (++by)==mz->ly )by=0;
		MazeDrawMapOneWall(wp,mz,sx,sy+l,bx,by,0,l);
		return;
	case 3:		
		if( (++bx)==(*mz).lx )bx=0;
		MazeDrawMapOneWall(wp,mz,sx+l,sy,bx,by,1,l);
		return;
	}

	MazeDrawOneWall(wp,sx,sy,vx,vy,l,wal,pas);
}




void MazeDrawMap
    (PAGE *wp,MAZEMAP *mz,int lx,int ly,int x1,int y1,int x2,int y2,int l)
{
	int bx,by,sx,sy;

	for(by=y1; by<=y2; by++)
	{
		for(bx=x1; bx<=x2; bx++)
		{
			sx=lx+(bx % ((*mz).lx) )*l;
			sy=ly+(by % ((*mz).ly) )*l;

			MazeDrawMapOneWall(wp,mz,sx,sy,bx,by,0,l);
			MazeDrawMapOneWall(wp,mz,sx,sy,bx,by,1,l);
		}
	}

	by=y2;
	sy=ly+(by % ((*mz).ly) )*l;
	for(bx=x1; bx<=x2; bx++)
	{
		sx=lx+(bx % ((*mz).lx) )*l;
		MazeDrawMapOneWall(wp,mz,sx,sy,bx,by,2,l);
	}
	bx=x2;
	sx=lx+(bx % ((*mz).lx) )*l;
	for(by=y1; by<=y2; by++)
	{
		sy=ly+(by % ((*mz).ly) )*l;
		MazeDrawMapOneWall(wp,mz,sx,sy,bx,by,3,l);
	}
}


static void MazeDrawOneWall
    (PAGE *wp,int sx,int sy,int vx,int vy,int l,int wal,int pas)
{
	int i;

	YGH_color(wp,spaceCol);
	YGH_line(wp,sx,sy,sx+vx*(l-1),sy+vy*(l-1));

	if  (wal==1 && !pas)YGH_color(wp,secretDoorCol);
	else                YGH_color(wp,wallCol);

	if(wal==1)
	{
		YGH_line(wp,sx,sy,sx+vx*(l-1),sy+vy*(l-1));
	}
	else if(wal==2)
	{
		YGH_line(wp,sx,sy,sx+vx*2,sy+vy*2);
		YGH_line(wp,sx+vx*(l-1),sy+vy*(l-1),sx+vx*(l-2),sy+vy*(l-2));
	}
	else if(wal==0 && pas)
	{
		for(i=0; i<l; i+=2)YGH_pset(wp,sx+vx*i,sy+vy*i);
	}
}
