/*
 * Maze Format                                                              *
 *                                                                          *
 * short int *mazeDat;                                                      *
 *                                                                          *
 *        1                                                                 *
 *                                                                *
 *   @                                                                   *
 *  2@ 3                                                                 *
 *   @                                                                   *
 *                                                                          *
 *                                                                          *
 * mazeDat[n];                                                              *
 *    16        8 7 6 5 4  2  0                                             *
 *     |XXXXXXXX|X|X|X|X|XX|XX|                                             *
 *               ǂP`  00:  01:  10:  11:U[u   *
 *               ǂQ`@00:  01:  10:  11:U[u   *
 * @@ @@   ǂPʉ߁@0:\  1:s                     *
 * @@ @@   ǂQʉ߁@0:\  1:s                     *
 *             ̃vg 1:L 2:                       *
 *             Ṽvg 1:L 2:                     *
 * @@ @@ vO}[gpiCxgpj             *
 *                                                                          *
 *                                                                          */


typedef struct {
	int bl;               /* 1ubN̕ǂ̒(cm) */
	int bh;               /* ǂ̍ (cm) */
	int lx,ly;            /* H̃ubN(,k) */
	short *map;           /* }bvf[^ */
} MAZEMAP;

typedef struct {
	int cx,cy;            /* ʒS */
	int x0,y0,x1,y1;      /* ʕ`͈ */
	int wc,dc;            /* ǂ̐F,hA̐F */
	int cont;             /* RgXg(Px̋1mɑ΂錸(%)) */
	int mag;              /* g嗦 */
} MAZESCREEN;

typedef struct {
	int viewz;     /* ̃CƕǂƂ̌_̎WnZW */
	int edgedist;  /*  ǂ̒[̒ */
	int door;      /*  ǂ̎(hAł邩ǂł邩) */
	struct {
		int mark;  /* /ṼvgtO(b0: b1:V) */
		int z1;    /*  vgƃCƂ̌_̎OZW */
		int z2     /*  vgƃCƂ̌_̉ZW */
	} floor[2];
} MAZEZBUF;





#define MazeFloorCeiling(mz,bx,by) ((mz->map[by*((*mz).lx)+bx]/64)&3)
#define MazeFloorNumber(mz,bx,by) ((mz->map[by*((*mz).lx)+bx]/256)&255)

/* wall.c */
int MazeWall(MAZEMAP *mz,int bx,int by,int dir);
int MazePass(MAZEMAP *mz,int bx,int by,int dir);
void MazeSetWall(MAZEMAP *mz,int bx,int by,int sid,int wal,int pas);


/* drawmaze.c */
void MazeGetLines(MAZEZBUF *buf,MAZEMAP *mz,MAZESCREEN *ms,
         int bx,int by,int h,int lng);
void MazeDrawWalls(PAGE *wp,
         MAZEMAP *mz,MAZESCREEN *ms,MAZEZBUF *buf);

/* printmap.c */
void MazeDrawMapOneWall(PAGE *wp,MAZEMAP *mz,
         int sx,int sy,int bx,int by,int dir,int l);
void MazeDrawMap(PAGE *wp,MAZEMAP *mz,
         int lx,int ly,int x1,int y1,int x2,int y2,int l);
void MazeDrawMapColor(int wall,int space,int secretDoor);



/* create.c */
void MazeCreate(MAZEMAP *mz);



/* mzbitmap.c */
void MazePrepareInsertBitmap(int x,int z,int dir,int len,MAZESCREEN *ims);
void MazeInsertBitmap(char *bm,int bx,int by,int lx,int ly,int x,int z);
void MazeFlushBitmap(PAGE *wp,MAZEZBUF *zb,char *buf);

