/*
 * Decompiled with CFR 0.152.
 */
package jkcemu;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jkcemu.audio.AudioRecorderFrm;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.ScreenFrm;
import jkcemu.disk.DiskImgCreateFrm;
import jkcemu.disk.DiskImgViewFrm;
import jkcemu.disk.FloppyDiskStationFrm;
import jkcemu.filebrowser.FileBrowserFrm;
import jkcemu.filebrowser.FindFilesFrm;
import jkcemu.image.ImageFrm;
import jkcemu.programming.assembler.CmdLineAssembler;
import jkcemu.programming.basic.CmdLineBasicCompiler;
import jkcemu.text.TextEditFrm;
import jkcemu.text.TextUtil;
import jkcemu.tools.calculator.CalculatorFrm;
import jkcemu.tools.fileconverter.FileConvertFrm;
import jkcemu.tools.hexdiff.HexDiffFrm;
import jkcemu.tools.hexedit.HexEditFrm;

public class Main {
    public static final String APPNAME = "JKCEMU";
    public static final String VERSION = "0.9.7";
    public static final String APPINFO = "JKCEMU Version 0.9.7";
    public static final String FILE_GROUP_AUDIO = "audio";
    public static final String FILE_GROUP_DEBUG = "debug";
    public static final String FILE_GROUP_DISK = "disk";
    public static final String FILE_GROUP_FC_IN = "fileconnverter.in";
    public static final String FILE_GROUP_FC_OUT = "fileconnverter.out";
    public static final String FILE_GROUP_FIND = "find";
    public static final String FILE_GROUP_HEXDIFF = "hexdiff";
    public static final String FILE_GROUP_HEXEDIT = "hexedit";
    public static final String FILE_GROUP_IMAGE = "image";
    public static final String FILE_GROUP_LABEL = "label";
    public static final String FILE_GROUP_PRINT = "print";
    public static final String FILE_GROUP_PROJECT = "project";
    public static final String FILE_GROUP_RF = "ramfloppy";
    public static final String FILE_GROUP_ROM = "rom";
    public static final String FILE_GROUP_SCREEN = "screen";
    public static final String FILE_GROUP_SECTOR = "sector";
    public static final String FILE_GROUP_SOFTWARE = "software";
    public static final String FILE_GROUP_TEXT = "text";
    public static final String FILE_GROUP_USB = "usb";
    public static final String LASTDIRS_FILE = "lastdirs.xml";
    public static final String PROP_LAF_CLASSNAME = "jkcemu.laf.classname";
    public static final int WINDOW_MASK_SCREEN = 1;
    public static final int WINDOW_MASK_JOYSTICK = 2;
    public static final int WINDOW_MASK_KEYBOARD = 4;
    public static PrintWriter consoleWriter = null;
    private static ThreadGroup threadGroup = new ThreadGroup("JKCEMU thread group");
    private static String[] iconResources = new String[]{"/images/icon/jkcemu16x16.png", "/images/icon/jkcemu20x20.png", "/images/icon/jkcemu32x32.png", "/images/icon/jkcemu50x50.png"};
    private static String[] usageLines = new String[]{"", "Aufruf:", "  java -jar jkcemu.jar <Argumente>", "", "Argumente:", "  <kein Argument>              Emulator mit Profil \"standard\" starten", "  <Profil>                     Emulator mit dem angegebenen Profil starten", "  -h oder --help               diese Hilfe anzeigen", "  -v oder --version            Versionsnummer anzeigen", "  --ar oder --audiorecorder    Audiorecorder starten", "  --as oder --assembler        Assembler starten", "  --as -h                      Hilfe zum Assembler anzeigen", "  --bc oder --basiccompiler    BASIC-Compiler starten", "  --bc -h                      Hilfe zum BASIC-Compiler anzeigen", "  --ca oder --calculator       Rechner starten", "  --dc oder --diskcreator      Diskettenabbilddatei erstellen", "  --dv oder --diskviewer       Diskettenabbilddatei-Inspector starten", "  --fb oder --filebrowser      Datei-Browser starten", "  --fc oder --fileconverter    Dateikonverter starten", "  --ff oder --findfiles        Dateisuche starten", "  --hd oder --hexdiff          Hex-Dateivergeicher starten", "  --he oder --hexeditor        Hex-Editor starten", "  --iv oder --imageviewer      Bildbetrachter starten", "  --te oder --texteditor       Texteditor starten", ""};
    private static Map<String, Image> images = new HashMap<String, Image>();
    private static Properties lastDirs = new Properties();
    private static String lastDriveFileName = null;
    private static File configDir = null;
    private static File lastDirsFile = null;
    private static File profileFile = null;
    private static Properties properties = null;
    private static Integer nProcessors = null;
    private static boolean firstExec = true;
    private static boolean printPageNum = true;
    private static boolean printFileName = true;
    private static int printFontSize = 12;
    private static PrintRequestAttributeSet printRequestAttrs = null;
    private static BaseFrm topFrm = null;
    private static ScreenFrm screenFrm = null;
    private static List<Image> iconImages = null;
    private static volatile int activeWindowMask = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        consoleWriter = null;
        if (File.separatorChar == '\\' && (object3 = System.console()) != null) {
            consoleWriter = ((Console)object3).writer();
        }
        object3 = "jkcemu";
        String string = null;
        try {
            string = TextUtil.emptyToNull(System.getenv("APPDATA"));
            if (string == null) {
                string = TextUtil.emptyToNull(System.getProperty("user.home"));
                if (Main.isUnixLikeOS()) {
                    object3 = ".jkcemu";
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        configDir = string != null ? new File(string, (String)object3) : new File((String)object3);
        lastDirsFile = new File(configDir, LASTDIRS_FILE);
        if (lastDirsFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(lastDirsFile);
                lastDirs.loadFromXML(fileInputStream);
            }
            catch (Exception exception) {
                EmuUtil.closeSilent(fileInputStream);
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileInputStream);
                    throw throwable;
                }
            }
            EmuUtil.closeSilent(fileInputStream);
        }
        boolean bl = false;
        Object object4 = "standard";
        int n = 0;
        if (n < stringArray.length) {
            if (((String)(object2 = stringArray[n++])).equals("-?") || ((String)object2).equalsIgnoreCase("-h") || ((String)object2).equalsIgnoreCase("--help")) {
                EmuUtil.printlnOut();
                EmuUtil.printlnOut(APPINFO);
                for (String string2 : usageLines) {
                    EmuUtil.printlnOut(string2);
                }
                Main.exitSuccess();
            } else if (((String)object2).equals("-v") || ((String)object2).equalsIgnoreCase("--version")) {
                System.out.println(APPINFO);
                Main.exitSuccess();
            } else if (((String)object2).equalsIgnoreCase("--ar") || ((String)object2).equalsIgnoreCase("--audiorecorder")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AudioRecorderFrm.open();
                    }
                });
                bl = true;
            } else if (((String)object2).equals("--as") || ((String)object2).equalsIgnoreCase("--assembler")) {
                if (CmdLineAssembler.execute(stringArray, n)) {
                    Main.exitSuccess();
                } else {
                    Main.exitFailure();
                }
            } else if (((String)object2).equals("--bc") || ((String)object2).equalsIgnoreCase("--basiccompiler")) {
                if (CmdLineBasicCompiler.execute(stringArray, n)) {
                    Main.exitSuccess();
                } else {
                    Main.exitFailure();
                }
            } else if (((String)object2).equalsIgnoreCase("--ca") || ((String)object2).equalsIgnoreCase("--calculator")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalculatorFrm.open();
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--dc") || ((String)object2).equalsIgnoreCase("--diskcreator")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DiskImgCreateFrm.open();
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--dv") || ((String)object2).equalsIgnoreCase("--diskviewer")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFile(stringArray, n);
                EventQueue.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$file;
                    {
                        this.val$file = file;
                    }

                    @Override
                    public void run() {
                        DiskImgViewFrm.open(this.val$file);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--fb") || ((String)object2).equalsIgnoreCase("--filebrowser")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileBrowserFrm.open(null);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--fc") || ((String)object2).equalsIgnoreCase("--fileconverter")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFile(stringArray, n);
                EventQueue.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$file;
                    {
                        this.val$file = file;
                    }

                    @Override
                    public void run() {
                        FileConvertFrm.open(this.val$file);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--ff") || ((String)object2).equalsIgnoreCase("--findfiles")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = null;
                File file = Main.getArgFile(stringArray, n);
                if (file != null) {
                    try {
                        object = file.toPath().toAbsolutePath().normalize();
                        if (!Files.isDirectory((Path)object, LinkOption.NOFOLLOW_LINKS)) {
                            object = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object object5 = object;
                EventQueue.invokeLater(new Runnable((Path)object5){
                    final /* synthetic */ Path val$path2;
                    {
                        this.val$path2 = path;
                    }

                    @Override
                    public void run() {
                        FindFilesFrm.open(null, this.val$path2);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--hd") || ((String)object2).equalsIgnoreCase("--hexdiff")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFileList(stringArray, n);
                EventQueue.invokeLater(new Runnable((List)object){
                    final /* synthetic */ List val$files;
                    {
                        this.val$files = list;
                    }

                    @Override
                    public void run() {
                        HexDiffFrm hexDiffFrm = HexDiffFrm.open();
                        if (this.val$files != null) {
                            hexDiffFrm.addFiles(this.val$files);
                        }
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--he") || ((String)object2).equalsIgnoreCase("--hexeditor")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFile(stringArray, n);
                EventQueue.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$file;
                    {
                        this.val$file = file;
                    }

                    @Override
                    public void run() {
                        HexEditFrm.open(this.val$file);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--iv") || ((String)object2).equalsIgnoreCase("--imageviewer")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFile(stringArray, n);
                EventQueue.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$file;
                    {
                        this.val$file = file;
                    }

                    @Override
                    public void run() {
                        ImageFrm.open(this.val$file);
                    }
                });
                bl = true;
            } else if (((String)object2).equalsIgnoreCase("--te") || ((String)object2).equalsIgnoreCase("--texteditor")) {
                properties = Main.loadProfileAndSetLAF((String)object4);
                object = Main.getArgFile(stringArray, n);
                EventQueue.invokeLater(new Runnable((File)object){
                    final /* synthetic */ File val$file;
                    {
                        this.val$file = file;
                    }

                    @Override
                    public void run() {
                        TextEditFrm.open(null, this.val$file);
                    }
                });
                bl = true;
            } else {
                if (((String)object2).startsWith("-")) {
                    EmuUtil.printlnErr();
                    EmuUtil.printErr(APPINFO);
                    EmuUtil.printlnErr(":");
                    EmuUtil.printErr((String)object2);
                    EmuUtil.printlnErr(": Unbekannte Option");
                    for (String string3 : usageLines) {
                        EmuUtil.printlnErr(string3);
                    }
                    Main.exitFailure();
                }
                if (!((String)object2).isEmpty()) {
                    object4 = object2;
                }
            }
        }
        if (!bl) {
            String string4;
            screenFrm = new ScreenFrm();
            if (configDir.exists()) {
                firstExec = false;
            } else if (!configDir.mkdirs()) {
                BaseDlg.showErrorDlg((Component)screenFrm, "Das Verzeichnis " + configDir.getPath() + "\nkonnte nicht angelegt werden." + "\nDadurch ist " + APPNAME + " nur mit einigen" + " Einschr\u00e4nkungen lauff\u00e4hig." + "\nInsbesondere k\u00f6nnen keine Einstellungen" + " und Profile gespeichert werden.");
                configDir = null;
            }
            Main.updIcon(screenFrm);
            object2 = null;
            object = Main.buildProfileFile((String)object4);
            if (object != null && ((File)object).exists()) {
                object2 = Main.loadProperties((File)object);
            }
            int n2 = 0;
            if (object2 != null && (string4 = ((Properties)object2).getProperty(PROP_LAF_CLASSNAME)) != null && !string4.isEmpty()) {
                n2 = 1;
            }
            if (n2 == 0) {
                Main.setDefaultLAF();
            }
            screenFrm.setEmuThread(new EmuThread(screenFrm, (Properties)object2));
            Main.applyProfileToFrames((File)object, (Properties)object2, true, null);
            screenFrm.lookAndFeelChanged();
            if (object2 != null) {
                FloppyDiskStationFrm.getSharedInstance(screenFrm).openDisks((Properties)object2);
            } else {
                screenFrm.applySettings(null, screenFrm.isResizable());
                screenFrm.pack();
                screenFrm.setScreenCentered();
            }
            screenFrm.startEmulationThread();
            EmuUtil.showFrame(screenFrm);
        }
    }

    public static void applyProfileToFrames(File file, Properties properties, boolean bl, Frame frame) {
        Object object;
        profileFile = file;
        Main.properties = properties;
        boolean bl2 = false;
        if (properties != null && bl && (object = properties.getProperty(PROP_LAF_CLASSNAME)) != null && !((String)object).isEmpty()) {
            boolean bl3 = bl2 = !EmuUtil.equalsLookAndFeel((String)object);
            if (bl2) {
                try {
                    UIManager.setLookAndFeel((String)object);
                }
                catch (Exception exception) {
                    properties.remove(PROP_LAF_CLASSNAME);
                }
            }
        }
        if ((object = Frame.getFrames()) != null) {
            for (int i = 0; i < ((Frame[])object).length; ++i) {
                Object object2 = object[i];
                if (object2 == null) continue;
                if (bl2) {
                    SwingUtilities.updateComponentTreeUI((Component)object2);
                    if (object2 instanceof BaseFrm) {
                        ((BaseFrm)object2).lookAndFeelChanged();
                    }
                    if (!((Frame)object2).isResizable()) {
                        ((Window)object2).pack();
                    }
                }
                if (!(object2 instanceof BaseFrm) || frame != null && frame == object2) continue;
                ((BaseFrm)object2).applySettings(properties, ((Frame)object2).isResizable());
            }
        }
    }

    public static boolean checkQuit(Frame frame) {
        boolean bl = false;
        if (frame == topFrm) {
            Frame[] frameArray = Frame.getFrames();
            if (frameArray != null) {
                for (Frame frame2 : frameArray) {
                    if (frame2 != frame && frame2 instanceof BaseFrm) {
                        ((BaseFrm)frame2).doClose();
                        continue;
                    }
                    frame2.setVisible(false);
                    frame2.dispose();
                }
            }
            Main.exitSuccess();
            bl = true;
        }
        return bl;
    }

    public static void exitFailure() {
        System.exit(-1);
    }

    public static void exitSuccess() {
        System.exit(0);
    }

    public static void frameCreated(BaseFrm baseFrm) {
        if (topFrm == null) {
            topFrm = baseFrm;
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    public static Image getImage(Component component, String string) {
        URL uRL;
        Image image = images.get(string);
        if (image == null && (uRL = component.getClass().getResource(string)) != null && (image = component.getToolkit().createImage(uRL)) != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(component);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            images.put(string, image);
        }
        return image;
    }

    public static String getLastDriveFileName() {
        return lastDriveFileName;
    }

    public static File getLastDirFile(String string) {
        String string2;
        File file = null;
        if (string != null && string.isEmpty()) {
            string = null;
        }
        if (string == null) {
            string = "*";
        }
        if ((string2 = lastDirs.getProperty(string)) != null && !string2.isEmpty()) {
            file = new File(string2);
        }
        return file;
    }

    public static boolean getPrintFileName() {
        return printFileName;
    }

    public static int getPrintFontSize() {
        return printFontSize;
    }

    public static boolean getPrintPageNum() {
        return printPageNum;
    }

    public static PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return printRequestAttrs;
    }

    public static File getProfileFile() {
        return profileFile;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getProperty(String string) {
        return properties != null ? properties.getProperty(string) : null;
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        return EmuUtil.getBooleanProperty(properties, string, bl);
    }

    public static Integer getIntegerProperty(String string) {
        String string2;
        Integer n = null;
        if (properties != null && (string2 = properties.getProperty(string)) != null && !(string2 = string2.trim()).isEmpty()) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getIntProperty(String string, int n) {
        Integer n2 = Main.getIntegerProperty(string);
        return n2 != null ? n2 : n;
    }

    public static ScreenFrm getScreenFrm() {
        return screenFrm;
    }

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public static boolean isFirstExecution() {
        return firstExec;
    }

    public static boolean isUnixLikeOS() {
        return File.separatorChar == '/';
    }

    public static boolean isWindowActive() {
        return activeWindowMask != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File file) {
        Properties properties = null;
        if (file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties = new Properties();
                properties.loadFromXML(fileInputStream);
                ((InputStream)fileInputStream).close();
                fileInputStream = null;
            }
            catch (Exception exception) {
                block5: {
                    try {
                        properties = null;
                        if (screenFrm == null) break block5;
                        BaseDlg.showErrorDlg((Component)screenFrm, "Profildatei '" + file.getPath() + "'\nkann nicht geladen werden.");
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(fileInputStream);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent(fileInputStream);
            }
            EmuUtil.closeSilent(fileInputStream);
        }
        return properties;
    }

    public static void putImage(String string, Image image) {
        if (string != null && image != null) {
            images.put(string, image);
        }
    }

    public static void setLastDriveFileName(String string) {
        lastDriveFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void setLastFile(File file, String string) {
        if (file != null) {
            String string2;
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null && (string2 = file.getPath()) != null && !string2.isEmpty()) {
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                if (string == null) {
                    string = "*";
                }
                lastDirs.setProperty(string, string2);
                if (configDir.exists()) {
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(lastDirsFile);
                        lastDirs.storeToXML(fileOutputStream, "JKCEMU zuletzt verwendete Verzeichnisse");
                    }
                    catch (Exception exception) {
                        EmuUtil.closeSilent(fileOutputStream);
                        catch (Throwable throwable) {
                            EmuUtil.closeSilent(fileOutputStream);
                            throw throwable;
                        }
                    }
                    EmuUtil.closeSilent(fileOutputStream);
                }
            }
        }
    }

    public static void setPrintFileName(boolean bl) {
        printFileName = bl;
    }

    public static void setPrintFontSize(int n) {
        printFontSize = n;
    }

    public static void setPrintPageNum(boolean bl) {
        printPageNum = bl;
    }

    public static void setPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        printRequestAttrs = printRequestAttributeSet;
    }

    public static void setProfile(File file, Properties properties) {
        if (properties != null) {
            profileFile = file;
            Main.properties = properties;
        }
    }

    public static void setProperty(String string, String string2) {
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty(string, string2);
    }

    public static void setWindowActivated(int n) {
        activeWindowMask |= n;
    }

    public static void setWindowDeactivated(int n) {
        activeWindowMask &= ~n;
    }

    public static void updIcon(Window window) {
        if (iconImages == null) {
            iconImages = new ArrayList<Image>();
            for (String string : iconResources) {
                Image image;
                URL uRL = window.getClass().getResource(string);
                if (uRL == null || (image = window.getToolkit().createImage(uRL)) == null) continue;
                iconImages.add(image);
            }
        }
        if (!iconImages.isEmpty()) {
            window.setIconImages(iconImages);
        }
    }

    private static File buildProfileFile(String string) {
        File file = null;
        if (configDir != null) {
            file = new File(configDir, "prf_" + string + ".xml");
        }
        return file;
    }

    private static File getArgFile(String[] stringArray, int n) {
        String string;
        File file = null;
        if (n >= 0 && n < stringArray.length && (string = stringArray[n]) != null && !string.isEmpty()) {
            file = new File(string);
        }
        return file;
    }

    private static List<File> getArgFileList(String[] stringArray, int n) {
        ArrayList<File> arrayList = null;
        if (n >= 0 && n < stringArray.length) {
            arrayList = new ArrayList<File>(stringArray.length - n);
            for (int i = n; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || string.isEmpty()) continue;
                arrayList.add(new File(string));
            }
        }
        return arrayList;
    }

    private static Properties loadProfileAndSetLAF(String string) {
        Properties properties = null;
        File file = Main.buildProfileFile(string);
        if (file != null) {
            properties = Main.loadPropertiesAndSetLAF(file);
        }
        return properties;
    }

    private static Properties loadPropertiesAndSetLAF(File file) {
        String string;
        Properties properties = null;
        boolean bl = false;
        if (file != null && file.exists() && (properties = Main.loadProperties(file)) != null && (string = properties.getProperty(PROP_LAF_CLASSNAME)) != null && !string.isEmpty()) {
            try {
                UIManager.setLookAndFeel(string);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            Main.setDefaultLAF();
        }
        return properties;
    }

    private static void setDefaultLAF() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        String string = null;
        String string2 = null;
        String string3 = System.getProperty("os.name");
        if (string3 != null) {
            if ((string3 = string3.toLowerCase()).startsWith("windows")) {
                string2 = "windows";
            } else if (string3.startsWith("mac")) {
                string2 = "mac";
            }
        }
        if (string2 != null && (lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) != null) {
            for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                String string4 = lookAndFeelInfoArray[i].getName();
                if (string4 == null) continue;
                if ((string4 = string4.toLowerCase()).equals(string2)) {
                    string = lookAndFeelInfoArray[i].getClassName();
                    break;
                }
                if (!string4.startsWith(string2)) continue;
                string = lookAndFeelInfoArray[i].getClassName();
            }
        }
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
                if (screenFrm != null) {
                    SwingUtilities.updateComponentTreeUI(screenFrm);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

