/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.JComboBox;
import jkcemu.Main;
import jkcemu.base.BaseFrm;

public class AbstractAudioFrm
extends BaseFrm {
    protected static final int[] frameRates = new int[]{96000, 48000, 44100, 45454, 32000, 22050, 16000, 11025, 8000};
    private Mixer.Info[] mixers = AudioSystem.getMixerInfo();

    protected AbstractAudioFrm() {
        Main.updIcon(this);
    }

    protected JComboBox<Object> createFrameRateComboBox() {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setEditable(false);
        jComboBox.addItem("Standard");
        int n = 0;
        while (true) {
            if (n >= frameRates.length) break;
            jComboBox.addItem(frameRates[n]);
            ++n;
        }
        return jComboBox;
    }

    protected JComboBox<String> createMixerComboBox() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(false);
        jComboBox.addItem("Standard");
        if (this.mixers != null) {
            for (int i = 0; i < this.mixers.length; ++i) {
                String string = this.mixers[i].getName();
                if (string != null && string.isEmpty()) {
                    string = null;
                }
                jComboBox.addItem(string != null ? string : "unbekannt");
            }
        }
        return jComboBox;
    }

    protected Mixer getSelectedMixer(JComboBox<String> jComboBox) {
        int n;
        Mixer mixer = null;
        if (this.mixers != null && (n = jComboBox.getSelectedIndex() - 1) >= 0 && n < this.mixers.length) {
            try {
                mixer = AudioSystem.getMixer(this.mixers[n]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return mixer;
    }

    protected int getSelectedFrameRate(JComboBox<Object> jComboBox) {
        int n = 0;
        Object object = jComboBox.getSelectedItem();
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }
}

