/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.audio.AbstractAudioIOComponent;
import jkcemu.audio.AudioFile;
import jkcemu.audio.AudioFrm;
import jkcemu.audio.AudioOut;
import jkcemu.audio.AudioPlayer;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.CSWFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.audio.SoundOutComponent;
import jkcemu.audio.TZXFile;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;

public abstract class AbstractAudioOutComponent
extends AbstractAudioIOComponent {
    protected boolean wasEnabled = false;
    protected AudioOut audioOut = null;
    protected AudioOut recordedData = null;
    protected boolean recordedDataSaved;
    protected Timer durationTimer = new Timer(500, this);
    protected JLabel labelDuration;
    protected JTextField fldDuration;
    protected JButton btnPlay;
    protected JButton btnSave;

    public AbstractAudioOutComponent(AudioFrm audioFrm, EmuThread emuThread) {
        super(audioFrm, emuThread);
        this.durationTimer.setRepeats(true);
    }

    protected boolean checkRecordedDataSaved() {
        boolean bl = true;
        if (this.recordedData != null && !this.recordedDataSaved) {
            if (BaseDlg.showYesNoWarningDlg(this, "Die Aufnahme wurden noch nicht gespeichert!\nM\u00f6chten Sie die Aufnahme verwerfen?", "Warnung")) {
                this.recordedData = null;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void willReset() {
        if (this.audioOut != null) {
            this.doDisable();
            this.wasEnabled = true;
        }
    }

    @Override
    protected boolean doAction(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        if (object == this.durationTimer) {
            this.updDurationText();
        } else if (object == this.btnPlay) {
            this.doPlay();
        } else if (object == this.btnSave) {
            this.doSave();
        } else {
            bl = super.doAction(actionEvent);
        }
        return bl;
    }

    @Override
    protected void doDisable() {
        AudioOut audioOut = this.audioOut;
        if (audioOut != null) {
            this.audioOut = null;
            if (this instanceof SoundOutComponent) {
                this.emuThread.setSoundOut(null);
            } else {
                this.emuThread.setTapeOut(null);
            }
            audioOut.stopAudio();
            this.durationTimer.stop();
            this.updFieldsEnabled();
            if (audioOut.hasRecordedData()) {
                this.btnPlay.setEnabled(true);
                this.btnSave.setEnabled(true);
                this.labelDuration.setEnabled(true);
                this.fldDuration.setEnabled(true);
                this.fldDuration.setText(AudioUtil.getDurationText(audioOut.getFrameRate(), audioOut.getRecordedFrameCount()));
                this.recordedData = audioOut;
                this.recordedDataSaved = false;
            } else {
                this.recordedData = null;
            }
        }
        this.wasEnabled = false;
    }

    private void doPlay() {
        AudioOut audioOut = this.recordedData;
        if (audioOut != null) {
            try {
                AudioPlayer.play(this, audioOut.createPCMDataSourceOfRecordedData(), "Wiedergabe der Aufnahme...");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() {
        AudioOut audioOut = this.recordedData;
        if (audioOut != null) {
            FileFilter[] fileFilterArray = null;
            fileFilterArray = audioOut.getSampleSizeInBits() > 1 || audioOut.getChannels() > 1 ? new FileFilter[]{AudioFile.getFileFilter()} : new FileFilter[]{AudioFile.getFileFilter(), CSWFile.getFileFilter()};
            File file = EmuUtil.showFileSaveDlg(this.audioFrm, "Sound- oder Tape-Datei speichern", Main.getLastDirFile("audio"), fileFilterArray);
            if (file != null) {
                boolean bl = false;
                boolean bl2 = false;
                String string = file.getName();
                if (string != null) {
                    bl = (string = string.toLowerCase()).endsWith(".csw") || string.endsWith(".csw1");
                    bl2 = string.endsWith(".cdt") || string.endsWith(".tzx");
                }
                PCMDataSource pCMDataSource = null;
                try {
                    pCMDataSource = audioOut.createPCMDataSourceOfRecordedData();
                    if (bl) {
                        CSWFile.write(pCMDataSource, file);
                    } else if (bl2) {
                        TZXFile.write(pCMDataSource, file);
                    } else {
                        AudioFile.write(pCMDataSource, file);
                    }
                    Main.setLastFile(file, "audio");
                    this.recordedDataSaved = true;
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
                finally {
                    EmuUtil.closeSilent(pCMDataSource);
                }
            }
        }
    }

    private void updDurationText() {
        String string = "";
        AudioOut audioOut = this.audioOut;
        if (audioOut == null) {
            audioOut = this.recordedData;
        }
        if (audioOut != null) {
            string = audioOut.getDurationText();
        }
        this.fldDuration.setText(string);
    }
}

