/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import jkcemu.Main;
import jkcemu.audio.AudioUtil;
import jkcemu.audio.PCMConverterInputStream;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.EmuUtil;

public class AudioPlayer
implements Runnable {
    private Component owner;
    private PCMDataSource pcm;
    private File file;
    private String title;

    public static void play(Component component, PCMDataSource pCMDataSource, String string) {
        if (component != null && pCMDataSource != null && string != null) {
            AudioPlayer.play(component, pCMDataSource, null, string);
        }
    }

    public static void play(Component component, File file) {
        if (component != null && file != null) {
            AudioPlayer.play(component, null, file, "Wiedergabe von " + file.getName() + "...");
        }
    }

    @Override
    public void run() {
        BufferedInputStream bufferedInputStream = null;
        ProgressMonitorInputStream progressMonitorInputStream = null;
        DataLine dataLine = null;
        AudioInputStream audioInputStream = null;
        try {
            if (this.pcm == null && this.file != null) {
                this.pcm = AudioUtil.openAudioOrTapeFile(this.file);
            }
            if (this.pcm != null) {
                boolean bl = this.pcm.isSigned();
                int n = this.pcm.getChannels();
                int n2 = this.pcm.getSampleSizeInBits();
                if (n2 < 8) {
                    n2 = 8;
                }
                audioInputStream = new AudioInputStream(new PCMConverterInputStream(this.pcm, bl, false), new AudioFormat(this.pcm.getFrameRate(), n2, n, bl, false), this.pcm.getFrameCount());
                AudioFormat audioFormat = audioInputStream.getFormat();
                long l = audioInputStream.getFrameLength();
                if (audioFormat != null && l > 0L) {
                    progressMonitorInputStream = new ProgressMonitorInputStream(this.owner, this.title != null ? this.title : "Wiedergabe...", audioInputStream);
                    ProgressMonitor progressMonitor = progressMonitorInputStream.getProgressMonitor();
                    if (progressMonitor != null) {
                        progressMonitor.setMinimum(0);
                        progressMonitor.setMaximum((int)l * audioFormat.getFrameSize());
                        progressMonitor.setMillisToDecideToPopup(500);
                        progressMonitor.setMillisToPopup(1000);
                    }
                    if ((dataLine = AudioSystem.getSourceDataLine(audioFormat)) != null) {
                        int n3;
                        if (!dataLine.isOpen()) {
                            dataLine.open();
                        }
                        if (!dataLine.isActive()) {
                            dataLine.start();
                        }
                        if ((n3 = (int)audioFormat.getFrameRate() / 4 * audioFormat.getFrameSize() * audioFormat.getChannels()) > 0) {
                            bufferedInputStream = new BufferedInputStream(progressMonitorInputStream);
                            dataLine.open(audioFormat);
                            byte[] byArray = new byte[n3];
                            int n4 = bufferedInputStream.read(byArray);
                            while (n4 > 0) {
                                dataLine.write(byArray, 0, n4);
                                n4 = bufferedInputStream.read(byArray);
                            }
                            dataLine.drain();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EmuUtil.closeSilent(progressMonitorInputStream);
        EmuUtil.closeSilent(audioInputStream);
        EmuUtil.closeSilent(bufferedInputStream);
        if (dataLine != null) {
            try {
                dataLine.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dataLine.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private AudioPlayer(Component component, PCMDataSource pCMDataSource, File file, String string) {
        this.owner = component;
        this.pcm = pCMDataSource;
        this.file = file;
        this.title = string;
    }

    public static void play(Component component, PCMDataSource pCMDataSource, File file, String string) {
        new Thread(Main.getThreadGroup(), new AudioPlayer(component, pCMDataSource, file, string), "JKCEMU audio player").start();
    }
}

