/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.audio;

import java.io.IOException;
import jkcemu.audio.AbstractPCMDataReader;

public class PCMDataBuffer
extends AbstractPCMDataReader {
    private byte[] dataBytes;
    private int dataPos;

    public PCMDataBuffer(int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray, long l, long l2) throws IOException {
        super(n, n2, n3, bl, bl2, l, l2);
        this.dataBytes = byArray;
        this.dataPos = 0;
        if ((long)byArray.length < l + l2) {
            l2 = (long)byArray.length - l;
        }
        this.frameCount = l2 / (long)this.bytesPerFrame;
        if (this.frameCount < 1L) {
            PCMDataBuffer.throwNoAudioData();
        }
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0 && this.dataPos < this.dataBytes.length) {
            byArray[n++] = this.dataBytes[this.dataPos++];
            ++n3;
            --n2;
        }
        return n3;
    }

    @Override
    public synchronized void setFramePos(long l) throws IOException {
        long l2 = this.pcmDataOffs + l * (long)this.bytesPerFrame;
        this.dataPos = l2 > (long)this.dataBytes.length ? this.dataBytes.length : (int)l2;
    }

    @Override
    public boolean supportsSetFramePos() {
        return true;
    }
}

