/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;

public abstract class AbstractFileWorker
implements FileVisitor<Path>,
Runnable {
    protected volatile Path curParent;
    protected volatile Path curPath;
    protected volatile boolean cancelled;
    private Window owner;
    private PathListener pathListener;
    private Collection<AbstractFileWorker> register;
    private JDialog progressDlg;
    private JLabel progressLabel;
    private Timer progressTimer;
    private List<Path> paths;
    private volatile boolean skipAll;
    private boolean failed;
    private Thread thread;
    private Object syncMonitor;
    private Set<Path> pastedPaths;
    private Set<Path> removedPaths;

    protected AbstractFileWorker(Window window, Collection collection, PathListener pathListener, Collection<AbstractFileWorker> collection2) {
        int n;
        this.owner = window;
        this.pathListener = pathListener;
        this.register = collection2;
        this.paths = null;
        this.curParent = null;
        this.curPath = null;
        this.progressDlg = null;
        this.progressLabel = null;
        this.progressTimer = null;
        this.cancelled = false;
        this.failed = false;
        this.skipAll = false;
        this.progressDlg = null;
        this.thread = null;
        this.syncMonitor = new Object();
        this.pastedPaths = EmuUtil.createPathSet();
        this.removedPaths = EmuUtil.createPathSet();
        if (collection != null && (n = collection.size()) > 0) {
            this.paths = new ArrayList<Path>(n);
            for (Object e : collection) {
                if (e == null) continue;
                if (e instanceof Path) {
                    this.paths.add((Path)e);
                    continue;
                }
                if (!(e instanceof File)) continue;
                try {
                    Path path = ((File)e).toPath();
                    if (path == null) continue;
                    this.paths.add(path);
                }
                catch (InvalidPathException invalidPathException) {
                    this.failed = true;
                }
            }
        }
    }

    public void cancelWork() {
        this.cancelled = true;
        this.setProgressText("Vorgang abgebrochen, bitte warten...");
        Thread thread = this.thread;
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected void checkSrcPathsAgainstDstPath(Path path, Collection collection, String string) throws IOException {
        for (Object e : collection) {
            if (e == null) continue;
            try {
                Path path2 = null;
                if (e instanceof Path) {
                    path2 = (Path)e;
                } else if (e instanceof File) {
                    path2 = ((File)e).toPath();
                }
                if (path2 == null || !path.startsWith(path2)) continue;
                throw new IOException(string);
            }
            catch (InvalidPathException invalidPathException) {
            }
        }
    }

    public static boolean checkWindowClosing(Component component, final Collection<AbstractFileWorker> collection) {
        boolean bl = true;
        if (collection != null && !collection.isEmpty()) {
            JOptionPane jOptionPane = new JOptionPane("Das Fenster wird erst geschlossen, wenn die laufenden\nDatei-Operationen fertig sind oder abgebrochen wurden.\n", 2, 0);
            jOptionPane.setOptions(new String[]{"Fenster nicht schlie\u00dfen"});
            final JDialog jDialog = jOptionPane.createDialog(component, "Hinweis");
            final Timer timer = new Timer(100, null);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (collection.isEmpty()) {
                        timer.stop();
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            timer.start();
            jDialog.setVisible(true);
            bl = collection.isEmpty();
        }
        return bl;
    }

    protected void pathPasted(Path path) {
        this.pastedPaths.add(path);
    }

    protected void pathRemoved(Path path) {
        this.removedPaths.add(path);
    }

    public abstract String getFileFailedMsg(String var1);

    public abstract String getProgressDlgTitle();

    public abstract String getUncompletedWorkMsg();

    protected void handleError(Path path, IOException iOException) {
        this.failed = true;
        if (!this.skipAll) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append(this.getFileFailedMsg(path.toString()));
            if (iOException != null) {
                String string = iOException.getMessage();
                if (string != null && !(string = string.trim()).isEmpty()) {
                    string = null;
                }
                if (string != null) {
                    stringBuilder.append("\n\n");
                    stringBuilder.append(string);
                }
            }
            switch (this.showJOptionPane(stringBuilder.toString(), 0, "Fehler", new String[]{"\u00dcberspringen", "Alle \u00fcberspringen", "Abbrechen"})) {
                case 0: {
                    break;
                }
                case 1: {
                    this.skipAll = true;
                    break;
                }
                default: {
                    this.cancelled = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int showJOptionPane(String string, int n, final String string2, String[] stringArray) {
        final JOptionPane jOptionPane = new JOptionPane(string, n);
        jOptionPane.setOptions(stringArray);
        Object object = this.syncMonitor;
        synchronized (object) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    jOptionPane.createDialog(AbstractFileWorker.this.owner, string2).setVisible(true);
                    Object object = AbstractFileWorker.this.syncMonitor;
                    synchronized (object) {
                        try {
                            AbstractFileWorker.this.syncMonitor.notifyAll();
                        }
                        catch (IllegalMonitorStateException illegalMonitorStateException) {
                            // empty catch block
                        }
                    }
                }
            });
            try {
                this.syncMonitor.wait();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
            }
            catch (InterruptedException interruptedException) {
                this.cancelled = true;
            }
        }
        int n2 = -1;
        Object object2 = jOptionPane.getValue();
        if (object2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!object2.equals(stringArray[i])) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public void startWork() {
        if (this.thread == null && this.progressDlg == null && this.paths != null) {
            if (this.register != null) {
                this.register.add(this);
            }
            this.progressLabel = new JLabel("In Arbeit...");
            this.progressLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.progressLabel.setAlignmentX(0.5f);
            this.progressLabel.setAlignmentY(0.5f);
            JButton jButton = new JButton("Abbrechen");
            jButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jButton.setAlignmentX(0.5f);
            jButton.setAlignmentY(0.5f);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFileWorker.this.cancelWork();
                }
            });
            this.progressDlg = new JDialog(this.owner, this.getProgressDlgTitle(), Dialog.ModalityType.MODELESS);
            this.progressDlg.setDefaultCloseOperation(0);
            Container container = this.progressDlg.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.progressLabel);
            container.add(jButton);
            this.progressDlg.pack();
            BaseDlg.setParentCentered(this.progressDlg);
            this.progressDlg.setVisible(true);
            this.progressTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFileWorker.this.updProgressDlg();
                }
            });
            this.progressTimer.start();
            this.thread = new Thread(Main.getThreadGroup(), this, "JKCEMU file worker");
            this.thread.start();
        }
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.paths != null) {
                for (Path path : this.paths) {
                    if (this.cancelled) break;
                    try {
                        this.curParent = path.getParent();
                        Files.walkFileTree(path, this);
                    }
                    catch (IOException iOException) {
                        this.handleError(path, iOException);
                    }
                }
                this.curParent = null;
                this.curPath = null;
            }
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractFileWorker.this.workFinished();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void setProgressText(String string) {
        if (string != null) {
            JDialog jDialog = this.progressDlg;
            JLabel jLabel = this.progressLabel;
            if (jDialog != null && jLabel != null) {
                jLabel.setText(string);
                jDialog.pack();
            }
        }
    }

    private void updProgressDlg() {
        if (this.cancelled) {
            if (this.progressTimer != null) {
                this.progressTimer.stop();
            }
        } else {
            Path path = this.curPath;
            if (path != null) {
                this.setProgressText(path.toString());
            }
        }
    }

    private void workFinished() {
        if (this.register != null) {
            this.register.remove(this);
        }
        if (this.pathListener != null) {
            if (!this.pastedPaths.isEmpty()) {
                this.pathListener.pathsPasted(this.pastedPaths);
            }
            if (!this.removedPaths.isEmpty()) {
                this.pathListener.pathsRemoved(this.removedPaths);
            }
        }
        if (this.progressDlg != null) {
            this.progressDlg.setVisible(false);
            this.progressDlg.dispose();
            this.progressDlg = null;
        }
        if (this.failed && !this.cancelled) {
            BaseDlg.showErrorDlg((Component)this.owner, this.getUncompletedWorkMsg());
        }
    }

    public static interface PathListener {
        public void pathsPasted(Set<Path> var1);

        public void pathsRemoved(Set<Path> var1);
    }
}

